#ifndef X42PPTXH
#define X42PPTXH

/* ===[ $RCSfile: x42pp_tx.h,v $ ]===========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2003-2005 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: x42pp_tx.h,v 1.2 2005/02/09 23:27:36 cmayncvs Exp $"
 *
 * \brief X42pp Transmit State Machine API.
 *
 */
/** X.42pp transmit timer indicator */
#define X42PP_TX    ('T' << 8)

void
x42pp_tx_init (char *drop_list, int length, ubyte_4 poll_tmo);

void
x42pp_tx_req (buf_t msg, ubyte_1 drop, ubyte_1 type);

void
x42pp_tx_poll_tmo (void);

void
x42pp_tx_ack_ind (void);

void
x42pp_tx_nack_ind (void);

void
x42pp_tx_fcs_error (void);

void
x42pp_tx_set_pending (void);

void
x42pp_tx_cfm (void);

void
x42pp_tx_idle_tmo (void);

void
x42pp_tx_rsp_tmo (ubyte_1 drop);

void
x42pp_tx_disable (ubyte_1 drop);

void
x42pp_tx_enable (ubyte_1 drop);

#endif /* X42PPTXH */


/*
 * End of "$Id: x42pp_tx.h,v 1.2 2005/02/09 23:27:36 cmayncvs Exp $".
 */


