#ifndef X42PPTYPESH
#define X42PPTYPESH

/* ===[ $RCSfile: x42pp_types.h,v $ ]========================================

    This item is the property of GTECH Corporation, West Greenwich,
    Rhode Island, and contains confidential and trade secret information.
    It may not be transferred from the custody or control of GTECH except
    as authorized in writing by an officer of GTECH.  Neither this item
    nor the information it contains may be used, transferred, reproduced,
    published, or disclosed, in whole or in part, and directly or
    indirectly, except as expressly authorized by an officer of GTECH,
    pursuant to written agreement.

    Copyright (c) 2003-2005 GTECH Corporation.  All rights reserved.

   ======================================================================= */

/** \file
 *
 *  "$Id: x42pp_types.h,v 1.2 2005/02/09 23:27:36 cmayncvs Exp $"
 *
 * \brief X.42pp types.
 *
 */

/** Maximum number of drops to poll */
#define MAX_DROPS   157

#define PAD         0x40    /**< PAD character */
#define SAD         0x20    /**< SAD character */
#define UAD         0x60    /**< UAD character */
#define BROC        0x00    /**< BRO character */

#define LINK        0x09    /**< LINK/NAK character */
#define ACKN        0x06    /**< ACK character */
#define ETX         0x03    /**< ETX character */
#define CNB         0x0F    /**< CNB (complement next byte) character */
#define ENQ         0x05    /**< ENQ character */
#define ETB_NEW     0x04    /**< ETB character */
#define ETB_OLD     0x17    /**< Old ETB character */

/** Convenient typedef for an unsigned char (1 byte) */
typedef unsigned char   ubyte_1;
/** Convenient typedef for an unsigned short (2 bytes) */
typedef unsigned short  ubyte_2;
/** Convenient typedef for an unsigned long (4 bytes) */
typedef unsigned long   ubyte_4;

#endif /* X42PPTYPESH */


/*
 * End of "$Id: x42pp_types.h,v 1.2 2005/02/09 23:27:36 cmayncvs Exp $".
 */


