#ifndef HTTPS_H
#define HTTPS_H

/**********************************************************
 * HTTP(S) Variables, Functions, & Setup
 **********************************************************/

/**Root certificate(s) for validation of server certificates.
 * Root certs should be in PEM format with "\r\n" at the end of each line.
 * Multiple certs can be added at the same time. (see below)
 * Certificate chain can be acquired with openssl
 *      openssl s_client -connect nucleus-connect.axeda.com:443 -showcerts
 */

/*
-----BEGIN CERTIFICATE-----
MIIFHzCCBAegAwIBAgIDAtokMA0GCSqGSIb3DQEBBQUAMEAxCzAJBgNVBAYTAlVT
MRcwFQYDVQQKEw5HZW9UcnVzdCwgSW5jLjEYMBYGA1UEAxMPR2VvVHJ1c3QgU1NM
IENBMB4XDTE0MDQyNzA5MTY0M1oXDTE1MDQyOTIyMTc0OFowgboxKTAnBgNVBAUT
IHh5UHdMS0lIcFNsbFNaZkl2Ny1Da1NxT01iYjl3U0NmMQswCQYDVQQGEwJVUzEW
-----END CERTIFICATE-----
-----BEGIN CERTIFICATE-----
MBQGA1UECBMNTWFzc2FjaHVzZXR0czEQMA4GA1UEBxMHRm94Ym9ybzEaMBgGA1UE
ChMRQXhlZGEgQ29ycG9yYXRpb24xFjAUBgNVBAsTDUF4ZWRhIEhvc3RpbmcxIjAg
BgNVBAMTGW51Y2xldXMtY29ubmVjdC5heGVkYS5jb20wggEiMA0GCSqGSIb3DQEB
AQUAA4IBDwAwggEKAoIBAQDLho01WLMt1cpK6uRumj9kcbAq4bjF7kyz6G634Xi+
-----END CERTIFICATE-----
-----BEGIN CERTIFICATE-----
5KyxP9Zzrp01AS1th+WHKCmDK+hJXor76GD7QZE+mAyS+3YWAhI6TfWRaF1LdMwp
qN5yefkMzlQelp1D3fo2lTkuOmfwPGp9r+1cyJjeUo/KLD9zs1wjWdd5XTZYKlGh
0DN7Vxvn1BlbLGWWL+jCO+kcve5PZrdQ9SfjzKZjMac0hH4cOkx8pNmAwDAz2azn
HlNXxx80a5LH05/+VY/pSRhQcItj5jdF+BgtVkjuoMWdy/v57qv9jpDE6hvHWN+p
-----END CERTIFICATE-----
*/

const char CERTIFICATES[] = 
    //Nucleus-connect.axeda.com
    
    //GeoTrustGlobalCA from GeoTrust website
    "-----BEGIN CERTIFICATE-----\r\n"
    "MIIDVDCCAjygAwIBAgIDAjRWMA0GCSqGSIb3DQEBBQUAMEIxCzAJBgNVBAYTAlVT\r\n"
    "MRYwFAYDVQQKEw1HZW9UcnVzdCBJbmMuMRswGQYDVQQDExJHZW9UcnVzdCBHbG9i\r\n"
    "YWwgQ0EwHhcNMDIwNTIxMDQwMDAwWhcNMjIwNTIxMDQwMDAwWjBCMQswCQYDVQQG\r\n"
    "EwJVUzEWMBQGA1UEChMNR2VvVHJ1c3QgSW5jLjEbMBkGA1UEAxMSR2VvVHJ1c3Qg\r\n"
    "R2xvYmFsIENBMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA2swYYzD9\r\n"
    "9BcjGlZ+W988bDjkcbd4kdS8odhM+KhDtgPpTSEHCIjaWC9mOSm9BXiLnTjoBbdq\r\n"
    "fnGk5sRgprDvgOSJKA+eJdbtg/OtppHHmMlCGDUUna2YRpIuT8rxh0PBFpVXLVDv\r\n"
    "iS2Aelet8u5fa9IAjbkU+BQVNdnARqN7csiRv8lVK83Qlz6cJmTM386DGXHKTubU\r\n"
    "1XupGc1V3sjs0l44U+VcT4wt/lAjNvxm5suOpDkZALeVAjmRCw7+OC7RHQWa9k0+\r\n"
    "bw8HHa8sHo9gOeL6NlMTOdReJivbPagUvTLrGAMoUgRx5aszPeE4uwc2hGKceeoW\r\n"
    "MPRfwCvocWvk+QIDAQABo1MwUTAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBTA\r\n"
    "ephojYn7qwVkDBF9qn1luMrMTjAfBgNVHSMEGDAWgBTAephojYn7qwVkDBF9qn1l\r\n"
    "uMrMTjANBgkqhkiG9w0BAQUFAAOCAQEANeMpauUvXVSOKVCUn5kaFOSPeCpilKIn\r\n"
    "Z57QzxpeR+nBsqTP3UEaBU6bS+5Kb1VSsyShNwrrZHYqLizz/Tt1kL/6cdjHPTfS\r\n"
    "tQWVYrmm3ok9Nns4d0iXrKYgjy6myQzCsplFAMfOEVEiIuCl6rYVSAlk6l5PdPcF\r\n"
    "PseKUgzbFbS9bZvlxrFUaKnjaZC2mqUPuLk/IH2uSrW4nOQdtqvmlKXBx4Ot2/Un\r\n"
    "hw4EbNX/3aBd7YdStysVAq45pmp06drE57xNNB6pXE0zX5IJL4hmXXeXxx12E6nV\r\n"
    "5fEWCRE11azbJHFwLJhWC9kXtNHjUStedejV0NxPNO3CBWaAocvmMw==\r\n"
    "-----END CERTIFICATE-----\r\n"

    //VeriSignClass3PublicPrimaryCA
    "-----BEGIN CERTIFICATE-----\r\n"
    "MIICPDCCAaUCEDyRMcsf9tAbDpq40ES/Er4wDQYJKoZIhvcNAQEFBQAwXzELMAkG\r\n"
    "A1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFz\r\n"
    "cyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk2\r\n"
    "MDEyOTAwMDAwMFoXDTI4MDgwMjIzNTk1OVowXzELMAkGA1UEBhMCVVMxFzAVBgNV\r\n"
    "BAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAzIFB1YmxpYyBQcmlt\r\n"
    "YXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GN\r\n"
    "ADCBiQKBgQDJXFme8huKARS0EN8EQNvjV69qRUCPhAwL0TPZ2RHP7gJYHyX3KqhE\r\n"
    "BarsAx94f56TuZoAqiN91qyFomNFx3InzPRMxnVx0jnvT0Lwdd8KkMaOIG+YD/is\r\n"
    "I19wKTakyYbnsZogy1Olhec9vn2a/iRFM9x2Fe0PonFkTGUugWhFpwIDAQABMA0G\r\n"
    "CSqGSIb3DQEBBQUAA4GBABByUqkFFBkyCEHwxWsKzH4PIRnN5GfcX6kb5sroc50i\r\n"
    "2JhucwNhkcV8sEVAbkSdjbCxlnRhLQ2pRdKkkirWmnWXbj9T/UWZYB2oK0z5XqcJ\r\n"
    "2HUw19JlYD1n1khVdWk/kfVIC0dpImmClr7JyDiGSnoscxlIaU5rfGW/D/xwzoiQ\r\n"
    "-----END CERTIFICATE-----\r\n"

    //Axeda Root CA Certificate
    "-----BEGIN CERTIFICATE-----\r\n"
    "MIICmTCCAgICAQAwDQYJKoZIhvcNAQEEBQAwgZQxCzAJBgNVBAYTAlVTMRYwFAYD\r\n"
    "VQQIEw1NYXNzYWNodXNldHRzMRIwEAYDVQQHEwlNYW5zZmllbGQxHDAaBgNVBAoT\r\n"
    "E0F4ZWRhIFN5c3RlbXMsIEluYy4xGTAXBgNVBAMTEEF4ZWRhIFN5c3RlbXMgQ0Ex\r\n"
    "IDAeBgkqhkiG9w0BCQEWEXN1cHBvcnRAYXhlZGEuY29tMB4XDTAzMDExMDE3MzUy\r\n"
    "N1oXDTEzMDEwNzE3MzUyN1owgZQxCzAJBgNVBAYTAlVTMRYwFAYDVQQIEw1NYXNz\r\n"
    "YWNodXNldHRzMRIwEAYDVQQHEwlNYW5zZmllbGQxHDAaBgNVBAoTE0F4ZWRhIFN5\r\n"
    "c3RlbXMsIEluYy4xGTAXBgNVBAMTEEF4ZWRhIFN5c3RlbXMgQ0ExIDAeBgkqhkiG\r\n"
    "9w0BCQEWEXN1cHBvcnRAYXhlZGEuY29tMIGfMA0GCSqGSIb3DQEBAQUAA4GNADCB\r\n"
    "iQKBgQD0VtQ82SdSI4QTwIWIXTya91GJ4IFZMwY3eXVkg3jpBwGGQFAk2yOAhITZ\r\n"
    "nQkZn5/JEifRJTvLhqq7AtFqkKG0bKza3jLFhMDh4q7nn5en1wWvMWQM8hSA7cBV\r\n"
    "DYbtsRObM8b7TiC8ZlxhN/6fZFiLyzX431Ppx2nSjyfpHK3oSQIDAQABMA0GCSqG\r\n"
    "SIb3DQEBBAUAA4GBAGav/orW9wQ7TvUiJV5IcpckJKQJrTd0M2XBu+iPwJ52+4pP\r\n"
    "SzJJ7zMdhUTEkxuWegz1L25DewZdnMBddtSK9/AcB6l7Ezqwfblr6cuLNduO9+MU\r\n"
    "29I/wb5gbC2vSppa/clLB7Cw/b7ypS+bTTIU9RbbOrtuKtyGGN3YCvXGKUgB\r\n"
    "-----END CERTIFICATE-----\r\n"
    ;

// Convert numeric HTTP response code to human readable string
char * httpResToStr(HTTPResult res) {
    switch(res) {
        case HTTP_PROCESSING:
            return "HTTP_PROCESSING";
        case HTTP_PARSE:
            return "HTTP_PARSE";
        case HTTP_DNS:
            return "HTTP_DNS";
        case HTTP_PRTCL:
            return "HTTP_PRTCL";
        case HTTP_NOTFOUND:
            return "HTTP_NOTFOUND";
        case HTTP_REFUSED:
            return "HTTP_REFUSED";
        case HTTP_ERROR:
            return "HTTP_ERROR";
        case HTTP_TIMEOUT:
            return "HTTP_TIMEOUT";
        case HTTP_CONN:
            return "HTTP_CONN";
        case HTTP_CLOSED:
            return "HTTP_CLOSED";
        case HTTP_REDIRECT:
            return "HTTP_REDIRECT";
        case HTTP_OK:
            return "HTTP_OK";
        default:
            return "HTTP Result unknown";
    }
}

#endif
