#include "Socket.h"
#include <cstring>
#include "Transport.h"

Socket::Socket() : _blocking(true), _timeout(1500) {
    ip = Transport::getInstance();
}

void Socket::set_blocking(bool blocking, unsigned int timeout) {
    _blocking = blocking;
    _timeout = timeout;
}

int Socket::close(bool shutdown) {
    return (ip->close(shutdown)) ? 0 : -1;
}

Socket::~Socket() {
    close(true); //Don't want to leak
}
