@echo on

set bootloader="%~dp0\bootloader.bin"
set bootloader_padded="%~dp0\bootloader_padded.bin"
set application="%1\application.bin"
set application_orig="%1\application_orig.bin"
set application_appended="%1\application_appended.bin"

: pad bootloader to 64kB (0x10000)
%~dp0\srec_cat.exe %bootloader% -Binary -fill 0xFF 0x0 0x10000 -o %bootloader_padded% -Binary

: combine padded bootloader binary with application binary
move %application% %application_orig%
%~dp0\srec_cat.exe %bootloader_padded% -Binary %application_orig% -Binary -offset 0x10000 -o %application% -Binary

: append CRC32 to end of binary
move %application% %application_appended%
%~dp0\srec_cat.exe %application_appended% -Binary -CRC32_Little_Endian -MAXimum-Address %application_appended% -Binary -o %application% -Binary

: remove leftovers
del %bootloader_padded%
del %application_orig%
del %application_appended%
