//#include "mbed.h"
//#include "mtsas.h"
//#include <string>
//
//int main(){
//    //Modify to match your apn if you are using an HSPA radio with a SIM card
//    //const char APN[] = "";
//    const char APN[] = "fast.t-mobile.com";
//    
//    //Sets the log level to INFO, higher log levels produce more log output.
//    //Possible levels: NONE, FATAL, ERROR, WARNING, INFO, DEBUG, TRACE
//    MTSLog::setLogLevel(MTSLog::INFO_LEVEL);
//    
//    //Receive buffer
//    char rbuf[4000];
//    
//    //url strings for HTTP requests, httpbin.org is a public website for fielding test HTTP requests
//    string url, base_url = "http://httpbin.org:80", url_get = "/get";
//
//    
//    /** MTS_DRAGONFLY_F411RE 
//    * 
//    * Uncomment the following line to use the MTS_DRAGONFLY_F411RE
//    */
//    
//    MTSSerialFlowControl* io = new MTSSerialFlowControl(RADIO_TX, RADIO_RX, PB_10/*RTS*/, PB_12/*CTS*/);
//    
//    /** STMicro Nucelo F401RE
//    * The supported jumper configurations of the MTSAS do not line up with
//    * the pin mapping of the Nucleo F401RE. Therefore, the MTSAS serial TX
//    * pin (JP8 Pin 2) must be manually jumped to Serial1 RX (Shield pin D2)
//    * and the MTSAS serial RX pin (JP9 Pin 2) pin must be manually jumped to
//    * Serial1 TX (Shield pin D8).
//    * Uncomment the following line to use the STMicro Nuceleo F401RE
//    */
//    //MTSSerialFlowControl* io = new MTSSerialFlowControl(D8, D2, D3, D6);
//        
//    /** Freescale KL46Z
//    * To configure the serial pins for the Freescale KL46Z board, use MTSAS jumper
//    * configuration B. Uncomment the following line to use the Freescale KL46Z board
//    */
//    //MTSSerialFlowControl* io = new MTSSerialFlowControl(D2, D9, D3, D6);
//    
//    /** Freescale K64F
//    * To configure the serial pins for the Freescale K64F board, use MTSAS jumper
//    * configuration A. Uncomment the following line to use the Freescale K64F board
//    */
//    //MTSSerialFlowControl* io = new MTSSerialFlowControl(D1, D0, D3, D6);
//    
//    //Sets the baud rate for communicating with the radio
//    io->baud(115200); 
//    
//    //Initialize radio configurations
//    Cellular* radio = CellularFactory::create(io);
//    if( ! radio) {
//        logFatal("Radio initialization failed");
//        return 1;
//    }
//    radio->configureSignals(D4/*DCD*/,D7/*DTR*/,RESET);
//    Transport::setTransport(radio);
//    
//    //Set up HTTP interface
//    HTTPClient* http = new HTTPClient();
//    HTTPText* receive = new HTTPText(rbuf, 4000);
//    
//    //Set radio APN
//    for (int i = 0; i < 10; i++) {
//        if (i >= 10) {
//            logError("Failed to set APN to %s", APN);
//        }
//        if (radio->setApn(APN) == MTS_SUCCESS) {
//            logInfo("Successfully set APN to %s", APN);
//            break;
//        } else {
//            wait(1);
//        }
//    }
//    
//    //Establish PPP link
//    for (int i = 0; i < 10; i++) {
//        if (i >= 10) {
//            logError("Failed to establish PPP link");
//        }
//        if (radio->connect() == true) {
//            logInfo("Successfully established PPP link");
//            break;
//        } else {
//            wait(1);
//        }
//    }
//    
//    //Format HTTP Get request
//    url = base_url + url_get;
//    
//     //Send HTTP GET request
//    for (int i = 0; i < 10; i++) {
//        if(http->get(url.c_str(), receive, 5000) == HTTP_OK) {
//            http->get(url.c_str(), receive, 5000);
//            printf("\n HTTP get succeeded \n");
//            logInfo("HTTP get succeeded\n%s",  rbuf);
//            break;
//        }
//        if (i >= 10) {
//            logError("HTTP GET failed");
//        }
//        wait(1);
//    }
//    //Disconnect PPP link
//    radio->disconnect();
//    
//    logInfo("End of example code\n");
//    return 0;
//}

#include "mbed.h"
#include "..\..\SpiFlash25\SpiFlash25\SpiFlash25.h"
#include "..\..\flash-fs\flash-fs\spiffs.h"
#include <string>

// this value represents the number of files you can have open at the same time
// adjust it according to your requirements
#define MAX_CONCURRENT_FDS      4

#define PAGE_SIZE               256
#define SECTOR_SIZE             64*1024
#define MEM_SIZE                2*1024*1024

static u8_t spiffs_work_buf[PAGE_SIZE * 2];
static u8_t spiffs_fds[32 * MAX_CONCURRENT_FDS];
static u8_t spiffs_cache_buf[(PAGE_SIZE + 32) * 4];

static SpiFlash25 flash(SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS1);
static spiffs fs;
static spiffs_config cfg;

// glue code between SPI driver and filesystem
int spi_read(unsigned int addr, unsigned int size, unsigned char* data) {
    if (flash.read(addr, size, (char*)data))
        return SPIFFS_OK;
    return -1;
}
int spi_write(unsigned int addr, unsigned int size, unsigned char* data) {
    if (flash.write(addr, size, (const char*)data))
        return SPIFFS_OK;
    return -1;
}
int spi_erase(unsigned int addr, unsigned int size) {
    flash.clear_sector(addr);
    return SPIFFS_OK;
}

int main(void) {
    int ret;
    int handle;
    char data[256];
    char msg[] = "Hello World! The sneaky cat crept around the sleeping dog.\r\n";
    char file[] = "test.txt";
    string sdata;

    // configure the filesystem
    cfg.phys_size = MEM_SIZE;
    cfg.phys_addr = 0;
    cfg.phys_erase_block = SECTOR_SIZE;
    cfg.log_block_size = SECTOR_SIZE;
    cfg.log_page_size = PAGE_SIZE;

    cfg.hal_read_f = &spi_read;
    cfg.hal_write_f = &spi_write;
    cfg.hal_erase_f = &spi_erase;

    Serial pc(USBTX, USBRX);
    pc.baud(115200);

    printf("dragonfly spi flash example started\r\n");

    // erase entire flash
    // THIS WILL ERASE THE ENTIRE FLASH! EVERYTHING ON IT WILL BE LOST AND CANNOT BE RECOVERED!
    //flash.clear_mem();

    // mount the filesystem
    ret = SPIFFS_mount(&fs, &cfg, spiffs_work_buf, spiffs_fds, sizeof(spiffs_fds), spiffs_cache_buf, sizeof(spiffs_cache_buf), NULL);
    if (ret) {
        printf("SPIFFS_mount failed %d - can't continue\r\n", ret);
        return 1;
    }

    // write to the file
    handle = SPIFFS_open(&fs, file, SPIFFS_CREAT | SPIFFS_RDWR | SPIFFS_APPEND, 0);
    if (handle < 0)
        printf("SPIFFS_open failed %d\r\n", SPIFFS_errno(&fs));

    if (handle) {
        ret = SPIFFS_write(&fs, handle, msg, sizeof(msg));
        if (ret < 0)
            printf("SPIFFS_write failed %d\r\n", SPIFFS_errno(&fs));
        else
            printf("wrote %d bytes\r\n", ret);
        SPIFFS_close(&fs, handle);
    }

    // read the current file contents
    spiffs_stat stat;
    memset(&stat, 0, sizeof(stat));
    ret = SPIFFS_stat(&fs, file, &stat);
    if (ret)
        printf("SPIFFS_stat failed %d\r\n", SPIFFS_errno(&fs));
    else
        printf("file size: %d bytes\r\n", stat.size);

    handle = SPIFFS_open(&fs, file, SPIFFS_RDWR, 0);
    if (handle < 0)
        printf("SPIFFS_open failed %d\r\n", SPIFFS_errno(&fs));

    if (handle) {
        while (sdata.size() < stat.size) {
            ret = SPIFFS_read(&fs, handle, data, stat.size - sdata.size() < sizeof(data) ? stat.size - sdata.size() : sizeof(data));
            if (ret < 0) {
                printf("SPIFFS_read failed %d\r\n", SPIFFS_errno(&fs));
                continue;
            }
            printf("read %d bytes\r\n", ret);
            sdata.append(data, ret);
        }

        printf("data [\r\n");
        for (int i = 0; i < sdata.size(); i++)
            printf("%c", sdata[i]);
        printf("\r\n]\r\n");

        SPIFFS_close(&fs, handle);
    }

    printf("dragonfly spi flash example finished\r\n\r\n");

    return 0;
}





