/* vim: set sw=2 ts=2 expandtab:
 *
 * Copyright (C) 2010 by Multi-Tech Systems
 *
 * Author: James Maki <jmaki@multitech.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#ifndef ANNEX_COMMON_H_
#define ANNEX_COMMON_H_

#define SSL_SUPPORT 1

#if SSL_SUPPORT
#include <sasl/sasl.h>
#include <sasl/saslutil.h>

#include <openssl/rand.h>
#include <openssl/ssl.h>
#include <openssl/err.h>
#endif

#include <log.h>

#define SI_WITH_BLOCKING_METHODS            0
#define SYNCHRONOUS_PACKAGE_DELIVERY        1

#ifndef DISALLOW_COPY_AND_ASSIGN
#define DISALLOW_COPY_AND_ASSIGN(TypeName) \
  TypeName(const TypeName&);               \
  void operator=(const TypeName&)
#endif

extern "C" {

char *basename_safe(const char *path);
int str_ends_with(const char *str, const char *sub);
void sleep_msec(size_t msec);
void log_backtrace();
int mutex_lock(pthread_mutex_t *mutex);
int mutex_unlock(pthread_mutex_t *mutex);
int cond_wait(pthread_cond_t *cond, pthread_mutex_t *mutex);
int cond_timedwait(
    pthread_cond_t *cond,
    pthread_mutex_t *mutex,
    const struct timespec *abstime);
int cond_signal(pthread_cond_t *cond);
int nonblocking(int fd, int nonblocking);
int abstimeout_tv_msec(struct timeval *tv, int msec);
int abstimeout_ts_msec(struct timespec *ts, int msec);

#if SSL_SUPPORT
void ssl_log_err(const char *prefix, unsigned long err);
void ssl_dump_err_queue(const char *prefix);
void ssl_log_ssl_error(const char *prefix, SSL *ssl, int ret);
int sasl_log_callback(
    void *context __attribute__ ((unused)),
    int priority,
    const char *message);
int sasl_realm_callback(
    void *context,
    int id,
    const char **availrealms __attribute__ ((unused)),
    const char **result);
int sasl_simple_callback(
    void *context,
    int id,
    const char **result,
    unsigned *len);
int sasl_secret_callback(
    sasl_conn_t *conn,
    void *context,
    int id,
    sasl_secret_t **psecret);
int sasl_challenge_callback(
    void *context,
    int id,
    const char *challenge __attribute__ ((unused)),
    const char *prompt,
    const char *defresult __attribute__ ((unused)),
    const char **result,
    unsigned *len);
int sasl_auth_callbacks_init(
    sasl_callback_t *callbacks,
    size_t n_callbacks,
    const char *username,
    const char *passwd,
    const char *realm);
int sasl_auth_start(
    sasl_conn_t **conn,
    sasl_callback_t *callbacks,
    char *mech_list,
    const char **mech,
    char *token_out,
    size_t token_out_size);
int sasl_auth_reply(
    sasl_conn_t *conn,
    const char *token_in,
    char *token_out,
    size_t token_out_size);
void sasl_auth_end(sasl_conn_t **conn);
#endif

int file_exists(const char *path);
int file_is_dir(const char *path);
int file_is_reg(const char *path);

int path_scanf(const char *path, const char *format, ...);
int path_printf(const char *path, const char *format, ...);
int path_read_address(const char *path, char *addr);
int hex_atoi(char *buf);

char *strrstrip(char *str);
char *atcmd_value_tok(char **str);
char *atcmd_response_brk(char **str);

int is_ppp_link_up();
int bring_ppp_link_up();

}

#endif  // ANNEX_COMMON_H_
