/* vim: set sw=2 ts=2 expandtab:
 *
 * Copyright (C) 2010 by Multi-Tech Systems
 *
 * Author: James Maki <jmaki@multitech.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#ifndef DELIVERY_AGENT_H_
#define DELIVERY_AGENT_H_

#include <pthread.h>
#include <annex_common.h>
#include <runnable.h>
#include <annex_transfer.h>
#include <annex_transfer_agent.h>

namespace mts {

class DeliveryAgent : public Runnable, public AnnexTransferAgent {
 public:
  static const char *kSysfsNetDir;

  DeliveryAgent();
  ~DeliveryAgent();

  bool TransferEventRecv(AnnexTransfer *transfer);

  bool Start();
  bool Stop();

  void set_synchronous(bool value);
  bool synchronous() const;
 private:
  void RunnableCore();

  void AddIpAddrs(annex::InetSettings *is, const char *dev);
  void HandleGetNetworkInterface(
      const annex::Package &package_in,
      const annex::NetworkInterface &ni_in);
  void SendNetworkInterfaceStats(const char *if_name);
  void SendNetworkStats();
  void CellularRadioFillFromLog(annex::CellularRadio *cr);
  void HandleGetCellularRadio(
      const annex::Package &package_in,
      const annex::CellularRadio &cr_in);
  void SendCellularRadio(void);
  void HandleGetAnnexVersion(
      const annex::Package &package_in,
      const annex::AnnexVersion &annex_ver);
  void HandleSetClientConfig(
      const annex::Package &package_in,
      const annex::ClientConfig &client_config);
  bool SendUpgradeStatus(
      int sendq_timeout_msec,
      annex::SoftwareUpgradeStatus_Code status_code,
      annex::File *file,
      const char *status_msg);
  void HandleDoSoftwareUpgrade(
      const annex::Package &package_in,
      const annex::SoftwareUpgrade &su_in);
  void HandleDoReboot(
      const annex::Package &package_in,
      const annex::Reboot &reboot_in);
  void HandleAction(
      const annex::Package &package_in,
      const annex::Action &action_in);
  void HandlePackage(const annex::Package &package_in);

  bool RequestPackageDelivery();
  bool MediaCardAvailable();
  bool Md5sumCheck(std::string &file, std::string &md5sum_expected);
  void PerformSoftwareUpgrade();

  bool synchronous_;

  bool restart_;

  std::string su_uri_;
  std::string su_scheme_;
  std::string su_host_;
  std::string su_port_;
  std::string su_path_;
  std::string su_md5sum_;
  std::string su_name_;
  std::string su_download_file_path_;

  std::string su_prev_uri_;
  std::string su_prev_md5sum_;
  bool su_resume_;

  int su_cdp_;
  int su_rcell_;
  int su_rcell_config_;

  DISALLOW_COPY_AND_ASSIGN(DeliveryAgent);
};

}
#endif  // DELIVERY_AGENT_H_
