/* vim: set sw=2 ts=2 expandtab:
 *
 * Copyright (C) 2010 by Multi-Tech Systems
 *
 * Author: James Maki <jmaki@multitech.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#ifndef GPIO_H_
#define GPIO_H_

#include <pthread.h>
#include <string>
#include <stdint.h>
#include <vector>

#include <annex_common.h>
#include <runnable.h>
#include <annex_transfer_agent.h>
#include <annex_transfer.h>

namespace mts {

class Courier;

class Gpio : public Runnable, public AnnexTransferAgent {
 public:
  static const char *kSysfsPlaformDir;

  struct SysfsPlatformGpio {
    std::string sysfs_path;
    annex::Gpio annex_gpio;
    int last_value;
  };
  struct SysfsPlatformSensor {
    std::string sysfs_path;
    annex::Sensor annex_sensor;
    int last_value;
  };

  Gpio();
  ~Gpio();

  bool Start();
  bool Stop();
 private:
  void RunnableCore();

  bool TransferEventRecv(AnnexTransfer *transfer);

  SysfsPlatformGpio *SysfsPlatformGpioAdd(
      annex::Gpio_Type type,
      const std::string &label);
  SysfsPlatformSensor *SysfsPlatformSensorAdd(
    const std::string &name,
    annex::Scalar_Type value_type);
  SysfsPlatformGpio *SysfsPlatformGpioGet(const std::string &label);
  SysfsPlatformSensor *SysfsPlatformSensorGet(const std::string &name);
  void HandleGetGpio(
      const annex::Package &package_in,
      const annex::Gpio &gpio_in);
  void HandleSetGpio(
      const annex::Package &package_in,
      const annex::Gpio &gpio_in);
  void MonitorTriggers();
  bool SysfsReadScalar(
      const std::string &path,
      annex::Scalar *scalar);
  void HandleGetSensor(
      const annex::Package &package_in,
      const annex::Sensor &sensor_in);
  void HandlePackage(const annex::Package &package_in);

  std::vector<SysfsPlatformGpio> sysfs_platform_gpios_;
  std::vector<SysfsPlatformSensor> sysfs_platform_sensors_;

  DISALLOW_COPY_AND_ASSIGN(Gpio);
};

}
#endif  // GPIO_H_
