#ifndef LOG_H_
#define LOG_H_

#include <config.h>
#include <syslog.h>

#define log_(level, name, format, args...) \
  syslog(level, "[" name "] %s:%s:%d: " format "\n" , \
      __FILE__ , __func__ , __LINE__ , ## args)

#define log_emerg(format, args...)    log_(LOG_EMERG, "EMERG", format , ## args)
#define log_alert(format, args...)    log_(LOG_ALERT, "ALERT", format , ## args)
#define log_crit(format, args...)     log_(LOG_CRIT, "CRIT", format , ## args)
#define log_err(format, args...)      log_(LOG_ERR, "ERR", format , ## args)
#define log_warning(format, args...)  log_(LOG_WARNING, "WARNING", format , ## args)
#define log_notice(format, args...)   log_(LOG_NOTICE, "NOTICE", format , ## args)
#define log_info(format, args...)     log_(LOG_INFO, "INFO", format , ## args)
#define log_debug(format, args...)    log_(LOG_DEBUG, "DEBUG", format , ## args)

#endif /* ~LOG_H_ */
