/* vim: set sw=2 ts=2 expandtab:
 *
 * Copyright (C) 2010 by Multi-Tech Systems
 *
 * Author: James Maki <jmaki@multitech.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#ifndef RUNNABLE_H_
#define RUNNABLE_H_

#include <pthread.h>

namespace mts {

class Runnable {
 public:
  Runnable() {
    runnable_running_ = false;
    runnable_exists_ = false;
    runnable_stop_ = true;
  }

  virtual ~Runnable() {
  }

  static void *StartRunnable(void *arg) {
    pthread_setcancelstate(PTHREAD_CANCEL_DISABLE, NULL);
    pthread_setcanceltype(PTHREAD_CANCEL_DEFERRED, NULL);

    Runnable *sm = reinterpret_cast<Runnable *>(arg);

    sm->RunnableRun();

    pthread_exit((void *) 0);
  }

  bool Start() {
    int tmp;

    if (runnable_exists_) {
      log_err("runnable thread already exists");
      return false;
    }
    runnable_stop_ = true;
    tmp = pthread_create(&runnable_tid_, NULL, &StartRunnable, this);
    if (tmp) {
      log_err("pthread_create StartRunnable failed: %d", tmp);
      return false;
    }
    runnable_exists_ = true;
    while (runnable_stop_) continue;

    return true;
  }

  bool Stop() {
    runnable_stop_ = true;
    if (runnable_exists_) {
      pthread_join(runnable_tid_, NULL);
    }
    runnable_exists_ = false;

    return true;
  }

  bool Running() {
    return runnable_running_;
  }

 protected:
  virtual void RunnableCore() = 0;

  void RunnableRun() {
    runnable_running_ = true;
    runnable_stop_ = false;

    RunnableCore();

    runnable_running_ = false;
  }

  pthread_t runnable_tid_;
  volatile bool runnable_exists_;
  volatile bool runnable_running_;
  volatile bool runnable_stop_;

  DISALLOW_COPY_AND_ASSIGN(Runnable);
};

}
#endif  // RUNNABLE_H_
