/* vim: set sw=2 ts=2 expandtab:
 *
 * Copyright (C) 2010 by Multi-Tech Systems
 *
 * Author: James Maki <jmaki@multitech.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#ifndef VALIDATOR_H_
#define VALIDATOR_H_

#include <pthread.h>
#include <string>
#include <stdint.h>

#include <annex_common.h>
#include <runnable.h>
#include <annex_transfer_agent.h>
#include <annex_transfer.h>

namespace mts {

class Courier;

class Validator : public AnnexTransferAgent {
 public:
  Validator() {}
  ~Validator() {}
 private:

  bool ValidateGpio(const annex::Package &package, const annex::Gpio &gpio);
  bool ValidateSensor(const annex::Package &package, const annex::Sensor &sensor);
  bool ValidateNotification(const annex::Package &package, const annex::Notification &note);
  bool ValidateAction(const annex::Package &package, const annex::Action &action);
  bool ValidateAttribute(const annex::Package &package, const annex::Attribute &attr);
  bool ValidateSoftwareUpgrade(const annex::Package &package, const annex::SoftwareUpgrade &su);
  bool ValidateReboot(const annex::Package &package, const annex::Reboot &reboot);
  bool ValidateFunction(const annex::Package &package, const annex::Function &func);
  bool ValidateContent(const annex::Package &package, const annex::Content &content);
  bool Validate(const annex::Package &package);

  bool TransferEventReply(AnnexTransfer *transfer);
  bool TransferEventRecv(AnnexTransfer *transfer);

  DISALLOW_COPY_AND_ASSIGN(Validator);
};

}
#endif  // VALIDATOR_H_
