### Generated by rprotoc. DO NOT EDIT!
### <proto file: annex.proto>
# // vi: set sw=2 ts=2 expandtab:
# //
# // Copyright (C) 2010 by Multi-Tech Systems
# //
# // This program is free software; you can redistribute it and/or modify
# // it under the terms of the GNU General Public License as published by
# // the Free Software Foundation; either version 2 of the License, or
# // (at your option) any later version.
# //
# // This program is distributed in the hope that it will be useful,
# // but WITHOUT ANY WARRANTY; without even the implied warranty of
# // MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
# // General Public License for more details.
# //
# // You should have received a copy of the GNU General Public License
# // along with this program; if not, write to the Free Software
# // Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
# //
# // Designed by James Maki <jmaki@multitech.com>
# 
# 
# // Protobuf default values:
# //
# // All fields in a message description should be marked as optional. Whether
# // the field is actually required by the receiver, depends on the context in
# // which the message is used. For example, Package.correlation_id is optional
# // and it only makes sense to set this field in a response to a previous
# // request.
# //
# // Explicitly defined default values should be avoided unless there is a very
# // good reason to provide one.
# //
# // If a default value is not explicitly specified as part of the message
# // description, then the default value should be ignored when operating on the
# // message.
# //
# // The has_[foo] method always needs to be checked for fields that do
# // not explicitly specify a default value in the message description.
# //
# // If has_[foo] is false for such an field then the below rules need to be
# // followed:
# //
# //   If the optional field is required to continue processing the message,
# //   then it should be treated as an error and processing should stop.
# //
# //   If the optional field is not required to continue processing the
# //   message, then the fields value should be ignored and processing
# //   should continue as if the value was not provided at all. If the field
# //   is an optional sub-message the entire sub-message will be ignored, even if
# //   it contains fields with explicit default values.
# 
# // Naming conventions:
# //
# // Enumeration value names should always be prefixed with the enumeration name
# // translated from camel case to upper case format.
# //
# // Message names should be in camel case. Even acronyms should be camel case.
# // e.g., GPS in a message name will be Gps.
# //
# // Field names should be in all lower case using underscores to delimit words.
# //
# // Try to name fields based on their type.
# // e.g. optional GpsReceiver gps_receiver = 2045;
# 
# // Making a C implementation behave like C++:
# //
# // All enumeration values must be handled in a switch statement. The default case
# // must have special behavior. The default case should be used to handle values
# // that are not yet defined in the protocol.
# //
# // If the field's default value is explicitly specified in the message
# // description, then the default case should treat the field as if it were
# // set to the default value.
# //
# // If the field's default value is not explicitly specified in the message
# // description, then the default case should treat the field as if it were
# // not set i.e., has_[foo] returned false.
# 
# 
# 
# // Changes required for all implementations of 0.1.0:
# //
# // Expanded STATUS_CODES_
# //
# // It is no longer a requirement for SessionInit to be the first message. Use
# // STATUS_CODE_SESSION_INIT_REQUIRED to notify the sender that a message must be
# // preceded by SessionInit.
# //
# // There are only a handful of cases right now where you should close the connection
# // instead of returning an error.
# //
# //   - If the size of the message is too large to de-serialize
# //   - If de-serialization fails
# //   - If you are unable to respond to the sender because of an invalid
# //     request.
# //
# 
# // Changes expected in 0.2.0:
# //
# // Support SASL authentication before SessionInit
# //
# // TLS support on port 5799
# //
# // Possible support for TLS upgrade prior to SessionInit.
# 
# option optimize_for = SPEED;
# // Set for resource constrained clients.
# // option optimize_for = LITE_RUNTIME;
# 
# option java_package = "com.multitech.management";
# option java_outer_classname = "Annex";
# 
# package annex;
# 
# message AnnexVersion {
#   // The default value changes when the version changes,
#   // so you must set version to the default before sending
#   // it because the other side may have a different default
#   // value.
#   optional string version = 1 [default = "0.1.2"];
# }
# 
# // The top level message exchanged between devices.
# message Container {
#   repeated Package packages = 1;
# }
# 
# message Package {
#   enum StatusCode {
#     // Do not use this value.
#     STATUS_CODE_NONE = 0;
# 
#     STATUS_CODE_OK = 1;
#     STATUS_CODE_ACCEPTED = 2;
#     STATUS_CODE_WAITING_FOR_RESPONSE = 3;
#     STATUS_CODE_NOT_FOUND = 4;
#     STATUS_CODE_UNKNOWN = 5;
#     STATUS_CODE_UNSUPPORTED = 6;
#     STATUS_CODE_UNIMPLEMENTED = 7;
#     STATUS_CODE_INVALID_FIELD = 8;
#     STATUS_CODE_EXPECTED_FIELD = 9;
#     STATUS_CODE_UNEXPECTED_FIELD = 10;
#     STATUS_CODE_SESSION_INIT_REQUIRED = 11;
#     STATUS_CODE_AUTH_REQUIRED = 12;
#     STATUS_CODE_AUTH_FAILED = 13;
#     STATUS_CODE_NOT_ALLOWED = 14;
#     STATUS_CODE_INTERNAL_ERROR = 15;
#     STATUS_CODE_FORBIDDEN = 16;
#     STATUS_CODE_CONFLICT = 17;
#     STATUS_CODE_RESOURCE_BUSY = 18;
#   }
# 
#   // Identifier for this package during the session.
#   optional uint32 message_id = 1;
# 
#   // Identifies the package that this package is in response to.
#   optional uint32 correlation_id = 2;
# 
#   // Request for the receiver to respond with positive acknowledgement
#   // of this package when under normal circumstances the receiver
#   // would not generate a response.
#   optional bool request_ack = 3;
# 
#   // Should be set by the receiver when responding to a package.
#   optional StatusCode status_code = 4;
#   // A human readable message describing the reason for the status_code.
#   optional string status_message = 5;
# 
#   // A priority supplied by the sender which may alter the order in which this
#   // package is processed by the receiver or when the information contained is
#   // acted upon.
#   //
#   // 0 (lowest) - 9 (highest)
#   optional uint32 priority = 6 [default = 4];
# 
#   // RFC 3339 formatted UTC timestamps.
#   //
#   // strftime() format is %Y-%m-%dT%H:%M:%SZ
#   //
#   // The time at which this package is no longer valid.
#   optional string time_expires = 7;
#   // The time at which this package was created.
#   optional string time_packaged = 8;
#   // The time at which this package was actually sent.
#   optional string time_sent = 9;
# 
#   // The contents of this package. A package may not contain anything if it is
#   // only a simple acknowledgement.
#   optional Content content = 15;
# }
# 
# message Content {
#   enum Type {
#     TYPE_SESSION_INIT = 0;
#     TYPE_REQUEST_PACKAGE_DELIVERY = 1;
#     TYPE_NOTIFICATION = 2;
#     TYPE_ACTION = 3;
#     TYPE_ATTRIBUTE = 4;
#   }
# 
#   optional Type type = 1;
# 
#   optional SessionInit session_init = 2;
#   optional RequestPackageDelivery request_package_delivery = 3;
#   optional Notification notification = 4;
#   optional Action action = 5;
#   optional Attribute attribute = 6;
# }
# 
# message Scalar {
#   enum Type {
#     TYPE_INT32 = 0;
#     TYPE_UINT32 = 1;
#     TYPE_SINT32 = 2;
#     TYPE_FIXED32 = 3;
#     TYPE_SFIXED32 = 4;
# 
#     TYPE_BOOL = 5;
#     TYPE_STRING = 6;
#     TYPE_BYTES = 7;
#     TYPE_DOUBLE = 8;
#     TYPE_FLOAT = 9;
# 
#     TYPE_INT64 = 10;
#     TYPE_UINT64 = 11;
#     TYPE_SINT64 = 12;
#     TYPE_FIXED64 = 13;
#     TYPE_SFIXED64 = 14;
#   }
# 
#   optional Type type = 1;
# 
#   optional int32 int32 = 2;
#   optional uint32 uint32 = 3;
#   optional sint32 sint32 = 4;
#   optional fixed32 fixed32 = 5;
#   optional sfixed32 sfixed32 = 6;
# 
#   optional bool bool = 7;
#   optional string string = 8;
#   optional bytes bytes = 9;
#   optional double double = 10;
#   optional float float = 11;
# 
#   optional int64 int64 = 12;
#   optional uint64 uint64 = 13;
#   optional sint64 sint64 = 14;
#   optional fixed64 fixed64 = 15;
#   optional sfixed64 sfixed64 = 16;
# }
# 
# message KeyValuePair {
#   message Value {
#     enum Type {
#       TYPE_SCALAR = 0;
#       TYPE_KEY_VALUE_PAIR = 1;
#     }
# 
#     optional Type type = 1;
# 
#     optional Scalar scalar = 2;
#     optional KeyValuePair key_value_pair = 3;
#   }
# 
#   optional string key = 1;
#   repeated Value value = 2;
# }
# 
# message SaslToken {
#   optional string base64_data = 1;
# }
# 
# message SaslAuth {
#   optional string mechanism = 1;
#   optional SaslToken sasl_token = 2;
# }
# 
# // Initialize the session. Must be sent once at the start of the session.
# //
# // response-status-code:
# //
# // STATUS_CODE_OK if the session was initialized successfully.
# // STATUS_CODE_WAITING_FOR_RESPONSE if the authentication mechanism used requires
# // more data.
# //
# // response-content:
# //
# // If status code is STATUS_CODE_WAITING_FOR_RESPONSE, then content should be a
# // SaslToken attribute. Otherwise content is omitted.
# //
# message SessionInit {
#   // e.g., host.example.com
#   optional string hostname = 1;
# 
#   // The ID of the company that created this device.
#   // All vendor_ids must be registered with the server maintainer to keep them
#   // unique.
#   // e.g., Multi-Tech
#   optional string vendor_id = 2;
# 
#   // Identifies a specific product from a vendor.
#   // e.g., MTCBA-E1-EN2
#   optional string product_id = 3;
# 
#   // Unique device identifier.
#   // e.g., serial number
#   optional string device_id = 4;
# 
#   // The product's software version.
#   optional string sw_version = 5;
# 
#   // The product's hardware version.
#   optional string hw_version = 6;
# 
#   // Authenticate using one of the SASL mechanism supported by the server.
#   optional SaslAuth sasl_auth = 7;
# 
#   // Inform the server that all communication during this session should be
#   // initiated by this side first. All packages received should have
#   // Package.correlation_id set.
#   //
#   // RequestPackageDelivery must be used to receive non-response generated
#   // packages from the server and the RequestPackageDelivery response should
#   // arrive in a single Container.
#   optional bool synchronized = 14 [default = true];
# 
#   // The maximum size of serialized container this side is willing to accept
#   // when receiving.
#   optional uint32 container_buffer_max = 15;
# }
# 
# message RequestPackageDelivery {
#   // Request delivery of packages of this priority or higher.
#   optional uint32 priority = 1  [default = 0];
# 
#   // The maximum number of packages that should be sent in response.
#   optional uint32 package_limit = 2;
# }
# 
# // A Notification is a string message plus an optional attribute with a level
# // of importance attached to it.
# //
# // Avoid sending notifications to the server in situations where the server
# // is capable of determining a similar outcome.
# //
# // Example:
# //
# // The device has a temperature sensor attached. Under normal operation the
# // sensor reading should be between 33 and 90 degrees Fahrenheit.
# //
# // At some point in time the devices reads 32 degrees from the sensor. The device
# // could send a notification to the server informing it of this condition, but
# // now the device has to decide what level of importance to attach to this
# // condition. It makes more sense to send the sensor attribute directly to the
# // server and let the server decide how important the temperature change is.
# //
# // Later on, the device tries to read the temperature sensor and it fails. The
# // device determines that the sensor has been unplugged. In this case the device
# // should send a notification to let the server know that the sensor is no
# // no longer present. The sensor attribute could be attached to clarify which
# // sensor is actually gone.
# //
# // response-status-code:
# //
# // STATUS_CODE_OK if request_ack is set in containing package and the notification
# // is handled normally.
# //
# message Notification {
#   enum Level {
#     LEVEL_EMERG = 0;
#     LEVEL_ALERT = 1;
#     LEVEL_CRIT = 2;
#     LEVEL_ERR = 3;
#     LEVEL_WARNING = 4;
#     LEVEL_NOTICE = 5;
#     LEVEL_INFO = 6;
#     LEVEL_DEBUG = 7;
#   }
# 
#   optional Level level = 1;
#   optional string message = 2;
#   optional Attribute attribute = 3;
# }
# 
# message Action {
#   enum Type {
#     TYPE_GET = 0;
#     TYPE_SET = 1;
#     TYPE_DO = 2;
#   }
# 
#   optional Type type = 1;
# 
#   // The attribute to get or set.
#   optional Attribute attribute = 2;
# 
#   // The function to perform when type is TYPE_DO.
#   optional Function function = 3;
# }
# 
# message Attribute {
#   enum Type {
#     TYPE_KEY_VALUE_PAIR = 0;
#     TYPE_GPS_NMEA = 1;
#     TYPE_GPIO = 2;
#     TYPE_SENSOR = 3;
# 
#     TYPE_ANNEX_VERSION = 2034;
#     TYPE_SASL_TOKEN = 2035;
#     TYPE_SASL_SERVER_MECH_LIST = 2036;
#     TYPE_AW_CELLULAR_PORT = 2037;
#     TYPE_AW_ANALOG_PORT = 2038;
#     TYPE_FILE_BUFFER = 2039;
#     TYPE_FILE_POS = 2040;
#     TYPE_FILE = 2041;
#     TYPE_SERIAL_PORT = 2042;
#     TYPE_GPS_RECEIVER = 2043;
#     TYPE_CELLULAR_RADIO = 2044;
#     TYPE_NETWORK_INTERFACE = 2045;
#     TYPE_EXTENSION = 2046;
#   }
# 
#   optional Type type = 1;
# 
#   optional KeyValuePair key_value_pair = 2;
#   optional GpsNmea gps_nmea = 3;
#   optional Gpio gpio = 4;
#   optional Sensor sensor = 5;
# 
#   optional AnnexVersion annex_version = 2036;
#   optional SaslToken sasl_token = 2037;
#   optional SaslServerMechList sasl_server_mech_list = 2038;
#   optional AwCellularPort aw_cellular_port = 2039;
#   optional AwAnalogPort aw_analog_port = 2040;
#   optional FileBuffer file_buffer = 2041;
#   optional FilePos file_pos = 2042;
#   optional File file = 2043;
#   optional SerialPort serial_port = 2044;
#   optional GpsReceiver gps_receiver = 2045;
#   optional CellularRadio cellular_radio = 2046;
#   optional NetworkInterface network_interface = 2047;
# 
#   extensions 2048 to 4095;
# }
# 
# message Function {
#   enum Type {
#     TYPE_FILE_READ = 0;
# 
#     TYPE_SOFTWARE_UPGRADE = 2039;
#     TYPE_FILE_OPEN = 2040;
#     TYPE_FILE_CLOSE = 2041;
#     TYPE_FILE_WRITE = 2042;
#     TYPE_FILE_GET_POS = 2043;
#     TYPE_FILE_SET_POS = 2044;
#     TYPE_REBOOT = 2045;
#     TYPE_EXTENSION = 2046;
#   }
# 
#   optional Type type = 1;
# 
#   optional FileRead file_read = 2;
# 
#   optional SoftwareUpgrade software_upgrade = 2041;
#   optional FileOpen file_open = 2042;
#   optional FileClose file_close = 2043;
#   optional FileWrite file_write = 2044;
#   optional FileGetPos file_get_pos = 2045;
#   optional FileSetPos file_set_pos = 2046;
#   optional Reboot reboot = 2047;
# 
#   extensions 2048 to 4095;
# }
# 
# 
# message GpsNmea {
#   optional string gpgga = 1;
#   optional string gpgsa = 2;
#   repeated string gpgsv = 3;
#   optional string gpgll = 4;
#   optional string gprmc = 5;
#   optional string gpvtg = 6;
# }
# 
# message Gpio {
#   enum Type {
#     TYPE_DIGITAL_INPUT = 0;
#     TYPE_DIGITAL_OUTPUT = 1;
#     TYPE_ANALOG_TO_DIGITAL = 2;
#   }
# 
#   enum DioTrigger {
#     DIO_TRIGGER_NONE = 0;
#     DIO_TRIGGER_EDGE_RISING = 1;
#     DIO_TRIGGER_EDGE_FALLING = 2;
#     DIO_TRIGGER_EDGE_BOTH = 3;
#     DIO_TRIGGER_LEVEL_HIGH = 4;
#     DIO_TRIGGER_LEVEL_LOW = 5;
#   }
# 
#   optional Type type = 1;
# 
#   optional string label = 2;
#   optional uint32 line = 3;
# 
#   optional uint32 value = 4;
#   optional bool internal_pullup = 5;
# 
#   optional DioTrigger dio_trigger = 6;
# }
# 
# message Sensor {
#   optional string name = 1;
#   optional Scalar value = 2;
# }
# 
# message SaslServerMechList {
#   // A list of mechanisms supported by the server.
#   repeated string mechanism = 1;
# }
# 
# // Request to upgrade a software package or component.
# //
# // response-status-code:
# //
# // STATUS_CODE_ACCEPTED after successful processing.
# //
# message SoftwareUpgrade {
#   // The name of the software package known by the device.
#   optional string name = 1;
# 
#   // The URI of the software package.
#   //
#   // The device must at least support the annex scheme.
#   //
#   // If the URI is a URL with scheme annex then the device
#   // will download the software by using the File* functions
#   // defined in this protocol. The device can either open a new
#   // session or perform the download from within this session.
#   optional string uri = 2;
# 
#   // The device may require one of the following to validate the
#   // software after downloading.
#   optional fixed32 cksum = 3;
#   optional string md5sum = 4;
#   optional string sha256sum = 5;
# }
# 
# // Open a file on the remote.
# //
# // response-status-code:
# //
# // STATUS_CODE_OK after successfully opening the file.
# //
# // response-content:
# //
# // A File attribute with File.fileno set to a number representing the newly
# // opened file.
# //
# message FileOpen {
#   optional string path = 1;
#   optional string mode = 2;
# }
# 
# // Close a previously opened file on the remote.
# //
# // response-status-code:
# //
# // STATUS_CODE_OK after successfully closing file.
# //
# message FileClose {
#   optional File file = 1;
# }
# 
# // Writes buffer to file opened on remote.
# //
# // response-status-code:
# //
# // STATUS_CODE_OK after successfully writing buffer.
# //
# message FileWrite {
#   optional File file = 1;
#   optional bytes buffer = 2;
# }
# 
# // Reads at most length bytes from file or to end of file if length is omitted.
# //
# // response-status-code:
# //
# // STATUS_CODE_OK after successfully writing buffer.
# //
# // response-content:
# //
# // A FileBuffer attribute containing the data read.
# //
# // If file is at eof and length is omitted then FileBuffer.buffer is set
# // to an empty buffer.
# //
# // If file is at eof and length is not omitted then FileBuffer.buffer is
# // not set.
# //
# message FileRead {
#   optional File file = 1;
#   optional uint32 length = 2;
# }
# 
# // Get the current file position.
# //
# // response-status-code:
# //
# // STATUS_CODE_OK if the position is found.
# //
# // response-content:
# //
# // A FilePos attribute set to the current file position.
# //
# message FileGetPos {
#   optional File file = 1;
# }
# 
# // Set the file position.
# //
# // response-status-code:
# //
# // STATUS_CODE_OK if the position set.
# //
# message FileSetPos {
#   optional File file = 1;
#   optional FilePos pos = 2;
# }
# 
# message FileBuffer {
#   optional bytes buffer = 1;
#   optional bool eof = 2;
# }
# 
# message FilePos {
#   optional uint32 pos = 1;
# }
# 
# message File {
#   optional uint32 fileno = 1;
# }
# 
# // Execute reboot command on remote device.
# //
# // response-status-code:
# //
# // STATUS_CODE_ACCEPTED after successful processing.
# //
# // The actual reboot may be delayed by a reasonable amount of time after the
# // request is processed. The device may send notification when the reboot
# // actually occurs.
# //
# message Reboot {
#   enum Cmd {
#     CMD_RESTART = 0;
#     CMD_HALT = 1;
#     CMD_POWER_OFF = 2;
#   }
# 
#   optional Cmd cmd = 1;
# }
# 
# message TerminalAttributes {
#   enum Speed {
#     SPEED_0 = 0;
#     SPEED_50 = 1;
#     SPEED_75 = 2;
#     SPEED_110 = 3;
#     SPEED_134 = 4;
#     SPEED_150 = 5;
#     SPEED_200 = 6;
#     SPEED_300 = 7;
#     SPEED_600 = 8;
#     SPEED_1200 = 9;
#     SPEED_1800 = 10;
#     SPEED_2400 = 11;
#     SPEED_4800 = 12;
#     SPEED_9600 = 13;
#     SPEED_19200 = 14;
#     SPEED_38400 = 15;
#     SPEED_57600 = 16;
#     SPEED_115200 = 17;
#     SPEED_230400 = 18;
#     SPEED_460800 = 19;
#     SPEED_500000 = 20;
#     SPEED_576000 = 21;
#     SPEED_921600 = 22;
#     SPEED_1000000 = 23;
#     SPEED_1152000 = 24;
#     SPEED_1500000 = 25;
#     SPEED_2000000 = 26;
#     SPEED_2500000 = 27;
#     SPEED_3000000 = 28;
#     SPEED_3500000 = 29;
#     SPEED_4000000 = 30;
#   }
# 
#   enum DataBits {
#     DATA_BITS_FIVE = 5;
#     DATA_BITS_SIX = 6;
#     DATA_BITS_SEVEN = 7;
#     DATA_BITS_EIGHT = 8;
#   }
# 
#   enum Parity {
#     PARITY_NONE = 0;
#     PARITY_ODD = 1;
#     PARITY_EVEN = 2;
#   }
# 
#   enum StopBits {
#     STOP_BITS_ONE = 1;
#     STOP_BITS_TWO = 2;
#   }
# 
#   optional Speed speed = 1;
#   optional DataBits data_bits = 2;
#   optional Parity parity = 3;
#   optional StopBits stop_bits = 4;
# }
# 
# message SerialPort {
#   optional string name = 1;
#   optional TerminalAttributes terminal_attributes = 2;
# }
# 
# message GpsReceiver {
#   optional uint32 gpgga = 1;
#   optional uint32 gpgsa = 2;
#   optional uint32 gpgsv = 3;
#   optional uint32 gpgll = 4;
#   optional uint32 gprmc = 5;
#   optional uint32 gpvtg = 6;
# 
#   optional uint32 message_interval = 7;
# }
# 
# message Sim {
#   // AT+CPIN?
#   optional string cpin = 1;
# 
#   // AT+CIMI?
#   optional string imsi = 2;
# }
# 
# message CellularRadio {
#   optional string label = 1;
# 
#   optional Sim sim = 2;
# 
#   // AT+CSQ
#   optional uint32 rssi = 3;
#   optional uint32 fer = 4;
# 
#   // AT+CGSN
#   optional string imei = 5;
# 
#   // AT+CNUM?
#   optional string phone_number = 6;
# }
# 
# message LinkStatistics {
#     optional uint32 rx_bytes = 1;
#     optional uint32 rx_packets = 2;
#     optional uint32 rx_errors = 3;
#     optional uint32 rx_dropped = 4;
#     optional uint32 rx_overrun = 5;
#     optional uint32 rx_multicast = 6;
#     optional uint32 tx_bytes = 7;
#     optional uint32 tx_packets = 8;
#     optional uint32 tx_errors = 9;
#     optional uint32 tx_dropped = 10;
#     optional uint32 tx_carrier = 11;
#     optional uint32 tx_collisions = 12;
# }
# 
# message IpAddrNet {
#   optional uint32 addr = 1;
#   optional uint32 network_prefix_length = 2;
# }
# 
# message InetSettings {
#   enum Method {
#     METHOD_MANUAL = 0;
#     METHOD_DHCP = 1;
#   }
#   optional Method method = 1;
#   repeated IpAddrNet ip_addrs = 2;
#   optional uint32 default_route = 3;
#   repeated uint32 name_servers = 4;
# }
# 
# message NetworkInterface {
#   enum LinkType {
#     LINK_TYPE_LOOPBACK = 772;
#     LINK_TYPE_ETHER = 1;
#     LINK_TYPE_IPIP = 768;
#     LINK_TYPE_GRE = 778;
#     LINK_TYPE_PPP = 512;
#     LINK_TYPE_VOID = 65535;
#   }
# 
#   message Flags {
#     optional bool up = 1;
#     optional bool lower_up = 2;
#     optional bool loopback = 3;
#     optional bool broadcast = 4;
#     optional bool pointtopoint = 5;
#     optional bool multicast = 6;
#     optional bool dynamic = 7;
#     optional bool noarp = 8;
#     optional bool allmulti = 9;
#     optional bool promisc = 10;
#   }
# 
#   optional string name = 1;
#   optional LinkType link_type = 2;
# 
#   optional Flags flags = 3;
# 
#   optional bytes addr = 4;
#   optional bytes broadcast_addr = 5;
#   optional uint32 mtu = 6;
# 
#   optional InetSettings inet_settings = 7;
# 
#   optional LinkStatistics link_statistics = 16;
# }
# 
# message AwCellularPort {
#   enum NetworkType {
#     NETWORK_TYPE_GSM = 0;
#     NETWORK_TYPE_GPRS = 1;
#     NETWORK_TYPE_CDMA = 2;
#     NETWORK_TYPE_A2A = 3;
#     NETWORK_TYPE_A2E = 4;
#     NETWORK_TYPE_AUTO = 9;
#   }
# 
#   enum Protocol {
#     PROTOCOL_DISABLED = 0;
#     PROTOCOL_TCPCLIENT = 1;
#     PROTOCOL_TELNET = 2;
#     PROTOCOL_UDP = 3;
#     PROTOCOL_PING = 4;
#   }
# 
#   enum Direction {
#     DIRECTION_AUTO_DETECT = 1;
#     DIRECTION_OUTBOUND = 3;
#     DIRECTION_INBOUND = 4;
#   }
# 
#   enum ConnectionType {
#     CONNECTION_TYPE_ON_DEMAND = 0;
#     CONNECTION_TYPE_ALWAYS_ON = 1;
#   }
# 
#   enum CellularBand {
#     CELLULAR_BAND_NAM = 0;
#     CELLULAR_BAND_EURO = 1;
#   }
# 
#   message PhoneToIP {
#     optional uint32 port = 1;
#     optional string phone = 2;
#     optional string addr = 3;
#   }
# 
#   optional NetworkType network_type = 1;
#   optional Protocol protocol = 2;
#   optional Direction direction = 3;
#   optional ConnectionType connection_type = 4;
#   optional uint32 localport = 5;
#   optional uint32 remoteport = 6;
#   optional string remote_addr = 7;
# 
#   repeated PhoneToIP phone_to_ip = 8;
# 
#   optional CellularBand cellular_band = 9;
#   optional string apn_un = 10;
#   optional string apn_pw = 11;
#   optional string apn_serv = 12;
#   optional uint32 phytimeout = 13;
#   optional uint32 dlemode = 14;
#   optional uint32 tcptxdelay = 15;
#   optional uint32 handshake_timeout = 16;
#   optional uint32 no_signal_reset_time = 17;
# }
# 
# message AwAnalogPort {
#   enum BaudRate {
#     BAUD_RATE_300 = 0;
#     BAUD_RATE_1200 = 1;
#     BAUD_RATE_2200 = 2;
#     BAUD_RATE_2400 = 3;
#     BAUD_RATE_4800 = 4;
#     BAUD_RATE_9600 = 5;
#     BAUD_RATE_12000 = 6;
#     BAUD_RATE_14400 = 7;
#     BAUD_RATE_28800 = 8;
#     BAUD_RATE_33600 = 9;
#     BAUD_RATE_56000 = 10;
#   }
# 
#   enum Modulation {
#     MODULATION_V92 = 0;
#     MODULATION_V90 = 1;
#     MODULATION_V34 = 2;
#     MODULATION_V32BIS = 3;
#     MODULATION_V32 = 4;
#     MODULATION_V22BIS = 5;
#     MODULATION_V22 = 6;
#     MODULATION_BELL212A = 7;
#     MODULATION_BELL103 = 8;
#   }
# 
#   enum Ecm {
#     ECM_NONE = 0;
#     ECM_DIRECT_MODE = 1;
#     ECM_MNP = 2;
#     ECM_V42MNP = 3;
#     ECM_V42 = 4;
#   }
# 
#   enum Compression {
#     COMPRESSION_NONE = 0;
#     COMPRESSION_V42BIS_MNP5 = 1;
#   }
# 
#   enum FlowControl {
#     FLOW_CONTROL_NONE = 0;
#     FLOW_CONTROL_XON_XOFF = 1;
#     FLOW_CONTROL_RTS_CTS = 2;
#   }
# 
#   optional string init_str = 1;
#   optional BaudRate baudrate = 2;
#   optional Modulation modulation = 3;
#   optional Ecm ecm = 4;
#   optional Compression compression = 5;
#   optional FlowControl flow_control = 6;
#   optional uint32 handshake_timeout = 7;
#   optional uint32 dialed_digit_timeout = 8;
# }

require 'protobuf/message/message'
require 'protobuf/message/enum'
require 'protobuf/message/service'
require 'protobuf/message/extend'

::Protobuf::OPTIONS[:"optimize_for"] = :SPEED
::Protobuf::OPTIONS[:"java_package"] = "com.multitech.management"
::Protobuf::OPTIONS[:"java_outer_classname"] = "Annex"
module Annex
  class AnnexVersion < ::Protobuf::Message
    defined_in __FILE__
    optional :string, :version, 1, :default => "0.1.2"
  end
  class Container < ::Protobuf::Message
    defined_in __FILE__
    repeated :Package, :packages, 1
  end
  class Package < ::Protobuf::Message
    defined_in __FILE__
    class StatusCode < ::Protobuf::Enum
      defined_in __FILE__
      STATUS_CODE_NONE = value(:STATUS_CODE_NONE, 0)
      STATUS_CODE_OK = value(:STATUS_CODE_OK, 1)
      STATUS_CODE_ACCEPTED = value(:STATUS_CODE_ACCEPTED, 2)
      STATUS_CODE_WAITING_FOR_RESPONSE = value(:STATUS_CODE_WAITING_FOR_RESPONSE, 3)
      STATUS_CODE_NOT_FOUND = value(:STATUS_CODE_NOT_FOUND, 4)
      STATUS_CODE_UNKNOWN = value(:STATUS_CODE_UNKNOWN, 5)
      STATUS_CODE_UNSUPPORTED = value(:STATUS_CODE_UNSUPPORTED, 6)
      STATUS_CODE_UNIMPLEMENTED = value(:STATUS_CODE_UNIMPLEMENTED, 7)
      STATUS_CODE_INVALID_FIELD = value(:STATUS_CODE_INVALID_FIELD, 8)
      STATUS_CODE_EXPECTED_FIELD = value(:STATUS_CODE_EXPECTED_FIELD, 9)
      STATUS_CODE_UNEXPECTED_FIELD = value(:STATUS_CODE_UNEXPECTED_FIELD, 10)
      STATUS_CODE_SESSION_INIT_REQUIRED = value(:STATUS_CODE_SESSION_INIT_REQUIRED, 11)
      STATUS_CODE_AUTH_REQUIRED = value(:STATUS_CODE_AUTH_REQUIRED, 12)
      STATUS_CODE_AUTH_FAILED = value(:STATUS_CODE_AUTH_FAILED, 13)
      STATUS_CODE_NOT_ALLOWED = value(:STATUS_CODE_NOT_ALLOWED, 14)
      STATUS_CODE_INTERNAL_ERROR = value(:STATUS_CODE_INTERNAL_ERROR, 15)
      STATUS_CODE_FORBIDDEN = value(:STATUS_CODE_FORBIDDEN, 16)
      STATUS_CODE_CONFLICT = value(:STATUS_CODE_CONFLICT, 17)
      STATUS_CODE_RESOURCE_BUSY = value(:STATUS_CODE_RESOURCE_BUSY, 18)
    end
    optional :uint32, :message_id, 1
    optional :uint32, :correlation_id, 2
    optional :bool, :request_ack, 3
    optional :StatusCode, :status_code, 4
    optional :string, :status_message, 5
    optional :uint32, :priority, 6, :default => 4
    optional :string, :time_expires, 7
    optional :string, :time_packaged, 8
    optional :string, :time_sent, 9
    optional :Content, :content, 15
  end
  class Content < ::Protobuf::Message
    defined_in __FILE__
    class Type < ::Protobuf::Enum
      defined_in __FILE__
      TYPE_SESSION_INIT = value(:TYPE_SESSION_INIT, 0)
      TYPE_REQUEST_PACKAGE_DELIVERY = value(:TYPE_REQUEST_PACKAGE_DELIVERY, 1)
      TYPE_NOTIFICATION = value(:TYPE_NOTIFICATION, 2)
      TYPE_ACTION = value(:TYPE_ACTION, 3)
      TYPE_ATTRIBUTE = value(:TYPE_ATTRIBUTE, 4)
    end
    optional :Type, :type, 1
    optional :SessionInit, :session_init, 2
    optional :RequestPackageDelivery, :request_package_delivery, 3
    optional :Notification, :notification, 4
    optional :Action, :action, 5
    optional :Attribute, :attribute, 6
  end
  class Scalar < ::Protobuf::Message
    defined_in __FILE__
    class Type < ::Protobuf::Enum
      defined_in __FILE__
      TYPE_INT32 = value(:TYPE_INT32, 0)
      TYPE_UINT32 = value(:TYPE_UINT32, 1)
      TYPE_SINT32 = value(:TYPE_SINT32, 2)
      TYPE_FIXED32 = value(:TYPE_FIXED32, 3)
      TYPE_SFIXED32 = value(:TYPE_SFIXED32, 4)
      TYPE_BOOL = value(:TYPE_BOOL, 5)
      TYPE_STRING = value(:TYPE_STRING, 6)
      TYPE_BYTES = value(:TYPE_BYTES, 7)
      TYPE_DOUBLE = value(:TYPE_DOUBLE, 8)
      TYPE_FLOAT = value(:TYPE_FLOAT, 9)
      TYPE_INT64 = value(:TYPE_INT64, 10)
      TYPE_UINT64 = value(:TYPE_UINT64, 11)
      TYPE_SINT64 = value(:TYPE_SINT64, 12)
      TYPE_FIXED64 = value(:TYPE_FIXED64, 13)
      TYPE_SFIXED64 = value(:TYPE_SFIXED64, 14)
    end
    optional :Type, :type, 1
    optional :int32, :int32, 2
    optional :uint32, :uint32, 3
    optional :sint32, :sint32, 4
    optional :fixed32, :fixed32, 5
    optional :sfixed32, :sfixed32, 6
    optional :bool, :bool, 7
    optional :string, :string, 8
    optional :bytes, :bytes, 9
    optional :double, :double, 10
    optional :float, :float, 11
    optional :int64, :int64, 12
    optional :uint64, :uint64, 13
    optional :sint64, :sint64, 14
    optional :fixed64, :fixed64, 15
    optional :sfixed64, :sfixed64, 16
  end
  class KeyValuePair < ::Protobuf::Message
    defined_in __FILE__
    class Value < ::Protobuf::Message
      defined_in __FILE__
      class Type < ::Protobuf::Enum
        defined_in __FILE__
        TYPE_SCALAR = value(:TYPE_SCALAR, 0)
        TYPE_KEY_VALUE_PAIR = value(:TYPE_KEY_VALUE_PAIR, 1)
      end
      optional :Type, :type, 1
      optional :Scalar, :scalar, 2
      optional :KeyValuePair, :key_value_pair, 3
    end
    optional :string, :key, 1
    repeated :Value, :value, 2
  end
  class SaslToken < ::Protobuf::Message
    defined_in __FILE__
    optional :string, :base64_data, 1
  end
  class SaslAuth < ::Protobuf::Message
    defined_in __FILE__
    optional :string, :mechanism, 1
    optional :SaslToken, :sasl_token, 2
  end
  class SessionInit < ::Protobuf::Message
    defined_in __FILE__
    optional :string, :hostname, 1
    optional :string, :vendor_id, 2
    optional :string, :product_id, 3
    optional :string, :device_id, 4
    optional :string, :sw_version, 5
    optional :string, :hw_version, 6
    optional :SaslAuth, :sasl_auth, 7
    optional :bool, :synchronized, 14, :default => true
    optional :uint32, :container_buffer_max, 15
  end
  class RequestPackageDelivery < ::Protobuf::Message
    defined_in __FILE__
    optional :uint32, :priority, 1, :default => 0
    optional :uint32, :package_limit, 2
  end
  class Notification < ::Protobuf::Message
    defined_in __FILE__
    class Level < ::Protobuf::Enum
      defined_in __FILE__
      LEVEL_EMERG = value(:LEVEL_EMERG, 0)
      LEVEL_ALERT = value(:LEVEL_ALERT, 1)
      LEVEL_CRIT = value(:LEVEL_CRIT, 2)
      LEVEL_ERR = value(:LEVEL_ERR, 3)
      LEVEL_WARNING = value(:LEVEL_WARNING, 4)
      LEVEL_NOTICE = value(:LEVEL_NOTICE, 5)
      LEVEL_INFO = value(:LEVEL_INFO, 6)
      LEVEL_DEBUG = value(:LEVEL_DEBUG, 7)
    end
    optional :Level, :level, 1
    optional :string, :message, 2
    optional :Attribute, :attribute, 3
  end
  class Action < ::Protobuf::Message
    defined_in __FILE__
    class Type < ::Protobuf::Enum
      defined_in __FILE__
      TYPE_GET = value(:TYPE_GET, 0)
      TYPE_SET = value(:TYPE_SET, 1)
      TYPE_DO = value(:TYPE_DO, 2)
    end
    optional :Type, :type, 1
    optional :Attribute, :attribute, 2
    optional :Function, :function, 3
  end
  class Attribute < ::Protobuf::Message
    defined_in __FILE__
    class Type < ::Protobuf::Enum
      defined_in __FILE__
      TYPE_KEY_VALUE_PAIR = value(:TYPE_KEY_VALUE_PAIR, 0)
      TYPE_GPS_NMEA = value(:TYPE_GPS_NMEA, 1)
      TYPE_GPIO = value(:TYPE_GPIO, 2)
      TYPE_SENSOR = value(:TYPE_SENSOR, 3)
      TYPE_ANNEX_VERSION = value(:TYPE_ANNEX_VERSION, 2034)
      TYPE_SASL_TOKEN = value(:TYPE_SASL_TOKEN, 2035)
      TYPE_SASL_SERVER_MECH_LIST = value(:TYPE_SASL_SERVER_MECH_LIST, 2036)
      TYPE_AW_CELLULAR_PORT = value(:TYPE_AW_CELLULAR_PORT, 2037)
      TYPE_AW_ANALOG_PORT = value(:TYPE_AW_ANALOG_PORT, 2038)
      TYPE_FILE_BUFFER = value(:TYPE_FILE_BUFFER, 2039)
      TYPE_FILE_POS = value(:TYPE_FILE_POS, 2040)
      TYPE_FILE = value(:TYPE_FILE, 2041)
      TYPE_SERIAL_PORT = value(:TYPE_SERIAL_PORT, 2042)
      TYPE_GPS_RECEIVER = value(:TYPE_GPS_RECEIVER, 2043)
      TYPE_CELLULAR_RADIO = value(:TYPE_CELLULAR_RADIO, 2044)
      TYPE_NETWORK_INTERFACE = value(:TYPE_NETWORK_INTERFACE, 2045)
      TYPE_EXTENSION = value(:TYPE_EXTENSION, 2046)
    end
    optional :Type, :type, 1
    optional :KeyValuePair, :key_value_pair, 2
    optional :GpsNmea, :gps_nmea, 3
    optional :Gpio, :gpio, 4
    optional :Sensor, :sensor, 5
    optional :AnnexVersion, :annex_version, 2036
    optional :SaslToken, :sasl_token, 2037
    optional :SaslServerMechList, :sasl_server_mech_list, 2038
    optional :AwCellularPort, :aw_cellular_port, 2039
    optional :AwAnalogPort, :aw_analog_port, 2040
    optional :FileBuffer, :file_buffer, 2041
    optional :FilePos, :file_pos, 2042
    optional :File, :file, 2043
    optional :SerialPort, :serial_port, 2044
    optional :GpsReceiver, :gps_receiver, 2045
    optional :CellularRadio, :cellular_radio, 2046
    optional :NetworkInterface, :network_interface, 2047
    extensions 2048..4095
  end
  class Function < ::Protobuf::Message
    defined_in __FILE__
    class Type < ::Protobuf::Enum
      defined_in __FILE__
      TYPE_FILE_READ = value(:TYPE_FILE_READ, 0)
      TYPE_SOFTWARE_UPGRADE = value(:TYPE_SOFTWARE_UPGRADE, 2039)
      TYPE_FILE_OPEN = value(:TYPE_FILE_OPEN, 2040)
      TYPE_FILE_CLOSE = value(:TYPE_FILE_CLOSE, 2041)
      TYPE_FILE_WRITE = value(:TYPE_FILE_WRITE, 2042)
      TYPE_FILE_GET_POS = value(:TYPE_FILE_GET_POS, 2043)
      TYPE_FILE_SET_POS = value(:TYPE_FILE_SET_POS, 2044)
      TYPE_REBOOT = value(:TYPE_REBOOT, 2045)
      TYPE_EXTENSION = value(:TYPE_EXTENSION, 2046)
    end
    optional :Type, :type, 1
    optional :FileRead, :file_read, 2
    optional :SoftwareUpgrade, :software_upgrade, 2041
    optional :FileOpen, :file_open, 2042
    optional :FileClose, :file_close, 2043
    optional :FileWrite, :file_write, 2044
    optional :FileGetPos, :file_get_pos, 2045
    optional :FileSetPos, :file_set_pos, 2046
    optional :Reboot, :reboot, 2047
    extensions 2048..4095
  end
  class GpsNmea < ::Protobuf::Message
    defined_in __FILE__
    optional :string, :gpgga, 1
    optional :string, :gpgsa, 2
    repeated :string, :gpgsv, 3
    optional :string, :gpgll, 4
    optional :string, :gprmc, 5
    optional :string, :gpvtg, 6
  end
  class Gpio < ::Protobuf::Message
    defined_in __FILE__
    class Type < ::Protobuf::Enum
      defined_in __FILE__
      TYPE_DIGITAL_INPUT = value(:TYPE_DIGITAL_INPUT, 0)
      TYPE_DIGITAL_OUTPUT = value(:TYPE_DIGITAL_OUTPUT, 1)
      TYPE_ANALOG_TO_DIGITAL = value(:TYPE_ANALOG_TO_DIGITAL, 2)
    end
    class DioTrigger < ::Protobuf::Enum
      defined_in __FILE__
      DIO_TRIGGER_NONE = value(:DIO_TRIGGER_NONE, 0)
      DIO_TRIGGER_EDGE_RISING = value(:DIO_TRIGGER_EDGE_RISING, 1)
      DIO_TRIGGER_EDGE_FALLING = value(:DIO_TRIGGER_EDGE_FALLING, 2)
      DIO_TRIGGER_EDGE_BOTH = value(:DIO_TRIGGER_EDGE_BOTH, 3)
      DIO_TRIGGER_LEVEL_HIGH = value(:DIO_TRIGGER_LEVEL_HIGH, 4)
      DIO_TRIGGER_LEVEL_LOW = value(:DIO_TRIGGER_LEVEL_LOW, 5)
    end
    optional :Type, :type, 1
    optional :string, :label, 2
    optional :uint32, :line, 3
    optional :uint32, :value, 4
    optional :bool, :internal_pullup, 5
    optional :DioTrigger, :dio_trigger, 6
  end
  class Sensor < ::Protobuf::Message
    defined_in __FILE__
    optional :string, :name, 1
    optional :Scalar, :value, 2
  end
  class SaslServerMechList < ::Protobuf::Message
    defined_in __FILE__
    repeated :string, :mechanism, 1
  end
  class SoftwareUpgrade < ::Protobuf::Message
    defined_in __FILE__
    optional :string, :name, 1
    optional :string, :uri, 2
    optional :fixed32, :cksum, 3
    optional :string, :md5sum, 4
    optional :string, :sha256sum, 5
  end
  class FileOpen < ::Protobuf::Message
    defined_in __FILE__
    optional :string, :path, 1
    optional :string, :mode, 2
  end
  class FileClose < ::Protobuf::Message
    defined_in __FILE__
    optional :File, :file, 1
  end
  class FileWrite < ::Protobuf::Message
    defined_in __FILE__
    optional :File, :file, 1
    optional :bytes, :buffer, 2
  end
  class FileRead < ::Protobuf::Message
    defined_in __FILE__
    optional :File, :file, 1
    optional :uint32, :length, 2
  end
  class FileGetPos < ::Protobuf::Message
    defined_in __FILE__
    optional :File, :file, 1
  end
  class FileSetPos < ::Protobuf::Message
    defined_in __FILE__
    optional :File, :file, 1
    optional :FilePos, :pos, 2
  end
  class FileBuffer < ::Protobuf::Message
    defined_in __FILE__
    optional :bytes, :buffer, 1
    optional :bool, :eof, 2
  end
  class FilePos < ::Protobuf::Message
    defined_in __FILE__
    optional :uint32, :pos, 1
  end
  class File < ::Protobuf::Message
    defined_in __FILE__
    optional :uint32, :fileno, 1
  end
  class Reboot < ::Protobuf::Message
    defined_in __FILE__
    class Cmd < ::Protobuf::Enum
      defined_in __FILE__
      CMD_RESTART = value(:CMD_RESTART, 0)
      CMD_HALT = value(:CMD_HALT, 1)
      CMD_POWER_OFF = value(:CMD_POWER_OFF, 2)
    end
    optional :Cmd, :cmd, 1
  end
  class TerminalAttributes < ::Protobuf::Message
    defined_in __FILE__
    class Speed < ::Protobuf::Enum
      defined_in __FILE__
      SPEED_0 = value(:SPEED_0, 0)
      SPEED_50 = value(:SPEED_50, 1)
      SPEED_75 = value(:SPEED_75, 2)
      SPEED_110 = value(:SPEED_110, 3)
      SPEED_134 = value(:SPEED_134, 4)
      SPEED_150 = value(:SPEED_150, 5)
      SPEED_200 = value(:SPEED_200, 6)
      SPEED_300 = value(:SPEED_300, 7)
      SPEED_600 = value(:SPEED_600, 8)
      SPEED_1200 = value(:SPEED_1200, 9)
      SPEED_1800 = value(:SPEED_1800, 10)
      SPEED_2400 = value(:SPEED_2400, 11)
      SPEED_4800 = value(:SPEED_4800, 12)
      SPEED_9600 = value(:SPEED_9600, 13)
      SPEED_19200 = value(:SPEED_19200, 14)
      SPEED_38400 = value(:SPEED_38400, 15)
      SPEED_57600 = value(:SPEED_57600, 16)
      SPEED_115200 = value(:SPEED_115200, 17)
      SPEED_230400 = value(:SPEED_230400, 18)
      SPEED_460800 = value(:SPEED_460800, 19)
      SPEED_500000 = value(:SPEED_500000, 20)
      SPEED_576000 = value(:SPEED_576000, 21)
      SPEED_921600 = value(:SPEED_921600, 22)
      SPEED_1000000 = value(:SPEED_1000000, 23)
      SPEED_1152000 = value(:SPEED_1152000, 24)
      SPEED_1500000 = value(:SPEED_1500000, 25)
      SPEED_2000000 = value(:SPEED_2000000, 26)
      SPEED_2500000 = value(:SPEED_2500000, 27)
      SPEED_3000000 = value(:SPEED_3000000, 28)
      SPEED_3500000 = value(:SPEED_3500000, 29)
      SPEED_4000000 = value(:SPEED_4000000, 30)
    end
    class DataBits < ::Protobuf::Enum
      defined_in __FILE__
      DATA_BITS_FIVE = value(:DATA_BITS_FIVE, 5)
      DATA_BITS_SIX = value(:DATA_BITS_SIX, 6)
      DATA_BITS_SEVEN = value(:DATA_BITS_SEVEN, 7)
      DATA_BITS_EIGHT = value(:DATA_BITS_EIGHT, 8)
    end
    class Parity < ::Protobuf::Enum
      defined_in __FILE__
      PARITY_NONE = value(:PARITY_NONE, 0)
      PARITY_ODD = value(:PARITY_ODD, 1)
      PARITY_EVEN = value(:PARITY_EVEN, 2)
    end
    class StopBits < ::Protobuf::Enum
      defined_in __FILE__
      STOP_BITS_ONE = value(:STOP_BITS_ONE, 1)
      STOP_BITS_TWO = value(:STOP_BITS_TWO, 2)
    end
    optional :Speed, :speed, 1
    optional :DataBits, :data_bits, 2
    optional :Parity, :parity, 3
    optional :StopBits, :stop_bits, 4
  end
  class SerialPort < ::Protobuf::Message
    defined_in __FILE__
    optional :string, :name, 1
    optional :TerminalAttributes, :terminal_attributes, 2
  end
  class GpsReceiver < ::Protobuf::Message
    defined_in __FILE__
    optional :uint32, :gpgga, 1
    optional :uint32, :gpgsa, 2
    optional :uint32, :gpgsv, 3
    optional :uint32, :gpgll, 4
    optional :uint32, :gprmc, 5
    optional :uint32, :gpvtg, 6
    optional :uint32, :message_interval, 7
  end
  class Sim < ::Protobuf::Message
    defined_in __FILE__
    optional :string, :cpin, 1
    optional :string, :imsi, 2
  end
  class CellularRadio < ::Protobuf::Message
    defined_in __FILE__
    optional :string, :label, 1
    optional :Sim, :sim, 2
    optional :uint32, :rssi, 3
    optional :uint32, :fer, 4
    optional :string, :imei, 5
    optional :string, :phone_number, 6
  end
  class LinkStatistics < ::Protobuf::Message
    defined_in __FILE__
    optional :uint32, :rx_bytes, 1
    optional :uint32, :rx_packets, 2
    optional :uint32, :rx_errors, 3
    optional :uint32, :rx_dropped, 4
    optional :uint32, :rx_overrun, 5
    optional :uint32, :rx_multicast, 6
    optional :uint32, :tx_bytes, 7
    optional :uint32, :tx_packets, 8
    optional :uint32, :tx_errors, 9
    optional :uint32, :tx_dropped, 10
    optional :uint32, :tx_carrier, 11
    optional :uint32, :tx_collisions, 12
  end
  class IpAddrNet < ::Protobuf::Message
    defined_in __FILE__
    optional :uint32, :addr, 1
    optional :uint32, :network_prefix_length, 2
  end
  class InetSettings < ::Protobuf::Message
    defined_in __FILE__
    class Method < ::Protobuf::Enum
      defined_in __FILE__
      METHOD_MANUAL = value(:METHOD_MANUAL, 0)
      METHOD_DHCP = value(:METHOD_DHCP, 1)
    end
    optional :Method, :method, 1
    repeated :IpAddrNet, :ip_addrs, 2
    optional :uint32, :default_route, 3
    repeated :uint32, :name_servers, 4
  end
  class NetworkInterface < ::Protobuf::Message
    defined_in __FILE__
    class LinkType < ::Protobuf::Enum
      defined_in __FILE__
      LINK_TYPE_LOOPBACK = value(:LINK_TYPE_LOOPBACK, 772)
      LINK_TYPE_ETHER = value(:LINK_TYPE_ETHER, 1)
      LINK_TYPE_IPIP = value(:LINK_TYPE_IPIP, 768)
      LINK_TYPE_GRE = value(:LINK_TYPE_GRE, 778)
      LINK_TYPE_PPP = value(:LINK_TYPE_PPP, 512)
      LINK_TYPE_VOID = value(:LINK_TYPE_VOID, 65535)
    end
    class Flags < ::Protobuf::Message
      defined_in __FILE__
      optional :bool, :up, 1
      optional :bool, :lower_up, 2
      optional :bool, :loopback, 3
      optional :bool, :broadcast, 4
      optional :bool, :pointtopoint, 5
      optional :bool, :multicast, 6
      optional :bool, :dynamic, 7
      optional :bool, :noarp, 8
      optional :bool, :allmulti, 9
      optional :bool, :promisc, 10
    end
    optional :string, :name, 1
    optional :LinkType, :link_type, 2
    optional :Flags, :flags, 3
    optional :bytes, :addr, 4
    optional :bytes, :broadcast_addr, 5
    optional :uint32, :mtu, 6
    optional :InetSettings, :inet_settings, 7
    optional :LinkStatistics, :link_statistics, 16
  end
  class AwCellularPort < ::Protobuf::Message
    defined_in __FILE__
    class NetworkType < ::Protobuf::Enum
      defined_in __FILE__
      NETWORK_TYPE_GSM = value(:NETWORK_TYPE_GSM, 0)
      NETWORK_TYPE_GPRS = value(:NETWORK_TYPE_GPRS, 1)
      NETWORK_TYPE_CDMA = value(:NETWORK_TYPE_CDMA, 2)
      NETWORK_TYPE_A2A = value(:NETWORK_TYPE_A2A, 3)
      NETWORK_TYPE_A2E = value(:NETWORK_TYPE_A2E, 4)
      NETWORK_TYPE_AUTO = value(:NETWORK_TYPE_AUTO, 9)
    end
    class Protocol < ::Protobuf::Enum
      defined_in __FILE__
      PROTOCOL_DISABLED = value(:PROTOCOL_DISABLED, 0)
      PROTOCOL_TCPCLIENT = value(:PROTOCOL_TCPCLIENT, 1)
      PROTOCOL_TELNET = value(:PROTOCOL_TELNET, 2)
      PROTOCOL_UDP = value(:PROTOCOL_UDP, 3)
      PROTOCOL_PING = value(:PROTOCOL_PING, 4)
    end
    class Direction < ::Protobuf::Enum
      defined_in __FILE__
      DIRECTION_AUTO_DETECT = value(:DIRECTION_AUTO_DETECT, 1)
      DIRECTION_OUTBOUND = value(:DIRECTION_OUTBOUND, 3)
      DIRECTION_INBOUND = value(:DIRECTION_INBOUND, 4)
    end
    class ConnectionType < ::Protobuf::Enum
      defined_in __FILE__
      CONNECTION_TYPE_ON_DEMAND = value(:CONNECTION_TYPE_ON_DEMAND, 0)
      CONNECTION_TYPE_ALWAYS_ON = value(:CONNECTION_TYPE_ALWAYS_ON, 1)
    end
    class CellularBand < ::Protobuf::Enum
      defined_in __FILE__
      CELLULAR_BAND_NAM = value(:CELLULAR_BAND_NAM, 0)
      CELLULAR_BAND_EURO = value(:CELLULAR_BAND_EURO, 1)
    end
    class PhoneToIP < ::Protobuf::Message
      defined_in __FILE__
      optional :uint32, :port, 1
      optional :string, :phone, 2
      optional :string, :addr, 3
    end
    optional :NetworkType, :network_type, 1
    optional :Protocol, :protocol, 2
    optional :Direction, :direction, 3
    optional :ConnectionType, :connection_type, 4
    optional :uint32, :localport, 5
    optional :uint32, :remoteport, 6
    optional :string, :remote_addr, 7
    repeated :PhoneToIP, :phone_to_ip, 8
    optional :CellularBand, :cellular_band, 9
    optional :string, :apn_un, 10
    optional :string, :apn_pw, 11
    optional :string, :apn_serv, 12
    optional :uint32, :phytimeout, 13
    optional :uint32, :dlemode, 14
    optional :uint32, :tcptxdelay, 15
    optional :uint32, :handshake_timeout, 16
    optional :uint32, :no_signal_reset_time, 17
  end
  class AwAnalogPort < ::Protobuf::Message
    defined_in __FILE__
    class BaudRate < ::Protobuf::Enum
      defined_in __FILE__
      BAUD_RATE_300 = value(:BAUD_RATE_300, 0)
      BAUD_RATE_1200 = value(:BAUD_RATE_1200, 1)
      BAUD_RATE_2200 = value(:BAUD_RATE_2200, 2)
      BAUD_RATE_2400 = value(:BAUD_RATE_2400, 3)
      BAUD_RATE_4800 = value(:BAUD_RATE_4800, 4)
      BAUD_RATE_9600 = value(:BAUD_RATE_9600, 5)
      BAUD_RATE_12000 = value(:BAUD_RATE_12000, 6)
      BAUD_RATE_14400 = value(:BAUD_RATE_14400, 7)
      BAUD_RATE_28800 = value(:BAUD_RATE_28800, 8)
      BAUD_RATE_33600 = value(:BAUD_RATE_33600, 9)
      BAUD_RATE_56000 = value(:BAUD_RATE_56000, 10)
    end
    class Modulation < ::Protobuf::Enum
      defined_in __FILE__
      MODULATION_V92 = value(:MODULATION_V92, 0)
      MODULATION_V90 = value(:MODULATION_V90, 1)
      MODULATION_V34 = value(:MODULATION_V34, 2)
      MODULATION_V32BIS = value(:MODULATION_V32BIS, 3)
      MODULATION_V32 = value(:MODULATION_V32, 4)
      MODULATION_V22BIS = value(:MODULATION_V22BIS, 5)
      MODULATION_V22 = value(:MODULATION_V22, 6)
      MODULATION_BELL212A = value(:MODULATION_BELL212A, 7)
      MODULATION_BELL103 = value(:MODULATION_BELL103, 8)
    end
    class Ecm < ::Protobuf::Enum
      defined_in __FILE__
      ECM_NONE = value(:ECM_NONE, 0)
      ECM_DIRECT_MODE = value(:ECM_DIRECT_MODE, 1)
      ECM_MNP = value(:ECM_MNP, 2)
      ECM_V42MNP = value(:ECM_V42MNP, 3)
      ECM_V42 = value(:ECM_V42, 4)
    end
    class Compression < ::Protobuf::Enum
      defined_in __FILE__
      COMPRESSION_NONE = value(:COMPRESSION_NONE, 0)
      COMPRESSION_V42BIS_MNP5 = value(:COMPRESSION_V42BIS_MNP5, 1)
    end
    class FlowControl < ::Protobuf::Enum
      defined_in __FILE__
      FLOW_CONTROL_NONE = value(:FLOW_CONTROL_NONE, 0)
      FLOW_CONTROL_XON_XOFF = value(:FLOW_CONTROL_XON_XOFF, 1)
      FLOW_CONTROL_RTS_CTS = value(:FLOW_CONTROL_RTS_CTS, 2)
    end
    optional :string, :init_str, 1
    optional :BaudRate, :baudrate, 2
    optional :Modulation, :modulation, 3
    optional :Ecm, :ecm, 4
    optional :Compression, :compression, 5
    optional :FlowControl, :flow_control, 6
    optional :uint32, :handshake_timeout, 7
    optional :uint32, :dialed_digit_timeout, 8
  end
end