#!/usr/bin/env ruby
#
# vim: set sw=2 ts=2 expandtab:
#

require 'annex_common'

class AnnexClient
  include AnnexCommon

  attr_accessor :recv_total
  attr_accessor :send_total

  def initialize(host, port = ANNEX_PORT)
    @socket = TCPSocket.new(host, port)
    @message_id = 0
    @recv_total = 0
    @send_total = 0
  end

  def send(container)
    send_container(container)
  end

  def recv
    recv_container()
  end

  def close
    @socket.close()
  end
end

if $0 == __FILE__
end
