# vim: set sw=2 ts=2 expandtab:
#

require 'rubygems'

require 'inform'

require 'socket'
require 'annex.pb'

module AnnexCommon
  ANNEX_PORT = 5798

  def message_id
    ret = @message_id
    @message_id += 1
    return ret
  end

  def send_raw(bytes, length)
    @send_total += 4 + length
    @socket.write([length].pack('N'))
    @socket.write(bytes)
  end

  def send_container(container)
    bytes = container.serialize_to_string()
    Inform.debug "Sending Container size: #{bytes.length}"
    Inform.debug "Sending Container:\n#{container.inspect}"
    send_raw(bytes, bytes.length)
  end

  def recv_raw
      bytes = @socket.read(4)
      unless bytes
        Inform.debug "remote closed socket"
        return nil
      end

      size = bytes.unpack('N')[0]
      Inform.debug "Container size: #{size}"

      bytes = @socket.read(size)
      unless bytes
        raise EOFError, "socket closed prematurely"
      end
      Inform.debug "Container bytes:\n#{bytes.inspect}"

      @recv_total += 4 + size
     
      return bytes, size
  end

  def recv_container
      bytes, size = recv_raw()
      
      return raw_to_container(bytes)
  end

  def raw_to_container(bytes)
      return nil if bytes.nil?
      container = Annex::Container.new
      container.parse_from_string(bytes)
      Inform.debug "Received Container:\n#{container.inspect}"

      return container
  end

  def container_to_raw(container)
      return container.serialize_to_string()
  end
end


