#!/usr/bin/env ruby
#
# vim: set sw=2 ts=2 expandtab:
#

# The ruby implementation is broken.
# You should switch to C++ or Python for future testing.

require 'annex_common'
require 'openssl'
require 'getopts'

class DeviceHandler
  include AnnexCommon

  def initialize(socket)
    @socket = socket
    @message_id = 0

    @gpio5_test_value = 0
    @gpio5_test_triggered = false
    @gpio5_last_value = nil

    @request_cell0 = true
    @request_netif = true
    @request_gpios = false
    @send_notification_test = false
    @request_gps_receiver = false
    @request_gps_nmea = false
    @request_annex_version = false

    @files = []

    @recv_total = 0
    @send_total = 0
  end

  def have_session_init(ack_container)
    if @session_init
      return true
    end

    ack_package = Annex::Package.new
    ack_container.packages << ack_package
    ack_package.message_id = message_id()
    ack_package.correlation_id = package.message_id
    ack_package.status_code = Annex::Package::StatusCode::STATUS_CODE_SESSION_INIT_REQUIRED

    return false
  end

  def handle_package(package, ack_container)
    content = package.content

    unless package.has_field?(:message_id)
      raise "need message_id"
    end

    unless content
      unless package.has_field?(:correlation_id)
        Inform.debug "no content"

        ack_package = Annex::Package.new
        ack_container.packages << ack_package
        ack_package.message_id = message_id()
        ack_package.correlation_id = package.message_id
        ack_package.status_code = Annex::Package::StatusCode::STATUS_CODE_EXPECTED_FIELD

        return
      else
        return
      end
    end

    unless content.has_field?(:type)
      ack_package = Annex::Package.new
      ack_container.packages << ack_package
      ack_package.message_id = message_id()
      ack_package.correlation_id = package.message_id
      ack_package.status_code = Annex::Package::StatusCode::STATUS_CODE_EXPECTED_FIELD

      return
    end

    case content.type
    when Annex::Content::Type::TYPE_SESSION_INIT:
      if @session_init
        ack_package = Annex::Package.new
        ack_container.packages << ack_package
        ack_package.message_id = message_id()
        ack_package.correlation_id = package.message_id
        ack_package.status_code = Annex::Package::StatusCode::STATUS_CODE_UNEXPECTED_FIELD
        return
      end

      @session_init = content.session_init

      Inform.debug "@session_init.hostname: #{@session_init.hostname}"
      Inform.debug "@session_init.vendor_id: #{@session_init.vendor_id}"
      Inform.debug "@session_init.product_id: #{@session_init.product_id}"
      Inform.debug "@session_init.device_id: #{@session_init.device_id}"
      Inform.debug "@session_init.sw_version: #{@session_init.sw_version}"
      Inform.debug "@session_init.hw_version: #{@session_init.hw_version}"
      Inform.debug "@session_init.synchronized: #{@session_init.synchronized}"
      Inform.debug "@session_init.container_buffer_max: #{@session_init.container_buffer_max}"

      if @session_init.has_field?(:sasl_auth)
        Inform.debug "sasl_auth checking"
        rc = system("gcc -o auth-plain sasl_auth_plain_test.c -l gsasl ")
        unless rc
          raise "check auth compile failed"
        end
        if @session_init.sasl_auth.mechanism != "PLAIN"
          raise "only know PLAIN"
        end
        rc = system("./auth-plain uip passwd #{@session_init.sasl_auth.sasl_token.base64_data}")
        unless rc
          Inform.err "check auth failed"
          ack_container.packages << Annex::Package.new
          ack_container.packages.last.message_id = message_id()
          ack_container.packages.last.correlation_id = package.message_id
          ack_container.packages.last.status_code = Annex::Package::StatusCode::STATUS_CODE_AUTH_FAILED
          return
        else
          Inform.info "auth-plain was successful"
        end
      end

      ack_container.packages << Annex::Package.new
      ack_container.packages.last.message_id = message_id()
      ack_container.packages.last.correlation_id = package.message_id
      ack_container.packages.last.status_code = Annex::Package::StatusCode::STATUS_CODE_OK
    when Annex::Content::Type::TYPE_REQUEST_PACKAGE_DELIVERY:
      return unless have_session_init(ack_container)

      Inform.debug "Device requested Package delivery"

      request_package_delivery = content.request_package_delivery
      Inform.debug "request_package_delivery.priority: #{request_package_delivery.priority}"
      Inform.debug "request_package_delivery.package_limit: #{request_package_delivery.package_limit}"

      if @session_init.product_id == "MTCDP-E1-DK"
        ack_package = Annex::Package.new
        ack_container.packages << ack_package
        ack_package.message_id = message_id()
        ack_package.correlation_id = package.message_id
        ack_package.status_code = Annex::Package::StatusCode::STATUS_CODE_OK

        if File.exists?("reboot")
          File.unlink("reboot")

          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION

          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_DO
          action.function = Annex::Function.new
          action.function.type = Annex::Function::Type::TYPE_REBOOT
          action.function.reboot = Annex::Reboot.new
          action.function.reboot.cmd = Annex::Reboot::Cmd::CMD_RESTART

          ack_package.content.action = action

          @reset_test_triggered = false
        end
        if @request_cell0
          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION

          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_GET
          action.attribute = Annex::Attribute.new
          action.attribute.type = Annex::Attribute::Type::TYPE_CELLULAR_RADIO
          action.attribute.cellular_radio = Annex::CellularRadio.new
          action.attribute.cellular_radio.label = "cell0"

          ack_package.content.action = action
        end
        if @request_netif
          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION

          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_GET
          action.attribute = Annex::Attribute.new
          action.attribute.type = Annex::Attribute::Type::TYPE_NETWORK_INTERFACE
          action.attribute.network_interface = Annex::NetworkInterface.new
          action.attribute.network_interface.name = "eth2"

          ack_package.content.action = action

          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION

          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_GET
          action.attribute = Annex::Attribute.new
          action.attribute.type = Annex::Attribute::Type::TYPE_NETWORK_INTERFACE
          action.attribute.network_interface = Annex::NetworkInterface.new
          action.attribute.network_interface.name = "lo"

          ack_package.content.action = action
        end
        if @request_gpios
          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION
          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_GET
          action.attribute = Annex::Attribute.new
          action.attribute.type = Annex::Attribute::Type::TYPE_GPIO
          action.attribute.gpio = Annex::Gpio.new
          action.attribute.gpio.label = "led-sig1"
          ack_package.content.action = action

          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION
          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_GET
          action.attribute = Annex::Attribute.new
          action.attribute.type = Annex::Attribute::Type::TYPE_GPIO
          action.attribute.gpio = Annex::Gpio.new
          action.attribute.gpio.label = "led-sig2"
          ack_package.content.action = action

          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION
          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_GET
          action.attribute = Annex::Attribute.new
          action.attribute.type = Annex::Attribute::Type::TYPE_GPIO
          action.attribute.gpio = Annex::Gpio.new
          action.attribute.gpio.label = "led-sig3"
          ack_package.content.action = action

          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION
          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_GET
          action.attribute = Annex::Attribute.new
          action.attribute.type = Annex::Attribute::Type::TYPE_GPIO
          action.attribute.gpio = Annex::Gpio.new
          action.attribute.gpio.label = "led-dtr"
          ack_package.content.action = action
        end
        if @send_notification_test
          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.request_ack = true
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_NOTIFICATION

          notification = Annex::Notification.new
          notification.level = Annex::Notification::Level::LEVEL_INFO
          notification.message = "test me"

          ack_package.content.notification = notification
        end
        if @request_gps_receiver
          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION

          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_GET
          action.attribute = Annex::Attribute.new
          action.attribute.type = Annex::Attribute::Type::TYPE_GPS_RECEIVER
          action.attribute.gps_receiver = Annex::GpsReceiver.new

          ack_package.content.action = action
        end
        if @request_gps_nmea
          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION

          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_GET
          action.attribute = Annex::Attribute.new
          action.attribute.type = Annex::Attribute::Type::TYPE_GPS_NMEA
          action.attribute.gps_nmea = Annex::GpsNmea.new

          ack_package.content.action = action
        end
        if @request_annex_version
          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION

          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_GET
          action.attribute = Annex::Attribute.new
          action.attribute.type = Annex::Attribute::Type::TYPE_ANNEX_VERSION
          action.attribute.annex_version = Annex::AnnexVersion.new

          ack_package.content.action = action
        end
        if File.exists?("su")
          File.unlink("su")

          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION

          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_DO
          action.function = Annex::Function.new
          action.function.type = Annex::Function::Type::TYPE_SOFTWARE_UPGRADE
          action.function.software_upgrade = Annex::SoftwareUpgrade.new
          action.function.software_upgrade.uri = "annex://204.26.122.94/UIP_1_0_1_JCM.BIN"
          action.function.software_upgrade.name = "uip-firmware"
          action.function.software_upgrade.cksum = `cksum files/UIP_1_0_1_JCM.BIN | cut -d ' ' -f 1`.to_i

          ack_package.content.action = action
        end

        # product_id MTCDP-E1-DK
      elsif @session_init.product_id == "MTCMR-E1-IP-GP"
        ack_package = Annex::Package.new
        ack_container.packages << ack_package
        ack_package.message_id = message_id()
        ack_package.correlation_id = package.message_id
        ack_package.status_code = Annex::Package::StatusCode::STATUS_CODE_OK

        if @gpio5_test_triggered
          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.request_ack = true
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION

          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_SET
          action.attribute = Annex::Attribute.new
          action.attribute.type = Annex::Attribute::Type::TYPE_GPIO
          action.attribute.gpio = Annex::Gpio.new
          action.attribute.gpio.line = 3
          action.attribute.gpio.type = Annex::Gpio::Type::TYPE_DIGITAL_OUTPUT
          action.attribute.gpio.value = @gpio5_test_value == 1 ? 0 : 1
          action.attribute.gpio.dio_trigger = Annex::Gpio::DioTrigger::DIO_TRIGGER_NONE
          ack_package.content.action = action

          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.request_ack = true
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION

          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_SET
          action.attribute = Annex::Attribute.new
          action.attribute.type = Annex::Attribute::Type::TYPE_GPIO
          action.attribute.gpio = Annex::Gpio.new
          action.attribute.gpio.line = 4
          action.attribute.gpio.type = Annex::Gpio::Type::TYPE_DIGITAL_OUTPUT
          action.attribute.gpio.value = @gpio5_test_value
          action.attribute.gpio.dio_trigger = Annex::Gpio::DioTrigger::DIO_TRIGGER_NONE
          ack_package.content.action = action

          @gpio5_test_triggered = false
        end
        if File.exists?("reboot")
          File.unlink("reboot")

          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION

          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_DO
          action.function = Annex::Function.new
          action.function.type = Annex::Function::Type::TYPE_REBOOT
          action.function.reboot = Annex::Reboot.new
          action.function.reboot.cmd = Annex::Reboot::Cmd::CMD_RESTART

          ack_package.content.action = action

          @reset_test_triggered = false
        end
        if @request_cell0
          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION

          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_GET
          action.attribute = Annex::Attribute.new
          action.attribute.type = Annex::Attribute::Type::TYPE_CELLULAR_RADIO
          action.attribute.cellular_radio = Annex::CellularRadio.new
          action.attribute.cellular_radio.label = "cell0"

          ack_package.content.action = action
        end
        if @request_netif
          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION

          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_GET
          action.attribute = Annex::Attribute.new
          action.attribute.type = Annex::Attribute::Type::TYPE_NETWORK_INTERFACE
          action.attribute.network_interface = Annex::NetworkInterface.new
          action.attribute.network_interface.name = "ppp0"

          ack_package.content.action = action
        end
        if @request_gpios
          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION

          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_GET
          action.attribute = Annex::Attribute.new
          action.attribute.type = Annex::Attribute::Type::TYPE_GPIO
          action.attribute.gpio = Annex::Gpio.new
          action.attribute.gpio.line = 1

          ack_package.content.action = action

          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION

          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_GET
          action.attribute = Annex::Attribute.new
          action.attribute.type = Annex::Attribute::Type::TYPE_GPIO
          action.attribute.gpio = Annex::Gpio.new
          action.attribute.gpio.line = 2

          ack_package.content.action = action

          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION

          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_GET
          action.attribute = Annex::Attribute.new
          action.attribute.type = Annex::Attribute::Type::TYPE_GPIO
          action.attribute.gpio = Annex::Gpio.new
          action.attribute.gpio.line = 3

          ack_package.content.action = action

          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION

          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_GET
          action.attribute = Annex::Attribute.new
          action.attribute.type = Annex::Attribute::Type::TYPE_GPIO
          action.attribute.gpio = Annex::Gpio.new
          action.attribute.gpio.line = 4

          ack_package.content.action = action

          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION

          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_GET
          action.attribute = Annex::Attribute.new
          action.attribute.type = Annex::Attribute::Type::TYPE_GPIO
          action.attribute.gpio = Annex::Gpio.new
          action.attribute.gpio.line = 5

          ack_package.content.action = action
        end
        if @send_notification_test
          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.request_ack = true
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_NOTIFICATION

          notification = Annex::Notification.new
          notification.level = Annex::Notification::Level::LEVEL_INFO
          notification.message = "test me"

          ack_package.content.notification = notification
        end
        if @request_gps_receiver
          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION

          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_GET
          action.attribute = Annex::Attribute.new
          action.attribute.type = Annex::Attribute::Type::TYPE_GPS_RECEIVER
          action.attribute.gps_receiver = Annex::GpsReceiver.new

          ack_package.content.action = action
        end
        if @request_gps_nmea
          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION

          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_GET
          action.attribute = Annex::Attribute.new
          action.attribute.type = Annex::Attribute::Type::TYPE_GPS_NMEA
          action.attribute.gps_nmea = Annex::GpsNmea.new

          ack_package.content.action = action
        end
        if @request_annex_version
          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION

          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_GET
          action.attribute = Annex::Attribute.new
          action.attribute.type = Annex::Attribute::Type::TYPE_ANNEX_VERSION
          action.attribute.annex_version = Annex::AnnexVersion.new

          ack_package.content.action = action
        end
        if File.exists?("su")
          File.unlink("su")

          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION

          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_DO
          action.function = Annex::Function.new
          action.function.type = Annex::Function::Type::TYPE_SOFTWARE_UPGRADE
          action.function.software_upgrade = Annex::SoftwareUpgrade.new
          action.function.software_upgrade.uri = "annex://204.26.122.94/UIP_1_0_1_JCM.BIN"
          action.function.software_upgrade.name = "uip-firmware"
          action.function.software_upgrade.cksum = `cksum files/UIP_1_0_1_JCM.BIN | cut -d ' ' -f 1`.to_i

          ack_package.content.action = action
        end
      elsif @session_init.product_id == "MT200A2W"
        ack_package = Annex::Package.new
        ack_container.packages << ack_package
        ack_package.message_id = message_id()
        ack_package.correlation_id = package.message_id
        ack_package.status_code = Annex::Package::StatusCode::STATUS_CODE_OK

        if true
          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION

          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_GET
          action.attribute = Annex::Attribute.new
          action.attribute.type = Annex::Attribute::Type::TYPE_AW_ANALOG_PORT
          action.attribute.aw_analog_port = Annex::AwAnalogPort.new

          ack_package.content.action = action
        end
        if true
          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION

          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_GET
          action.attribute = Annex::Attribute.new
          action.attribute.type = Annex::Attribute::Type::TYPE_AW_CELLULAR_PORT
          action.attribute.aw_cellular_port = Annex::AwCellularPort.new

          ack_package.content.action = action
        end
        if false
          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ACTION

          action = Annex::Action.new
          action.type = Annex::Action::Type::TYPE_GET
          action.attribute = Annex::Attribute.new
          action.attribute.type = Annex::Attribute::Type::TYPE_CELLULAR_RADIO
          action.attribute.cellular_radio = Annex::CellularRadio.new

          ack_package.content.action = action
        end
      end
    when Annex::Content::Type::TYPE_NOTIFICATION:
      return unless have_session_init(ack_container)

      notification = content.notification
      unless notification.has_field?(:level)
        ack_package = Annex::Package.new
        ack_container.packages << ack_package
        ack_package.message_id = message_id()
        ack_package.correlation_id = package.message_id
        ack_package.status_code = Annex::Package::StatusCode::STATUS_CODE_EXPECTED_FIELD
        return
      end

      Inform.debug "notification.level: #{Annex::Notification::Level.name_by_value(notification.level)}"

      if notification.has_field?(:message)
        Inform.debug "notification.message: #{notification.message}"
      end

      if package.has_field?(:request_ack) && package.has_field?(:message_id)
        Inform.debug "Device requested an ack"

        ack_container.packages << Annex::Package.new
        ack_container.packages.last.correlation_id = package.message_id
        ack_container.packages.last.status_code = Annex::Package::StatusCode::STATUS_CODE_OK
      end
    when Annex::Content::Type::TYPE_ACTION:
      action = content.action

      unless action.has_field?(:type)
        ack_package = Annex::Package.new
        ack_container.packages << ack_package
        ack_package.message_id = message_id()
        ack_package.correlation_id = package.message_id
        ack_package.status_code = Annex::Package::StatusCode::STATUS_CODE_EXPECTED_FIELD
        return
      end

      Inform.debug "action.type: #{Annex::Action::Type.name_by_value(action.type)}"

      case action.type
      when Annex::Action::Type::TYPE_GET:
        attr = action.attribute

        unless attr.has_field?(:type)
          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.status_code = Annex::Package::StatusCode::STATUS_CODE_EXPECTED_FIELD
          return
        end

        case attr.type
        when Annex::Attribute::Type::TYPE_SASL_SERVER_MECH_LIST:
          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.status_code = Annex::Package::StatusCode::STATUS_CODE_OK
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ATTRIBUTE
          attr = Annex::Attribute.new
          attr.type = Annex::Attribute::Type::TYPE_SASL_SERVER_MECH_LIST
          attr.sasl_server_mech_list = Annex::SaslServerMechList.new
          attr.sasl_server_mech_list.mechanism << "PLAIN"
          ack_package.content.attribute = attr
          return
        else
          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.status_code = Annex::Package::StatusCode::STATUS_CODE_UNSUPPORTED
          return
        end
      when Annex::Action::Type::TYPE_DO:
        return unless have_session_init(ack_container)

        function = action.function

        unless function.has_field?(:type)
          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.status_code = Annex::Package::StatusCode::STATUS_CODE_EXPECTED_FIELD
          return
        end

        case function.type
        when Annex::Function::Type::TYPE_FILE_OPEN:
          file_open = function.file_open
          path = File.basename(file_open.path)
          if path == "/" || path == ""
            raise "bad path"
          end

          path = "files/#{path}"

          file = File.open(path, file_open.mode)
          Inform.debug "opened file #{path} mode #{file_open.mode} (with little checking)"
          @files << file

          ack_package = Annex::Package.new
          ack_container.packages << ack_package
          ack_package.message_id = message_id()
          ack_package.correlation_id = package.message_id
          ack_package.status_code = Annex::Package::StatusCode::STATUS_CODE_OK
          ack_package.content = Annex::Content.new
          ack_package.content.type = Annex::Content::Type::TYPE_ATTRIBUTE

          attr = Annex::Attribute.new
          attr.type = Annex::Attribute::Type::TYPE_FILE
          attr.file = Annex::File.new
          attr.file.fileno = file.fileno
          ack_package.content.attribute = attr
        when Annex::Function::Type::TYPE_FILE_CLOSE:
          file_close = function.file_close

          file = find_file_by_fileno(file_close.file.fileno)
          if file
            file.close()
            @files.delete(file)

            ack_package = Annex::Package.new
            ack_container.packages << ack_package
            ack_package.message_id = message_id()
            ack_package.correlation_id = package.message_id
            ack_package.status_code = Annex::Package::StatusCode::STATUS_CODE_OK
          else
            ack_package = Annex::Package.new
            ack_container.packages << ack_package
            ack_package.message_id = message_id()
            ack_package.correlation_id = package.message_id
            ack_package.status_code = Annex::Package::StatusCode::STATUS_CODE_NOT_FOUND
          end
        when Annex::Function::Type::TYPE_FILE_WRITE:
          file_write = function.file_write

          file = find_file_by_fileno(file_write.file.fileno)
          if file
            file.write(file_write.buffer)

            ack_package = Annex::Package.new
            ack_container.packages << ack_package
            ack_package.message_id = message_id()
            ack_package.correlation_id = package.message_id
            ack_package.status_code = Annex::Package::StatusCode::STATUS_CODE_OK
          else
            ack_package = Annex::Package.new
            ack_container.packages << ack_package
            ack_package.message_id = message_id()
            ack_package.correlation_id = package.message_id
            ack_package.status_code = Annex::Package::StatusCode::STATUS_CODE_NOT_FOUND
          end
        when Annex::Function::Type::TYPE_FILE_READ:
          file_read = function.file_read

          file = find_file_by_fileno(file_read.file.fileno)
          if file
            length = nil
            if file_read.has_field?(:length)
              length = file_read.length
            end
            buffer = file.read(length)

            ack_package = Annex::Package.new
            ack_container.packages << ack_package
            ack_package.message_id = message_id()
            ack_package.correlation_id = package.message_id
            ack_package.status_code = Annex::Package::StatusCode::STATUS_CODE_OK
            ack_package.content = Annex::Content.new
            ack_package.content.type = Annex::Content::Type::TYPE_ATTRIBUTE

            attr = Annex::Attribute.new
            attr.type = Annex::Attribute::Type::TYPE_FILE_BUFFER
            attr.file_buffer = Annex::FileBuffer.new
            attr.file_buffer.buffer = buffer
            attr.file_buffer.eof = file.eof?
            ack_package.content.attribute = attr
          else
            ack_package = Annex::Package.new
            ack_container.packages << ack_package
            ack_package.message_id = message_id()
            ack_package.correlation_id = package.message_id
            ack_package.status_code = Annex::Package::StatusCode::STATUS_CODE_NOT_FOUND
          end
        when Annex::Function::Type::TYPE_FILE_GET_POS:
          file_get_pos = function.file_get_pos

          file = find_file_by_fileno(file_get_pos.file.fileno)
          if file
            ack_package = Annex::Package.new
            ack_container.packages << ack_package
            ack_package.message_id = message_id()
            ack_package.correlation_id = package.message_id
            ack_package.status_code = Annex::Package::StatusCode::STATUS_CODE_OK
            ack_package.content = Annex::Content.new
            ack_package.content.type = Annex::Content::Type::TYPE_ATTRIBUTE

            attr = Annex::Attribute.new
            attr.type = Annex::Attribute::Type::TYPE_FILE_POS
            attr.file_pos = Annex::FilePos.new
            attr.file_pos.pos = file.pos
            ack_package.content.attribute = attr
          else
            ack_package = Annex::Package.new
            ack_container.packages << ack_package
            ack_package.message_id = message_id()
            ack_package.correlation_id = package.message_id
            ack_package.status_code = Annex::Package::StatusCode::STATUS_CODE_NOT_FOUND
          end
        when Annex::Function::Type::TYPE_FILE_SET_POS:
          file_set_pos = function.file_set_pos

          file = find_file_by_fileno(file_set_pos.file.fileno)
          if file
            file.pos = file_set_pos.pos.pos

            ack_package = Annex::Package.new
            ack_container.packages << ack_package
            ack_package.message_id = message_id()
            ack_package.correlation_id = package.message_id
            ack_package.status_code = Annex::Package::StatusCode::STATUS_CODE_OK
          else
            ack_package = Annex::Package.new
            ack_container.packages << ack_package
            ack_package.message_id = message_id()
            ack_package.correlation_id = package.message_id
            ack_package.status_code = Annex::Package::StatusCode::STATUS_CODE_NOT_FOUND
          end
        when Annex::Function::Type::TYPE_EXTENSION:
        else
          raise "unhandled function type"
        end
      else
        if package.has_field?(:request_ack) && package.has_field?(:message_id)
          Inform.debug "Device requested an ack"

          ack_container.packages << Annex::Package.new
          ack_container.packages.last.correlation_id = package.message_id
          ack_container.packages.last.status_code = Annex::Package::StatusCode::STATUS_CODE_OK
        end
      end
    when Annex::Content::Type::TYPE_ATTRIBUTE:
      return unless have_session_init(ack_container)

      attribute = content.attribute

      unless attribute.has_field?(:type)
        ack_package = Annex::Package.new
        ack_container.packages << ack_package
        ack_package.message_id = message_id()
        ack_package.correlation_id = package.message_id
        ack_package.status_code = Annex::Package::StatusCode::STATUS_CODE_EXPECTED_FIELD
        return
      end

      Inform.debug "attribute.type: #{Annex::Attribute::Type.name_by_value(attribute.type)}"

      case attribute.type
      when Annex::Attribute::Type::TYPE_KEY_VALUE_PAIR:
      when Annex::Attribute::Type::TYPE_GPS_NMEA:
        gps_nmea = attribute.gps_nmea
        Inform.debug "gps_nmea.gpgga: #{gps_nmea.gpgga.inspect}"
        Inform.debug "gps_nmea.gpgsa: #{gps_nmea.gpgsa.inspect}"
        Inform.debug "gps_nmea.gpgll: #{gps_nmea.gpgll.inspect}"
        Inform.debug "gps_nmea.gprmc: #{gps_nmea.gprmc.inspect}"
        Inform.debug "gps_nmea.gpvtg: #{gps_nmea.gpvtg.inspect}"
        gps_nmea.gpgsv.each_with_index { |gpgsv, gpgsv_index|
          Inform.debug "gps_nmea.gpgsv[#{gpgsv_index}]: #{gpgsv.inspect}"
        }
      when Annex::Attribute::Type::TYPE_GPIO:
        if @session_init.product_id == "MTCMR-E1-IP-GP"
          if attribute.gpio.line == 5
            unless @gpio5_last_value.nil?
              if @gpio5_last_value <= 900 && attribute.gpio.value > 900
                @gpio5_test_value = 0
                @gpio5_test_triggered = true
              end
              if @gpio5_last_value >= 600 && attribute.gpio.value < 600
                @gpio5_test_value = 1
                @gpio5_test_triggered = true
              end
            end

            @gpio5_last_value = attribute.gpio.value
          end
        end
      when Annex::Attribute::Type::TYPE_SENSOR:
      when Annex::Attribute::Type::TYPE_SERIAL_PORT:
      when Annex::Attribute::Type::TYPE_GPS_RECEIVER:
      when Annex::Attribute::Type::TYPE_CELLULAR_RADIO:
      when Annex::Attribute::Type::TYPE_NETWORK_INTERFACE:
      when Annex::Attribute::Type::TYPE_EXTENSION:
      when Annex::Attribute::Type::TYPE_AW_CELLULAR_PORT:
      when Annex::Attribute::Type::TYPE_AW_ANALOG_PORT:
      when Annex::Attribute::Type::TYPE_EXTENSION:
      else
        Inform.err "Unhandled attribute.type: #{attribute.type}"
      end
    else
      Inform.err "Unhandled content.type: #{content.type}"
    end
  end

  def find_file_by_fileno(fileno)
    file = nil

    @files.each { |item|
      if item.fileno == fileno
        file = item
      end
    }

    return file
  end

  def run
    Inform.info "connected to device"

    loop {
      container = recv_container()
      unless container
        Inform.info "closing connection with device"
        return
      end
      if container.packages.length == 0
        raise "empty container"
      end

      Inform.debug "#{container.packages.length} packages are present"

      ack_container = Annex::Container.new
      container.packages.each { |package|
        handle_package(package, ack_container)
      }

      if ack_container.packages.length > 0
        send_container(ack_container)
      end
    }
  rescue => e
    Inform.err(e)
    $thread_exceptions << e
  ensure
    @socket.close()

    @files.each { |file|
      file.close()
    }
  end
end

class AnnexServer
  def initialize(port = AnnexCommon::ANNEX_PORT, ctx = nil)
    @tcpserver = TCPServer.new(port)
    @ctx = ctx
    if @ctx
      @ssl_server = OpenSSL::SSL::SSLServer.new(@tcpserver, @ctx)
    end
  end

  def device_thread(socket)
    Thread.new {
      handler = DeviceHandler.new(socket)
      handler.run()
    }
  end

  def run
    loop {
      if @ssl_server
        @ssl_server.start_immediately = true
        begin
          socket = @ssl_server.accept()
        rescue => e
          Inform.err(e)
          retry
        end
      else
        begin
          socket = @tcpserver.accept_nonblock()
        rescue Errno::EAGAIN, Errno::ECONNABORTED, Errno::EPROTO, Errno::EINTR
          IO.select([@tcpserver])
          retry
        end
      end

      device_thread(socket)
    }
  end
end

if $0 == __FILE__
  $thread_exceptions = []
  at_exit {
    Inform.info "Thread Exceptions:"
    $thread_exceptions.each { |e|
      Inform.info(e)
    }
  }

  Thread.abort_on_exception = true

  Inform.level = Inform::LOG_DEBUG
  Inform.file = $stdout

  getopts nil, "p:#{AnnexCommon::ANNEX_PORT}", "c:", "k:", "C:", "s"

  port = $OPT_p

  ctx = nil
  if $OPT_s
    cert_file = $OPT_c
    key_file = $OPT_k
    ca_path  = $OPT_C

    if cert_file && key_file
      cert = OpenSSL::X509::Certificate.new(File::read(cert_file))
      key = OpenSSL::PKey::RSA.new(File::read(key_file))
    else
      key = OpenSSL::PKey::RSA.new(512){ print "." }
      puts
      cert = OpenSSL::X509::Certificate.new
      cert.version = 2
      cert.serial = 0
      name = OpenSSL::X509::Name.new([["C","US"],["O","Multi-Tech Systems"],["CN","Multi-Tech"]])
      cert.subject = name
      cert.issuer = name
      cert.not_before = Time.now
      cert.not_after = Time.now + 3600
      cert.public_key = key.public_key
      ef = OpenSSL::X509::ExtensionFactory.new(nil,cert)
      cert.extensions = [
        ef.create_extension("basicConstraints","CA:FALSE"),
        ef.create_extension("subjectKeyIdentifier","hash"),
        ef.create_extension("extendedKeyUsage","serverAuth"),
        ef.create_extension("keyUsage",
                            "keyEncipherment,dataEncipherment,digitalSignature")
      ]
      ef.issuer_certificate = cert
      cert.add_extension ef.create_extension("authorityKeyIdentifier",
                                             "keyid:always,issuer:always")
      cert.sign(key, OpenSSL::Digest::SHA1.new)
    end

    ctx = OpenSSL::SSL::SSLContext.new()
    ctx.key = key
    ctx.cert = cert
    if ca_path
      ctx.verify_mode =
        OpenSSL::SSL::VERIFY_PEER|OpenSSL::SSL::VERIFY_FAIL_IF_NO_PEER_CERT
      ctx.ca_path = ca_path
    else
      Inform.notice "!!! WARNING: PEER CERTIFICATE WON'T BE VERIFIED !!!"
    end
  end

  Inform.info "Listening on port #{port}"
  as = AnnexServer.new(port, ctx)
  as.run()
end
