#include <stdarg.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <gsasl.h>

static void server_authenticate(Gsasl_session *session, const char *base64_data)
{
	char *p;
	int tmp;

	tmp = gsasl_step64(session, base64_data, &p);
	if (tmp != GSASL_OK) {
		fprintf(stderr, "gsasl_step64 failed: %d %s\n", tmp, gsasl_strerror(tmp));
		exit(1);
	}

	printf("authorized\n");
}

static void server_plain(Gsasl *ctx, const char *base64_data)
{
	Gsasl_session *session;
	const char *mech = "PLAIN";
	int tmp;

	tmp = gsasl_server_start(ctx, mech, &session);
	if (tmp != GSASL_OK) {
		fprintf(stderr, "gsasl_server_start failed: %d %s", tmp, gsasl_strerror(tmp));
		exit(1);
	}

	server_authenticate(session, base64_data);

	gsasl_finish(session);
}

char *username;
char *passwd;

static int server_plain_callback(Gsasl *ctx, Gsasl_session *session, Gsasl_property prop)
{
	const char *key;

	switch (prop) {
	case GSASL_VALIDATE_SIMPLE:
		key = gsasl_property_get(session, GSASL_AUTHZID);
		if (strcmp(key, username)) {
			return GSASL_AUTHENTICATION_ERROR;
		}
		key = gsasl_property_get(session, GSASL_AUTHID);
		if (strcmp(key, username)) {
			return GSASL_AUTHENTICATION_ERROR;
		}
		key = gsasl_property_get(session, GSASL_PASSWORD);
		if (strcmp(key, passwd)) {
			return GSASL_AUTHENTICATION_ERROR;
		}
		return GSASL_OK;
	default:
		return GSASL_NO_CALLBACK;
	}
}

int main(int argc, char *argv[])
{
	Gsasl *ctx = NULL;
	int tmp;

	if (argc != 4) {
		fprintf(stderr, "argc is 4\n");
		exit(1);
	}

	tmp = gsasl_init(&ctx);
	if (tmp != GSASL_OK) {
		fprintf(stderr, "gsasl_init failed: %d %s", tmp, gsasl_strerror(tmp));
		exit(1);
	}

	username = argv[1];
	passwd = argv[2];

	gsasl_callback_set(ctx, server_plain_callback);
	server_plain(ctx, argv[3]);

	gsasl_done(ctx);

	return 0;
}
