/* AGDEBUG.H -- Header to AGDEBUG.C
*/

#ifndef _AGDEBUG_H_
#define _AGDEBUG_H_

#ifdef MEM_DEBUG

extern BYTE *mbm(USHORT data_size);
extern BYTE *mtm(ULONG num_items, ULONG item_size);
extern void mbf(BYTE *bptr);
extern void mtf(void *bptr);
extern void DebugBreak();

#else /* MEM_DEBUG */

#define mbm(data_size)				buffer_malloc(data_size)
#define mtm(num_items, item_size)	table_malloc(num_items, item_size)
#define mbf(bptr)					buffer_free(bptr)
#define mtf(bptr)					table_free(bptr)

#endif /* MEM_DEBUG */

#endif /* _AGDEBUG_H_ */
