/* AGPKTTYP.H -- Has the client/server request/response packet structures
*/

#ifndef _AGPKTTYP_H_
#define _AGPKTTYP_H_

#define MAX_IN_LINES				9		/* Maximum inbound lines in
											** inbound request 
											*/

#define MAX_LINES_PER_STATUS_PACKET	8		/* Status response packets will
											** contain this many entries
											*/

typedef struct LINE_STAT_INFO_TYPE {
        BYTE    line_status;				/* Status of the line. */
        BYTE    line_class;      			/* Line class.         */
        BYTE    access;         			/* ALLOWED if user has */
                                			/* permssion, NOT_ALLOWED if */
                                			/* not. */
        BYTE    general_name[GENERAL_NAME_LENGTH];
        BYTE    specific_name[SPECIFIC_NAME_LENGTH];
        BYTE    line_owner[USER_NAME_LENGTH];
        LINE_PARAM_TYPE line_parameters;    /* Current line parameters. */
} LINE_STAT_INFO_TYPE;

typedef struct NAME_VALIDATE_REQ_TYPE {
	BYTE user_name[USER_NAME_LENGTH];
} NAME_VALIDATE_REQ_TYPE;

typedef struct NAME_VALIDATE_RESP_TYPE {
	BYTE name_valid;						/* TRUE if name valid, else FALSE */
	BYTE password_present;					/* TRUE if password present, else FALSE */
} NAME_VALIDATE_RESP_TYPE;

typedef struct PASSWORD_VALIDATE_REQ_TYPE {
	BYTE user_name[USER_NAME_LENGTH];
	BYTE encrypted_password[PASSWORD_LENGTH];
} PASSWORD_VALIDATE_REQ_TYPE;

typedef struct PASSWORD_VALIDATE_RESP_TYPE {
	BYTE password_valid_state;				/* VALID_PASSWORD or INVALID_PASSWORD */
} PASSWORD_VALIDATE_RESP_TYPE;

/* Following two differ for IPX and NetBIOS. Code needs to take care of this */
typedef struct CONNECT_REQ_TYPE {
	BYTE user_name[USER_NAME_LENGTH];
	BYTE general_name[GENERAL_NAME_LENGTH];
	BYTE specific_name[SPECIFIC_NAME_LENGTH];
	BYTE connect_type;
} CONNECT_REQ_TYPE;

typedef struct INBOUND_CONNECT_REQ_TYPE {
	BYTE user_name[USER_NAME_LENGTH];
	BYTE connect_type;
	BYTE number_of_channels;					/* Number of connections */
	BYTE services_array[MAX_IN_LINES];
} INBOUND_CONNECT_REQ_TYPE;

typedef struct CONNECT_VARS_TYPE {
	LINE_PARAM_TYPE line_parameters;		/*	Line parameters.			*/
	USHORT max_packet_size; 				/*	Maximum packet size.		*/
	USHORT max_inter_packet_delay;			/*	Force next packet assembly	*/
											/*	if time elapsed since last	*/
											/*	packet sent exceeds this.	*/
	USHORT idle_time;						/*	IdleTime in minutes */
} CONNECT_VARS_TYPE;

typedef struct CONNECT_RESP_TYPE {
	BYTE general_name[GENERAL_NAME_LENGTH];
	BYTE specific_name[SPECIFIC_NAME_LENGTH];
	BYTE channel_number;
	BYTE connect_status;				/*	Status of the connection	*/
										/*	request. CONNECTED if the	*/
										/*	connection was established,	*/
										/*	else NOT_CONNECTED.			*/
	BYTE EIA_status;					/* Status of EIA signals		*/
	CONNECT_VARS_TYPE connect_vars_info;
} CONNECT_RESP_TYPE;

typedef struct STATUS_REQ_TYPE {
	BYTE user_name[USER_NAME_LENGTH];
	BYTE last_line_id;						/* ID of the last line returned */
											/* in a previous status resp */
} STATUS_REQ_TYPE;

typedef struct STATUS_RESP_TYPE {
	BYTE number_of_lines;					/*	No. of lines available on 	*/
											/*	the server.					*/
	BYTE last_line_id;						/* Id of the last line about	*/
											/* which info is returned in 	*/
											/* packet						*/
	LINE_STAT_INFO_TYPE line_status_array[1];
} STATUS_RESP_TYPE;

typedef struct DISCONNECT_REQ_TYPE {
	BYTE channel_number;
} DISCONNECT_REQ_TYPE;

typedef struct DISCONNECT_RESP_TYPE {
	BYTE channel_number;
	BYTE abort_reason;
} DISCONNECT_RESP_TYPE;

typedef struct DATA_TYPE {
	BYTE channel_number;
	USHORT packet_size;
	BYTE data[1];
} DATA_TYPE;

typedef struct CONTROL_TYPE {
	BYTE channel_number;
	BYTE control_source;					/*	Source of status change, 	*/
											/*	i.e., Line / Modem status 	*/
											/*	register.					*/
	BYTE control_value;						/*	Actual value of the 		*/
											/*	appropriate register.		*/
} CONTROL_TYPE;

typedef struct CHANGE_PARAMS_REQ_TYPE {
	BYTE channel_number;
	CONNECT_VARS_TYPE connect_vars_info;
} CHANGE_PARAMS_REQ_TYPE;

/* Following are not responses, but generated internal to the AG */

/* Following is not used currently */
typedef struct FLOW_CONTROL_TYPE {
	BYTE stop_send;					/* If 1, then client will stop sending */
	USHORT wait_time;
} FLOW_CONTROL_TYPE;

typedef struct CONNECTION_ABORT_TYPE {
	BYTE channel_number;
	BYTE abort_reason;
} CONNECTION_ABORT_TYPE;

typedef struct REMOTE_CONSOLE_TYPE {
	BYTE sub_function;
} REMOTE_CONSOLE_TYPE;

/* The union of all the above */
typedef struct UNION_AG_PACKET {
	BYTE packet_class;
	union packet_type {
		LINE_STAT_INFO_TYPE			line_info;
		CHANGE_PARAMS_REQ_TYPE		change_parameters_request;
		NAME_VALIDATE_REQ_TYPE		name_validate_request;
		NAME_VALIDATE_RESP_TYPE		name_validate_response;
		PASSWORD_VALIDATE_REQ_TYPE	password_validate_request;
		PASSWORD_VALIDATE_RESP_TYPE	password_validate_response;
		CONNECT_REQ_TYPE			connect_request;
		INBOUND_CONNECT_REQ_TYPE	inbound_connect_request;
		CONNECT_RESP_TYPE			connect_response;
		STATUS_REQ_TYPE				status_request;
		STATUS_RESP_TYPE			status_response;
		DISCONNECT_REQ_TYPE			disconnect_request;
		DISCONNECT_RESP_TYPE		disconnect_response;
		DATA_TYPE					data_packet;
		CONTROL_TYPE				control_packet;
		REMOTE_CONSOLE_TYPE			remote_console_packet;

		CONNECTION_ABORT_TYPE		connection_abort_packet;
		FLOW_CONTROL_TYPE			flow_control_packet;	/* Not used by us */
	} packet_type;
} UNION_AG_PACKET;

#endif /* _AGPKTTYP_H_ */
