/* AGTX.C -- Has delayed send and send complete routine for the serial side
** By: Sanjay
** Start: 23, July, 1996
** Done: 30, August, 1996
*/

#include "rtrstd.h"

#include <serial.h>

#include "kag.h"
#include "vagstr.h"
#include "agpkttyp.h"
#include "agutil.h"
#include "agnetif.h"
#include "agtx.h"
#include "agdebug.h"

/* -- CODE ------------------------------------------------------------- */

void send_delayed_serial_packets(SESSION_TABLE_ENTRY *sptr_session_entry)
{
	BYTE line_id;
	USHORT data_size;
	UNION_AG_PACKET *sptr_ag_packet;
	LINE_INFO_ENTRY *sptr_line_info;
	RETAINED_RX_PACKET *sptr_retained_entry;


	sptr_retained_entry = (RETAINED_RX_PACKET *)get_entry_from_list((LINK *)&sptr_session_entry->retained_packet_links);
	while (sptr_retained_entry != NULL)
	{
		sptr_ag_packet = sptr_retained_entry->sptr_ag_packet;
		line_id = sptr_ag_packet->packet_type.data_packet.channel_number;
		data_size = sptr_retained_entry->data_size;

		if (serial_tx_packet((USHORT)line_id, sptr_ag_packet->packet_type.data_packet.data, data_size, APPLICATION) == FAIL)
		{
			/* Delay some more */
			add_entry_to_front_of_list((LINK *)&sptr_session_entry->retained_packet_links, (LINK *)&sptr_retained_entry->links);
			return;
		}

		/* Statistics update */
		sptr_line_info = &ag.line_info_array[line_id];
		sptr_line_info->stats.pending_tx_bytes -= data_size;
		update_line_line_tx_statistics(line_id, data_size);

		mbf((BYTE *)sptr_retained_entry);

		/* Since we were able to do the send, reduce the throttle on the
		** network receive side.
		*/
		increase_network_receives(sptr_session_entry);

		sptr_retained_entry = (RETAINED_RX_PACKET *)get_entry_from_list((LINK *)&sptr_session_entry->retained_packet_links);
	}
}

void serial_tx_complete(USHORT port_number, SESSION_TABLE_ENTRY *sptr_session_entry, BYTE *sptr_buffer)
{
	UNION_AG_PACKET *sptr_ag_packet;

	sptr_ag_packet = (UNION_AG_PACKET *)((BYTE *)sptr_buffer - (sizeof(DATA_TYPE) - sizeof(BYTE) + sizeof(BYTE)));
	free_network_stuff(sptr_ag_packet);

	if (sptr_session_entry->session_status != AG_SESS_ABORTED)
		reduce_receives_and_wait_for_network_packets(sptr_session_entry);
}

enum TEST write_serial_port(USHORT port_number, char *sptr_buffer, USHORT bytes_to_write)
{
	return serial_tx_packet(port_number, sptr_buffer, bytes_to_write, DRIVER);
}

/* -- END CODE -------------------------------------------------------- */
