/* KAG.H -- Constants and enumerations for AG code usage
*/

#ifndef _KAG_H_
#define _KAG_H_

/* Comment out below two defines before creating shipping version */
/*
#define DEBUG
#define MEM_DEBUG
*/

/* Make statics global if compiled with DEBUG defined */
#ifdef DEBUG
#define STATIC
#else
#define STATIC static
#endif

#define AG_IPX_SERVICE_SOCKET	0x828D		/* Registered with Novell */
#define AG_IPX_SERVER_TYPE		0x0335		/* Registered with Novell -- AG is server 335h */

#define MAX_PACKET_SIZE			512		/* Buffer size for receives */
#define DEF_PACKET_SIZE			256		

#define MAX_NET_RX_BUFFER_SIZE	512		/* We assume we may receive atmost
										** this much from a MCSI client.
										*/

#define SERVER_NAME_LENGTH		9			/* 8 + 1 */
#define SER_NAME_LENGTH  		17
#define USER_NAME_LENGTH		17			/* 16 + 1 */
#define PASSWORD_LENGTH			17			/* 16 + 1 */
#define GENERAL_NAME_LENGTH		9			/* 8 + 1 */
#define SPECIFIC_NAME_LENGTH	15			/* 14 + 1 */
#define CALLBACK_NUMBER_LENGTH	60			/* 59 + 1 */
#define VERSION_STRING_LENGTH	6

/* Added by Naveen on 17-10-1996 ... */
#define NETWORK_NUMBER_LENGTH 9
#define NODE_NUMBER_LENGTH    13
#define HOST_STATUS_LENGTH    5
/* ...Naveen*/

/*Following defines are added by Naveen 16-10-1996*/
#define FILE_NAME_LENGTH 13
#define PATH_NAME_LENGTH 68
/*Above defines are added by Naveen 16-10-1996 */

#define REMOTE_TERMINAL_HEIGHT		25
#define INBOUND_HOSTS_LIST_SIZE 	10		/* 10 lines per screen of display */
#define MAX_INBOUND_LOGIN_ATTEMPTS	4
#define MAX_INBOUND_INPUT			256		/* Atmost 255 characters can be
											** input when prompting for 
											** inbound user name, password, 
											** etc.
											*/

enum PORT_OWNER {
	UNKNOWN_MODULE  = 0,
	OUTBOUND_MODULE = 1,
	INBOUND_MODULE  = 2
};

/* Session status */		  	
/* NOTE: We use the following codes slightly differently. AG_SESS_CLOSED
** refers to a session entry that has been allocated and on which a
** listen is waiting. Once the listen is posted this goes to the 
** AG_SESS_ACTIVE state. We do this because of the way RouterWare SPX is.
*/
#define AG_SESS_CLOSED				0	/* Free */
#define AG_SESS_ABORTED				1	/* Session has been aborted */
/* Following is not used but retained for compatibility */
#define AG_SESS_BAD_NET_INTERFACE	2	/* IPX/NETBIOS interface bad */
#define AG_SESS_ACTIVE				3	/* Session active, but does not */
										/* have a line allocated to it */
#define AG_SESS_CONNECTED			4	/* Session has a line allocated	*/
										/* to it						*/
#define AG_SESS_CANCELLING			5	/* NEW. State on a session with
										** inbound call possibility during
										** which all network sends will be
										** aborted and after which the
										** state goes to AG_SESS_ACTIVE.
										*/
#define	UNKNOWN_LINE		0xFF			/*	Used to indicate that the	*/
											/*	LineId field in the packet	*/
											/*	header is not valid, and	*/
											/*	the LineName field should	*/
											/*	be looked into to get the	*/
											/*	actual user / workstation	*/
											/*	name.						*/


enum NET_INTERFACE
{		/* Don't change these values...they are used in configuration */
	NET_INTERFACE_IPXSPX = 0,		
	NET_INTERFACE_IP = 1,
	NET_INTERFACE_NETBIOS = 2
};

enum AG_PRINTF_GROUPS
{
	AG_INIT_PRINTF,
	AG_ALARM_PRINTF,
	AG_SESS_PRINTF,
	AG_MCSI_IN_PRINTF,
	AG_MCSI_OUT_PRINTF,
	AG_CONNECT_PRINTF,
	AG_DIAGNOSTIC_PRINTF,
	AG_LINE_PRINTF,			/* Line related stuff */
	AG_INBOUND_PRINTF
};

enum AG_PORT_AVAILABILITY
{
	AG_PORT_AVAILABLE,
	AG_PORT_IN_USE,
	AG_PORT_DISABLED,
	AG_PORT_NOT_ASYNC
};

/*	The following define the type of each line on the server.				*/

#define	OUTBOUND_MODEM		0x00
#define	INBOUND_MODEM		0x01


/* The following defintion give the packet types.							*/
/* The first few are request codes */
#define	AG_NAME_VALIDATE_REQ		0x00	/* Do not change the order		*/
#define	AG_PASSWORD_VALIDATE_REQ	0x01	/* of these definitions.		*/
#define	AG_CONNECT_REQ				0x02	/* These are being used as		*/
#define	AG_STATUS_REQ				0x03	/* indices into jump tables		*/
#define	AG_DISCONNECT_REQ			0x04
#define	AG_CHANGE_CONNECT_PARAM		0x05
#define AG_RC_REQ_PKT				0x06
#define	AG_IN_CONNECT_REQ			0x07   
#define	AG_DATA_PACKET		   		0x08
#define	AG_CONTROL_PACKET			0x09
/* The following are response codes */
#define	AG_CONNECT_ABORTED			0x88
#define	AG_FLOW_CONTROL				0x89
#define	AG_NAME_VALIDATE_RESP		0x8A
#define	AG_PASSWORD_VALIDATE_RESP	0x8B
#define	AG_CONNECT_RESP				0x8C
#define	AG_STATUS_RESP				0x8D
#define	AG_DISCONNECT_RESP			0x8E
#define	AG_INBOUND_CONNECT_RESP		0x8F
#define AG_BROADCAST_PACKET			0x90
#define AG_RC_RESPONSE_PACKET		0x91

/* Line status codes. AGLS = AG Line Status */
#define	AGLS_LINE_FREE			0			/* Line is free. */
#define	AGLS_LINE_BUSY			1			/* Line is allocated. */
#define	AGLS_BAD_INTERFACE		2			/* IPX interface is bad */
#define	AGLS_BAD_LINE			3			/* Serial port/card is bad */
#define	AGLS_CLEANING_UP		4			/* Line is being reset after a */
											/* disconnect */
#define	AGLS_CONNECTING			5			/* Temp status while connect */
											/* response packet is being sent */
#define	AGLS_LISTEN_INBOUND		6			/* Line is in inbound mode --
											** Removed in this version of AG;
											** Now the state is AGLS_LINE_FREE
											*/
#define	AGLS_CALL_COMING_IN		7			/* Call coming in on inbound */
#define	AGLS_RESET_MODEM		8			/* Sending initialization */
											/* strings to modem */
#define AGLS_CALLING_BACK		9			/* Calling back the user */


/*	The following are values for the ControlSrc field in the ControlType 	*/
/*	packet. AGCS = AG Control Source										*/

#define	AGCS_SET_LINE_CONTROL	0x00		/* Set line control register	*/
#define	AGCS_SET_MODEM_CONTROL	0x01		/* Set modem control register	*/
#define AGCS_FLUSH_TX_BUFFER	0x02 		/* Flush transmit buffer 		*/
#define AGCS_FLUSH_RX_BUFFER	0x03 		/* Flush receive buffer 		*/

#define	AGCS_SET_RING_IND		0x02		/*	Set RI 						*/
#define	AGCS_SET_DCD			0x04		/*	Set DCD						*/
#define AGCS_SET_BREAK			0x05		/*  Set break to be sent		*/

/* The following are possible responses for connection request.  
** AGCR = AG Connect Response.
*/

#define	AGCR_CONNECTED			0x01		/*	Connection is made.			*/
#define	AGCR_NOT_CONNECTED		0x89		/*	Connection not made.		*/
#define	AGCR_ACCESS_DENIED		0x85		/*	User does not have access.	*/
#define	AGCR_NO_MEM				0x8b		/*	No memory for line buffers.	*/
#define AGCR_NO_MORE_SESSIONS	0x8b
#define	AGCR_INVALID_LINE_NAME	0x86		/*	The line name was not		*/
											/*	a valid one.				*/
#define	AGCR_INVALID_USER_NAME	0x87		/*	The user name was not		*/
											/*	valid.						*/

/* The following are values for abort reason.
** AGAR = AG Abort Reason
*/

#define	AGAR_NORMAL_TERMINATION		0x01	/* Normal termination			*/
#define	AGAR_SUPERVISOR_DISCONNECT	0x02	/* Supervisor terminated conxun	*/
#define	AGAR_IDLE_TIMEOUT			0x03	/* Idle timeout expired			*/
#define	AGAR_CD_DROPPED				0x04	/* carrier was dropped on an	*/
											/* inbound session				*/
#define AGAR_ISI_CARD_FAILED	 	0x05	/* ISI card did not respond in	*/
											/* time */
#define AGAR_ABNORMAL_TERMINATION	0x06	/* Connection ended abnormally	*/


/* The following are possible password status values.
** AGPV - AG Password Validate
*/

#define	AGPV_INVALID_PASSWORD	0x00		/*	Password is valid.			*/
#define	AGPV_VALID_PASSWORD		0x01		/*	Password is not valid.		*/


/* Reasons for freeing up a line. In all cases, the corresponding SPX
** session too is aborted except in the case of AGFL_CD_DROPPED which
** applies to inbound sessions and where the session continues to await
** future inbound calls.
*/

#define AGFL_SUPERVISOR_DISCONNECT	0x02
#define AGFL_IDLE_TIMEOUT			0x03
#define AGFL_CD_DROPPED				0x04	/* For inbound session; in this
											** case don't abort session
											*/
#define AGFL_NORMAL_TERMINATION		0x05
#define AGFL_ABNORMAL_TERMINATION	0x06

/* Abort errors */
#define AGE_SESSION_ABORTED			0
#define AGE_BAD_PACKET				1


/* Inbound state machine states */
#define	IS_CHECK_RING					0
#define	IS_INIT_MODEM					1
#define	IS_WAIT_FOR_OK					2
#define	IS_CHECK_CD						3
#define	IS_ATERM_TIMER					4
#define	IS_CHECK_ATERM					5
#define	IS_INIT_ATERM					6
#define	IS_WAIT_ASCII					7
#define	IS_WAIT_ACK1					8
#define	IS_WAIT_ACK2					9
#define	IS_WAIT_ACK3					10
#define	IS_DISPLAY_MENU					11
#define	IS_PROMPT_NAME					12
#define	IS_GET_NAME						13
#define	IS_DISPLAY_NAME_ERROR			14
#define	IS_PROMPT_PASSWORD				15
#define	IS_GET_PASSWORD					16
#define	IS_DISPLAY_PASSWORD_ERROR		17
#define	IS_RESET_ATERM					18
#define	IS_WAIT_RESET					19
#define	IS_CONNECT_INBOUND				20
#define	IS_DISPLAY_ABORTED_LOGIN		21
#define	IS_STOP_STATE					22
#define IS_CHECK_CALLBACK				23
#define IS_CALLBACK						24
#define IS_WAIT_CALL_CD					25
#define IS_GET_MENU_INPUT				26
#define IS_DISPLAY_HOSTS				27
#define IS_VALIDATE_HOST				28
#define IS_CALL_HANGUP					29
#define IS_GET_PHONE_NUMBER  			30
#define	IS_WAIT_ABORTED_LOGIN			31	/* New to this version */

/* Inbound state timeouts -- usually a 2 minute delay */
#define GET_NAME_DELAY					(120 * ag.clock_ticks_per_second)
#define GET_PASSWORD_DELAY				(120 * ag.clock_ticks_per_second)
#define GET_PHONE_NUMBER_DELAY			(120 * ag.clock_ticks_per_second)
#define GET_MENU_INPUT_DELAY			(120 * ag.clock_ticks_per_second)
#define NO_ANSWERING_DELAY				(3 * ag.clock_ticks_per_second)	
#define DELAY_FOR_SERIAL_TRANSFER     (3 * ag.clock_ticks_per_second)

#if 0
#define set_line_status(sptr_line_info, new_line_status)	\
				(sptr_line_info)->line_status = new_line_status
#endif

#endif /* _KAG_H_ */
