/* RCON.H -- Structures and constants related to remote console */

#ifndef _RCON_H_
#define _RCON_H_


#define	MAX_FILE_PKT				400

/* Naveen 24-10-1996*/
#define  GENERAL_INFO_SIZE          198
/* Naveen 24-10-1996*/

/* Following are possible remote console request types */
#define REQ_RC_GET_SERVER_INFORMATION	0		/* Get general info about server*/
#define REQ_RC_DOWN_SERVER				1		/* Shut down server */
#define REQ_RC_GET_LOG_STATUS			2		/* Get status of log */
#define REQ_RC_OPEN_LOG					3		/* Open log file */
#define REQ_RC_CLOSE_LOG				4		/* Close the log file */
#define REQ_RC_DISCONNECT				5		/* Disconnect the line */
#define REQ_RC_CHANGE_PARAMETERS		6		/* Change the line parameters */
#define REQ_RC_GET_STATISTICS_SUMMARY	7		/* Get statistics summary */
#define REQ_RC_GET_CURRENT_STATISTICS	8		/* Get current statistics for */
											/* all the lines */
#define REQ_RC_RESET_LINE				9		/* Reset a line */
#define REQ_RC_VALIDATE_PASSWORD		10		/* Validate Password */
#define REQ_RC_GET_STATUS				11		/* Get status */
#define REQ_RC_GET_INBOUND_LIST			12		/* Get inbound list */
#define REQ_RC_DELETE_INBOUND			13		/* Delete inbound user */
#define REQ_RC_GET_SERVER_CONFIGURATION	14		/* Get server configuration */
#define REQ_RC_CHANGE_SERVER_CONFIGURATION	15		/* Change server configuration */
#define REQ_RC_GET_CONFIGURATION_FILE	16		/* Get the config file 		*/
#define REQ_RC_PUT_CONFIGURATION_FILE	17		/* Save the config file		*/
#define REQ_RC_RESET_SBC_PROCESSOR		18		/* Reset SBC processor 	*/
#define REQ_RC_USER_VALIDATE_RESPONSE	19
#define REQ_RC_UNLOCK_USER				20
#define REQ_RC_SAVE_CHANGES_TO_DISK 	21

#define REQ_RC_REQUEST_LAST_TYPE		21		/* Maximum valid function num */

/* Following are possible remote console response types */
#define RESP_RC_SERVER_INFORMATION		0		/* General info about server*/
#define RESP_RC_LOG_STATUS				1		/* Log status of server*/
#define RESP_RC_STATISTICS_SUMMARY		2		/* Statistics summary */
#define RESP_RC_CURRENT_STATISTICS		3		/* Statistics for current lines */
#define RESP_RC_VALID_PASSWORD			4		/* Password validation */
#define RESP_RC_STATUS					5		/* Status */
#define RESP_RC_INBOUND_LIST				6		/* Inbound list */
#define RESP_RC_SERVER_CONFIGURATION		7		/* Server Config Info */
#define RESP_RC_FILE_RETURN				8		/* Give the config file */
#define RESP_RC_FILE_GET_MORE			9		/* Request for next file block */

#define RESP_RC_RESPONE_LAST_TYPE		9		/* Maximum valid function num */


/* Request structures */

typedef struct RC_DISCONNECT_REQUEST {
	BYTE	request_type;
	BYTE	channel_number;
} RC_DISCONNECT_REQUEST;




typedef struct RC_CHANGE_PARAMETERS_REQUEST {
	BYTE	request_type;
	BYTE	channel_number;
	CONNECT_VARS_TYPE	connect_vars_info;
} RC_CHANGE_PARAMETERS_REQUEST;

typedef struct RC_GET_STATISTICS_REQUEST {
	BYTE	request_type;
	BYTE	channel_number;
} RC_GET_STATISTICS_REQUEST;

typedef struct RC_RESET_SBC_PROCESSOR_TYPE_REQUEST {
	BYTE	request_type;
	BYTE	segment_number;
} RC_RESET_SBC_PROCESSOR_TYPE_REQUEST;

typedef struct RC_RESET_SBC_PROCESSOR_REQUEST {
	BYTE	request_type;
	BYTE	segment_number;
} RC_RESET_SBC_PROCESSOR_REQUEST;

typedef struct RC_OPEN_LOG_REQUEST {
	BYTE	request_type;
	ULONG	log_duration;
} RC_OPEN_LOG_REQUEST;

typedef struct RC_RESET_REQUESTS {
	BYTE	request_type;
	BYTE	channel_number;
} RC_RESET_REQUESTS;

typedef struct RC_FILE_REQUEST {
	BYTE	request_type;
	USHORT	packet_number;
} RC_FILE_REQUEST;

typedef struct GENERAL_INFO
{
   BYTE general_info[GENERAL_INFO_SIZE];
}GENERAL_INFO;

/* Naveen */

typedef struct
{
   ULONG general_info_offset ;
   ULONG communication_info_offset ;
   ULONG user_info_offset ;
   GENERAL_INFO general_info ;
   BYTE port_type ;
   BYTE number_of_cards ;
   USHORT number_of_users ;
} FIXED_CONFIG_FILE_HEADER ;

typedef struct
{
   BYTE response_type ;
   USHORT packet_number ;
   USHORT remaining_bytes ;
   BYTE error_in_read ;
   BYTE buffer[MAX_FILE_PKT] ;
} RC_FILE_RESPONSE ;
/* Naveen */

#if 0 
By Naveen 24-10-1996
typedef struct USER_INFO_TYPE {
	BYTE UserName[USER_NAME_LENGTH];
	BYTE UserPasswd[PASSWORD_LENGTH];
	BYTE CallBackNum[CALLBACK_NUMBER_LENGTH];
	WORD CallBackDelay;						/* Delay in secs */
	BYTE EnterNumber;						/* To let user enter call back no */
	ULONG LinePerms;						/* Line permissions for 32 lines */
	BYTE ModePerms;							/* Connect Mode permissions */
	WORD ProtocolPerms;						/* Protocols allowed 0 -IPX, 1-IP */
											/* 2-SpanningTree, 3-Netbios	  */
	BYTE TimeOfDay[7][6];					/* Each bit is 1/2 hr slot */
	WORD ConnectionTimeLimit;			/* Connection time limit */
} USER_INFO_TYPE;								
#endif

/* Naveen 24-10-1996*/
typedef struct USER_INFO_TYPE
{
	BYTE user_name[USER_NAME_LENGTH];
	BYTE password[PASSWORD_LENGTH];
	BYTE callback_number[CALLBACK_NUMBER_LENGTH];
	USHORT callback_delay;						/* Delay in secs */
	BYTE enter_number;						/* To let user enter call back no */
	ULONG line_permissions;						/* Line permissions for 32 lines */
	BYTE mode_permissions;						/* Connect Mode permissions */
} USER_INFO_TYPE;


/* Naveen 24-10-1996*/


typedef struct RC_USER_REQUEST {
	BYTE	request_type;
   USER_INFO_TYPE	user_information;
	BYTE	validate_or_update;
	USHORT	index;
	BYTE	insert_or_delete;
} RC_USER_REQUEST;

typedef struct RC_SAVE_CHANGES_REQUEST {
	BYTE	request_type;
	BYTE	save_type;
} RC_SAVE_CHANGES_REQUEST;

typedef struct RC_STATUS_REQUEST {
	BYTE	request_type;
	BYTE	user_name[USER_NAME_LENGTH];
	BYTE	last_line_id;
} RC_STATUS_REQUEST;

typedef union UNION_RC_REQUEST {
	RC_DISCONNECT_REQUEST				disconnect_request;
	RC_CHANGE_PARAMETERS_REQUEST		change_parameters_request;
	RC_GET_STATISTICS_REQUEST			statistics_request;
	RC_RESET_SBC_PROCESSOR_TYPE_REQUEST	reset_processor_type_request;
	RC_RESET_SBC_PROCESSOR_REQUEST		reset_processor_request;
	RC_OPEN_LOG_REQUEST					open_log_request;
	RC_RESET_REQUESTS					reset_request;
	RC_FILE_REQUEST						file_request;
	RC_USER_REQUEST						user_request;
	RC_SAVE_CHANGES_REQUEST				save_changes_request;
	RC_STATUS_REQUEST					status_request;
} UNION_RC_REQUEST;

/* Response structures */

typedef struct RC_SERVER_INFORMATION {
	BYTE	response_type;
	BYTE	server_name[SER_NAME_LENGTH]; /* SER_NAME_LENGTH = 17 */
	BYTE	version_string[VERSION_STRING_LENGTH]; /* VERSION_STRING_LENGTH = 6 */
	BYTE	number_of_ports;
	BYTE	server_type;
	BYTE	number_of_cards;
	BYTE	password_present;
} RC_SERVER_INFORMATION;

typedef struct RC_LOG_STATUS_INFORMATION {
	BYTE		response_type;
	BYTE		log_status;				/* opened or closed */
	DATE_TIME	log_start_time;
	DATE_TIME	current_time;
	ULONG		log_period;
} RC_LOG_STATUS_INFORMATION;

typedef struct RC_STATISTICS_SUMMARY {
	BYTE		response_type;
	USHORT		utilization;				/* % utilization */
	ULONG		free_memory;				/* Available memory */
	USHORT		dialin_users;				/* Total users awaiting dialin */
	DATE_TIME	boot_time;
	DATE_TIME	current_time;
	BYTE		busy_lines;					/* Currently busy lines */
	ULONG		dialin_calls;				/* Inbound calls since power up */
	ULONG		dialout_calls;				/* Outbound calls since power up */
	ULONG		tx_data_packets;			/* Total packets from server to workstations */
	ULONG		rx_data_packets;			/* Total packets from workstation to server */
	ULONG		lan_tx_data_bytes;			/* Total bytes from server on lan */
	ULONG		lan_rx_data_bytes;			/* Total bytes to server from lan */
	ULONG		line_tx_data_bytes;			/* Total bytes from server on wan */
	ULONG		line_rx_data_bytes;			/* Total bytes to server from wan */
} RC_STATISTICS_SUMMARY;


typedef struct RC_CURRENT_STATISTICS {
	BYTE		response_type;
	BYTE		line_status;
	BYTE		user_name[USER_NAME_LENGTH];
	BYTE		user_address[12];
	DATE_TIME	connect_time;
	DATE_TIME	current_time;

	LINE_PARAM_TYPE line_parameters;  
	ULONG		idle_time;					/* Idle timeout */
	ULONG		dialout_calls;				/* Dialout calls on this line since power up */
	ULONG		dialin_calls;				/* Dialin calls on this line since power up */
	ULONG		lan_tx_throughput;			/* per second */
	ULONG		lan_rx_throughput;			/* per second */
	ULONG		line_tx_throughput;			/* per second */
	ULONG		line_rx_throughput;			/* per second */
	ULONG		pending_tx_bytes;
	ULONG		pending_rx_bytes;
	ULONG		current_rx_data_packets;
	ULONG		current_tx_data_packets;
	ULONG		current_line_tx_bytes;
	ULONG		current_line_rx_bytes;
	ULONG		current_lan_tx_bytes;
	ULONG		current_lan_rx_bytes;
	ULONG		total_tx_data_packets;
	ULONG		total_rx_data_packets;
	ULONG		total_lan_tx_bytes;
	ULONG		total_lan_rx_bytes;
	ULONG		total_line_tx_bytes;
	ULONG		total_line_rx_bytes;
} RC_CURRENT_STATISTICS;

typedef struct RC_USER_RESPONSE {
	BYTE		response_type;
	BYTE		ok_or_not;
	USHORT		index;
} RC_USER_RESPONSE;

typedef struct RC_STATUS_RESPONSE
{
	BYTE		response_type;
	BYTE		number_of_lines;
	BYTE		last_line_id;
	LINE_STAT_INFO_TYPE line_status_array[1];
} RC_STATUS_RESPONSE;

/* Naveen 16-10-1996 */
typedef	struct RC_SERVER_CONFIG
{
	/* BYTE	PktClass; */
	BYTE response_type ;
	BYTE server_name[SERVER_NAME_LENGTH];
	BYTE password[PASSWORD_LENGTH];
	BYTE log_file_name[FILE_NAME_LENGTH + PATH_NAME_LENGTH - 1];
	ULONG log_duration;
	BYTE message_file_name[FILE_NAME_LENGTH + PATH_NAME_LENGTH - 1];
	BYTE message_on_off;
	BYTE log_on_off;
	BYTE connection_manager_on_off;
	BYTE mmm_on_off;
	BYTE screen_saver;
} RC_SERVER_CONFIG;
/* Naveen 16-10-1996 */

/* Naveen 17-10-1996*/
typedef		struct RC_INBOUND_LIST_DIR_TYPE
{
	BYTE host_name[USER_NAME_LENGTH];
	BYTE network_number[NETWORK_NUMBER_LENGTH];				/* Make sure this is 2*NET_LEN + 1 */
	BYTE node_number[NODE_NUMBER_LENGTH];				/* Make sure this is 2*NODE_LEN + 1 */
	BYTE host_status[HOST_STATUS_LENGTH];				/* For FREE or BUSY */
} RC_INBOUND_LIST_DIR_TYPE;

typedef struct RC_INBOUND_LIST_RESPONSE
{
	BYTE response_type;
	BYTE last_packet;
	BYTE number_of_entries;
	RC_INBOUND_LIST_DIR_TYPE  inbound_list_array[1];
} RC_INBOUND_LIST_RESPONSE;

/* Naveen 17-10-1996*/

/* Naveen 26-10-1996 */
typedef struct RC_USER_REQ_TYPE
{
	BYTE response_type;
	USER_INFO_TYPE user_info;
	BYTE validate_or_update;
	WORD index;
	BYTE insert_or_delete;
} RC_USER_REQ_TYPE;

typedef struct RC_USER_RESPONSE_TYPE
{
	BYTE response_type;
	BYTE ok_or_not;
	WORD index;
}RC_USER_RESP_TYPE;
/* Naveen 26-10-1996 */

/* Added by Naveen on 01-11-1996 ... */
typedef struct RC_DELETE_INBOUND_REQUEST
{
   BYTE response_type;
   BYTE user_name[USER_NAME_LENGTH];
   BYTE network_number[NETWORK_NUMBER_LENGTH];
   BYTE node_number[NODE_NUMBER_LENGTH];
   BYTE status[HOST_STATUS_LENGTH];
}RC_DELETE_INBOUND_REQUEST ;
/* .... Naveen */


typedef union UNION_RC_RESPONSE
{
	RC_SERVER_INFORMATION		server_information_response;
	RC_LOG_STATUS_INFORMATION	log_status_response;
	RC_STATISTICS_SUMMARY		statistics_response;
	RC_CURRENT_STATISTICS		current_statistics_response;
	RC_FILE_RESPONSE			file_response;
	RC_USER_RESPONSE			user_response;
	RC_STATUS_RESPONSE			status_response;
	RC_SERVER_CONFIG			  server_config;
	RC_INBOUND_LIST_RESPONSE	inbound_list_response;
} UNION_RC_RESPONSE;


/* Naveen */
#define COM_VERSION 0
#define AG_SERVER   4
#define IPX_VERSION 8
#define HARDWARE_68K 0x80

#define WAN_PORT_DISABLED 10
/* Naveen */

#endif /* _RCON_H_ */



