/* VAGSTR.H -- Key structures used by AG code
*/

#ifndef _VAGSTR_H_
#define _VAGSTR_H_

/* -------------------------------------------------------------------------*/
/* Session related structures */

#define MAX_WAN_PORTS			3

typedef struct DATE_TIME {
	USHORT	year;			   	/* 1980 - 2099 */
	BYTE	month;				/* 1 - 12 */
	BYTE	day;				/* 1 - 31 */
	BYTE	week_day;			/* 0 - Sunday, 1 - Monday etc */
	BYTE	hour;				/* 0 - 23 */
	BYTE	minute;				/* 0 - 59 */
	BYTE	second;				/* 0 - 59 */
	BYTE	hundredth_of_second;/* 0 - 99  (100 = 1 second) */
} DATE_TIME;

typedef struct RETAINED_RX_PACKET_LINKS {
	struct RETAINED_RX_PACKET *sptr_forward_link;
	struct RETAINED_RX_PACKET *sptr_backward_link;
} RETAINED_RX_PACKET_LINKS;

typedef struct RETAINED_RX_PACKET {
	RETAINED_RX_PACKET_LINKS	links;
	void 						*sptr_ag_packet;
	USHORT						data_size;
} RETAINED_RX_PACKET;

typedef struct SESSION_TABLE_ENTRY_LINK {
	struct SESSION_TABLE_ENTRY *sptr_forward_link;
	struct SESSION_TABLE_ENTRY *sptr_backward_link;
} SESSION_TABLE_ENTRY_LINK;

typedef struct SESSION_TABLE_ENTRY {
	SESSION_TABLE_ENTRY_LINK links;
	SESSION_TABLE_ENTRY_LINK inbound_links;	/* Use to link into list of sessions waiting for inbound on a per-line basis */
	
	ULONG session_ID;				/* Just a unique incrementing value to distinguish sessions */
	ULONG connection_ID;			/* This is the key into this list */
	BYTE session_status;

	BYTE line_in_use;				/* The port in use once inbound/outbound 
									** is established. This field is used as
									** an index into the line info array to
									** find line info of line associated with
									** this session. There is no associated
									** line if this is UNKNOWN_LINE.
									*/

	BYTE *user_entry;				/* pointer to user record for connection */				

	void *protocol_specific_info;

	RETAINED_RX_PACKET_LINKS retained_packet_links;	

	enum BOOLEAN freeup_session;	/* Valid for checks only in the internal
									** send post routine. If TRUE, session
									** will be terminated if the reason is
									** not "CD dropped".
									*/
} SESSION_TABLE_ENTRY;

/* Below should be same as that in VIPXSTR.H */
typedef struct IPX_ADDRESS_DEFINED {
	ULONG						network;	
	ETHERNET_ADDRESS			node_address;	
	USHORT						socket; 	
} IPX_ADDRESS_DEFINED;

typedef struct IPX_SPECIFIC_INFO {
	IPX_ADDRESS_DEFINED client_ipx_address;
	MAC_ADDRESS client_immediate_address;
	BYTE receives_issued;
	BYTE pending_calls;					/* Number of calls pending with SPX.
										** When aborting a session, it is ok
										** to perform the abort if this is 0.
										*/

	void *sptr_listen_ecb;		/* alloc-ed space will be used to issue listens */
	void *sptr_listen_packet;	

	void *sptr_terminate_ecb;
	void *sptr_terminate_packet;/* alloc-ed space will be used to terminate */
} IPX_SPECIFIC_INFO;

/* -------------------------------------------------------------------------*/
/* Line Information Structure */

/* NOTE: Following structure is used to pass parameters regarding initializing
** a 8250 or compatible UART. Since we do not have a UART, we map each of
** these to something suitable on the SCC's programmed as a UART. In the
** 'line_format' parameter only the parity, stop bits and data bits settings
** are used. In the 'modem_control_byte', only the RTS and DTR settings are
** used. The 'int_mask_byte' is not used at all.
*/
typedef	struct {
	USHORT	baud_divisor;			/* 8250 style baud divisor */
	BYTE	line_format;			/* 8250 style line control register settings */
	BYTE    modem_control_byte;		/* 8250 style modem control register settings */
	BYTE    int_mask_byte;			/* 8250 style interrupt enable register settings */
} LINE_PARAM_TYPE;

typedef struct LINE_VARS_TYPE {
	BYTE general_name[GENERAL_NAME_LENGTH];
	BYTE specific_name[SPECIFIC_NAME_LENGTH];
	BYTE line_type;					/* INBOUND_MODEM, OUTBOUND_MODEM */
	LINE_PARAM_TYPE line_parameters;
	ULONG default_baud_rate;		/* Config info */
	BYTE default_data_bits;			/* Config info */
	BYTE default_parity;			/* Config info */
	BYTE default_stop_bits;			/* Config info */
	USHORT default_max_packet_size;	/* Config info; this parameter gives max 
									** amount of data to send to client in a 
									** single packet
									*/

	ULONG current_baud_rate;		/* Actually used */
	BYTE current_data_bits;			/* Actually used */
	BYTE current_parity;			/* Actually used */
	BYTE current_stop_bits;			/* Actually used */
	USHORT current_max_packet_size;	/* Actually used */

/* Following field was used in the original code to decide when to 
** packetise and send serially received data. We don't use this as in the
** QUICC all this is taken care of internally by the SCC's (which currently
** use a 20 character idle time to packetise.
*/
	USHORT max_inter_packet_delay;		/* Force next packet assembly	*/
										/* if time elapsed since last	*/
										/* packet sent exceeds this.	*/
	ULONG idle_time;					/* If line is continuously		*/
										/* idle for this time hang up.	*/
										/* Time in minutes */
} LINE_VARS_TYPE;

typedef struct PER_LINE_STATISTICS {
	DATE_TIME connect_time;     		/* Time connection was made */
	ULONG   total_dialout_calls;   		/* Number of dial out calls        */
	                           			/* since the server was up */
	ULONG   total_dialin_calls;    		/* Number of dial in calls */
	                           			/* since the server was up */
	ULONG   lan_tx_bytes;        		/* No Of bytes transmitted on      */
	                           			/* LAN for this line in one sec*/
	ULONG   last_lan_tx_bytes;    		/* No Of bytes transmitted on      */
	                           			/* LAN in the previous sec*/
	ULONG   lan_rx_bytes;        		/* No Of bytes received on         */
	                           			/* LAN for this line in one sec*/
	ULONG   last_lan_rx_bytes;    		/* No Of bytes received on         */
	                           			/* LAN in the previous sec*/
	ULONG   line_tx_bytes;       		/* No Of bytes transmitted on      */
	                           			/* the port in one second          */
	ULONG   last_line_tx_bytes;   		/* No Of bytes transmitted on      */
			                           	/* the port in the previous sec*/
	ULONG   line_rx_bytes;       		/* No Of bytes received on         */
	                           			/* the port in one second          */
	ULONG   last_line_rx_bytes;   		/* ?? No Of bytes received on         */
	                           			/* the port in previous second */
	/* Following two pertain to packets being sent to serial side or
	** received from the serial side. Since we do not queue up serial packets
	** at our layer of code, there is never anything pending. (Maybe only
	** the Tx part will pend when we 'retain')
	*/
	ULONG   pending_tx_bytes;    		/* Cumulative count of bytes       */
	                           			/* waiting to be transmitted       */
	ULONG   pending_rx_bytes;    		/* Cumulative count of bytes       */
	                           			/* waiting to be sent to the       */
	                           			/* workstation                                     */
	ULONG   current_tx_data_packets;    /* No. of data pkts sent to        */
	                           			/* the current user */
	ULONG   current_rx_data_packets;    /* No. of data pkts recd from      */
	                           			/* the current user */
	ULONG   current_line_tx_bytes;    	/* Total number of bytes sent      */
	                           			/* over line for current user  */
	ULONG   current_line_rx_bytes;    	/* Total number of bytes recvd     */
	                           			/* over line for current user      */
	ULONG   current_lan_tx_bytes;     	/* Total number of bytes sent      */
	                           			/* over LAN for current user  */
	ULONG   current_lan_rx_bytes;     	/* Total number of bytes recvd     */
	                           			/* over LAN for current user  */
	ULONG   log_tx_data_packets;     	/* Total data pkts sent during */
	                           			/* the log period */
	ULONG   log_rx_data_packets;     	/* Total data pkts recd during     */
	                           			/* the log period */
	ULONG   log_line_tx_bytes;    		/* Total number of bytes sent      */
	                           			/* over the line during the  */
	                           			/* log period */
	ULONG   log_line_rx_bytes;    		/* Total number of bytes recvd     */
	                           			/* over the line during the */
	                           			/* log period */
	ULONG   log_lan_tx_bytes;     		/* Total number of data bytes*/
	                           			/* sent from the server to the */
	                           			/* workstn during log period*/
	ULONG   log_lan_rx_bytes;     		/* Total number of data bytes*/
	                           			/* sent to the server from the */
	                           			/* workstn during log period*/
	ULONG   total_tx_data_packets;     	/* Total number of data packets*/
	                           			/* sent from the server to the */
	                           			/* workstation since server up     */
	ULONG   total_rx_data_packets;     	/* Total number of data packets*/
	                           			/* sent to the server from the */
		                           		/* workstation since server up     */
	ULONG   total_lan_tx_bytes;     	/* Total number of data bytes*/
	                           			/* sent from the server to the */
	                           			/* workstation since server up     */
	ULONG   total_lan_rx_bytes;     	/* Total number of data bytes*/
	                           			/* sent to the server from the */
	                           			/* workstation since server up     */
	ULONG   total_line_tx_bytes;    	/* Total number of bytes sent */
	                           			/* out over the line since */
	                           			/* server was powered up */
	ULONG   total_line_rx_bytes;    	/* Total number of bytes recvd */
	                           			/* over the line since */
	                           			/* server was powered up */
} PER_LINE_STATISTICS;

typedef struct LINE_INFO_ENTRY {
	LINK					next_inbound_line_link;
	BYTE					line_id;
	LINE_VARS_TYPE			line_vars;		/* General line params -- inited on startup */

	BYTE					line_status;
	BYTE_ENUM(BOOLEAN)		cleanup;
	BYTE					abort_reason;

	SESSION_TABLE_ENTRY 	*sptr_session_entry;	/* ptr to session related to connection */

	BYTE					connect_mode;			/* Currently inbound/outbound etc. */
	BYTE					freeup_reason;			/* Why the connected line will be disconnected */

	USHORT 					inter_packet_delay_timer;
	ULONG					inactivity_timer;

	/* Inbound related stuff */
	SESSION_TABLE_ENTRY_LINK	sessions_awaiting_inbound;
	ULONG					number_of_inbound_users;	/* Number of entries in above list */
	enum BOOLEAN			inbound_init_on;/* Set to indicate serial receive 
											** should be directed to the
											** inbound state machine code.
											*/
	BYTE					next_inbound_state;
	ULONG					inbound_state_timer;
	BYTE					inbound_login_attempts;
	BYTE					menu_line_number;

	enum BOOLEAN			inbound_input_valid;
	enum BOOLEAN			echo_inbound_input;
	char					index_inbound_input_buffer;
	char					inbound_input_buffer[MAX_INBOUND_INPUT];

	char					inbound_user_name[USER_NAME_LENGTH];
	char					inbound_user_password[PASSWORD_LENGTH];
	char					inbound_user_callback_number[CALLBACK_NUMBER_LENGTH];

	enum BOOLEAN 			callback_check_done;
	enum BOOLEAN 			callback_hangup_done;

	enum BOOLEAN			blank_screen_done;
	enum BOOLEAN			title_display_done;
	enum BOOLEAN			hosts_display_done;
	enum BOOLEAN			footer_display_done;
	BYTE					next_line_to_blank;
	BYTE					next_host_index;
	BYTE					top_host_index;
	BYTE					line_display_buffer[160];	/* Arbitary value of array size */

	PER_LINE_STATISTICS		stats;

} LINE_INFO_ENTRY;

/* -------------------------------------------------------------------------*/
/* Network interface structures */

typedef struct IPX_INTERFACE_CLASS {
	ULONG					broadcast_interval;		/* In seconds */
	ULONG					last_broadcast_timer;	/* In seconds */
	BYTE					receives_per_session;	/* Configured */
	USHORT					max_net_rx_buffer_size;	/* 512 is default */
} IPX_INTERFACE_CLASS;

typedef struct IP_INTERFACE_CLASS {
	/* Nothing here for now */
	BYTE dummy;
} IP_INTERFACE_CLASS;

typedef struct NB_INTERFACE_CLASS {		/* NetBIOS */
	/* Nothing here for now */
	BYTE dummy;
} NB_INTERFACE_CLASS;

/* -------------------------------------------------------------------------*/
/* AsyncGateway Class Structure */

typedef struct AG_PRINT_CLASS {
	BYTE_ENUM(BOOLEAN) ag_print_switch_on;
	BYTE_ENUM(BOOLEAN) init_printing_enabled;
	BYTE_ENUM(BOOLEAN) alarm_printing_enabled;
	BYTE_ENUM(BOOLEAN) session_printing_enabled;
	BYTE_ENUM(BOOLEAN) mcsi_in_printing_enabled;
	BYTE_ENUM(BOOLEAN) mcsi_out_printing_enabled;
	BYTE_ENUM(BOOLEAN) connect_printing_enabled;
	BYTE_ENUM(BOOLEAN) diagnostic_printing_enabled;
	BYTE_ENUM(BOOLEAN) line_printing_enabled;
	BYTE_ENUM(BOOLEAN) inbound_printing_enabled;
} AG_PRINT_CLASS;

typedef struct AG_STATISTICS {
	BYTE 	number_of_connections;	/* Number of busy connections */
	BYTE	number_of_sessions;		/* Number of active sessions */
	BYTE	inbound_connections;	/* Connections busy inbound */
	BYTE	outbound_connections;	/* Connections busy outbound */
	ULONG	total_dialin_calls;		/* Busy inbound connects since power up */
	ULONG	total_dialout_calls;	/* Busy outbound connects since power up */
	USHORT	total_dialin_users;		/* Users currently awaiting inbound */
	/* Below statistic not computed */
	USHORT	current_utilization;	/* Percentage utilization of server */
} AG_STATISTICS;

typedef struct AG_CLASS {
	BYTE_ENUM (BOOLEAN)		enabled;
	BYTE_ENUM (BOOLEAN)		timer_enabled;
	DATE_TIME				boot_time;
	ULONG 					application_id;
	ULONG 					clock_ticks_per_second;
	enum NET_INTERFACE		network_interface_to_use;
	BYTE_ENUM (PORT_OWNER)	owned_by_module[MAX_WAN_PORTS];
	BYTE					server_name[SERVER_NAME_LENGTH];
	BYTE					version_string[VERSION_STRING_LENGTH];

	IPX_INTERFACE_CLASS		ipx_interface;
	IP_INTERFACE_CLASS		ip_interface;
	NB_INTERFACE_CLASS		nb_interface;
	BYTE_ENUM (BOOLEAN)		issue_listen;	/* Need to issue a listen? */

	ULONG					next_session_id_to_use;
	ULONG					max_sessions;	/* Configured */
	SESSION_TABLE_ENTRY		*sptr_listen_issued_session_entry;	/* Listen issued last on this session -- valid only in listen post routine */
	SESSION_TABLE_ENTRY_LINK session_entries_list;	/* Will doubly-link all session entries */

	USHORT					number_of_lines;
	LINE_INFO_ENTRY			line_info_array[MAX_WAN_PORTS];
	void 					(*fptr_rx_complete)(USHORT, BYTE *);
	void					(*fptr_msm_init_phase_callback[MAX_WAN_PORTS])(USHORT, BYTE *, USHORT);

	/* Inbound related stuff */
	BYTE_ENUM (BOOLEAN)		inbound_skip_ring;
	BYTE_ENUM (BOOLEAN)		show_connection_manager_menu;
	LINK 					lines_awaiting_inbound;

	AG_PRINT_CLASS			print_class;
	AG_STATISTICS			stats;

	BYTE_ENUM (BOOLEAN)		start_statistics_timer;
	ULONG					statistics_timer;		/* Used for throughput calculations */
} AG_CLASS;


extern AG_CLASS ag;

#endif /* _VAGSTR_H_ */
