#define GLOBAL_FILE

#include <stdio.h>
#include "dhcp.h"
#include "dhcps.h"

#if STATUS_DEBUG
enum BOOLEAN register_debugger (void (*fptr_debug_function)(), char *signature) ;
extern void dhcp_server_configuration (void) ;
extern void print_dhcp_database () ;
#endif
extern void dhcp_server_timer () ;
BYTE is_server_interface(USHORT port_number);
USHORT get_dhcp_server_protocol_port_number();


void initialize_dhcp_server (ULONG clock_ticks_per_second)
{
#if STATUS_DEBUG
	register_debugger (dhcp_server_configuration, "dhcpcon") ;
	register_debugger (print_dhcp_database, "dhcpdb") ;
#endif
   if (initialize_dhcp_server_socket_interface())
   {
      if (dhcp_server.enabled == TRUE)
      {
         add_server_id_option_to_default_option_list () ;
         initialize_dhcp_server_database () ;

         if (dhcp_server.db_update_period == 0)
            dhcp_server.db_update_period = DHCP_DATABASE_UPDATE_PERIOD ;
         dhcp_server.db_update_period *= clock_ticks_per_second ;

         dhcp_server.db_counter = dhcp_server.db_update_period ;
         dhcp_server.db_changed = FALSE ;
         dhcp_server.clock_ticks_per_second = clock_ticks_per_second ;
      }
   }
}

void dhcp_server_foreground ()
{
   ULONG source_ip_address ;
   int packet_length, source_port ;
   char source_ip_address_string[40] ;
   int dhcp_receive_return_value ;

/* Added by Naveen for Firewall 12/6/1998... */
   USHORT rx_port_number;
/* ...Added by Naveen for Firewall 12/6/1998 */

   dhcp_receive_return_value = dhcp_server_receive_data (&source_ip_address, &source_port, &dhcp_server.dhcp_receive_packet[0], &packet_length, &rx_port_number) ;
   if ((dhcp_receive_return_value != -1) && (packet_length))
   {
#if 0		/* Commented by sri */
      ulong_to_dot_format (&source_ip_address_string[0], net_to_host_long (source_ip_address)) ;
      printf ("\nDHCP : Packet of size %d received from %s\n", packet_length, source_ip_address_string) ;
#endif

      /* Now the packet will be given to either server or relay agent */
      if (is_server_interface(rx_port_number) && dhcp_server.enabled == TRUE)
      {
         /* Give the packet to Our Built in DHCP Server because packet is
            from Secured LAN */
         process_dhcp_packet (&dhcp_server.dhcp_receive_packet[0], packet_length, source_ip_address, source_port) ;
      }
      else
      {
         if (dhcp.is_relay_agent_port_up)
         {
            /* Relay the packet to WAN because packet is from Internet LAN */
            if (source_port == get_dhcp_server_protocol_port_number())
            {
               forward_reply_packets_to_dhcp_clients((char*)(&dhcp_server.dhcp_receive_packet[0]), rx_port_number);
            }
            else
            {
               regenarate_and_relay_dhcp_packet((char*)(&dhcp_server.dhcp_receive_packet[0]), rx_port_number);
            }
         }
      }
   }
   dhcp_server_timer () ;
   return ;
}

/* Added by Naveen for the Firewall Support... */
void update_dhcp_server_parameters(ULONG name_server_ip_address)
{
   USHORT range_index = 0;
   DHCP_OPTION_ENTRY *sptr_dhcp_option_entry ;

   for ( range_index = 0 ; range_index < dhcp_server.number_of_tags ; ++range_index)
   {
      for (sptr_dhcp_option_entry = dhcp_server.sptr_tag_list[range_index].sptr_option_list ;
           sptr_dhcp_option_entry ;
           sptr_dhcp_option_entry = sptr_dhcp_option_entry->sptr_next_option_entry)
      {
         if (sptr_dhcp_option_entry->option_type == DNS)
         {
            printf("DHCP SERVER: Updating DNS option for Range %d\n", range_index);
            memcpy (&sptr_dhcp_option_entry->option_data, &name_server_ip_address, sizeof(ULONG)) ;
         }
      }
   }
}

BYTE is_server_interface(USHORT port_number)
{
   return (port_number == 0);
}
/* ... Added by Naveen for the Firewall Support */



