#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include "dhcps.h"



STATIC BYTE temp_option_data[DHCP_MAXIMUM_PACKET_LENGTH] ;
STATIC int process_dhcp_discover_packet (BYTE *dhcp_receive_packet, int packet_length, ULONG source_ip_address, USHORT source_port, DHCP_OPTION_ENTRY *sptr_dhcp_option_list)
{
   DHCP_PACKET *sptr_dhcp_offer_packet, *dhcp_discover_packet = (DHCP_PACKET *)dhcp_receive_packet ;
   int length_of_all_options, dhcp_fixed_fields_length = (BYTE *)&dhcp_discover_packet->options_list[0] - (BYTE *)&dhcp_discover_packet->op_code ;
   DHCP_OPTION_ENTRY *sptr_dhcp_offer_options_list = (DHCP_OPTION_ENTRY *)NULL ;
   DHCP_OPTION_ENTRY *sptr_temp_option_entry ;
   ULONG relay_agent_address, allocated_ip_address, preferred_ip_address, server_id, lease_time ;
   BYTE_ENUM (DHCP_MESSAGE_TYPE) message_type = DHCPOFFER ;
   BYTE_ENUM (DHCP_OPTION_TYPE) dhcp_option ;
   int option, option_length ;
   BYTE ip_address_string[20], relay_agent_string[20] ;

   PARAMETER_NOT_USED (packet_length) ;
   PARAMETER_NOT_USED (source_ip_address) ;

   printf ("DHCP : DHCP Discover packet received\n") ;

   /* Get an IP address for this guy.
      Put that address in the yiaddr field.
   NOTE : The client CANNOT have a non-zero address in the 'client_ip_address' field
   in case of a DHCPDISCOVER packet, while it is permitted to do so in a
   DHCPREQUEST packet.
   */
   sptr_temp_option_entry = get_dhcp_option_entry (sptr_dhcp_option_list, REQUESTED_IP_ADDRESS) ;
   if (sptr_temp_option_entry)
      memcpy (&allocated_ip_address, &sptr_temp_option_entry->option_data, sptr_temp_option_entry->option_length) ;
   else
      allocated_ip_address = 0L ;

   allocated_ip_address = net_to_host_long (allocated_ip_address) ;

   relay_agent_address = dhcp_discover_packet->gateway_ip_address ;
   if (relay_agent_address == 0L)
      relay_agent_address = dhcp_server.dhcp_my_node_ip_address ;
   relay_agent_address = net_to_host_long (relay_agent_address) ;

   preferred_ip_address = allocated_ip_address ;
   allocated_ip_address = get_dhcp_ip_address (allocated_ip_address, relay_agent_address, &dhcp_discover_packet->client_hardware_address[0], dhcp_discover_packet->hardware_addr_len) ;
   if (allocated_ip_address == 0L)
   {
      printf ("DHCP SERVER : Cannot allocate an IP address with Prefered address : %s, Relay Agent : %s\n",
         ulong_to_dot_format (&ip_address_string[0], preferred_ip_address),
         ulong_to_dot_format (&relay_agent_string[0], relay_agent_address)) ;
      return (FAIL) ;
   }

   allocated_ip_address = host_to_net_long (allocated_ip_address) ;

   dhcp_discover_packet->your_ip_address = allocated_ip_address ;
   dhcp_discover_packet->server_ip_address = dhcp_server.dhcp_my_node_ip_address ;
   dhcp_discover_packet->op_code = DHCP_REPLY ;

   allocated_ip_address = net_to_host_long (allocated_ip_address) ;

   /* Start adding options to the sptr_dhcp_offer_options_list */

   /* Now add the other options */
   sptr_temp_option_entry = get_dhcp_option_entry (sptr_dhcp_option_list, PARAMETER_REQUEST_LIST) ;
   if (sptr_temp_option_entry)
   {
      for (option = 0 ; option < (int) sptr_temp_option_entry->option_length ; option++)
      {
         dhcp_option = sptr_temp_option_entry->option_data.byte_array[option] ;
         option_length = get_dhcp_option_length (allocated_ip_address, dhcp_option) ;
         if (option_length == -1)
         {
            continue ;
         }
         get_dhcp_option_value (allocated_ip_address, dhcp_option, &temp_option_data[0]) ;
         add_dhcp_option_to_list (&sptr_dhcp_offer_options_list, dhcp_option, (BYTE) option_length, &temp_option_data[0]) ;
      }
   }

   /* Adding IP_ADDRESS_LEASE_TIME */
   if (get_dhcp_option_value (allocated_ip_address, IP_ADDRESS_LEASE_TIME, (BYTE *)&lease_time) == FAIL)
   {
      while (1)
         printf ("DHCP : Fatal error, cannot determine lease time for an IP address Discover\n") ;
   }
   if (sptr_temp_option_entry)
   {
      /* Change this to make the comparison in NET BYTE ORDER */
      if (net_to_host_long(lease_time) > net_to_host_long(*((ULONG *)&sptr_temp_option_entry->option_data)))
         lease_time = *((ULONG *)&sptr_temp_option_entry->option_data) ;
   }
   add_dhcp_option_to_list (&sptr_dhcp_offer_options_list, IP_ADDRESS_LEASE_TIME, sizeof(lease_time), &lease_time) ;


   /* Adding SERVER_ID */
   server_id = dhcp_server.dhcp_my_node_ip_address ;
   add_dhcp_option_to_list (&sptr_dhcp_offer_options_list, SERVER_ID, sizeof(server_id), &server_id) ;


   /* Adding MESSAGE_TYPE */
   add_dhcp_option_to_list (&sptr_dhcp_offer_options_list, DHCP_MESSAGE_TYPE, sizeof(BYTE_ENUM(DHCP_MESSAGE_TYPE)), &message_type) ;
   sptr_temp_option_entry = get_dhcp_option_entry (sptr_dhcp_option_list, IP_ADDRESS_LEASE_TIME) ;


   /* Copy the fixed fields of dhcp_receive_packet to dhcp_send_packet.
   Add the options to dhcp_send_packet.
   Free up the sptr_dhcp_offer_options_list.
   Add this binding to the database and mark it as OFFERED.
   */

   memcpy (&dhcp_server.dhcp_send_packet[0], dhcp_receive_packet, dhcp_fixed_fields_length) ;
   length_of_all_options = get_length_of_options (sptr_dhcp_offer_options_list) ;
   length_of_all_options += sizeof (BYTE_ENUM (DHCP_OPTION_TYPE)) ; /* For the DHCP_END_OPTION */

   sptr_dhcp_offer_packet = (DHCP_PACKET *)&dhcp_server.dhcp_send_packet[0] ;
   swing_dhcp_options_into_packet (sptr_dhcp_offer_options_list, &sptr_dhcp_offer_packet->options_list[0]) ;
   add_entry_to_database (sptr_dhcp_offer_packet->client_hardware_address, sptr_dhcp_offer_packet->hardware_addr_len,
      (allocated_ip_address), OFFER_TIMEOUT, OFFERED) ;

#if DHCP_DEBUG
   printf ("\nDHCP : Sending DHCP Offer Packet (IP Address : %s)\n",
      ulong_to_dot_format (&ip_address_string[0], allocated_ip_address)) ;
   display_dhcp_options (sptr_dhcp_offer_options_list) ;
#endif
   free_dhcp_list (sptr_dhcp_offer_options_list) ;

   if (dhcp_server_send_data (dhcp_discover_packet->gateway_ip_address ? dhcp_discover_packet->gateway_ip_address : 0xFFFFFFFFL,
         dhcp_discover_packet->gateway_ip_address ? host_to_net_short (DHCP_SERVER_PORT) : source_port,
         (BYTE *)sptr_dhcp_offer_packet, (dhcp_fixed_fields_length+length_of_all_options)) == -1)
      return (FAIL) ;

   return (PASS) ;
}

STATIC int process_dhcp_request_packet (BYTE *dhcp_receive_packet, int packet_length, ULONG source_ip_address, USHORT source_port, DHCP_OPTION_ENTRY *sptr_dhcp_option_list)
{
   DHCP_PACKET *sptr_dhcp_ack_packet, *dhcp_request_packet = (DHCP_PACKET *)dhcp_receive_packet ;
   int length_of_all_options, dhcp_fixed_fields_length = (BYTE *)&dhcp_request_packet->options_list[0] - (BYTE *)&dhcp_request_packet->op_code ;
   DHCP_OPTION_ENTRY *sptr_dhcp_ack_options_list = (DHCP_OPTION_ENTRY *)NULL ;
   DHCP_OPTION_ENTRY *sptr_temp_option_entry ;
   ULONG relay_agent_address, allocated_ip_address, preferred_ip_address, server_id, lease_time ;
   BYTE_ENUM (DHCP_MESSAGE_TYPE) message_type = DHCPACK ;
   BYTE_ENUM (DHCP_OPTION_TYPE) dhcp_option ;
   int option, option_length ;
   BYTE ip_address_string[20], relay_agent_string[20] ;

   PARAMETER_NOT_USED (packet_length) ;
   PARAMETER_NOT_USED (source_ip_address) ;

   printf ("DHCP : DHCP Request packet received\n") ;


   /* Check if we need to process this packet */
   sptr_temp_option_entry = get_dhcp_option_entry (sptr_dhcp_option_list, SERVER_ID) ;
   if (sptr_temp_option_entry == NULL)
   {
      /* The second check is to make sure it is a response to Discover.
      If a client has already got an IP address, it does NOT need to include
      the server id the next time around */
      if (is_ip_address_offered (net_to_host_long (dhcp_request_packet->client_ip_address), &dhcp_request_packet->client_hardware_address[0], dhcp_request_packet->hardware_addr_len) == PASS)
      {
         printf ("DHCP : Client does not have a SERVER ID option, rejecting request\n") ;
         allocated_ip_address = get_ip_address_from_mac_address (&dhcp_request_packet->client_hardware_address[0], dhcp_request_packet->hardware_addr_len) ;
         if (allocated_ip_address)
            delete_entry_given_ip_address (allocated_ip_address) ;
         return (FAIL) ;
      }
   }
   else
   {
      if (is_ip_address_offered (net_to_host_long (dhcp_request_packet->client_ip_address), &dhcp_request_packet->client_hardware_address[0], dhcp_request_packet->hardware_addr_len) == PASS)
      {
         if (sptr_temp_option_entry->option_data._ulong != dhcp_server.dhcp_my_node_ip_address)
         {
            printf ("DHCP : Client shows interest in a different server, rejecting request\n") ;
            allocated_ip_address = get_ip_address_from_mac_address (&dhcp_request_packet->client_hardware_address[0], dhcp_request_packet->hardware_addr_len) ;
            if (allocated_ip_address)
               delete_entry_given_ip_address (allocated_ip_address) ;
            return (FAIL) ;
         }
      }
   }

   /* Get an IP address for this guy.
      Put that address in the yiaddr field.
   NOTE : The client CANNOT have a non-zero address in the 'client_ip_address' field
   in case of a DHCPDISCOVER packet, while it is permitted to do so in a
   DHCPREQUEST packet.
   */
   sptr_temp_option_entry = get_dhcp_option_entry (sptr_dhcp_option_list, REQUESTED_IP_ADDRESS) ;
   if (sptr_temp_option_entry)
      memcpy (&allocated_ip_address, &sptr_temp_option_entry->option_data, sptr_temp_option_entry->option_length) ;
   else
      allocated_ip_address = dhcp_request_packet->client_ip_address ;

   allocated_ip_address = net_to_host_long (allocated_ip_address) ;

   relay_agent_address = dhcp_request_packet->gateway_ip_address ;
   if (relay_agent_address == 0L)
      relay_agent_address = dhcp_server.dhcp_my_node_ip_address ;
   relay_agent_address = net_to_host_long (relay_agent_address) ;

   preferred_ip_address = allocated_ip_address ;
   allocated_ip_address = get_dhcp_ip_address (allocated_ip_address, relay_agent_address, &dhcp_request_packet->client_hardware_address[0], dhcp_request_packet->hardware_addr_len) ;
   if (allocated_ip_address == 0L)
   {
      printf ("DHCP SERVER : Cannot allocate an IP address with Prefered address : %s, Relay Agent : %s\n",
         ulong_to_dot_format (&ip_address_string[0], preferred_ip_address),
         ulong_to_dot_format (&relay_agent_string[0], relay_agent_address)) ;
      return (FAIL) ;
   }

   allocated_ip_address = host_to_net_long (allocated_ip_address) ;

   dhcp_request_packet->your_ip_address = allocated_ip_address ;
   dhcp_request_packet->server_ip_address = dhcp_server.dhcp_my_node_ip_address ;
   dhcp_request_packet->op_code = DHCP_REPLY ;

   allocated_ip_address = net_to_host_long (allocated_ip_address) ;

   /* Start adding options to the sptr_dhcp_ack_options_list */

   /* Now add the other options */
   sptr_temp_option_entry = get_dhcp_option_entry (sptr_dhcp_option_list, PARAMETER_REQUEST_LIST) ;
   if (sptr_temp_option_entry)
   {
      for (option = 0 ; option < (int) sptr_temp_option_entry->option_length ; option++)
      {
         dhcp_option = sptr_temp_option_entry->option_data.byte_array[option] ;
         option_length = get_dhcp_option_length (allocated_ip_address, dhcp_option) ;
         if (option_length == -1)
         {
            continue ;
         }
         get_dhcp_option_value (allocated_ip_address, dhcp_option, &temp_option_data[0]) ;
         add_dhcp_option_to_list (&sptr_dhcp_ack_options_list, dhcp_option, (BYTE) option_length, &temp_option_data[0]) ;
      }
   }

   /* Adding IP_ADDRESS_LEASE_TIME */
   if (get_dhcp_option_value (allocated_ip_address, IP_ADDRESS_LEASE_TIME, (BYTE *)&lease_time) == FAIL)
   {
      while (1)
         printf ("DHCP : Fatal error, cannot determine lease time for an IP address Request\n") ;
   }
   if (sptr_temp_option_entry)
   {
      /* Change this to make the comparison in NET BYTE ORDER */
      if (net_to_host_long(lease_time) > net_to_host_long(*((ULONG *)&sptr_temp_option_entry->option_data)))
         lease_time = *((ULONG *)&sptr_temp_option_entry->option_data) ;
   }
   add_dhcp_option_to_list (&sptr_dhcp_ack_options_list, IP_ADDRESS_LEASE_TIME, sizeof(lease_time), &lease_time) ;


   /* Adding SERVER_ID */
   server_id = dhcp_server.dhcp_my_node_ip_address ;
   add_dhcp_option_to_list (&sptr_dhcp_ack_options_list, SERVER_ID, sizeof(server_id), &server_id) ;


   /* Adding MESSAGE_TYPE */
   add_dhcp_option_to_list (&sptr_dhcp_ack_options_list, DHCP_MESSAGE_TYPE, sizeof(BYTE_ENUM(DHCP_MESSAGE_TYPE)), &message_type) ;
   sptr_temp_option_entry = get_dhcp_option_entry (sptr_dhcp_option_list, IP_ADDRESS_LEASE_TIME) ;


   /* Copy the fixed fields of dhcp_receive_packet to dhcp_send_packet.
   Add the options to dhcp_send_packet.
   Free up the sptr_dhcp_ack_options_list.
   Add this binding to the database and mark it as OFFERED.
   */

   memcpy (&dhcp_server.dhcp_send_packet[0], dhcp_receive_packet, dhcp_fixed_fields_length) ;
   length_of_all_options = get_length_of_options (sptr_dhcp_ack_options_list) ;
   length_of_all_options += sizeof (BYTE_ENUM (DHCP_OPTION_TYPE)) ; /* For the DHCP_END_OPTION */

   sptr_dhcp_ack_packet = (DHCP_PACKET *)&dhcp_server.dhcp_send_packet[0] ;
   swing_dhcp_options_into_packet (sptr_dhcp_ack_options_list, &sptr_dhcp_ack_packet->options_list[0]) ;
   add_entry_to_database (sptr_dhcp_ack_packet->client_hardware_address, sptr_dhcp_ack_packet->hardware_addr_len,
      (allocated_ip_address), net_to_host_long (lease_time), LEASED) ;

#if DHCP_DEBUG
   printf ("\nDHCP : Sending DHCP ACK Packet (IP Address : %s)\n",
      ulong_to_dot_format (&ip_address_string[0], allocated_ip_address)) ;
   display_dhcp_options (sptr_dhcp_ack_options_list) ;
#endif
   free_dhcp_list (sptr_dhcp_ack_options_list) ;

   if (dhcp_server_send_data (dhcp_request_packet->gateway_ip_address ? dhcp_request_packet->gateway_ip_address : 0xFFFFFFFFL,
         dhcp_request_packet->gateway_ip_address ? host_to_net_short (DHCP_SERVER_PORT) : source_port,
         (BYTE *)sptr_dhcp_ack_packet, (dhcp_fixed_fields_length+length_of_all_options)) == -1)
      return (FAIL) ;

   return (PASS) ;
}

STATIC int process_dhcp_decline_packet (BYTE *dhcp_receive_packet, int packet_length, ULONG source_ip_address, USHORT source_port, DHCP_OPTION_ENTRY *sptr_dhcp_option_list)
{
   printf ("DHCP : DHCP Decline packet received\n") ;

   PARAMETER_NOT_USED (dhcp_receive_packet) ;
   PARAMETER_NOT_USED (packet_length) ;
   PARAMETER_NOT_USED (source_ip_address) ;
   PARAMETER_NOT_USED (source_port) ;
   PARAMETER_NOT_USED (sptr_dhcp_option_list) ;

   return (PASS) ;
}

STATIC int process_dhcp_release_packet (BYTE *dhcp_receive_packet, int packet_length, ULONG source_ip_address, USHORT source_port, DHCP_OPTION_ENTRY *sptr_dhcp_option_list)
{
   printf ("DHCP : DHCP Release packet received\n") ;

   PARAMETER_NOT_USED (dhcp_receive_packet) ;
   PARAMETER_NOT_USED (packet_length) ;
   PARAMETER_NOT_USED (source_port) ;
   PARAMETER_NOT_USED (sptr_dhcp_option_list) ;

   paint_entry_dirty (net_to_host_long(source_ip_address)) ;

   return (PASS) ;
}


void process_dhcp_packet (BYTE *dhcp_receive_packet, int packet_length, ULONG source_ip_address, USHORT source_port)
{
   DHCP_OPTION_ENTRY *sptr_dhcp_option_list, *sptr_message_option_entry ;
   DHCP_MESSAGE_TYPE_OPTION *sptr_message_type_option ;

   sptr_dhcp_option_list = parse_dhcp_options (dhcp_receive_packet) ;
#if DHCP_DEBUG
   display_dhcp_options (sptr_dhcp_option_list) ;
#endif

   sptr_message_option_entry = get_dhcp_option_entry (sptr_dhcp_option_list, DHCP_MESSAGE_TYPE) ;

   if (sptr_message_option_entry)
   {
      sptr_message_type_option = (DHCP_MESSAGE_TYPE_OPTION *)&sptr_message_option_entry->option_type ;
      switch (sptr_message_type_option->message_type)
      {
         case (DHCPDISCOVER) :
            process_dhcp_discover_packet (dhcp_receive_packet, packet_length, source_ip_address, source_port, sptr_dhcp_option_list) ;
            break ;

         case (DHCPOFFER) :
            printf ("DHCP : Offer Message\n") ;
            break ;

         case (DHCPREQUEST) :
            process_dhcp_request_packet (dhcp_receive_packet, packet_length, source_ip_address, source_port, sptr_dhcp_option_list) ;
            break ;

         case (DHCPDECLINE) :
            process_dhcp_decline_packet (dhcp_receive_packet, packet_length, source_ip_address, source_port, sptr_dhcp_option_list) ;
            break ;

         case (DHCPACK) :
            printf ("DHCP : ACK Message\n") ;
            break ;

         case (DHCPNAK) :
            printf ("DHCP : NACK Message\n") ;
            break ;

         case (DHCPRELEASE) :
            process_dhcp_release_packet (dhcp_receive_packet, packet_length, source_ip_address, source_port, sptr_dhcp_option_list) ;
            break ;

         case (DHCPREQUEST_LEASE_RENEW	) :
            printf ("DHCP : Lease Renew Message\n") ;
            break ;

         case (DHCPREQUEST_LEASE_REBIND) :
            printf ("DHCP : Lease Rebind Message\n") ;
            break ;

         default :
            break ;
      }
   }
   free_dhcp_list (sptr_dhcp_option_list) ;
}

