/* -----------------------------------------------------------------------
Module: DHCP
Author: Kamalnath
Duration: July - October (1996)
 ----------------------------------------------------------------------- */
#include "dhcp.h"

/* -----------------------------------------------------------------------
	ROUTINE  : my_bytcmp(ptr_1, ptr_2)
	INPUT    : Pointers to strings to be compared
	SYNOPSIS : Compares 16 octet HArdware address
 -----------------------------------------------------------------------*/

BYTE my_bytcmp(char *ptr_1, char *ptr_2, BYTE port_num)
{
	BYTE count;

   count = 1;
   if ( port_num > (TOTAL_NUMBER_OF_PORTS - 1) ) return(0);
   while ( count < MAC_ADDR_LEN)
   {
   	if ( *ptr_1 != *ptr_2 )
      {
      	return(1);
      }
      else 
      {
      	ptr_1++; 
         ptr_2++;
         count++;
      }
	}
   return(0) ;
}

/* -----------------------------------------------------------------------
	ROUTINE  : scan_option_list_and_fill_values(ptr_1, resp_packet_type, port_number )
	INPUT    : ptr_1 points to the option_list in received packet,
              packet_type indicates the values to be filled
              if DHCPOFFER , fill just server_ip_address
              if DHCPACK   , fill server and client ip_address, subnetmask,
                        renewal_time and rebind_time values
	SYNOPSIS : Searches for the option_code in the given buffer and returns
              a pointer to the option_value
 ----------------------------------------------------------------------- */

void scan_option_list_and_fill_values(char *ptr_1, BYTE resp_packet_type, BYTE port_number)
{

	/* Skip four bytes for Magic Cookie   */
	ptr_1 = ptr_1 + 4;

	/* switch on the Packet_type reseived */
   switch ( resp_packet_type ) 
   {
   	case	DHCPOFFER:
      {
      	while (  *ptr_1 != 0xFF )	/* Scan until END opcode (0xFF) */
 			{
				if ( *ptr_1 == SERVER_IDENTIFIER_OPTION )
            {
            	ptr_1 = ptr_1 + 2;
               memcpy(&dhcp_client_addr_info[port_number].dhcp_server_ip_address,ptr_1,sizeof(ULONG));
               return ;
            } 
            else 
            {
            	if ( *(ptr_1 + 1) == 0 ) 
               	ptr_1 = ptr_1 + 2;
               else
                  ptr_1 = ptr_1 + *(ptr_1 + 1 ) + 2;     

            }
         }
        	break;
		}

		case DHCPACK:
      {
      	while (  *ptr_1 != 0xFF )	    /* Scan through the list until we */
         {				   					/* get an opcode of END (0xFF)    */
/* Added by Ravi for General Parsing for Option Values Based on the length */
 
				BYTE	option_type;
				BYTE	option_length;

				option_type = *ptr_1;		/* store option type */
				option_length = *(ptr_1 + 1);		/* store option length */
           	ptr_1 = ptr_1 + 2;			/* point to option value */

         	switch ( option_type )
 				{
/* Naveen Added the following for Firewall Support 5/6/1998 ... */
               case DEFAULT_GATEWAY_OPTION:
                	memcpy(&dhcp_client_addr_info[port_number].gateway_ip_address,ptr_1,sizeof(ULONG));
                	break;
               case DNS_SERVER_ADDRESS_OPTION:   
                	memcpy(&dhcp_client_addr_info[port_number].name_server_ip_address,ptr_1,sizeof(ULONG));
                  break;
/* ... Naveen Added the following for Firewall Support 5/6/1998 */

					case SUBNET_MASK_OPTION:
                	memcpy(&dhcp_client_addr_info[port_number].subnet_mask,ptr_1,sizeof(ULONG));
                	break;

				  	case RENEWAL_TIME_OPTION:
                	memcpy(&dhcp_client_addr_info[port_number].lease_renew_time_in_ticks,ptr_1,sizeof(ULONG));
      			 	dhcp_client_addr_info[port_number].lease_renew_time_in_ticks = 
                          swap_long(dhcp_client_addr_info[port_number].lease_renew_time_in_ticks);
					 	break;

				  	case REBIND_TIME_OPTION:
                	memcpy(&dhcp_client_addr_info[port_number].lease_rebind_time_in_ticks,ptr_1,sizeof(ULONG));
        			 	dhcp_client_addr_info[port_number].lease_rebind_time_in_ticks = 
                        swap_long(dhcp_client_addr_info[port_number].lease_rebind_time_in_ticks);
					 	break;

				   case IP_ADDRESS_LEASE_TIME_OPTION:
                	memcpy(&dhcp_client_addr_info[port_number].lease_duration_in_ticks,ptr_1,sizeof(ULONG));
      			 	dhcp_client_addr_info[port_number].lease_duration_in_ticks = 
                          swap_long(dhcp_client_addr_info[port_number].lease_duration_in_ticks);
					 	break;

				  	case SERVER_IDENTIFIER_OPTION:
                	memcpy(&dhcp_client_addr_info[port_number].dhcp_server_ip_address,ptr_1,sizeof(ULONG));
                	break;

				}
            ptr_1 = ptr_1 + option_length;
         }
        	break;
      }

		default: break;
     
   }
}

ULONG get_default_gateway_from_dhcp(USHORT port_number)
{
   return (dhcp_client_addr_info[port_number].gateway_ip_address);
}

ULONG get_subnet_mask_from_dhcp(USHORT port_number)
{
   return (dhcp_client_addr_info[port_number].subnet_mask);
}

USHORT get_dhcp_server_protocol_port_number()
{
   return DHCP_SERVER_PORT;
}

USHORT get_dhcp_client_protocol_port_number()
{
   return DHCP_CLIENT_PORT;
}

