#ifndef _VDHCPSSTR_H_

#define _VDHCPSSTR_H_
 
typedef struct DHCP_PACKET
{
    BYTE_ENUM (DHCP_OPCODE_TYPE)  op_code; 
    BYTE_ENUM (HARDWARE_TYPE)     hardware_type;
	 BYTE_ENUM (ADDRESS_LENGTH)    hardware_addr_len;
	 BYTE									 number_of_hops;
	 ULONG								 transaction_id;
	 USHORT								 seconds;
	 USHORT								 flags_field;
	 ULONG								 client_ip_address;
	 ULONG								 your_ip_address;
	 ULONG								 server_ip_address;
	 ULONG								 gateway_ip_address;
	 BYTE									 client_hardware_address[MAC_ADDR_LEN];
	 BYTE									 server_host_name[SERVER_HOST_NAME_LENGTH];
	 BYTE									 boot_file_name[BOOT_FILE_NAME_LENGTH];
	 ULONG								 magic_cookie ;
	 BYTE									 options_list[MINIMUM_OPTIONS_LIST_LENGTH];
} DHCP_PACKET;

typedef union DHCP_UNION_OPTION_DATA_TYPES
{
	BYTE_ENUM (BOOLEAN)	boolean;
	BYTE						byte_array[1];
	ULONG						_ulong;
	USHORT					_ushort;
	BYTE						_byte;
} DHCP_UNION_OPTION_DATA_TYPES;

struct dhcp_option_entry
{
   struct dhcp_option_entry *sptr_next_option_entry ;
   BYTE_ENUM (DHCP_OPTION_TYPE) option_type ;
   BYTE option_length ;
   DHCP_UNION_OPTION_DATA_TYPES option_data ;
} ;
typedef struct dhcp_option_entry DHCP_OPTION_ENTRY ;

typedef struct DHCP_OPTION
{
   BYTE_ENUM (DHCP_OPTION_TYPE) option_type ;
   BYTE option_length ;
   DHCP_UNION_OPTION_DATA_TYPES option_data ;
} DHCP_OPTION ;


typedef struct DHCP_MESSAGE_TYPE_OPTION
{
   BYTE_ENUM (DHCP_OPTION_TYPE) message_type_option ;
   BYTE option_length ;
   BYTE_ENUM (DHCP_MESSAGE_TYPE) message_type ;
} DHCP_MESSAGE_TYPE_OPTION ;


typedef struct
{
   BYTE_ENUM (DHCP_OPTION_TYPE) option ;
   BYTE length ;
   BYTE *value ;
} DHCP_OPTION_VALUE ;

typedef struct
{
   ULONG lower_ip_address ;
   ULONG higher_ip_address ;
   ULONG subnet_mask ;
} IP_ADDRESS_RANGE ;


struct dhcp_exclusion_entry
{
   struct dhcp_exclusion_entry *sptr_next_entry ;
   ULONG lower_ip_address ;
   ULONG higher_ip_address ;
} ;
typedef struct dhcp_exclusion_entry DHCP_EXCLUSION_ENTRY ;


struct dhcp_static_binding_entry
{
   struct dhcp_static_binding_entry *sptr_next_entry ;
   ULONG ip_address ;
   BYTE mac_address_length ;
   BYTE mac_address[1] ;
} ;
typedef struct dhcp_static_binding_entry DHCP_STATIC_BINDING_ENTRY ;


typedef struct
{
   ULONG lower_ip_address ;
   ULONG higher_ip_address ;
   ULONG subnet_mask ;
   DHCP_OPTION_ENTRY *sptr_option_list ;
   DHCP_EXCLUSION_ENTRY *sptr_exclusion_list ;
   DHCP_STATIC_BINDING_ENTRY *sptr_binding_list ;
} DHCP_TAG_DEFINITION ;


struct dhcp_database
{
   struct dhcp_database *sptr_next_entry ;   
   enum DHCP_DATABASE_ENTRY_STATE state ;
   BYTE client_hardware_address[MAC_ADDR_LEN] ;
   BYTE hardware_address_length ;
   ULONG allocated_ip_address ;
   ULONG lease_timer ;
} ;
typedef struct dhcp_database DHCP_DATABASE_ENTRY ;


typedef struct
{
/*   enum BOOLEAN enabled ; Commented by Naveen on 15/6/1998 
                            because this decleration does not go with
                            VNVdhcp file*/

	BYTE_ENUM (BOOLEAN)				enabled;
   ULONG dhcp_my_node_ip_address ;

   ULONG number_of_tags ;
   DHCP_TAG_DEFINITION *sptr_tag_list ;
   
   DHCP_DATABASE_ENTRY *sptr_dhcp_database ;
   ULONG number_of_nodes ;

   BYTE dhcp_receive_packet[DHCP_MAXIMUM_PACKET_LENGTH+100] ;
   BYTE dhcp_send_packet[DHCP_MAXIMUM_PACKET_LENGTH+100] ;
   int dhcp_socket ;

   ULONG max_database_entries ;
   ULONG number_of_database_entries ;
   ULONG database_length ;

   ULONG clock_ticks_per_second ;
   ULONG clock_ticks_to_be_passed ;

   ULONG db_update_period ;
   ULONG db_counter ;
   ULONG db_changed ;

   enum BOOLEAN dhcp_server_printing ;
} DHCP_SERVER_CLASS ;


extern void dhcp_server_foreground (void) ;
extern int initialize_dhcp_server_socket_interface (void) ;

extern int dhcp_server_receive_data (ULONG *source_ip_address, int *source_port, BYTE *packet, int *packet_length, USHORT *rx_port_number) ;
extern int dhcp_server_send_data (ULONG destination_ip_address, int destination_port, BYTE *info, ULONG length) ;
extern char *ulong_to_dot_format (char *cptr_array, ULONG ip_address) ;

extern DHCP_OPTION_ENTRY *parse_dhcp_options (void *vptr_dhcp_packet) ;
extern void swing_dhcp_options_into_packet (DHCP_OPTION_ENTRY *sptr_dhcp_option_entry_list, BYTE *bptr_dhcp_options) ;
extern void display_dhcp_options (DHCP_OPTION_ENTRY *sptr_dhcp_option_list) ;
extern int get_dhcp_option_length (ULONG client_ip_address, BYTE_ENUM (DHCP_OPTION_TYPE) option_type) ;
extern int get_dhcp_option_value (ULONG client_ip_address, BYTE_ENUM (DHCP_OPTION_TYPE) option_type, BYTE *option_value) ;
extern DHCP_OPTION_ENTRY *add_dhcp_option_entry_to_list (DHCP_OPTION_ENTRY *sptr_dhcp_option_entry_link, DHCP_OPTION_ENTRY *sptr_dhcp_new_option) ;
extern int delete_option_entry_from_list (DHCP_OPTION_ENTRY **sptr_dhcp_option_entry_list, BYTE_ENUM (DHCP_OPTION_TYPE) option) ;
extern int add_dhcp_option_to_list (DHCP_OPTION_ENTRY **sptr_dhcp_option_entry_list, BYTE_ENUM (DHCP_OPTION_TYPE) option, BYTE length, void *value) ;
extern DHCP_OPTION_ENTRY *get_dhcp_option_entry (DHCP_OPTION_ENTRY *sptr_dhcp_option_entry_list, BYTE_ENUM (DHCP_OPTION_TYPE) option_type) ;
extern int get_length_of_options (DHCP_OPTION_ENTRY *sptr_dhcp_option_entry_list) ;
extern void free_dhcp_list (DHCP_OPTION_ENTRY *sptr_dhcp_option_list) ;
extern DHCP_OPTION_ENTRY *get_dhcp_option_entry (DHCP_OPTION_ENTRY *sptr_dhcp_option_entry_list, BYTE_ENUM (DHCP_OPTION_TYPE) option_type) ;
extern void add_server_id_option_to_default_option_list () ;
extern int does_mac_or_ip_address_belong_to_any_static_binding_list (ULONG ip_address, char mac_address[], BYTE mac_address_length) ;
extern int is_ip_address_bound (ULONG ip_address) ;
extern int is_mac_address_bound (char chaddr[], BYTE hlen) ;


extern void process_dhcp_packet (BYTE *dhcp_receive_packet, int packet_length, ULONG source_ip_address, USHORT source_port) ;



extern int add_entry_to_database (BYTE chaddr[], BYTE hlen, ULONG ip_address, ULONG lease_period, enum DHCP_DATABASE_ENTRY_STATE state) ;
extern int is_ip_address_free (ULONG ip_address) ;
extern void delete_entry_given_ip_address (ULONG ip_address) ;
extern ULONG get_first_dirty_ip_address () ;
extern ULONG get_ip_address_from_mac_address (BYTE *mac_address, BYTE mac_address_length) ;
extern void paint_entry_dirty (ULONG ip_address) ;
extern int is_ip_address_offered (ULONG ip_address, BYTE chaddr[], BYTE hlen) ;
extern void initialize_dhcp_server_database () ;


#endif
