/*--------------------------------------------------------------------------*\

**	Description	: Virtual Server LoopBack Problem - Extern declarations file
**	Author		: Sudha
**	Start Date	: 15-Feb-2000	
**	File Name	: gserlpbk.h
**	Warning		: 
**	Notes			: This file includes all the necessary extern declarations needed
					: for vserlpbk.c file
**	References	:
**	Rev History : 	
		
\*--------------------------------------------------------------------------*/

/* Extern Variable Declarations */

extern PROXY_SERVER_CLASS proxy_server;
extern BYTE *sptr_virtual_server_loopback_mapped_port_status;
extern PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_virtual_server_loopback_client_descriptor_tree ;
extern PROXY_SERVER_DESCRIPTOR_NODE far *sptr_virtual_server_loopback_server_descriptor_tree ;

extern USHORT virtual_server_loopback_dynamic_port_number;
extern USHORT virtual_server_loopback_reserved_port_number_value;
extern USHORT virtual_server_loopback_new_icmp_packet_id;

/* Extern Function Declarations */

/* TCP protocol related functions */

extern USHORT get_tcp_port_number_from_ip_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, USHORT *destination_port);
extern USHORT set_tcp_src_port_number (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, USHORT new_port);
extern void set_tcp_dest_port_number (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, USHORT new_port);
extern enum BOOLEAN is_close_connection_initiated (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern UNION_IP_PACKET *update_tcp_checksum_in_packet (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern BYTE *get_ptr_to_tcp_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern void modify_tcp_acknowledge_field (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters,int offset);
extern void modify_tcp_seq_number_field	(BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters,int offset);
extern BYTE *check_for_ftp_port_command_and_process (BYTE *uptr_ip_rx_packet, enum BOOLEAN *return_value, IP_PARAMETERS *sptr_ip_parameters, PROXY_SERVER_INFO *sptr_control_connection);
extern USHORT get_application_port_number (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, 
		USHORT *destination_port, enum IP_PROTOCOL_VALUE *protocol_type);
extern USHORT get_port_command_length (BYTE *ptr_to_start_of_port_command);
extern void get_ftp_src_port_and_address (BYTE *ptr_to_tcp_pkt, USHORT *source_port, ULONG *source_address);
extern void set_source_port_number (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, 
		USHORT mapped_port, enum IP_PROTOCOL_VALUE protocol_type);
extern BYTE *form_new_port_command (BYTE *tcp_data, PROXY_SERVER_INFO *proxy_server_info);
extern BOOL road_runner_rlogin_replace_source_address_if_in_data(
	ULONG client_ip_address, ULONG outgoing_port_address, BYTE *ptr_to_data);
extern void set_destination_port_number (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, 
		USHORT mapped_port, enum IP_PROTOCOL_VALUE protocol_type);

/* UDP protocol related functions */

extern USHORT get_udp_port_number_from_ip_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, USHORT *destination_port);
extern void set_udp_src_port_number (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, USHORT new_port);
extern void set_udp_dest_port_number (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, USHORT new_port);
extern UNION_IP_PACKET *update_udp_checksum_in_packet (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern BYTE *get_ptr_to_udp_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);

/* ICMP protocol related functions */

extern USHORT get_icmp_echo_request_id (UNION_IP_PACKET *ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern BYTE *get_ptr_to_icmp_header (UNION_IP_PACKET *ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern enum BOOLEAN is_icmp_echo_request_message (UNION_IP_PACKET *ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern void set_icmp_checksum (BYTE *ptr_to_icmp_header, USHORT new_csum);

/* IP Stack related functions */

extern USHORT get_insecured_lan_port_number();
extern USHORT get_wan_port_number();
extern USHORT get_the_internet_gateway_port_number();
extern USHORT get_the_internet_gateway_address();
extern enum TEST determine_next_hop_ip_address_and_outgoing_port (IP_PARAMETERS *sptr_ip_parameters, ULONG *ulptr_next_hop_ip_address,
	USHORT *usptr_outgoing_port_number, IP_PORT_CLASS **ptr_to_sptr_outgoing_port, IP_ROUTE_CACHE_ENTRY *sptr_route_cache,
	ULONG destination_address, USHORT tx_port_number, ULONG type_of_service,
	IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters, enum PROXY_PACKET_TYPE is_this_a_proxy_response, USHORT rx_port_number);

/* RB Tree related functions */

extern PROXY_CLIENT_DESCRIPTOR_NODE far *proxy_rb_client_descriptor_search(PROXY_CLIENT_DESCRIPTOR_NODE far *Tree, PROXY_RB_CLIENT_KEY_TYPE key);
extern PROXY_SERVER_DESCRIPTOR_NODE far *proxy_rb_server_descriptor_search(PROXY_SERVER_DESCRIPTOR_NODE far *Tree, PROXY_RB_SERVER_KEY_TYPE key);
/* For pasv FTP support */
extern void proxy_rb_pasv_ftp_ctrl_client_descriptor_search(PROXY_CLIENT_DESCRIPTOR_NODE far *Tree, PROXY_SERVER_INFO *ptr_proxy_info);

extern void add_entry_to_virtual_server_loopback_client_descriptor_tree (BYTE *proxy_client_descriptor, unsigned char *vptr_buffer);
extern void add_entry_to_virtual_server_loopback_server_descriptor_tree (BYTE *proxy_server_descriptor, unsigned char *vptr_buffer);

/* General Functions */

extern USHORT get_a_free_virtual_server_loopback_port (USHORT application_port, 
	USHORT source_port);

extern enum BOOLEAN check_if_the_packet_is_for_our_NAT_address (BYTE *uptr_ip_rx_packet, 
		IP_PARAMETERS *sptr_ip_parameters,ULONG *local_destination_ip_address, 
		enum BOOLEAN *is_my_packet);

/* --- EOF of gserlpbk.h file --- */
