/*--------------------------------------------------------------------------*\

modifi	:	Vidy added code to support best effort allocation of same source
		port. 01/09/98

Changes History : 

{sudha 25-Jan-2000. process_proxy_response_packet() function - Trace Route 
	support. } 
{Ravi 27-Jan-2000. NAT minor fix - Checking for NAT request packet only
	if rcvd port number is other than secured LAN port number}
{sudha 02-Feb-2000. proxy pasv FTP, NAT active & pasv FTP support}
{sudha 05-Feb-2000. NAT minor fix - Checking for non-zero mapped local IP 
	address, if NAT request packet matches with any NAT dynamic mapping}
{sudha 07-Feb-2000. Virtual Server Loopback support}
{sudha 15-Feb-2000. NAT minor fix - If NAT request	to our interface address 
	with no NAT mapping & protocol is TCP, only for	telnet & web request, form
	a descriptor & not otherwise. check_if_the_packet_is_for_our_NAT_address()}
		
\*--------------------------------------------------------------------------*/

#include <defs.h>

#include <stdio.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdlib.h>
#include <kstart.h>

#include <string.h>
#include <memory.h>
#include "proxy.h"
/* Added by Sreelu for PPTP */
#include <redblack.h>
#include "vpptpstr.h"
#include "proxyrb.h"
/* Added by Sreelu for PPTP */

/* sudha 07-Feb-2000 */
#include "lpbkip.h"  

#include "..\..\applicat\userdata\kuser.h"
#include "..\..\applicat\userdata\vuserstr.h"


#define PROXY_DEBUG 1

/*extern PROXY_DYNAMIC_APP_LIST *proxy_server_dynamic_application_list;*/

/* Added by Sri for debug */
extern char *convert_ip_address_to_dot_format (char *, ULONG) ;
/* Added by Sri for debug */

extern void display_proxy_client_descriptors ();
extern PROXY_SERVER_CLASS proxy_server;
extern PROXY_SERVER_INFO *get_free_proxy_server_info_ptr (USHORT application_port, UNION_IP_PACKET *, IP_PARAMETERS *, USHORT, USHORT, enum BOOLEAN *, enum BOOLEAN, IP_ROUTE_ENTRY *sptr_static_route_entry);
extern USHORT get_tcp_port_number_from_ip_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, USHORT *destination_port);
extern USHORT set_tcp_src_port_number (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, USHORT new_port);
extern void set_tcp_dest_port_number (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, USHORT new_port);
extern enum BOOLEAN is_close_connection_initiated (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern USHORT get_udp_port_number_from_ip_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, USHORT *destination_port);
extern void set_udp_src_port_number (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, USHORT new_port);
extern void set_udp_dest_port_number (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, USHORT new_port);
extern UNION_IP_PACKET *update_tcp_checksum_in_packet (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern UNION_IP_PACKET *update_udp_checksum_in_packet (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern enum BOOLEAN is_enough_buffer_is_free (USHORT port_number);
extern enum BOOLEAN is_ipport_up (USHORT port_number);
extern BYTE *get_ptr_to_tcp_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern BYTE *get_ptr_to_udp_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern void modify_tcp_acknowledge_field (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters,int offset);
extern void modify_tcp_seq_number_field	(BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters,int offset);

extern USHORT get_icmp_echo_request_id (UNION_IP_PACKET *ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern BYTE *get_ptr_to_icmp_header (UNION_IP_PACKET *ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern enum BOOLEAN is_icmp_echo_request_message (UNION_IP_PACKET *ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern void set_icmp_checksum (BYTE *ptr_to_icmp_header, USHORT new_csum);

/* Added by Sreelu for PPTP */
extern void check_for_pptp_client_packet_and_process (BYTE *uptr_ip_rx_packet , IP_PARAMETERS *sptr_ip_parameters,
		USHORT tx_port_number);
extern void process_client_gre_packet_if_required (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters,
		PPTP_INFO_DESCRIPTOR *ptr_to_pptp_info);
extern void check_for_pptp_server_packet_and_process (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern void process_server_gre_packet_if_required (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters,
			PPTP_INFO_DESCRIPTOR *ptr_to_pptp_info);
extern PPTP_INFO_DESCRIPTOR *get_ptr_to_pptp_info_from_gre_packet (BYTE *, IP_PARAMETERS *);
extern PPTP_INFO_DESCRIPTOR *get_ptr_to_pptp_info_from_gre_response_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
/* Added by Sreelu for PPTP */

extern void get_dns_response_packet(UNION_IP_PACKET *sptr_ip_packet, IP_PARAMETERS *sptr_ip_parameters, BYTE *dns_resp_pkt, 
	USHORT length, void (*fptr_tx_completion) (USHORT port_number, void *vptr_tx_packet));
extern BYTE *get_domain_name_from_dns_query_packet (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern BYTE *get_dns_response_from_local_cache_if_any ( BYTE *domain_name, USHORT *data_len, USHORT dns_id);
extern USHORT get_quest_count_from_dns_query_pkt(UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters) ;
extern USHORT get_send_id_from_dns_query_pkt(UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern enum BOOLEAN is_dns_query_pkt_destined_to_lan_of_proxy_as_dns_server(UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters) ;

extern USHORT get_insecured_lan_port_number();
extern USHORT get_wan_port_number();
extern enum TEST determine_next_hop_ip_address_and_outgoing_port (IP_PARAMETERS *sptr_ip_parameters, ULONG *ulptr_next_hop_ip_address,
	USHORT *usptr_outgoing_port_number, IP_PORT_CLASS **ptr_to_sptr_outgoing_port, IP_ROUTE_CACHE_ENTRY *sptr_route_cache,
	ULONG destination_address, USHORT tx_port_number, ULONG type_of_service,
	IP_UPPER_LAYER_PARAMETERS *sptr_ip_upper_layer_parameters, enum PROXY_PACKET_TYPE is_this_a_proxy_response, USHORT rx_port_number);

extern USHORT get_the_internet_gateway_port_number();
extern USHORT get_the_internet_gateway_address();

USHORT dynamic_port_number=DYNAMIC_PORT_NUMBER;
USHORT reserved_port_number_value= STARTING_RESERVED_PORT;
USHORT new_icmp_packet_id=5;
extern BYTE *sptr_proxy_mapped_port_status;

/* sudha 07-Feb-2000 ... */
#ifdef __VIRTUAL_SERVER_LOOPBACK__
extern BYTE *sptr_virtual_server_loopback_mapped_port_status;
USHORT virtual_server_loopback_dynamic_port_number=DYNAMIC_PORT_NUMBER;
USHORT virtual_server_loopback_reserved_port_number_value= STARTING_RESERVED_PORT;
USHORT virtual_server_loopback_new_icmp_packet_id=5;
#endif /* __VIRTUAL_SERVER_LOOPBACK__ */
/* ... sudha 07-Feb-2000 */

extern PROXY_APPLICATION_LIST_NODE far *proxy_rb_demo_search(PROXY_APPLICATION_LIST_NODE far *Tree, PROXY_RB_KEY_TYPE key);
extern PROXY_CLIENT_DESCRIPTOR_NODE far *proxy_rb_client_descriptor_search(PROXY_CLIENT_DESCRIPTOR_NODE far *Tree, PROXY_RB_CLIENT_KEY_TYPE key);
extern PROXY_SERVER_DESCRIPTOR_NODE far *proxy_rb_server_descriptor_search(PROXY_SERVER_DESCRIPTOR_NODE far *Tree, PROXY_RB_SERVER_KEY_TYPE key);

extern void add_entry_to_proxy_client_descriptor_tree (BYTE *proxy_client_descriptor, unsigned char *vptr_buffer);
extern void add_entry_to_proxy_server_descriptor_tree (BYTE *proxy_server_descriptor, unsigned char *vptr_buffer);

extern PROXY_APPLICATION_LIST_NODE far *sptr_proxy_address_tree ;
extern PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_proxy_client_descriptor_tree ;
extern PROXY_SERVER_DESCRIPTOR_NODE far *sptr_proxy_server_descriptor_tree ;

extern BYTE *check_for_ftp_port_command_and_process (BYTE *uptr_ip_rx_packet, enum BOOLEAN *return_value, IP_PARAMETERS *sptr_ip_parameters, PROXY_SERVER_INFO *sptr_control_connection);

enum BOOLEAN is_new_port_already_in_use (USHORT application_port)
{
	USHORT offset=0 , bit_position=0;
	BYTE *ptr_to_bit_status, port_status;
	BYTE exp_bit_mask[] = {1,2,4,8,16,32,64,128};
	
	offset = application_port / 8;
	bit_position = application_port % 8;
	
	if (sptr_proxy_mapped_port_status != NULL)
   {
		ptr_to_bit_status = (BYTE *) ((ULONG )sptr_proxy_mapped_port_status +  (ULONG) offset);
		port_status = 	*ptr_to_bit_status & exp_bit_mask[bit_position];
		if (port_status)
			return TRUE;
	}
	return FALSE;
}				

void set_port_status_to_not_in_use (USHORT application_port)
{
	USHORT offset=0 , bit_position=0;
	BYTE *ptr_to_bit_status;
	BYTE exp_bit_mask[] = {254, 253, 251, 247, 239, 223, 191, 127};
	

	offset = application_port / 8;
	bit_position = application_port % 8;
			
	if (sptr_proxy_mapped_port_status != NULL)
   {
		ptr_to_bit_status = (BYTE *) ((ULONG )sptr_proxy_mapped_port_status +  (ULONG) offset);
		*ptr_to_bit_status &= exp_bit_mask[bit_position];
	}
	
	return;
}

void set_port_status_to_in_use (USHORT application_port)
{
	USHORT offset=0 , bit_position=0;
	BYTE *ptr_to_bit_status;
	BYTE exp_bit_mask[] = {1,2,4,8,16,32,64,128};


	offset = application_port / 8;
	bit_position = application_port % 8;

	if (sptr_proxy_mapped_port_status != NULL)
   {
		ptr_to_bit_status = (BYTE *) ((ULONG )sptr_proxy_mapped_port_status +  (ULONG) offset);
		*ptr_to_bit_status |= exp_bit_mask[bit_position];
	}
	return;		
}

USHORT get_a_free_port (USHORT application_port, USHORT source_port)
{

/* Modified for rlogin */

	switch (application_port)
	{
		case RLOGIN_PORT:
			while (1)
			{
				reserved_port_number_value++;
				if (reserved_port_number_value == 1023)
					reserved_port_number_value = STARTING_RESERVED_PORT;
				if (is_new_port_already_in_use (reserved_port_number_value) == FALSE)
				{
					set_port_status_to_in_use (reserved_port_number_value);
					break;
				}
			}
			return reserved_port_number_value;					
							
		default:

/* Vidy 28/08/98, to take care of best effort allocation of the same port.
Some applications try to look at the incoming source port to
decide somethings (which is non-IP?) like VOIP, cable modem login etc */

			if (source_port)
			{
				if (is_new_port_already_in_use (source_port) == FALSE)
				{
					set_port_status_to_in_use (source_port);
					return source_port;
				}
			}

			while (1)
			{
				dynamic_port_number++;
				if (dynamic_port_number == 0)
					dynamic_port_number = DYNAMIC_PORT_NUMBER;
				if (is_new_port_already_in_use (dynamic_port_number) == FALSE)
				{
					set_port_status_to_in_use (dynamic_port_number);
					break;
				}
			}	
			return dynamic_port_number;
	}
}

/* sudha 07-Feb-2000 ... */
#ifdef __VIRTUAL_SERVER_LOOPBACK__ 

/*--------------------------------------------------------------------------*\

**	Function Name	: is_new_virtual_server_loopback_port_already_in_use()
**	Description 	: Checking whether the source port sent by the loopback
						: client is unique or it is already in use by some other 
						: loopback client.
**	Parameters		: 1. source port
**	Return Value	: TRUE or FALSE
**	Notes				:

\*--------------------------------------------------------------------------*/

enum BOOLEAN is_new_virtual_server_loopback_port_already_in_use (USHORT application_port)
{
	USHORT offset=0 , bit_position=0;
	BYTE *ptr_to_bit_status, port_status;
	BYTE exp_bit_mask[] = {1,2,4,8,16,32,64,128};
	
	offset = application_port / 8;
	bit_position = application_port % 8;
	
	if (sptr_virtual_server_loopback_mapped_port_status != NULL)
   {
		ptr_to_bit_status = (BYTE *) ((ULONG )sptr_virtual_server_loopback_mapped_port_status + (ULONG) offset);
		port_status = 	*ptr_to_bit_status & exp_bit_mask[bit_position];
		if (port_status)
		{
			return TRUE;
		}
		else
		{
			return FALSE;
		}
	}
	else
	{
		return FALSE;
	}
	return FALSE;
}				

/*--------------------------------------------------------------------------*\

**	Function Name	: set_virtual_server_loopback_port_status_to_not_in_use()
**	Description 	: setting a specific port number status that it is not used
						: by any client. This port number can then be available for
						: some other client to use.This will be done when the 
						: descriptor is deleted for that client due to no processing.							
**	Parameters		: 1. source port
**	Return Value	: void
**	Notes				:

\*--------------------------------------------------------------------------*/

void set_virtual_server_loopback_port_status_to_not_in_use (USHORT application_port)
{
	USHORT offset=0 , bit_position=0;
	BYTE *ptr_to_bit_status;
	BYTE exp_bit_mask[] = {254, 253, 251, 247, 239, 223, 191, 127};
	

	offset = application_port / 8;
	bit_position = application_port % 8;
			
	if (sptr_virtual_server_loopback_mapped_port_status != NULL)
   {
		ptr_to_bit_status = (BYTE *) ((ULONG )sptr_virtual_server_loopback_mapped_port_status +  (ULONG) offset);
		*ptr_to_bit_status &= exp_bit_mask[bit_position];
	}
	else
	{
		return;
	}

	return;
}

/*--------------------------------------------------------------------------*\

**	Function Name	: set_virtual_server_loopback_port_status_to_in_use()
**	Description 	: setting a specific port number status that it is used
						: by some client. This port number then won't be available 
						: for some other client to use.This will be done when the 
						: descriptor is created for that client.
**	Parameters		: 1. source port
**	Return Value	: void
**	Notes				:

\*--------------------------------------------------------------------------*/

void set_virtual_server_loopback_port_status_to_in_use (USHORT application_port)
{
	USHORT offset=0 , bit_position=0;
	BYTE *ptr_to_bit_status;
	BYTE exp_bit_mask[] = {1,2,4,8,16,32,64,128};


	offset = application_port / 8;
	bit_position = application_port % 8;

	if (sptr_virtual_server_loopback_mapped_port_status != NULL)
   {
		ptr_to_bit_status = (BYTE *) ((ULONG )sptr_virtual_server_loopback_mapped_port_status +  (ULONG) offset);
		*ptr_to_bit_status |= exp_bit_mask[bit_position];
	}
	else
	{
		return;
	}

	return;		
}

/*--------------------------------------------------------------------------*\

**	Function Name	: get_a_free_virtual_server_loopback_port()
**	Description 	: checking whether the source port sent by the client is
						: unique & not used by any other client. If yes, the same 
						: port number can be used as mapped port. If not, the next 
						: available unique port number is used as the mapped port 
						: for this client.
**	Parameters		: 1. reserved destination port
						: 2. source port
**	Return Value	: USHORT
**	Notes				:

\*--------------------------------------------------------------------------*/

USHORT get_a_free_virtual_server_loopback_port (USHORT application_port, USHORT source_port)
{

/* Modified for rlogin */

	switch (application_port)
	{
		case RLOGIN_PORT:
			while (1)
			{
				virtual_server_loopback_reserved_port_number_value++;
				
				if (virtual_server_loopback_reserved_port_number_value == 1023)
				{
					virtual_server_loopback_reserved_port_number_value = STARTING_RESERVED_PORT;
				}

				if (is_new_virtual_server_loopback_port_already_in_use (virtual_server_loopback_reserved_port_number_value) == FALSE)
				{
					set_virtual_server_loopback_port_status_to_in_use (virtual_server_loopback_reserved_port_number_value);
					break;
				}
			}
			return (virtual_server_loopback_reserved_port_number_value);					
			break;
							
		default:
			if (source_port)
			{
				if (is_new_virtual_server_loopback_port_already_in_use (source_port) == FALSE)
				{
					set_virtual_server_loopback_port_status_to_in_use (source_port);
					return source_port;
				}
			}

			while (1)
			{
				virtual_server_loopback_dynamic_port_number++;

				if (virtual_server_loopback_dynamic_port_number == 0)
				{
					virtual_server_loopback_dynamic_port_number = DYNAMIC_PORT_NUMBER;
				}

				if (is_new_virtual_server_loopback_port_already_in_use (virtual_server_loopback_dynamic_port_number) == FALSE)
				{
					set_virtual_server_loopback_port_status_to_in_use (virtual_server_loopback_dynamic_port_number);
					break;
				}
			}	
			return (virtual_server_loopback_dynamic_port_number);
			break;
	}
	return 0;
}

#endif /* __VIRTUAL_SERVER_LOOPBACK__ */
/* ... sudha 07-Feb-2000 */

/* Sachin, 3rd Oct. 1997 */
void ppp_port_down_by_no_demand (USHORT real_port_number)
{
   proxy_server.port[real_port_number].port_down_by_no_demand = TRUE ;
   proxy_server.port[real_port_number].port_opened = FALSE ;
	process_nat_descriptor_table (); /*Neelu for NAT*/

	/* Added by Ravi on 08 Apr 1999 ... */
	ip_port_down(real_port_number);
	/* ... Added by Ravi on 08 Apr 1999 */
}
/* Sachin, 3rd Oct. 1997 */


USHORT get_application_port_number (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, 
		USHORT *destination_port, enum IP_PROTOCOL_VALUE *protocol_type)
{
	if (sptr_ip_parameters->protocol == TCP_PROTOCOL)
	{
		*protocol_type = TCP_PROTOCOL; 
		return (get_tcp_port_number_from_ip_packet (uptr_ip_rx_packet, sptr_ip_parameters, destination_port));
	}
	else if (sptr_ip_parameters->protocol == UDP_PROTOCOL)
	{
		*protocol_type = UDP_PROTOCOL;
		return (get_udp_port_number_from_ip_packet(uptr_ip_rx_packet, sptr_ip_parameters, destination_port));
	}
	else if (sptr_ip_parameters->protocol == ICMP_PROTOCOL)
		*protocol_type = ICMP_PROTOCOL;
	else if (sptr_ip_parameters->protocol == GRE_PROTOCOL) /* Added by Sreelu for PPTP */
		*protocol_type = GRE_PROTOCOL;

	return INVALID_DESTINATION_PORT;
}


/* sudhir added dynamic app ptr for passive ftp command */

enum BOOLEAN check_if_application_port_is_to_be_proxied (USHORT application_port, 
		enum IP_PROTOCOL_VALUE protocol_type, USHORT rx_port_number, BYTE **dynamic_app_ptr)
{
	USHORT application_index=0;
/*sri	PROXY_APPLICATION_TABLE *proxy_application_list = proxy_server.sptr_application_list; */

	/* added By ravi on 04 Jan 1999 ... */
	PROXY_APP_PORT_RANGE_LIST *ptr_to_port_range = proxy_server.proxy_server_application_port_range_list;
	/* ... added By ravi on 04 Jan 1999 */

	PROXY_APPLICATION_LIST_NODE *proxy_temp_application_node;
	PROXY_DYNAMIC_APP_LIST *temp_app_list_ptr;
	PROXY_RB_KEY_TYPE proxy_rb_key;

/* Added By Ravi for User defined Ranges on 04 Jan 1999 ... */
	for (application_index = 0; application_index < proxy_server.number_of_user_defined_applications; 
		  application_index++, ptr_to_port_range++)
	{
		if (ptr_to_port_range->protocol == protocol_type &&
			 ((application_port == ptr_to_port_range->lower_port_number && ptr_to_port_range->higher_port_number == 0) ||
			  (application_port >= ptr_to_port_range->lower_port_number && application_port <= ptr_to_port_range->higher_port_number &&
		     ptr_to_port_range->higher_port_number != 0)))
		{
			proxy_printf("\n User defined Port.  Protocol : %04x, Port Number : %04x", protocol_type, application_port); 
			return TRUE;
		}
	}
/* ... Added By Ravi for User defined Ranges on 04 Jan 1999 */

	switch (protocol_type)
	{
		case IP_DATA_TCP:
		case IP_DATA_UDP:

			proxy_rb_key.protocol_type = protocol_type;
			proxy_rb_key.application_port = application_port;

			proxy_temp_application_node = proxy_rb_demo_search (sptr_proxy_address_tree, proxy_rb_key);			
			if (proxy_temp_application_node != NULL)
			{
				if (proxy_temp_application_node->key.protocol_type == protocol_type &&
					proxy_temp_application_node->key.application_port == application_port)
						return TRUE;
				else
						return FALSE;
			}

			temp_app_list_ptr = proxy_server.proxy_server_dynamic_application_list;
			while (temp_app_list_ptr)
			{
				if (temp_app_list_ptr->application_port == application_port)
				{
					*dynamic_app_ptr = temp_app_list_ptr;
					return TRUE;
				}
				temp_app_list_ptr = temp_app_list_ptr->sptr_forward_link;
			}	 
			break;

		default:
			break;
	}

	/* Added by Ravi on 29 Oct 1998 ... */
	if(proxy_server.proxy_any_application_enabled)
		return TRUE;
	/* ... Added by Ravi on 29 Oct 1998 */

	return FALSE;
}

#if PROXY_DEBUG
extern char *convert_ip_address_to_dot_format (char *, ULONG) ;
extern char *get_protocol_type (char *protocol_type_string, enum IP_PROTOCOL_VALUE protocol_type) ;
extern char *get_port_type (char *port_type_string, enum IP_PROTOCOL_VALUE protocol_type, USHORT protocol_port_number) ;
#endif

#if OLD_FILTER
/* Sreelu for filter... */
enum BOOLEAN check_in_forbidden_list_for_destination_address (ULONG destination_address)
{
	PROXY_FORBIDDEN_SITE_LIST *sptr_next_forbidden_site = proxy_server.ptr_to_forbidden_list;
/* Sudha 6 June 1998 .sptr_next_restricted_domain_address is initialized */
	PROXY_FORBIDDEN_DOMAIN_ADDRESS *sptr_next_restricted_domain_address = proxy_server.ptr_to_restricted_domain_address;
	ULONG *temp_ptr;
	USHORT forbidden_addr_index,count=0;

	for (forbidden_addr_index = 0; forbidden_addr_index < proxy_server.number_of_forbidden_sites;
		forbidden_addr_index++, sptr_next_forbidden_site++)
  	{
		if (sptr_next_forbidden_site->destination_ip_address == destination_address)
			return TRUE;
	}

	for (forbidden_addr_index = 0; forbidden_addr_index < proxy_server.max_number_of_restricted_domain_address;
		forbidden_addr_index++, sptr_next_restricted_domain_address++)
	{
/* Sudha 23 June 1998 */
		temp_ptr = sptr_next_restricted_domain_address->destination_ip_address;
		for ( count = 0;count < sptr_next_restricted_domain_address->count;count++)
		{
			if (*(temp_ptr) == destination_address)
				return TRUE;
			temp_ptr++;
		}
	}
	return FALSE;
}	

enum BOOLEAN check_in_restricted_list_for_source_address (ULONG source_address)
{
	PROXY_RESTRICTED_CLIENT_LIST *sptr_next_restricted_client = proxy_server.ptr_to_restricted_client_list;
	USHORT restricted_addr_index;

	for (restricted_addr_index = 0; restricted_addr_index < proxy_server.number_of_restricted_clients;
		restricted_addr_index++, sptr_next_restricted_client++)
  	{
		if (sptr_next_restricted_client->source_ip_address == source_address)
			return TRUE;
	}
	return FALSE;
}	


enum BOOLEAN check_if_application_is_to_be_restricted (USHORT protocol , USHORT application_port)
{
	USHORT application_index=0;
	PROXY_APPLICATION_TABLE *proxy_application_list = proxy_server.sptr_restricted_application_list;

	for (application_index = 0; application_index <= proxy_server.number_of_restricted_applications; 
				application_index++, proxy_application_list++)
	{

		if (proxy_application_list->protocol_type == protocol &&
			 proxy_application_list->protocol_port == application_port)
		{
			return TRUE;
		}
	}
	return FALSE;
}

enum BOOLEAN check_if_MAC_address_is_to_be_filtered (BYTE *uptr_ip_rx_packet)
{
	PROXY_RESTRICTED_MAC_ADDRESS_LIST *sptr_next_restricted_MAC_address_list;
	BYTE mac_address[6];
	USHORT mac_address_index;

	memcpy (&mac_address[0], (uptr_ip_rx_packet+6), 6);
	sptr_next_restricted_MAC_address_list = proxy_server.ptr_to_restricted_MAC_address_list;
	
	for (mac_address_index = 0; mac_address_index < proxy_server.max_number_of_restricted_MAC_address;
			mac_address_index++, sptr_next_restricted_MAC_address_list++)
	{
		if (!memcmp (&mac_address[0], &sptr_next_restricted_MAC_address_list->mac_address[0], 6))
			return TRUE;
	}
	return FALSE;

}
/* ...Sreelu for filter */
#endif

enum BOOLEAN check_if_packet_is_to_be_proxied (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters,
		USHORT *mapped_port, enum BOOLEAN *abort_forwarding, USHORT rx_port_number, enum IP_PROTOCOL_VALUE *ip_protocol_type, 
		USHORT *outgoing_port, void **proxy_info, enum BOOLEAN *eptr_size_modified, IP_ROUTE_ENTRY *sptr_static_route_entry)
{
	USHORT application_port=0, destination_port=0;
	enum IP_PROTOCOL_VALUE protocol_type;
	PROXY_SERVER_INFO *ptr_to_proxy_info;
	BYTE *ptr_to_dynamic_app_list = NULL;

	PROXY_RB_SERVER_KEY_TYPE server_descriptor_key;
	PPTP_INFO_DESCRIPTOR *pptp_info_ptr;

#if 1
	char src_ip_address[20], dest_ip_address[20], dest_application[10], protocol_type_string[10] ;
#endif

/* This is to be included after initing from nvram */
	if (!proxy_server.proxy_server_enabled || !proxy_server.port[rx_port_number].proxy_server_enabled)
	{
		proxy_printf ("PROXY_SERVER: proxy server disabled for port %d\n",rx_port_number); 
		return FALSE;
	}

	application_port = get_application_port_number ((BYTE *) uptr_ip_rx_packet, 
									sptr_ip_parameters, &destination_port, &protocol_type);
	*ip_protocol_type = protocol_type;

	if (application_port == INVALID_DESTINATION_PORT && protocol_type != ICMP_PROTOCOL && protocol_type != GRE_PROTOCOL)
	{
		return FALSE;
	}

#if OLD_FILTER
/* Sreelu for filter... */
	if (check_if_MAC_address_is_to_be_filtered ((BYTE *)uptr_ip_rx_packet) == TRUE)
	{
		*abort_forwarding = TRUE;			
		return FALSE;
	}
	
	if (check_in_restricted_list_for_source_address (sptr_ip_parameters->source_address) == TRUE)
	{
		*abort_forwarding = TRUE;			
		return FALSE;
	}

	if (check_in_forbidden_list_for_destination_address (sptr_ip_parameters->destination_address) == TRUE)
	{
		*abort_forwarding = TRUE;			
		return FALSE;
	}
#endif
/* Sreelu */

	switch (protocol_type)
	{
		case IP_DATA_ICMP:
			if (is_icmp_echo_request_message (uptr_ip_rx_packet, sptr_ip_parameters))
			{
				ptr_to_proxy_info = get_free_proxy_server_info_ptr(destination_port, uptr_ip_rx_packet, sptr_ip_parameters,
												rx_port_number, protocol_type, eptr_size_modified ,TRUE, sptr_static_route_entry);
				if (ptr_to_proxy_info == NULL)
				{
					*abort_forwarding = TRUE;			
					return FALSE;
				}					


				proxy_server.port[ptr_to_proxy_info->outgoing_physical_port].number_of_packets_txed++;
				*outgoing_port = ptr_to_proxy_info->outgoing_physical_port;
				ptr_to_proxy_info->in_use = TRUE;
				ptr_to_proxy_info->incoming_physical_port = sptr_ip_parameters->rx_port_number;
/*				printf ("Setting idle timer for icmp\n"); */
				ptr_to_proxy_info->protocol_type = protocol_type;					
/*				ptr_to_proxy_info->proxy_idle_timer = proxy_server.proxy_server_idle_timeout ; */
/* Changed by Ravi on 03 Nov 1999 */
				ptr_to_proxy_info->proxy_idle_timer = 30;
				ptr_to_proxy_info->destination_address = sptr_ip_parameters->destination_address;

				ptr_to_proxy_info->icmp_packet_id = get_icmp_echo_request_id (uptr_ip_rx_packet, sptr_ip_parameters);
	
/* sudha 05-Nov-1999... */
				ptr_to_proxy_info->client_node = NULL;
				ptr_to_proxy_info->server_node = NULL;		
/* ...sudha 05-Nov-1999 */

				if (new_icmp_packet_id == 0)
					new_icmp_packet_id = 5;
			
				ptr_to_proxy_info->mapped_icmp_packet_id = new_icmp_packet_id++;

				server_descriptor_key.protocol_type = protocol_type;
				server_descriptor_key.application_port = ptr_to_proxy_info->mapped_icmp_packet_id;
				add_entry_to_proxy_server_descriptor_tree (ptr_to_proxy_info, (BYTE *) &server_descriptor_key);
				
				*proxy_info = (void *) ptr_to_proxy_info;
				return TRUE;
			}	
			break;

/* Added by Sreelu for PPTP */
#ifdef _VPN_PPTP_
		case IP_GRE_PROTOCOL:

			pptp_info_ptr = get_ptr_to_pptp_info_from_gre_packet (uptr_ip_rx_packet, sptr_ip_parameters);
			if (pptp_info_ptr == NULL)
			{
				*abort_forwarding = TRUE;			
				return FALSE;
			}
			
			pptp_info_ptr->idle_timer = proxy_server.proxy_server_idle_timeout;
			pptp_info_ptr->rx_port_number = sptr_ip_parameters->rx_port_number;

			proxy_server.port[pptp_info_ptr->tx_port_number].number_of_packets_txed++;
					
			*outgoing_port = pptp_info_ptr->tx_port_number;

			*proxy_info = (void *) pptp_info_ptr;
			return TRUE;
#endif
/* Added by Sreelu for PPTP */

		case IP_DATA_TCP:
		case IP_DATA_UDP:
/* Added by Sreelu for Filtering Application Port... */
			application_port = get_application_port_number ((BYTE *) uptr_ip_rx_packet, 
							sptr_ip_parameters, &destination_port, &protocol_type );
		
#if OLD_FILTER
			if (check_if_application_is_to_be_restricted (sptr_ip_parameters->protocol, 
					application_port) == TRUE)
			{
				*abort_forwarding = TRUE;			
				return FALSE;
			}
#endif

			if (application_port == INVALID_DESTINATION_PORT)
			{
				proxy_printf ("PROXY :Destination Port is Invalid\n");
				return FALSE;
			}
/* ...Added by Sreelu for Filtering Application Port */

			if (check_if_application_port_is_to_be_proxied (application_port, protocol_type, 
				rx_port_number, &ptr_to_dynamic_app_list))
			{
				ptr_to_proxy_info = get_free_proxy_server_info_ptr(destination_port, uptr_ip_rx_packet, sptr_ip_parameters,rx_port_number, protocol_type, eptr_size_modified, FALSE, sptr_static_route_entry);
				if (ptr_to_proxy_info == NULL)
				{
					printf ("PROXY : Not Enough memory to Allocate Descriptor\n"); 
					*abort_forwarding = TRUE;			
					return FALSE;
				}
		
/* This is to support TFTP */
				if (application_port == TFTP_RESERVED_PORT)
					ptr_to_proxy_info->tftp_packet_detected = TRUE;
/* This is to support TFTP */

				ptr_to_proxy_info->destination_address = sptr_ip_parameters->destination_address;

				proxy_server.port[ptr_to_proxy_info->outgoing_physical_port].number_of_packets_txed++;
				*outgoing_port = ptr_to_proxy_info->outgoing_physical_port;
				ptr_to_proxy_info->in_use = TRUE;
				ptr_to_proxy_info->incoming_physical_port = rx_port_number;
				ptr_to_proxy_info->protocol_type = protocol_type;					


/* sudhir for ftp passive comm */
				ptr_to_proxy_info->destination_port = application_port;
				ptr_to_proxy_info->ptr_to_dynamic_application_list = *ptr_to_dynamic_app_list;		 

				if ((protocol_type == TCP_PROTOCOL) && 
					(is_close_connection_initiated ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters) == TRUE))
				{
					proxy_printf ("PROXY : TCP Connection is closed by %08x\n",
								uptr_ip_rx_packet->ip.header.source_ip_address); 
					
					ptr_to_proxy_info->connection_closing = TRUE;

					/* Descriptor Should be freed only after 20 minutes */
					/* Changed by Sreelu */
/*					ptr_to_proxy_info->proxy_idle_timer = proxy_server.proxy_server_idle_timeout; */

					/* Changed by Ravi on 03 Nov 1999 */
					ptr_to_proxy_info->proxy_idle_timer = 30;
				}

				if (ptr_to_proxy_info->connection_closing == FALSE)
/* Sachin, 23/12/1997 */
		      {
      		   if (ptr_to_proxy_info->ptr_to_ftp_command_descriptor)
					{
	         		ptr_to_proxy_info->ptr_to_ftp_command_descriptor->proxy_idle_timer = 600;
					}
/* Sachin, 23/12/1997 */

/* Added by Ravi on 03 Nov 1999 ... */
					if (protocol_type == UDP_PROTOCOL) 
					{
					   ptr_to_proxy_info->proxy_idle_timer = 60;
					}
					else 
					{
				   	ptr_to_proxy_info->proxy_idle_timer = 600;
					}
/* ... Added by Ravi on 03 Nov 1999 */
      		}
  		
				*mapped_port = ptr_to_proxy_info->mapped_port;
				*proxy_info = (void *) ptr_to_proxy_info;
#if 0		
			proxy_printf ("PR: <%s,%d>--><%s,%s,%s> proxied on port %04X\n",
				convert_ip_address_to_dot_format (&src_ip_address[0], ptr_to_proxy_info->client_ip_address),
				ptr_to_proxy_info->source_port,
				convert_ip_address_to_dot_format (&dest_ip_address[0], uptr_ip_rx_packet->ip.header.destination_ip_address),
				get_protocol_type (&protocol_type_string[0], protocol_type),
				get_port_type (&dest_application[0], protocol_type, application_port),
				*outgoing_port) ;
#endif

				return TRUE;
			}		  
			break;

		default:
			break;
	}

	return FALSE;
}



/* Sachin, 09/01/1998 */
#if LOAD_BALANCING
/*
** Returns the least loaded port among ports starting from
** (port_number + 1) % NUMBER_OF_PROXY_PORTS to port_number
** in that order.
** The assumption is that no port will have more than 0x7FFF connections
*/
USHORT get_least_loaded_port (USHORT port_number)
{
   USHORT i, least_loaded_port = NUMBER_OF_PROXY_PORTS ;
   USHORT least_load = 0x7FFF ;

   ++port_number ;
   for (i = 0 ; i < NUMBER_OF_PROXY_PORTS ; i++)
   {
      port_number = port_number % NUMBER_OF_PROXY_PORTS ;
      if (is_ipport_up (port_number + 1))
      {
         if (proxy_server.port[port_number+1].number_of_connections <= least_load)
         {
            least_load = proxy_server.port[port_number+1].number_of_connections ;
            least_loaded_port = port_number ;
         }
      }
      port_number++ ;
   }
   if (least_load == 0x7FFF)
      return (NUMBER_OF_PROXY_PORTS) ;
   else
      return (least_loaded_port) ;
}
#endif
/* Sachin, 09/01/1998 */


/* Sachin, 09/01/1998 */
BYTE use_dial_triggered_port = FALSE  ;
/* Sachin, 09/01/1998 */
USHORT last_allocated_port = 0 ;

#if 0 /* By Naveen 25/2/1998... Wrote new function for firewall */
USHORT get_outgoing_port_number ()
{
#if 0
#if LOAD_BALANCING
   USHORT port_number, i ;
   BYTE dialing_triggered_for_a_port = 0 ;

   port_number = last_allocated_port ;
   for (i = 0 ; i < NUMBER_OF_PROXY_PORTS ; i++)
   {
      port_number = get_least_loaded_port (port_number) ;
      if (port_number == NUMBER_OF_PROXY_PORTS)
         return (0) ;

      if (proxy_server.port[port_number+1].port_down_by_no_demand == FALSE)
      {
         last_allocated_port = port_number ;
         proxy_server.port[port_number+1].number_of_connections++ ;
         return (port_number + 1) ;
         /* to be made port_number + number_of_lan_ports */
      }
      else
      {
         if ((dialing_triggered_for_a_port == 0) && (proxy_server.port[port_number+1].port_opened == FALSE))
         {
            dialing_triggered_for_a_port = 1 ;
            printf ("PROXY SERVER : Triggering off dialing up of down-by-demand WAN port %04X\n", port_number) ;
            proxy_server.port[port_number+1].port_opened = TRUE ;
            ppp_link_active (port_number) ;
#if 1 /* To be used in the proposed new scheme to used the dialing-triggered port */
            if (use_dial_triggered_port)
            {
               last_allocated_port = port_number ;
               proxy_server.port[port_number+1].number_of_connections++ ;
               return (port_number + 1) ;
               /* to be made port_number + number_of_lan_ports */
            }
#endif
         }
      }
   }
   return (0) ;
#else
	USHORT port_number ;
   BYTE another_port_activated = 0 ;
	
	for (port_number = 0 ; port_number < NUMBER_OF_PROXY_PORTS ; port_number++)
	{
		last_allocated_port %= NUMBER_OF_PROXY_PORTS ;

		/* Do this thru' a command to LSL and not call-by-name */
      if (is_ipport_up (last_allocated_port + 1))
      {
         if (proxy_server.port[last_allocated_port + 1].port_down_by_no_demand)
         {
            if (proxy_server.port[last_allocated_port + 1].port_opened == FALSE)
            {
               if (another_port_activated == 0)
               {
                  ppp_link_active (last_allocated_port) ;
                  printf ("PROXY SERVER : Triggering off dialing up of down-by-demand WAN port %04X\n", last_allocated_port) ;
                  another_port_activated = 1 ;
                  proxy_server.port[last_allocated_port + 1].port_opened = TRUE ;
               }
            }
            last_allocated_port++ ;
         }
         else
         {
            last_allocated_port++ ;
            proxy_server.port[last_allocated_port].number_of_connections++ ;
            return(last_allocated_port) ;
         }
      }
      else
      {
         last_allocated_port++ ;
      }
	}
	return (0) ;
#endif
#else /* FIREWALL */
   return (1); /* i.e. SCC2 because we allways proxy a packet to 
                  SCC2 */
#endif/* FIREWALL */
}
/* Naveen 26/2/1998 for FIREWALL...*/
USHORT get_outgoing_port_number (IP_PARAMETERS* sptr_ip_parameters)
{
/* First we have to check whether the packet lies on INTERNET LAN if so
   then packet is destined for one of the host on INTERNET LAN otherwise
   we have to assume that the packet is destined for INTERNET itself
*/
   USHORT internet_port_number;
   ULONG ip_destination_address;
   
   ip_destination_address = sptr_ip_parameters->destination_address;
/* Check whether the destination address of the packet matches INTERNET LAN
   PORT Address */
   internet_port_number = get_insecured_lan_port_number();
   if ((ip.port[internet_port_number].config.ip_address & ip.port[internet_port_number].config.subnetmask) ==
			(ip_destination_address & ip.port[internet_port_number].config.subnetmask))
   {
      /* Yesss, the packet is destined for INTERNET LAN.*/
/*      printf("PROXY: Decided to transmit packet on INTERNETLAN %X %X %X\n", ip_destination_address, ip.port[internet_port_number].config.ip_address, ip.port[internet_port_number].config.subnetmask);*/
      return internet_port_number;
   }
/*   printf("PROXY: Decided to transmit packet on WAN %X\n", ip_destination_address);*/
   return internet_port_number+1; /* This is nothing but WAN port */
}
/* ...Naveen 26/2/1998 for FIREWALL*/
#endif

USHORT get_outgoing_port_number (IP_PARAMETERS* sptr_ip_parameters)
{
   ULONG next_hop_ip_address;
   USHORT outgoing_port_number, tx_port_number = 0;
	IP_PORT_CLASS *sptr_outgoing_port;
	IP_UPPER_LAYER_PARAMETERS dummy_parameters;
   
   if (determine_next_hop_ip_address_and_outgoing_port (sptr_ip_parameters, 
                                                        &next_hop_ip_address,
                                                        &outgoing_port_number,
                                                        &sptr_outgoing_port,
                                                        (IP_ROUTE_CACHE_ENTRY *) NULL,
                                                        sptr_ip_parameters->destination_address,
                                                        tx_port_number,
                                                        (ULONG) *((BYTE *) &sptr_ip_parameters->type_of_service) ,
                                                        &dummy_parameters,
                                                        THIS_IS_A_PROXY_REQUEST_PACKET,
                                                        NO_SUCH_PORT) == PASS)
   {
      return outgoing_port_number;
   }
   else
   {
      return get_the_internet_gateway_port_number();
   }
}
void set_source_port_number (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, 
		USHORT mapped_port, enum IP_PROTOCOL_VALUE protocol_type)
{
	if (protocol_type == TCP_PROTOCOL)
	{
		set_tcp_src_port_number (uptr_ip_rx_packet, sptr_ip_parameters, mapped_port);
	}
	else if (protocol_type == UDP_PROTOCOL)
	{			
		set_udp_src_port_number (uptr_ip_rx_packet, sptr_ip_parameters, mapped_port);
	}
}

enum BOOLEAN is_proxy_response_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, 
		ULONG *client_ip_address, USHORT *destination_port, enum IP_PROTOCOL_VALUE *ip_protocol_type, 
		USHORT *outgoing_physical_port, void **proxy_info)
{
	USHORT application_port=0, dummy_port=0;
	USHORT icmp_packet_id =0;
	enum IP_PROTOCOL_VALUE protocol_type;
	PROXY_SERVER_INFO *ptr_to_proxy_server_info;
	char src_ip_address[20], dest_ip_address[20], src_application[10], protocol_type_string[10] ;

	PROXY_RB_SERVER_KEY_TYPE server_descriptor_key;
	PROXY_SERVER_DESCRIPTOR_NODE far *proxy_temp_server_descriptor_list;
	PPTP_INFO_DESCRIPTOR *pptp_info_ptr;
		
#ifdef _VPN_PPTP_
	if (sptr_ip_parameters->protocol == GRE_PROTOCOL)
	{
		pptp_info_ptr = get_ptr_to_pptp_info_from_gre_response_packet (uptr_ip_rx_packet, sptr_ip_parameters);
		if (pptp_info_ptr == NULL)
		{
			printf ("PPTP: No Descriptor for GRE Response Packet\n");
			return FALSE;
		}
		
		pptp_info_ptr->idle_timer = proxy_server.proxy_server_idle_timeout;

		*outgoing_physical_port = pptp_info_ptr->rx_port_number;
		*client_ip_address = pptp_info_ptr->source_ip_address;

		*proxy_info = (void *) pptp_info_ptr;
		return TRUE;
	}
#endif

	application_port = get_application_port_number (uptr_ip_rx_packet, sptr_ip_parameters, &dummy_port, &protocol_type);
	*ip_protocol_type = protocol_type;

	if (protocol_type != TCP_PROTOCOL  && protocol_type != UDP_PROTOCOL && 
				protocol_type != ICMP_PROTOCOL)
	{
		return FALSE; 
	}

#if 0
	ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) get_pointer_to_first_entry_in_list ((LINK *)&proxy_server.proxy_server_info_list);
	
	while (ptr_to_proxy_server_info != NULL)
	{
		if (protocol_type == ICMP_PROTOCOL)
		{
			icmp_packet_id = get_icmp_echo_request_id (uptr_ip_rx_packet, sptr_ip_parameters);

			if (ptr_to_proxy_server_info->mapped_icmp_packet_id == icmp_packet_id)
			{	
				*outgoing_physical_port = ptr_to_proxy_server_info->incoming_physical_port;
				*client_ip_address = ptr_to_proxy_server_info->client_ip_address;			
				*proxy_info = ptr_to_proxy_server_info;
				return TRUE;
			}		
		}
		if (application_port == ptr_to_proxy_server_info->mapped_port)
		{
			*outgoing_physical_port = ptr_to_proxy_server_info->incoming_physical_port;
			*destination_port = ptr_to_proxy_server_info->source_port;
			*client_ip_address = ptr_to_proxy_server_info->client_ip_address;
			if (is_close_connection_initiated (uptr_ip_rx_packet, sptr_ip_parameters) == TRUE &&
					(protocol_type == TCP_PROTOCOL))
			{
/*				proxy_printf ("PROXY_SERVER : TCP Connection is closed\n"); */
				ptr_to_proxy_server_info->connection_closing = TRUE;

				/*sri  ptr_to_proxy_server_info->proxy_idle_timer = (proxy_server.proxy_server_idle_timeout) / 10;*/
/* Descriptor Should be freed only after 20 minutes */
			/* Changed by Sreelu */
				ptr_to_proxy_server_info->proxy_idle_timer = 30;
			}
			else if (ptr_to_proxy_server_info->connection_closing == FALSE)
/* Sachin, 23/12/1997 */
         {
            if (ptr_to_proxy_server_info->ptr_to_ftp_command_descriptor)
	            ptr_to_proxy_server_info->ptr_to_ftp_command_descriptor->proxy_idle_timer = 600;
/* Sachin, 23/12/1997 */
				   ptr_to_proxy_server_info->proxy_idle_timer = 600;
         }

/* This is to support TFTP */
			if (ptr_to_proxy_server_info->tftp_packet_detected == TRUE)
			{
				proxy_printf ("PROXY : Adding TFTP dynamic port %d\n",dummy_port);
				add_port_to_application_list (dummy_port);	
				ptr_to_proxy_server_info->tftp_packet_detected = FALSE;
			}		
/* This is to support TFTP */

			proxy_server.port[ptr_to_proxy_server_info->outgoing_physical_port].number_of_packets_rxed++;
			*proxy_info = ptr_to_proxy_server_info;

#if 0			
			printf ("PR: <%s,%s,%s>--><%s,%d> relayed on port %04X\n",
				convert_ip_address_to_dot_format (&src_ip_address[0], ((UNION_IP_PACKET *)uptr_ip_rx_packet)->ip.header.source_ip_address),
				get_protocol_type (&protocol_type_string[0], protocol_type),
				get_port_type (&src_application[0], protocol_type, dummy_port),
				convert_ip_address_to_dot_format (&dest_ip_address[0], *client_ip_address),
				*destination_port,
				*outgoing_physical_port) ;
#endif

			return TRUE;
		}
		ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) get_pointer_to_next_entry_in_list ((LINK *)ptr_to_proxy_server_info);
	}
#endif

	if (sptr_ip_parameters->protocol == ICMP_PROTOCOL)
	{
		icmp_packet_id = get_icmp_echo_request_id (uptr_ip_rx_packet, sptr_ip_parameters);
		
		server_descriptor_key.protocol_type = sptr_ip_parameters->protocol;
		server_descriptor_key.application_port = icmp_packet_id;
		proxy_temp_server_descriptor_list = proxy_rb_server_descriptor_search (
					sptr_proxy_server_descriptor_tree, server_descriptor_key);
	
		if (proxy_temp_server_descriptor_list == NULL)
			return FALSE;

		ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) (proxy_temp_server_descriptor_list->info.server_descriptor);
		
		if (ptr_to_proxy_server_info->mapped_icmp_packet_id == icmp_packet_id)
		{	
/* Added by Ravi on 03 Nov 1999 ... */		
			ptr_to_proxy_server_info->proxy_idle_timer = 1;
/* ... Added by Ravi on 03 Nov 1999 */		

			*outgoing_physical_port = ptr_to_proxy_server_info->incoming_physical_port;
			*client_ip_address = ptr_to_proxy_server_info->client_ip_address;			
			*proxy_info = ptr_to_proxy_server_info;
			return TRUE;
		}
/* Added by Ravi on 03 Nov 1999 ... */		
		else
		{
			*proxy_info = ptr_to_proxy_server_info;
			return FALSE;
		}
/* ... Added by Ravi on 03 Nov 1999 */		
  	}

	server_descriptor_key.protocol_type = sptr_ip_parameters->protocol;
	server_descriptor_key.application_port = application_port;

	proxy_temp_server_descriptor_list = proxy_rb_server_descriptor_search (
					sptr_proxy_server_descriptor_tree, server_descriptor_key);

	if (proxy_temp_server_descriptor_list->key.application_port == application_port &&
			proxy_temp_server_descriptor_list->key.protocol_type == sptr_ip_parameters->protocol)
	{
		ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) (proxy_temp_server_descriptor_list->info.server_descriptor);

		*outgoing_physical_port = ptr_to_proxy_server_info->incoming_physical_port;
		*destination_port = ptr_to_proxy_server_info->source_port;			
		*client_ip_address = ptr_to_proxy_server_info->client_ip_address;			
		if ((protocol_type == TCP_PROTOCOL) && 
			(is_close_connection_initiated (uptr_ip_rx_packet, sptr_ip_parameters) == TRUE))
		{
			proxy_printf ("PROXY_SERVER : TCP Connection is closed\n"); 
  			ptr_to_proxy_server_info->connection_closing = TRUE;
			/*sri  ptr_to_proxy_server_info->proxy_idle_timer = (proxy_server.proxy_server_idle_timeout) / 10;*/
/* Descriptor Should be freed only after 20 minutes */
			/* Changed by Sreelu */
			ptr_to_proxy_server_info->proxy_idle_timer = 30;
		}

  		if (ptr_to_proxy_server_info->connection_closing == FALSE)
/* Sachin, 23/12/1997 */
      {
      	if (ptr_to_proxy_server_info->ptr_to_ftp_command_descriptor)
			{
	         ptr_to_proxy_server_info->ptr_to_ftp_command_descriptor->proxy_idle_timer = 600;
			}
/* Sachin, 23/12/1997 */
			if (protocol_type == UDP_PROTOCOL) 
			{
				ptr_to_proxy_server_info->proxy_idle_timer = 60;
			}
			else
			{
				ptr_to_proxy_server_info->proxy_idle_timer = 600;
			}
      }

/* This is to support TFTP */
		if (ptr_to_proxy_server_info->tftp_packet_detected == TRUE)
		{
			proxy_printf ("PROXY : Adding TFTP dynamic port %d\n",dummy_port);
			add_port_to_application_list (dummy_port);	
			ptr_to_proxy_server_info->tftp_packet_detected = FALSE;
		}		
/* This is to support TFTP */

		proxy_server.port[ptr_to_proxy_server_info->outgoing_physical_port].number_of_packets_rxed++;
		*proxy_info = ptr_to_proxy_server_info;
		return TRUE;
	}
	
	return FALSE;
}

void set_destination_port_number (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, 
		USHORT mapped_port, enum IP_PROTOCOL_VALUE protocol_type)
{
	if (protocol_type == TCP_PROTOCOL)
	{
		set_tcp_dest_port_number (uptr_ip_rx_packet, sptr_ip_parameters, mapped_port);
	}
	else if (protocol_type == UDP_PROTOCOL)
	{			
		set_udp_dest_port_number (uptr_ip_rx_packet, sptr_ip_parameters, mapped_port);
	}
}

/* Port command format :
	PORT i1,i2,i3,i4,p1,p2,13,10
*/
BYTE *form_new_port_command (BYTE *tcp_data, PROXY_SERVER_INFO *proxy_server_info)
{
	USHORT buffer_index=0, port_higher_byte, port_lower_byte ;
	ULONG tx_port_address;
	BYTE ip_address[20] ;

	tx_port_address = proxy_server_info->outgoing_port_address;
	convert_ip_address_to_dot_format (&ip_address[0], tx_port_address);
	for (buffer_index = 0 ; ip_address[buffer_index] ; buffer_index++)
		if (ip_address[buffer_index] == '.')
			ip_address[buffer_index] = ',' ;

	port_higher_byte = (proxy_server_info->mapped_port & 0xff00);
	port_higher_byte >>= 8;
	port_lower_byte = (proxy_server_info->mapped_port  & 0x00ff);


	sprintf (&tcp_data[0], "PORT %s,%d,%d\x0D\x0A", &ip_address[0],
		port_higher_byte, port_lower_byte) ;

	return tcp_data ;
}

USHORT get_port_command_length (BYTE *ptr_to_start_of_port_command)
{
	BYTE *x = ptr_to_start_of_port_command ;

	while (*x++ != 0x0A)
	{
/* sudha 02-Feb-2000. For pasv FTP support */
		/* It can never cross 35 if "PORT" command or 55 if "227 Entering PASV mode
		   command.So 35 has been changed to 55. */
		if (((BYTE *)x - (BYTE *)ptr_to_start_of_port_command) > 55)
			return (100);
	}

	return ((BYTE *)x - (BYTE *)ptr_to_start_of_port_command);
}		

void process_proxy_ip_packet (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters,
		USHORT mapped_port, enum IP_PROTOCOL_VALUE protocol_type, USHORT tx_port, BYTE *proxy_server_info, 
		enum BOOLEAN ftp_port_command)
{
	PROXY_SERVER_INFO *ptr_to_proxy_server_info;
	BYTE *ptr_to_tcp_packet, *ptr_to_udp_packet;
	int old_length, new_length ;
	BYTE *sptr_icmp_header;
	USHORT new_checksum=0;
	ULONG dns_server_addr ;
	PPTP_INFO_DESCRIPTOR *ptr_to_pptp_info;

	ptr_to_proxy_server_info = (PROXY_SERVER_INFO *)proxy_server_info;

#ifdef _VPN_PPTP_
	if (sptr_ip_parameters->protocol == TCP_PROTOCOL)
		check_for_pptp_client_packet_and_process (uptr_ip_rx_packet, sptr_ip_parameters,ptr_to_proxy_server_info->outgoing_physical_port);


	if (sptr_ip_parameters->protocol == GRE_PROTOCOL)
	{
		ptr_to_pptp_info = (PPTP_INFO_DESCRIPTOR *)proxy_server_info; 
		if (ptr_to_pptp_info == NULL)
		{
			printf ("PPTP: Invalid GRE Packet\n");
			return;
		}

		process_client_gre_packet_if_required (uptr_ip_rx_packet, sptr_ip_parameters, ptr_to_pptp_info);

		sptr_ip_parameters->source_address = ptr_to_pptp_info->outgoing_port_address;
		uptr_ip_rx_packet->ip.header.source_ip_address = ptr_to_pptp_info->outgoing_port_address;
		return;
	}

#endif
	sptr_ip_parameters->source_address = ptr_to_proxy_server_info->outgoing_port_address;

/* Ported by Sreelu for DNS Caching from BIG Proxy... */
/* Sudha 07 Nov 1998 */	
	if ( is_dns_query_pkt_destined_to_lan_of_proxy_as_dns_server ( uptr_ip_rx_packet,
 		sptr_ip_parameters ) == TRUE )
	{
		dns_server_addr = get_dns_server_address(1) ;		
		if ( dns_server_addr )
			sptr_ip_parameters->destination_address = dns_server_addr ;
		uptr_ip_rx_packet->ip.header.destination_ip_address = sptr_ip_parameters->destination_address;
	 }	

/* Sudha 07 Nov 1998 */
/*...Ported by Sreelu for DNS Caching from BIG Proxy */

/* Added for Ping */
	if (protocol_type == ICMP_PROTOCOL)
	{
		uptr_ip_rx_packet->icmp.ip_header.source_ip_address = sptr_ip_parameters->source_address;
		uptr_ip_rx_packet->icmp.header.option.echo_message.identifier = 
					ptr_to_proxy_server_info->mapped_icmp_packet_id;					
		sptr_icmp_header = get_ptr_to_icmp_header (uptr_ip_rx_packet, sptr_ip_parameters);		 
		set_icmp_checksum (sptr_icmp_header, 0);
		new_checksum =	calculate_ip_checksum (NULL, 
				(BYTE *)sptr_icmp_header, (USHORT) (sptr_ip_parameters->total_length- sptr_ip_parameters->header_length));
		set_icmp_checksum (sptr_icmp_header, new_checksum);
		return;				
	}

	uptr_ip_rx_packet->ip.header.source_ip_address = sptr_ip_parameters->source_address;


	set_source_port_number ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters, mapped_port, protocol_type);
	
	if (ptr_to_proxy_server_info->ftp_port_command_on)
		modify_tcp_seq_number_field ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters, ptr_to_proxy_server_info->seq_offset);


	if (ftp_port_command)
	{
		ptr_to_proxy_server_info->ftp_port_command_on = TRUE;
		ptr_to_tcp_packet = get_ptr_to_tcp_packet ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters) ;
		old_length = get_port_command_length (ptr_to_tcp_packet) ;
		form_new_port_command (ptr_to_tcp_packet, ptr_to_proxy_server_info->ptr_to_ftp_data_descriptor);
		new_length = get_port_command_length (ptr_to_tcp_packet) ;
#if 0
		printf ("Old Length : %d, New length : %d\n", old_length, new_length) ;
#endif

		uptr_ip_rx_packet->ip.header.total_length += (new_length - old_length) ;
		sptr_ip_parameters->total_length += (new_length - old_length) ;

		ptr_to_proxy_server_info->seq_offset += new_length - old_length;
	}

/* vidy 1/9/98. To support the RoadRunner rrlogin vvvv */
	if (protocol_type == TCP_PROTOCOL)
	{
		if (ptr_to_proxy_server_info->destination_port == RD_RNR_TAS_TCP_PORT)
		{
			/* we need to see if the data contains the source address in string
			form. If it found replace it with the FW internet port address. */
			ptr_to_tcp_packet = get_ptr_to_tcp_packet ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters) ;

			road_runner_rlogin_replace_source_address_if_in_data(
				ptr_to_proxy_server_info->client_ip_address,
				ptr_to_proxy_server_info->outgoing_port_address, ptr_to_tcp_packet);
		}
	}
	else if (protocol_type == UDP_PROTOCOL)
	{
		if (ptr_to_proxy_server_info->destination_port == RD_RNR_TAS_UDP_PORT)
		{
/* printf(" Proxy :rd_rnr sock %d\n", RD_RNR_TAS_UDP_PORT); */
			/* we need to see if the data contains the source address in string
			form. If it found replace it with the FW internet port address. */
			ptr_to_udp_packet = get_ptr_to_udp_packet ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters) ;

			road_runner_rlogin_replace_source_address_if_in_data(
				ptr_to_proxy_server_info->client_ip_address,
				ptr_to_proxy_server_info->outgoing_port_address, ptr_to_udp_packet);
		}
	}
/* vidy 1/9/98. To support the RoadRunner rrlogin ^^^^
road runner changes done on 8/9/98 */

	if (protocol_type == TCP_PROTOCOL)
		update_tcp_checksum_in_packet (uptr_ip_rx_packet, sptr_ip_parameters); 
	else if (protocol_type == UDP_PROTOCOL)
		update_udp_checksum_in_packet (uptr_ip_rx_packet, sptr_ip_parameters); 
}

void process_proxy_response_packet (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters,
	  USHORT destination_port, enum IP_PROTOCOL_VALUE protocol_type, ULONG client_ip_address, BYTE *proxy_server_info)
{
	PROXY_SERVER_INFO *ptr_to_proxy_info;	
	BYTE *sptr_icmp_header, *ptr_to_tcp_packet;
	USHORT new_checksum=0, dest_port, src_port ;
	USHORT time_exceeded_message_id = 0; /* sudha 25-Jan-2000 */
	USHORT pasv_port = 0; /* sudha 02-Feb-2000. For pasv FTP support */
	PPTP_INFO_DESCRIPTOR *ptr_to_pptp_info;

#ifdef _VPN_PPTP_
	if (sptr_ip_parameters->protocol == TCP_PROTOCOL)
		check_for_pptp_server_packet_and_process (uptr_ip_rx_packet, sptr_ip_parameters);

	if (sptr_ip_parameters->protocol == GRE_PROTOCOL)
	{
		printf ("\nPPTP: GRE packet detected while processing response\n"); 
		
		ptr_to_pptp_info = (PPTP_INFO_DESCRIPTOR *)proxy_server_info; 
		if (ptr_to_pptp_info == NULL)
		{
	   	printf ("PPTP: No Descriptor match exists\n");
		}
		process_server_gre_packet_if_required (uptr_ip_rx_packet, sptr_ip_parameters, ptr_to_pptp_info);
				
		sptr_ip_parameters->destination_address = client_ip_address;
		uptr_ip_rx_packet->ip.header.destination_ip_address = client_ip_address;
		return;
	}

#endif

	ptr_to_proxy_info = (PROXY_SERVER_INFO *) proxy_server_info;

	sptr_ip_parameters->destination_address = client_ip_address;		

/* Ported by Sreelu for DNS Caching from BIG Proxy... */
/* Sudha 07 Nov 1998 */	
	if ( sptr_ip_parameters->protocol == IP_DATA_UDP )
	{
		dest_port = get_udp_port_number_from_ip_packet(uptr_ip_rx_packet, sptr_ip_parameters, &src_port); 
		if (( src_port == DNS_PORT_NUMBER ) && 
			(sptr_ip_parameters->source_address != ptr_to_proxy_info->destination_address) &&
			(is_proxy_secured_lan_addr(ptr_to_proxy_info->destination_address)))
		{
			sptr_ip_parameters->source_address = ptr_to_proxy_info->destination_address ;
			uptr_ip_rx_packet->ip.header.source_ip_address = ptr_to_proxy_info->destination_address;
		}
	}
/*...Ported by Sreelu for DNS Caching from BIG Proxy */

	/* Added for Ping */
	if (protocol_type == ICMP_PROTOCOL)
	{
		uptr_ip_rx_packet->icmp.ip_header.destination_ip_address = client_ip_address;

/* sudha 25-Jan-2000.Support for trace route - ICMP TIME EXCEEDED packet ... */
		sptr_icmp_header = get_ptr_to_icmp_header (uptr_ip_rx_packet, sptr_ip_parameters);		
		if (*sptr_icmp_header == 0x0B) /* ICMP Time Exceeded Type value */
		{
			uptr_ip_rx_packet->icmp.header.option.time_exceeded_message.ip_data.source_ip_address =
				client_ip_address;
			memcpy ((void *)&uptr_ip_rx_packet->icmp.header.option.time_exceeded_message.data[4], 
				(void *)&ptr_to_proxy_info->icmp_packet_id, sizeof (USHORT));			

			time_exceeded_message_id = get_icmp_echo_request_id (uptr_ip_rx_packet, sptr_ip_parameters);
/*			printf ("PROXY : original id in time exceeded message is %x\n", time_exceeded_message_id); */
		}
		else
/* ... sudha 25-Jan-2000 */
			uptr_ip_rx_packet->icmp.header.option.echo_message.identifier = 
						ptr_to_proxy_info->icmp_packet_id;			

		set_icmp_checksum (sptr_icmp_header, 0);
		new_checksum = calculate_ip_checksum (NULL, sptr_icmp_header, (USHORT) (sptr_ip_parameters->total_length- sptr_ip_parameters->header_length));
		set_icmp_checksum (sptr_icmp_header, new_checksum);
		ptr_to_proxy_info->proxy_idle_timer = 1 ;
		return;				
	}

	uptr_ip_rx_packet->ip.header.destination_ip_address = client_ip_address;

	if (protocol_type == TCP_PROTOCOL)
	{
/* sudhir for ftp passive command handling */
		ptr_to_tcp_packet = get_ptr_to_tcp_packet ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters);
		if (strstr (ptr_to_tcp_packet, "227 Entering Passive Mode") != NULL)
		{
			proxy_printf ("PROXY : Passive port command received\n");
/* sudha 02-Feb-2000. For pasv FTP support ... */
			pasv_port = add_passive_port_to_application_list ((BYTE *) ptr_to_tcp_packet);
			ptr_to_proxy_info->pasv_port = pasv_port; 
/* ... sudha 02-Feb-2000. For pasv FTP support */
		}

		set_destination_port_number ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters, destination_port,protocol_type);			
/* sudhir for ftp passive command handling */
	
		if (ptr_to_proxy_info->ftp_port_command_on)
			modify_tcp_acknowledge_field ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters, ptr_to_proxy_info->seq_offset);
		update_tcp_checksum_in_packet (uptr_ip_rx_packet,sptr_ip_parameters); 
		return;
	}
		
	if (protocol_type == UDP_PROTOCOL)
	{
		set_destination_port_number ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters, destination_port,protocol_type);			
		update_udp_checksum_in_packet (uptr_ip_rx_packet,sptr_ip_parameters); 
		return;
	}
}

#if 0
void process_proxy_response_packet (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters,
	  USHORT destination_port, enum IP_PROTOCOL_VALUE protocol_type, ULONG client_ip_address)
{
	USHORT tcp_checksum, dest_port, dummy_port, addr1,addr2;
	ULONG destination_address;


	tcp_checksum = get_tcp_checksum (uptr_ip_rx_packet, sptr_ip_parameters);
	printf ("TCP Checksum is %4x\n",tcp_checksum);

	dest_port = get_tcp_port_number_from_ip_packet (uptr_ip_rx_packet, sptr_ip_parameters,dummy_port);
	tcp_checksum -= dest_port;
	
	destination_address = uptr_ip_rx_packet->ip.header.destination_ip_address;

	addr1 = destination_address & 0x0000ffff;
	tcp_checksum -= addr1;

 	addr2 = destination_address >> 16;
	tcp_checksum -= addr2;

	
	tcp_checksum += destination_port;

	destination_address = client_ip_address;
	addr1 = destination_address & 0x0000ffff;
	tcp_checksum += addr1;

	addr2 = destination_address >> 16;
	tcp_checksum += addr2;

	set_tcp_checksum (uptr_ip_rx_packet,sptr_ip_parameters,tcp_checksum);

/* Here we have to Subtract IP Address and port number */
		
	
	uptr_ip_rx_packet->ip.header.destination_ip_address = client_ip_address;
	set_destination_port_number (uptr_ip_rx_packet, sptr_ip_parameters, destination_port,protocol_type);			
	sptr_ip_parameters->destination_address = client_ip_address;		

	update_tcp_checksum_in_packet (uptr_ip_rx_packet,sptr_ip_parameters); 
	tcp_checksum = get_tcp_checksum (uptr_ip_rx_packet, sptr_ip_parameters);
	printf ("Actual Checksum is %4x\n",tcp_checksum);

#if 0
	if (protocol_type == TCP_PROTOCOL)
		update_tcp_checksum_in_packet (uptr_ip_rx_packet,sptr_ip_parameters); 
	else if (protocol_type == UDP_PROTOCOL)
		update_udp_checksum_in_packet (uptr_ip_rx_packet,sptr_ip_parameters); 
#endif
}
#endif


/*---------------------- Neelu added for NAT -------------------------------*/

void add_ftp_data_port_descriptor_if_required (BYTE *uptr_ip_rx_packet, 
	IP_PARAMETERS *sptr_ip_parameters, PROXY_INTERNET_SERVER_DESCRIPTOR *sptr_control_connection)
{
	PROXY_INTERNET_SERVER_DESCRIPTOR *ptr_to_internet_server_descriptor;
	BYTE temp_buff[6];
	BYTE *ptr_to_tcp_pkt;

	USHORT ip_total_length = sptr_ip_parameters->total_length ;
	USHORT port_command_length, ip_header_length = sptr_ip_parameters->header_length ;
	USHORT source_port=0;
	ULONG source_ip_address;

	
	ptr_to_tcp_pkt = get_ptr_to_tcp_packet ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters);
	memcpy (temp_buff,ptr_to_tcp_pkt,4);
	temp_buff[4] = 0;
	if (strcmpi (temp_buff, "Port"))
	{
		return ;
	}

	printf ("PROXY: FTP port command detected\n");

	ptr_to_internet_server_descriptor = (PROXY_INTERNET_SERVER_DESCRIPTOR *) calloc (sizeof (PROXY_INTERNET_SERVER_DESCRIPTOR), 1);
	if (ptr_to_internet_server_descriptor == NULL)
	{
		printf ("PROXY_SERVER: Not Enough memory to proxy, Dropping packet\n");	
		return ;
	}

	get_ftp_src_port_and_address (ptr_to_tcp_pkt, &source_port, &source_ip_address);
	ptr_to_internet_server_descriptor->destination_address = sptr_ip_parameters->destination_address;
/*	ptr_to_internet_server_descriptor->source_address = source_ip_address; */
	ptr_to_internet_server_descriptor->source_address = sptr_ip_parameters->source_address;
	ptr_to_internet_server_descriptor->destination_port = proxy_server.ftp_data_conn_port;
	ptr_to_internet_server_descriptor->source_port = source_port;
	printf ("PROXY : Added %08x %d\n", source_ip_address, source_port);
	ptr_to_internet_server_descriptor->protocol = sptr_ip_parameters->protocol;
	ptr_to_internet_server_descriptor->local_mapped_address = sptr_control_connection->local_mapped_address;
	ptr_to_internet_server_descriptor->seq_offset = 0;
	ptr_to_internet_server_descriptor->rx_port_number = sptr_ip_parameters->rx_port_number;
/*	ptr_to_internet_server_descriptor->idle_timer = proxy_server.proxy_server_idle_timeout; */

/* sudha 02-Feb-2000. For NAT active & pasv FTP support ... */

	ptr_to_internet_server_descriptor->ftp_pasv_mode_on = 0;
	ptr_to_internet_server_descriptor->pasv_port = 0;
	ptr_to_internet_server_descriptor->ptr_to_ftp_data_descriptor = NULL;

	ptr_to_internet_server_descriptor->ptr_to_ftp_command_descriptor = sptr_control_connection;
	sptr_control_connection->ptr_to_ftp_data_descriptor = ptr_to_internet_server_descriptor;

	ptr_to_internet_server_descriptor->connection_closing = FALSE;
	ptr_to_internet_server_descriptor->idle_timer = 600; /* 600 Secs */

/* ... sudha 02-Feb-2000. For NAT active & pasv FTP support */

	add_entry_to_list ((LINK *)&proxy_server.proxy_internet_server_list, (LINK *)ptr_to_internet_server_descriptor);
	return;
}

/* sudha 02-Feb-2000. For NAT pasv FTP support ... */

/*--------------------------------------------------------------------------*\

**	Function Name	: update_ftp_command_descriptor_info_if_pasv_ftp()
**	Description 	: Checking whether the NAT request destination port is
						: matching with any of the descriptor's pasv port field.
						: If yes, pasv FTP ctrl & data connection association is 
						: made.
**	Parameters		: 1. pointer to rcvd ip packet
						: 2. pointer to ip parameters
						: 3. pointer to internet_server_descriptor
**	Return Value	: void
**	Notes				:

\*--------------------------------------------------------------------------*/

void update_ftp_command_descriptor_info_if_pasv_ftp(BYTE *uptr_ip_rx_packet, 
 	IP_PARAMETERS *sptr_ip_parameters, PROXY_INTERNET_SERVER_DESCRIPTOR *ptr_to_descriptor)
{
	PROXY_INTERNET_SERVER_DESCRIPTOR *sptr_internet_server_descriptor;
	USHORT destination_port=0, source_port=0;
	enum IP_PROTOCOL_VALUE protocol_type;

	sptr_internet_server_descriptor = get_pointer_to_first_entry_in_list
						((LINK *)&proxy_server.proxy_internet_server_list);

	destination_port = get_application_port_number ((BYTE *) uptr_ip_rx_packet, 
		sptr_ip_parameters, &source_port, &protocol_type);

	while (sptr_internet_server_descriptor != NULL)
	{
		if ((sptr_ip_parameters->source_address == sptr_internet_server_descriptor->source_address) && 
			 (sptr_ip_parameters->destination_address == sptr_internet_server_descriptor->destination_address) && 
			 (sptr_ip_parameters->protocol == sptr_internet_server_descriptor->protocol) && 
			 (sptr_internet_server_descriptor->pasv_port != 0)	&& 
			 (destination_port == sptr_internet_server_descriptor->pasv_port))
		{
			ptr_to_descriptor->ptr_to_ftp_command_descriptor = sptr_internet_server_descriptor;
			sptr_internet_server_descriptor->ptr_to_ftp_data_descriptor = ptr_to_descriptor;

			if (sptr_internet_server_descriptor->ptr_to_ftp_command_descriptor)
			{
				sptr_internet_server_descriptor->ptr_to_ftp_command_descriptor->idle_timer = 600; /* 600 secs */
			}
			return;
		}
		sptr_internet_server_descriptor = (PROXY_INTERNET_SERVER_DESCRIPTOR *) get_pointer_to_next_entry_in_list ((LINK *)sptr_internet_server_descriptor);
	}
	return ;
}
/* ... sudha 02-Feb-2000. For NAT pasv FTP support */

enum BOOLEAN check_for_the_descriptor_in_the_current_list(BYTE *uptr_ip_rx_packet, 
 	IP_PARAMETERS *sptr_ip_parameters, PROXY_INTERNET_SERVER_DESCRIPTOR **matched_descriptor)
{
	PROXY_INTERNET_SERVER_DESCRIPTOR *sptr_internet_server_descriptor;
	USHORT destination_port=0, source_port=0;
   enum IP_PROTOCOL_VALUE protocol_type; /* Neelu */

	sptr_internet_server_descriptor = get_pointer_to_first_entry_in_list
						((LINK *)&proxy_server.proxy_internet_server_list);

	destination_port = get_application_port_number ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters, &source_port,&protocol_type);

	while (sptr_internet_server_descriptor != NULL)
	{
		if (sptr_ip_parameters->source_address == sptr_internet_server_descriptor->source_address
			&& sptr_ip_parameters->destination_address == sptr_internet_server_descriptor->destination_address
			&& sptr_ip_parameters->protocol == sptr_internet_server_descriptor->protocol
			&& destination_port == sptr_internet_server_descriptor->destination_port
			&& source_port == sptr_internet_server_descriptor->source_port)
		{

			if (destination_port == proxy_server.ftp_ctrl_conn_port)
			{
				add_ftp_data_port_descriptor_if_required (uptr_ip_rx_packet,
					sptr_ip_parameters, sptr_internet_server_descriptor);
			}
/* sudha 02-Feb-2000. For NAT active & pasv FTP support ... */
			if (sptr_ip_parameters->protocol == IP_DATA_TCP)
			{
				if ( is_close_connection_initiated((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters) == TRUE )
				{
					proxy_printf ("PROXY : NAT TCP Connection is closed by %08x\n",
					uptr_ip_rx_packet->ip.header.source_ip_address); 

					sptr_internet_server_descriptor->connection_closing = TRUE;
					sptr_internet_server_descriptor->idle_timer = 60; /* 60 Secs */
				}
				if ( sptr_internet_server_descriptor->connection_closing == FALSE )
				{
					if (sptr_internet_server_descriptor->ptr_to_ftp_command_descriptor)
					{
						sptr_internet_server_descriptor->ptr_to_ftp_command_descriptor->idle_timer = 600;  /* 600 Secs */ 
					 }
					sptr_internet_server_descriptor->idle_timer = 600;  /* 600 Secs */ 
				}
			}
			else
			{
			 	sptr_internet_server_descriptor->idle_timer = 60; /* 60 Secs */
			}
			sptr_internet_server_descriptor->rx_port_number = sptr_ip_parameters->rx_port_number;

/* ... sudha 02-Feb-2000. For NAT active & pasv FTP support */

			*matched_descriptor = sptr_internet_server_descriptor;
			return TRUE;
		}

		sptr_internet_server_descriptor = (PROXY_INTERNET_SERVER_DESCRIPTOR *) get_pointer_to_next_entry_in_list ((LINK *)sptr_internet_server_descriptor);
	}
	return FALSE;
}


PROXY_INTERNET_SERVER_DESCRIPTOR *update_descriptor_list_for_local_servers (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, 
			ULONG local_destination_address)
{
	PROXY_INTERNET_SERVER_DESCRIPTOR *ptr_to_internet_server_descriptor, *temp_ptr;
	USHORT source_port=0, destination_port=0;
	UNION_IP_PACKET *uptr_rx_packet;
   enum IP_PROTOCOL_VALUE protocol_type; /* Neelu */


	uptr_rx_packet = (UNION_IP_PACKET *) uptr_ip_rx_packet;

	if (check_for_the_descriptor_in_the_current_list (uptr_ip_rx_packet, 
			sptr_ip_parameters, &temp_ptr) == TRUE)
	{
		return temp_ptr;
	}
	
	destination_port =  get_application_port_number ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters, &source_port,&protocol_type);

		
/* sudha 02-Feb-2000. changed "malloc" to "calloc" */
	ptr_to_internet_server_descriptor = (PROXY_INTERNET_SERVER_DESCRIPTOR *)
							calloc (sizeof (PROXY_INTERNET_SERVER_DESCRIPTOR), 1);
	if (ptr_to_internet_server_descriptor == NULL)
	{
		printf ("PROXY :Error Allocating Memory\n");
		return NULL;
	}
	
	ptr_to_internet_server_descriptor->destination_address = sptr_ip_parameters->destination_address; 
	ptr_to_internet_server_descriptor->source_address = sptr_ip_parameters->source_address; 
	ptr_to_internet_server_descriptor->local_mapped_address = local_destination_address;
	ptr_to_internet_server_descriptor->protocol = sptr_ip_parameters->protocol;
	ptr_to_internet_server_descriptor->destination_port = destination_port;
	ptr_to_internet_server_descriptor->source_port = source_port;
	ptr_to_internet_server_descriptor->rx_port_number = sptr_ip_parameters->rx_port_number;
	ptr_to_internet_server_descriptor->seq_offset = 0;

/* sudha 02-Feb-2000. For NAT active & pasv FTP support ... */
	ptr_to_internet_server_descriptor->ftp_pasv_mode_on = 0; 
	ptr_to_internet_server_descriptor->pasv_port = 0;
	ptr_to_internet_server_descriptor->ptr_to_ftp_command_descriptor = NULL;
	ptr_to_internet_server_descriptor->ptr_to_ftp_data_descriptor = NULL;
	ptr_to_internet_server_descriptor->connection_closing = FALSE;
/* ... sudha 02-Feb-2000. For NAT active & pasv FTP support */

	if (sptr_ip_parameters->protocol == IP_DATA_TCP)
		ptr_to_internet_server_descriptor->idle_timer = 600; /* 600 Secs */
	else 
		ptr_to_internet_server_descriptor->idle_timer = 60; /* 60 Secs */

/* sudha 02-Feb-2000. For NAT pasv FTP support */
	update_ftp_command_descriptor_info_if_pasv_ftp(uptr_ip_rx_packet, 
			sptr_ip_parameters, ptr_to_internet_server_descriptor);

#if 0	 
	printf ("\n\nPROXYN1:Destination address %04x\n",ptr_to_internet_server_descriptor->destination_address);
	printf ("\n\nPROXYN2:Source addres %04x\n",ptr_to_internet_server_descriptor->source_address);
	printf ("\n\nPROXYN3:Local mapped address %04x\n",ptr_to_internet_server_descriptor->local_mapped_address);
	printf ("\n\nPROXYN4:Adding new entries with ports %d %d\n",destination_port ,source_port);
	printf ("\n\nPROXYN5:Received port number is %d\n", ptr_to_internet_server_descriptor->rx_port_number);
#endif

	add_entry_to_list ((LINK *)&proxy_server.proxy_internet_server_list, (LINK *)ptr_to_internet_server_descriptor);
	return ptr_to_internet_server_descriptor;
}

enum BOOLEAN check_if_the_packet_is_from_a_local_server (BYTE *uptr_ip_rx_packet, 
		IP_PARAMETERS *sptr_ip_parameters, PROXY_INTERNET_SERVER_DESCRIPTOR **server_descriptor)
{
	
    PROXY_INTERNET_SERVER_DESCRIPTOR *sptr_internet_server_descriptor;
	USHORT destination_port=0, source_port=0;
   enum IP_PROTOCOL_VALUE protocol_type; /* Neelu */

	sptr_internet_server_descriptor = get_pointer_to_first_entry_in_list
						((LINK *)&proxy_server.proxy_internet_server_list);
	
	destination_port = get_application_port_number ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters, &source_port,&protocol_type);
	
	while (sptr_internet_server_descriptor != NULL)
	{
		switch (sptr_ip_parameters->protocol)
		{
         case IP_DATA_TCP:
			case IP_DATA_UDP:
				if (sptr_ip_parameters->source_address == sptr_internet_server_descriptor->local_mapped_address
					&& sptr_ip_parameters->destination_address == sptr_internet_server_descriptor->source_address
					&& sptr_ip_parameters->protocol == sptr_internet_server_descriptor->protocol
					&& destination_port == sptr_internet_server_descriptor->source_port)
				{
					*server_descriptor = sptr_internet_server_descriptor;
/* sudha 02-Feb-2000. For NAT active & pasv FTP support ... */
					if (sptr_ip_parameters->protocol == IP_DATA_TCP)
					{
						if (is_close_connection_initiated((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters) == TRUE)
						{
							proxy_printf ("PROXY : NAT TCP Connection is closed by %08x\n",
									uptr_ip_rx_packet->ip.header.source_ip_address); 

							sptr_internet_server_descriptor->connection_closing = TRUE;
							sptr_internet_server_descriptor->idle_timer = 60; /* 60 Secs */
						}

						if (sptr_internet_server_descriptor->connection_closing == FALSE)
						{
							if (sptr_internet_server_descriptor->ptr_to_ftp_command_descriptor)
							{
								sptr_internet_server_descriptor->ptr_to_ftp_command_descriptor->idle_timer = 600; /* 600 Secs */
							}
							sptr_internet_server_descriptor->idle_timer = 600; /* 600 Secs */
						}
					}
					else
					{
						sptr_internet_server_descriptor->idle_timer = 60; /* 60 Secs */
					}

/* ... sudha 02-Feb-2000. For NAT active & pasv FTP support */
/*					printf ("PROXY: Received packets from a local server\n");  */
					return TRUE;
				}
				break;

			case IP_DATA_ICMP:
				if (sptr_ip_parameters->source_address == sptr_internet_server_descriptor->local_mapped_address
					&& sptr_ip_parameters->destination_address == sptr_internet_server_descriptor->source_address
					&& sptr_ip_parameters->protocol == sptr_internet_server_descriptor->protocol)
				{
					*server_descriptor = sptr_internet_server_descriptor;
					sptr_internet_server_descriptor->idle_timer = 60; /* 60 Secs */
					return TRUE;
				}
				break;

			default:
				break;
		}
		sptr_internet_server_descriptor = (PROXY_INTERNET_SERVER_DESCRIPTOR *) get_pointer_to_next_entry_in_list ((LINK *)sptr_internet_server_descriptor);
	}
	return FALSE;
}


ULONG get_dynamic_server_address_from_port_number (USHORT application_port, USHORT protocol)
{
	USHORT server_index;
	PROXY_DYNAMIC_SERVER_LIST *sptr_dynamic_internet_server_list;

/* sudha 02-Feb-2000. For NAT active & pasv FTP support */
	PROXY_DYNAMIC_NAT_APP_LIST *temp_dynamic_internet_app_list; 

	sptr_dynamic_internet_server_list = proxy_server.dynamic_internet_server_list;
	switch (protocol)
	{
		case IP_DATA_TCP:
		case IP_DATA_UDP:
			for (server_index=0; server_index < proxy_server.total_number_of_dynamic_servers;
					server_index++, sptr_dynamic_internet_server_list++)
			{	
				if (application_port == sptr_dynamic_internet_server_list->application_port &&
						protocol == sptr_dynamic_internet_server_list->ip_protocol_type)			

				return (sptr_dynamic_internet_server_list->dynamic_server_ip_address);
			}

/* sudha 02-Feb-2000. For NAT active & pasv FTP support ... */
						
			temp_dynamic_internet_app_list = proxy_server.dynamic_nat_application_list;
			while(temp_dynamic_internet_app_list != NULL)
			{
				if ((application_port == temp_dynamic_internet_app_list->application_port) &&
					 (protocol == temp_dynamic_internet_app_list->ip_protocol_type))			
				{
					return (temp_dynamic_internet_app_list->dynamic_server_ip_address);
				}
				else
				{
					temp_dynamic_internet_app_list = temp_dynamic_internet_app_list->sptr_forward_link;
				}
			}
			break;
/* ... sudha 02-Feb-2000. For NAT active & pasv FTP support */

		case IP_DATA_ICMP:
			return (sptr_dynamic_internet_server_list->dynamic_server_ip_address);
			break;
	}
	return 0;
}


enum BOOLEAN check_if_the_destination_is_our_interface_address (ULONG destination_address)
{
	USHORT lan_ports=0, wan_ports, port_index;

	lan_ports = lsl_control(GET_NUMBER_OF_LAN_PORTS);
	wan_ports = lsl_control(GET_NUMBER_OF_WAN_PORTS);

	for (port_index=0; port_index < lan_ports+wan_ports; port_index++)
	{
/*	 	if (destination_address == get_ip_address (port_index+lan_ports)) */
	 	if (destination_address == get_ip_address (port_index+wan_ports))
		{
			return TRUE;
		}
	}
	return FALSE;
}


enum BOOLEAN check_if_the_packet_is_for_our_NAT_address (BYTE *uptr_ip_rx_packet, 
		IP_PARAMETERS *sptr_ip_parameters,ULONG *local_destination_ip_address, 
		enum BOOLEAN *is_my_packet)
{
	USHORT global_addr_index, source_port, destination_port;
	PROXY_NAT_ADDRESS_LIST *sptr_global_address_list;
   enum IP_PROTOCOL_VALUE protocol_type; /*Neelu */

	destination_port = get_application_port_number (uptr_ip_rx_packet, sptr_ip_parameters,
					&source_port,&protocol_type);

	if (sptr_ip_parameters->destination_address == proxy_server.proxy_local_internet_server_address)
	{
/* This packet is meant for dynamically configured servers 
	we need to get the local server address from dynamic server list */

	   *local_destination_ip_address = get_dynamic_server_address_from_port_number (destination_port, sptr_ip_parameters->protocol);

/* sudha 05-Feb-2000 ... */
		if (*local_destination_ip_address != 0x00000000L)
		{
			*is_my_packet = FALSE;
			return TRUE;
		}
/* ... sudha 05-Feb-2000 */
	}

	sptr_global_address_list = proxy_server.global_address_list;

#if Ravi
	for (global_addr_index = 0; global_addr_index <= proxy_server.total_number_of_global_address;
#endif

	for (global_addr_index = 0; global_addr_index < proxy_server.total_number_of_global_address;
			global_addr_index++, sptr_global_address_list++)				
	{
		if (sptr_ip_parameters->destination_address == sptr_global_address_list->global_address)
		{
			*local_destination_ip_address = sptr_global_address_list->local_address;
			*is_my_packet = FALSE;
			return TRUE;						
		}				
	}

	if (check_if_the_destination_is_our_interface_address (sptr_ip_parameters->destination_address) == TRUE)
	{
/* Added By Ravi on 12 March 1999 
   Synopsis : If the Internet Lan address is configured for DHCP Client,
  				  then the IP address obtained will be dynamic and hence
				  can't have a virtual mappings before hand. So While configuring
				  virtual server, have Global Ip address as 0.0.0.0. The check
				  is made for 0.0.0.0 and corresponding Local IP address is
  				  replaced. This is true only for Interface addresses.
*/
#if 0
		printf("\n Number of Dynamic Servers : %4x", proxy_server.total_number_of_dynamic_servers);
		printf("\n Global Dynamic Address : %8x", proxy_server.proxy_local_internet_server_address);
#endif

		if ((proxy_server.total_number_of_dynamic_servers != 0) &&
			 proxy_server.proxy_local_internet_server_address == 0)
		{
		   *local_destination_ip_address = get_dynamic_server_address_from_port_number (destination_port, sptr_ip_parameters->protocol);
/* sudha 05-Feb-2000 ... */
			if (*local_destination_ip_address != 0x00000000L)
			{
				*is_my_packet = FALSE;
				return TRUE;
			}
/* ... sudha 05-Feb-2000 */
		}

		sptr_global_address_list = proxy_server.global_address_list;

#if Ravi
		for (global_addr_index = 0; global_addr_index <= proxy_server.total_number_of_global_address;
#endif
		for (global_addr_index = 0; global_addr_index < proxy_server.total_number_of_global_address;
				global_addr_index++, sptr_global_address_list++)				
		{
			if (sptr_global_address_list->global_address == 0)
			{
				*local_destination_ip_address = sptr_global_address_list->local_address;
				*is_my_packet = FALSE;
				return TRUE;						
			}				
		}

/* sudha 15-Feb-2000 ... */
		if (sptr_ip_parameters->protocol == TCP_PROTOCOL)
		{
			if ((destination_port == TELNET_RESERVED_PORT) ||
			    (destination_port == WEB_RESERVED_PORT))
			{
				*local_destination_ip_address = 	get_ip_address (0);
				*is_my_packet = TRUE;
				return TRUE;
			}
			else
			{
				return FALSE;
			}
		}
		else if (sptr_ip_parameters->protocol == UDP_PROTOCOL)
		{
			*local_destination_ip_address = 	get_ip_address (0);
			*is_my_packet = TRUE;
			return TRUE;
		}
/* ... sudha 15-Feb-2000 */
	}
	return FALSE;	
}	

void process_ftp_port_command_and_update_descriptor_list (BYTE *uptr_ip_rx_packet,
		IP_PARAMETERS *sptr_ip_parameters)
{
	USHORT source_port=0;
	ULONG source_ip_address;
	BYTE *ptr_to_tcp_pkt;
	PROXY_INTERNET_SERVER_DESCRIPTOR *ptr_to_internet_server_descriptor;
	BYTE temp_buff[6];

	ptr_to_tcp_pkt = get_ptr_to_tcp_packet ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters);
	memcpy (temp_buff,ptr_to_tcp_pkt,4);
	temp_buff[4] = 0;
	if (strcmpi (temp_buff, "Port"))
	{
		return;
	}

	printf ("PROXY: FTP port command detected\n");
/* sudha 02-Feb-2000. changed "malloc" to "calloc" */
	ptr_to_internet_server_descriptor = (PROXY_INTERNET_SERVER_DESCRIPTOR *)
							calloc (sizeof (PROXY_INTERNET_SERVER_DESCRIPTOR), 1);

	if (ptr_to_internet_server_descriptor == NULL)
	{
		printf ("PROXY :Error Allocating Memory\n");
		return ;
	}

	get_ftp_src_port_and_address (ptr_to_tcp_pkt, &source_port, &source_ip_address);

	ptr_to_internet_server_descriptor->destination_address = sptr_ip_parameters->destination_address; 
	ptr_to_internet_server_descriptor->source_address = sptr_ip_parameters->source_address; 
	ptr_to_internet_server_descriptor->protocol = sptr_ip_parameters->protocol;
	ptr_to_internet_server_descriptor->destination_port = proxy_server.ftp_data_conn_port;
	ptr_to_internet_server_descriptor->source_port = source_port;
	ptr_to_internet_server_descriptor->rx_port_number = sptr_ip_parameters->rx_port_number;
	ptr_to_internet_server_descriptor->seq_offset = 0;
	ptr_to_internet_server_descriptor->idle_timer = 600; /* 600 Secs */

#if 0
	printf ("Destination address %04x\n",ptr_to_internet_server_descriptor->destination_address);
	printf ("Source addres %04x\n",ptr_to_internet_server_descriptor->source_address);
	printf ("Local mapped address %04x\n",ptr_to_internet_server_descriptor->local_mapped_address);
	printf ("Adding new entries with ports %d\n",source_port);
	printf ("Received port number is %d\n", ptr_to_internet_server_descriptor->rx_port_number);
#endif

	add_entry_to_list ((LINK *)&proxy_server.proxy_internet_server_list, (LINK *)ptr_to_internet_server_descriptor);
	return;		 	
}



void process_packets_meant_for_local_servers (UNION_IP_PACKET *uptr_ip_rx_packet, 
		IP_PARAMETERS *sptr_ip_parameters, ULONG local_destination_address,
		PROXY_INTERNET_SERVER_DESCRIPTOR *server_descriptor_info)
{
	USHORT destination_port=0, source_port=0;
   enum IP_PROTOCOL_VALUE protocol_type; /*Neelu */
  
   sptr_ip_parameters->destination_address = local_destination_address;
	uptr_ip_rx_packet->ip.header.destination_ip_address = local_destination_address;

   switch (sptr_ip_parameters->protocol)
	{
		case IP_DATA_TCP:
			destination_port = get_application_port_number ((BYTE *) uptr_ip_rx_packet,
											sptr_ip_parameters, &source_port,&protocol_type);
        
			if (destination_port == proxy_server.ftp_ctrl_conn_port)
			{
/*			 	process_ftp_port_command_and_update_descriptor_list ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters ); */
/*				modify_tcp_acknowledge_field ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters, server_descriptor_info->seq_offset); */
			}

/* sudha 02-Feb-2000. For NAT pasv FTP support ... */			
			if(server_descriptor_info->ftp_pasv_mode_on)
			{
				modify_tcp_acknowledge_field ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters, server_descriptor_info->seq_offset);
			}

			update_tcp_checksum_in_packet (uptr_ip_rx_packet, sptr_ip_parameters); 
			break;

		case IP_DATA_UDP:
			update_udp_checksum_in_packet (uptr_ip_rx_packet, sptr_ip_parameters); 
			break;

		case IP_DATA_ICMP:
        break;
	}
}


void process_the_ftp_packet_after_pasv_commd (UNION_IP_PACKET *uptr_ip_rx_packet, 
		IP_PARAMETERS *sptr_ip_parameters, PROXY_INTERNET_SERVER_DESCRIPTOR *server_descriptor_info, enum BOOLEAN *ftp_pasv_mode)
{
	BYTE *ptr_to_tcp_packet;
	int old_length, new_length ;
	BYTE ip_address[20], port_buff[10];
	USHORT number_of_commas=0, buffer_index=0, port_index=0;
	
/* sudha 02-Feb-2000. For NAT pasv FTP support ... */	
	USHORT port1, port2, new_port_number;
	PROXY_DYNAMIC_NAT_APP_LIST *ptr_to_nat_app_list;	

	ptr_to_tcp_packet = get_ptr_to_tcp_packet ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters) ;
	old_length = get_port_command_length (ptr_to_tcp_packet) ;

	if (strstr (ptr_to_tcp_packet, "227 Entering Passive Mode") == NULL)
	{
/* sudha 02-Feb-2000. For NAT pasv FTP support */
		*ftp_pasv_mode = FALSE;
		return;
	}

/* sudha 02-Feb-2000. For NAT pasv FTP support ... */
	ptr_to_nat_app_list = (PROXY_DYNAMIC_NAT_APP_LIST *) calloc (sizeof (PROXY_DYNAMIC_NAT_APP_LIST), 1);
	if (ptr_to_nat_app_list == NULL)
	{
		printf ("PROXY : Not Enough memory add application\n");
		return;
	} 

	ptr_to_nat_app_list->dynamic_server_ip_address = server_descriptor_info->local_mapped_address;
	ptr_to_nat_app_list->ip_protocol_type = server_descriptor_info->protocol;
/* ... sudha 02-Feb-2000. For NAT pasv FTP support */

	convert_ip_address_to_dot_format (&ip_address[0], server_descriptor_info->destination_address);
	for (buffer_index = 0 ; ip_address[buffer_index] ; buffer_index++)
	{
		if (ip_address[buffer_index] == '.')
		{
			ip_address[buffer_index] = ',' ;
		}
	}
			
	for (buffer_index =0; ptr_to_tcp_packet[buffer_index] != 0x0A; buffer_index++)
	{
/* sudha 02-Feb-2000. For NAT pasv FTP support ... */
		if (number_of_commas == 4)
		{
			if((ptr_to_tcp_packet[buffer_index] == 0x0D) || 
				(ptr_to_tcp_packet[buffer_index] == ')'))
			{
				break;
			}

			port_buff[port_index] = ptr_to_tcp_packet[buffer_index];
			port_index++;
			continue;
		}
		if (ptr_to_tcp_packet[buffer_index] == ',')
		{
			number_of_commas++;
		}
	}
	port_buff[port_index] = 0;

	sprintf (&ptr_to_tcp_packet[0], "227 Entering Passive Mode (%s,%s)\x0D\x0A",
			&ip_address[0], &port_buff[0]);

	sscanf (port_buff ,"%hu,%hu",&port1, &port2);		
	
	port1 = port1 & 0x00ff;
	port1 = port1 << 8;
	port2 = port2 &0x00ff;
	new_port_number = (port1 | port2);
	ptr_to_nat_app_list->application_port = new_port_number;

	server_descriptor_info->pasv_port = new_port_number;

	ptr_to_nat_app_list->sptr_forward_link = proxy_server.dynamic_nat_application_list;
	proxy_server.dynamic_nat_application_list = ptr_to_nat_app_list;
	
	new_length = get_port_command_length (ptr_to_tcp_packet) ;

	uptr_ip_rx_packet->ip.header.total_length += (new_length - old_length) ;
	sptr_ip_parameters->total_length += (new_length - old_length) ;

	server_descriptor_info->seq_offset += new_length - old_length;

	*ftp_pasv_mode = TRUE;
	server_descriptor_info->ftp_pasv_mode_on = TRUE;
/* ... sudha 02-Feb-2000. For NAT pasv FTP support */

	return;
}

/* sudha 02-Feb-2000. Included one var "ftp_pasv_mode" for NAT pasv FTP support */
void process_packets_from_local_servers (UNION_IP_PACKET *uptr_ip_rx_packet,
		IP_PARAMETERS *sptr_ip_parameters, PROXY_INTERNET_SERVER_DESCRIPTOR *server_descriptor_info, enum BOOLEAN *ftp_pasv_mode)
{
	USHORT source_port=0, destination_port=0;
	BYTE *sptr_icmp_header;
	USHORT new_checksum=0;
   enum IP_PROTOCOL_VALUE protocol_type; /*Neelu */
	
   sptr_ip_parameters->source_address = server_descriptor_info->destination_address;
	uptr_ip_rx_packet->ip.header.source_ip_address = server_descriptor_info->destination_address;

	switch (sptr_ip_parameters->protocol)
	{
		case IP_DATA_TCP:
			destination_port = get_application_port_number ((BYTE *) uptr_ip_rx_packet, 
					sptr_ip_parameters, &source_port,&protocol_type);				

/* sudha 02-Feb-2000. For NAT pasv FTP support ... */
			if (server_descriptor_info->ftp_pasv_mode_on)	
			{
				modify_tcp_seq_number_field ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters, server_descriptor_info->seq_offset);
			}

			if (source_port == proxy_server.ftp_ctrl_conn_port)
			{
				process_the_ftp_packet_after_pasv_commd (uptr_ip_rx_packet, sptr_ip_parameters, server_descriptor_info, ftp_pasv_mode);
			}

/* ... sudha 02-Feb-2000. For NAT pasv FTP support */

			update_tcp_checksum_in_packet (uptr_ip_rx_packet, sptr_ip_parameters); 
			break;
		 	
		case IP_DATA_UDP:
			update_udp_checksum_in_packet (uptr_ip_rx_packet, sptr_ip_parameters); 
			break;

		case IP_DATA_ICMP:
#if 0
			sptr_icmp_header = get_ptr_to_icmp_header (uptr_ip_rx_packet, sptr_ip_parameters);		 
			set_icmp_checksum (sptr_icmp_header, 0);
			new_checksum =	calculate_ip_checksum (NULL, 
					(BYTE *)sptr_icmp_header, (USHORT) (sptr_ip_parameters->total_length- sptr_ip_parameters->header_length));
			set_icmp_checksum (sptr_icmp_header, new_checksum);
#endif
			break;
	}
	return;
}


/* sudha 02-Feb-2000. Included one var "ftp_pasv_mode" for NAT pasv FTP support */
enum BOOLEAN check_and_process_the_packets_to_or_from_internet_servers (UNION_IP_PACKET *uptr_ip_rx_packet,
		IP_PARAMETERS *sptr_ip_parameters, USHORT *outgoing_port_number, enum BOOLEAN *is_my_packet, enum BOOLEAN *ftp_pasv_mode)
{
	ULONG local_destination_address;
	PROXY_INTERNET_SERVER_DESCRIPTOR *server_descriptor_info;

/* Ravi on 27-Jan-2000 ... */
	if (!is_secured_lan_port(sptr_ip_parameters->rx_port_number))
	{
/* ... Ravi on 27-Jan-2000 */
		if (check_if_the_packet_is_for_our_NAT_address ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters, &local_destination_address, is_my_packet) == TRUE)
		{
   	   server_descriptor_info = update_descriptor_list_for_local_servers ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters,
					local_destination_address);

			if (server_descriptor_info == NULL)
		      return FALSE;

 			process_packets_meant_for_local_servers (uptr_ip_rx_packet, sptr_ip_parameters,
				local_destination_address, server_descriptor_info);

			*outgoing_port_number = 0;
   	   return TRUE;
		}
	}

	if (check_if_the_packet_is_from_a_local_server ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters, 
		&server_descriptor_info) == TRUE)
	{  
/* sudha 02-Feb-2000. Added "ftp_pasv_mode" for NAT pasv FTP support */
		process_packets_from_local_servers (uptr_ip_rx_packet, sptr_ip_parameters,
			server_descriptor_info, ftp_pasv_mode);
		*outgoing_port_number = server_descriptor_info->rx_port_number;

/*      printf("\nPROXY1:outgoing_port_number=%d",outgoing_port_number);*/

      return TRUE;
	}
	return FALSE;
}	

