#include "defs.h"
#include <stdio.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>

#include <kstart.h>

#include <redblack.h>
#include "proxyrb.h"

#define PROXY_RB_INSERT_OVERFLOW 0
#define PROXY_RB_NEW_ENTRY 1
#define PROXY_RB_UPDATED 2


/* Define this and do operations like copying and comparisons more optimally */
#define PROXY_CUSTOM_OPERATIONS 1
#define PROXY_RB_STATISTICS 0

/* #if PROXY_RB_STATISTICS*/
static struct
{
	unsigned long number_of_nodes ; /* (PROXY_RB_NEW_ENTRY) */
	unsigned long number_of_search_hits ;
	unsigned long number_of_insert_hits ; /* (PROXY_RB_UPDATED) */
	unsigned long number_of_insert_overflows ;
   unsigned long number_of_deletions ;
} statistics ;
/* #endif */

/* The following need to defined for the specific application */


PROXY_APPLICATION_LIST_NODE *sptr_proxy_address_tree ;
ULONG proxy_descriptor_rb_node_age = 5 * 20 ;

static PROXY_APPLICATION_LIST_NODE *get_new_proxy_rb_node ()
{
#if PROXY_CUSTOM_OPERATIONS
	return ((PROXY_APPLICATION_LIST_NODE *) malloc (sizeof (PROXY_APPLICATION_LIST_NODE))) ;
#else
	return ((PROXY_APPLICATION_LIST_NODE *) malloc (sizeof (PROXY_APPLICATION_LIST_NODE))) ;
#endif
}

static void free_proxy_rb_node (PROXY_APPLICATION_LIST_NODE *sptr_node)
{
#if PROXY_CUSTOM_OPERATIONS
	free (sptr_node) ;
#else
	free (sptr_node) ;
#endif
}


int proxy_RB_demo_insert_node(PROXY_APPLICATION_LIST_NODE *Tree, PROXY_RB_KEY_TYPE key, PROXY_RB_INFO_TYPE info, PROXY_APPLICATION_LIST_NODE **ptr_sptr_new_node)
{
	PROXY_APPLICATION_LIST_NODE *nptr ;

	int retVal ;

#if 0
#if PROXY_CUSTOM_OPERATIONS
	retVal = _fmemcmp((unsigned char *)&Tree->key, (unsigned char *)&key, sizeof (PROXY_RB_KEY_TYPE)) ;
#else
	retVal = _fmemcmp((unsigned char *)&Tree->key, (unsigned char *)&key, sizeof (PROXY_RB_KEY_TYPE)) ;
#endif
#endif

	retVal = rb_demo_compare_key(Tree, key);	

	if (retVal < 0)
	{
		if (Tree->rb_header.RChild != sptr_RB_sentinal_node)
			return (proxy_RB_demo_insert_node ((PROXY_APPLICATION_LIST_NODE *)Tree->rb_header.RChild, key, info, ptr_sptr_new_node)) ;
		else
		{
			*ptr_sptr_new_node = nptr = get_new_proxy_rb_node() ;
			if (nptr == NULL)
			{
#if PROXY_RB_STATISTICS
				statistics.number_of_insert_overflows++ ;
#endif
				return PROXY_RB_INSERT_OVERFLOW ;
			}
			nptr->rb_header.LChild = nptr->rb_header.RChild = sptr_RB_sentinal_node ;
#if PROXY_CUSTOM_OPERATIONS
			nptr->key = key ;
			nptr->info = info ;
#else
			nptr->key = key ;
			nptr->info = info ;
#endif

			nptr->rb_header.Color = COLOR_RED ;
			nptr->rb_header.Parent = (RED_BLACK_NODE_HEADER *)Tree ;
			Tree->rb_header.RChild = (RED_BLACK_NODE_HEADER *)nptr ;
/* #if PROXY_RB_STATISTICS */
			statistics.number_of_nodes++ ;
/* #endif */
			return PROXY_RB_NEW_ENTRY ;
		}
	}
	else if (retVal > 0)
	{
		if (Tree->rb_header.LChild != sptr_RB_sentinal_node)
		{
			return (proxy_RB_demo_insert_node ((PROXY_APPLICATION_LIST_NODE *)Tree->rb_header.LChild, key, info, ptr_sptr_new_node)) ;
		}
		else
		{
			*ptr_sptr_new_node = nptr = get_new_proxy_rb_node() ;
			if (nptr == NULL)
			{
#if PROXY_RB_STATISTICS
				statistics.number_of_insert_overflows++ ;
#endif
				return PROXY_RB_INSERT_OVERFLOW ;
			}
			nptr->rb_header.LChild = nptr->rb_header.RChild = sptr_RB_sentinal_node ;
#if PROXY_CUSTOM_OPERATIONS
			nptr->key = key ;
			nptr->info = info ;
#else
			nptr->key = key ;
			nptr->info = info ;
#endif
			nptr->rb_header.Color = COLOR_RED ;
			nptr->rb_header.Parent = (RED_BLACK_NODE_HEADER *) Tree ;
			Tree->rb_header.LChild = (RED_BLACK_NODE_HEADER *) nptr ;
/* #if PROXY_RB_STATISTICS */
			statistics.number_of_nodes++ ;
/* #endif */
			return PROXY_RB_NEW_ENTRY ;
		}
	}
#if PROXY_CUSTOM_OPERATIONS
	/* Here is where you should be putting in things like updating
	the information fields and things like that. For example you
	may want to reset an age field or update some field like
	information_source_port .... */
#endif
#if PROXY_RB_STATISTICS
	statistics.number_of_insert_hits++ ;
#endif
	return PROXY_RB_UPDATED ;
}


int proxy_RB_demo_insert(PROXY_RB_KEY_TYPE key, PROXY_RB_INFO_TYPE info)
{
	PROXY_APPLICATION_LIST_NODE *nptr, *sptr_new_node ;
	int retVal ;

	if (sptr_proxy_address_tree == (PROXY_APPLICATION_LIST_NODE *)sptr_RB_sentinal_node)
	{
		nptr = get_new_proxy_rb_node() ;
		if (nptr == NULL)
		{
#if PROXY_RB_STATISTICS
			statistics.number_of_insert_overflows++ ;
#endif
			return PROXY_RB_INSERT_OVERFLOW ;
		}
#if PROXY_CUSTOM_OPERATIONS
		nptr->key = key ;
		nptr->info = info ;
#else
		nptr->key = key ;
		nptr->info = info ;
#endif
		nptr->rb_header.Color = COLOR_BLACK ;
		nptr->rb_header.Parent = nptr->rb_header.RChild = nptr->rb_header.LChild = sptr_RB_sentinal_node ;
		sptr_proxy_address_tree = nptr ;
/* #if PROXY_RB_STATISTICS */
		statistics.number_of_nodes++ ;
/* #endif */
		return PROXY_RB_NEW_ENTRY ;
	}

	retVal = proxy_RB_demo_insert_node (sptr_proxy_address_tree, key, info, &sptr_new_node) ;

	if (retVal == PROXY_RB_NEW_ENTRY)
	{
		sptr_proxy_address_tree = (PROXY_APPLICATION_LIST_NODE *) RB_red_balance ((RED_BLACK_NODE_HEADER *)sptr_new_node, (RED_BLACK_NODE_HEADER *)sptr_proxy_address_tree) ;
	}
	return retVal ;
}


PROXY_APPLICATION_LIST_NODE *proxy_rb_demo_search(PROXY_APPLICATION_LIST_NODE *Tree, PROXY_RB_KEY_TYPE key)
{
	int ret_val ;

	if (Tree == (PROXY_APPLICATION_LIST_NODE  *)sptr_RB_sentinal_node)
		return NULL ;

#if 0			/* Sri */
#if PROXY_CUSTOM_OPERATIONS
	ret_val = _fmemcmp((unsigned char *)&Tree->key, (unsigned char *)&key, sizeof (PROXY_RB_KEY_TYPE)) ;
#else
	ret_val = _fmemcmp((unsigned char *)&Tree->key, (unsigned char *)&key, sizeof (PROXY_RB_KEY_TYPE)) ;
#endif
#endif
	ret_val = rb_demo_compare_key(Tree, key);	

	if (ret_val < 0)
	{
		return proxy_rb_demo_search ((PROXY_APPLICATION_LIST_NODE *)Tree->rb_header.RChild, key) ;
	}
	else if (ret_val > 0)
	{	
	 	return proxy_rb_demo_search((PROXY_APPLICATION_LIST_NODE *)Tree->rb_header.LChild, key) ;
	}
		else
		{
#if PROXY_RB_STATISTICS
			statistics.number_of_search_hits++ ;
#endif	

			return Tree ;
		}
} 

#if 0
extern unsigned long scc1_collision_errors ;
extern unsigned long scc1_overflow_errors ;
extern unsigned long scc1_CRC_errors ;
extern unsigned long scc1_short_frame_errors ;
extern unsigned long scc1_non_octet_aligned_frame_errors ;
extern unsigned long scc1_frame_length_violation_errors ;
#define PRINT_BUFFER_SIZE 1000
char print_buffer[PRINT_BUFFER_SIZE] ;

void display_proxy_tree ()
{
#if 0
	int index=0 ;
	PROXY_APPLICATION_LIST_NODE  *sptr_root = sptr_proxy_address_tree;
	PROXY_APPLICATION_LIST_NODE  *sptr_next_node = (PROXY_APPLICATION_LIST_NODE *) RB_get_first_node ((RED_BLACK_NODE_HEADER *)sptr_root) ;
	
	printf ("\n\nPROXY: Displaying Redblack Tree.....\n") ;
	while (sptr_next_node)
	{
		printf ("[%d]. %d      %d\n", ++index, sptr_next_node->key.protocol_type,
						sptr_next_node->key.application_port);
					
		sptr_next_node = (PROXY_APPLICATION_LIST_NODE *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;
	}

#endif

#if 1
	BYTE application_buffer[200], temp_buffer[100];
	USHORT index = 0 ;
   PROXY_APPLICATION_LIST_NODE *sptr_root = sptr_proxy_address_tree ;
	PROXY_APPLICATION_LIST_NODE *sptr_next_node = (PROXY_APPLICATION_LIST_NODE *) RB_get_first_node ((RED_BLACK_NODE_HEADER *)sptr_root) ;
		
	application_buffer[0] = 0 ;
	printf ("\nPROXY: Proxy Server Configuration...............\n") ;
	printf ("Number of Applications %d\n",statistics.number_of_nodes);
	while (sptr_next_node)
	{
		if (index && ((index % 3) == 0))
		{
			printf ("%s", &application_buffer[0]) ;
			application_buffer[0] = 0 ;
		}
		sprintf (&temp_buffer[0], "\tProtocol : %04d Application : %04d\n",
					sptr_next_node->key.protocol_type,
					sptr_next_node->key.application_port);
		strcat (&application_buffer[0], &temp_buffer[0]) ;
		index++;
		sptr_next_node = (PROXY_APPLICATION_LIST_NODE *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;
	}
#endif
	return ;
}

#endif

void add_entry_to_proxy_rb_tree (BYTE same_port_required, unsigned char *vptr_buffer)
{
   PROXY_RB_INFO_TYPE info ;
	
	if (sptr_proxy_address_tree == NULL)
		sptr_proxy_address_tree = (PROXY_APPLICATION_LIST_NODE *) sptr_RB_sentinal_node;


   info.same_port_required = same_port_required;

   proxy_RB_demo_insert (*((PROXY_RB_KEY_TYPE *)(vptr_buffer)), info) ;
}

#define TEMP 0
void initialize_proxy_rb_tree ()
{
#if TEMP
   PROXY_RB_KEY_TYPE proxy_descriptor_key ;
   int i ;
   PROXY_RB_INFO_TYPE info ;

   info.age = proxy_descriptor_rb_node_age ;
#endif

   sptr_proxy_address_tree = (PROXY_APPLICATION_LIST_NODE *) sptr_RB_sentinal_node ;

#if TEMP
   ethernet_address.ethernet_address_ulong = 0x00FFFFFF ;
   ethernet_address.ethernet_address_ushort = 0xFFFF ;

   for (i = 0 ; i < 300 ; i++)
   {
      proxy_RB_demo_insert (ethernet_address, info) ;
      ethernet_address.ethernet_address_ulong-- ;
   }
#endif
}


int delete_entry_from_proxy_rb_tree (PROXY_RB_KEY_TYPE key)
{
   PROXY_APPLICATION_LIST_NODE *sptr_node_to_delete ;

   sptr_node_to_delete = proxy_rb_demo_search (sptr_proxy_address_tree, key) ;
   if (sptr_node_to_delete)
   {
#if PROXY_RB_STATISTICS
      statistics.number_of_deletions++ ;
#endif
      RB_delete ((RED_BLACK_NODE_HEADER *)sptr_proxy_address_tree, (RED_BLACK_NODE_HEADER *)sptr_node_to_delete, (unsigned long) sizeof (PROXY_APPLICATION_LIST_NODE), (RED_BLACK_NODE_HEADER **)&sptr_node_to_delete) ;
      return (1) ;
   }
   return (0) ;
}



void age_proxy_rb_tree ()
{
#if 0
	PROXY_APPLICATION_LIST_NODE *sptr_temp, *sptr_next_node = (PROXY_APPLICATION_LIST_NODE *) RB_get_first_node ((RED_BLACK_NODE_HEADER *)sptr_proxy_address_tree) ;

   while (sptr_next_node)
   {
      sptr_temp = sptr_next_node ;
      sptr_next_node = (PROXY_APPLICATION_LIST_NODE *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;
      if (sptr_temp->info.age)
      {
         sptr_temp->info.age-- ;
      }
      else
      {
#if 0
         sptr_proxy_address_tree = (PROXY_APPLICATION_LIST_NODE *)
            RB_delete((RED_BLACK_NODE_HEADER *)sptr_temp,
                      (RED_BLACK_NODE_HEADER *)sptr_proxy_address_tree,
                      (unsigned long) sizeof (PROXY_APPLICATION_LIST_NODE),
                      (RED_BLACK_NODE_HEADER **)&sptr_temp) ;
#endif
      }
   }
#endif
}

void delete_aged_out_entries_in_proxy_rb_tree (void)
{
	PROXY_APPLICATION_LIST_NODE *x, *sptr_next_node = (PROXY_APPLICATION_LIST_NODE *) RB_get_first_node ((RED_BLACK_NODE_HEADER  *)sptr_proxy_address_tree) ;
   
#if 0
   while (sptr_next_node)
   {
      if (sptr_next_node->info.same_port_required)
      {
      }
      else
      {
         sptr_proxy_address_tree = (PROXY_APPLICATION_LIST_NODE  *)
            RB_delete((RED_BLACK_NODE_HEADER *)sptr_next_node,
                      (RED_BLACK_NODE_HEADER *)sptr_proxy_address_tree,
                      (unsigned long) sizeof (PROXY_APPLICATION_LIST_NODE),
                      (RED_BLACK_NODE_HEADER **)&x) ;
#if PROXY_RB_STATISTICS
         statistics.number_of_deletions++ ;
#endif
         free_proxy_rb_node (x) ;
         /* In one pass, delete just one. In fact as an optimization,
         we can keep track of the existence of aged out entries in
         a class variable so that we dont even need to call this function
         in case there are no aged entries */
         return ;
      }
      sptr_next_node = (PROXY_APPLICATION_LIST_NODE *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;
   }
#endif
}



#define PRINT_BUFFER_SIZE 1000
static char pr_print_buffer[PRINT_BUFFER_SIZE] ;
void display_proxy_tree ()
{
	int i = 1, j ;
	unsigned char ch ;
	unsigned char  *x ;
	char *print_buffer_ptr = &pr_print_buffer[0] ;
	int print_buffer_length = 0 ;
   PROXY_APPLICATION_LIST_NODE  *sptr_root = sptr_proxy_address_tree ;
	PROXY_APPLICATION_LIST_NODE  *sptr_next_node = (PROXY_APPLICATION_LIST_NODE  *) RB_get_first_node ((RED_BLACK_NODE_HEADER  *)sptr_root) ;

	printf ("\n\nDisplaying Redblack Tree.....\n") ;
	while (sptr_next_node)
	{
		sprintf (print_buffer_ptr, "\n\tNode %04d : ", i++) ;
		print_buffer_ptr += 14 ;
		print_buffer_length += 14 ;
		if (print_buffer_length >= PRINT_BUFFER_SIZE - 50)
		{
			*print_buffer_ptr = 0 ;
			printf ("%s", &pr_print_buffer[0]) ;
			print_buffer_ptr = &pr_print_buffer[0] ;
			print_buffer_length = 0 ;
		}
		x = (unsigned char *) &sptr_next_node->key ;
		for (j = 0 ; j < sizeof (PROXY_RB_KEY_TYPE) ; j++)
		{
			ch =  *x++ ;
			sprintf (print_buffer_ptr, "%02X", ch) ;
			print_buffer_ptr += 2 ;
			print_buffer_length += 2 ;
			if (print_buffer_length >= PRINT_BUFFER_SIZE - 50)
			{
				*print_buffer_ptr = 0 ;
				printf ("%s", &pr_print_buffer[0]) ;
				print_buffer_ptr = &pr_print_buffer[0] ;
				print_buffer_length = 0 ;
			}
		}
#if 0
      sprintf (print_buffer_ptr, ", Age : %04d seconds", sptr_next_node->info.age/20) ;
		print_buffer_ptr += 20 ;
		print_buffer_length += 20 ;
#endif
		if (print_buffer_length >= PRINT_BUFFER_SIZE - 50)
		{
			*print_buffer_ptr = 0 ;
			printf ("%s", &pr_print_buffer[0]) ;
			print_buffer_ptr = &pr_print_buffer[0] ;
			print_buffer_length = 0 ;
		}
#if 0
      sprintf (print_buffer_ptr, ", Port : %04d", sptr_next_node->info.port_number) ;
		print_buffer_ptr += 13 ;
		print_buffer_length += 13 ;
#endif
		if (print_buffer_length >= PRINT_BUFFER_SIZE - 50)
		{
			*print_buffer_ptr = 0 ;
			printf ("%s", &pr_print_buffer[0]) ;
			print_buffer_ptr = &pr_print_buffer[0] ;
			print_buffer_length = 0 ;
		}


		if (sptr_next_node == sptr_root)
		{
			sprintf (print_buffer_ptr, " (ROOT)") ;
			print_buffer_ptr += 7 ;
			print_buffer_length += 7 ;
			if (print_buffer_length >= PRINT_BUFFER_SIZE - 50)
			{
				*print_buffer_ptr = 0 ;
				printf ("%s", &pr_print_buffer[0]) ;
				print_buffer_ptr = &pr_print_buffer[0] ;
				print_buffer_length = 0 ;
			}
		}
		sptr_next_node = (PROXY_APPLICATION_LIST_NODE *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;
	}

	if (print_buffer_length)
		printf ("%s\n\n", &pr_print_buffer[0]) ;
	
	return ;
}

/* Added by Sreelu */
int rb_demo_compare_key(PROXY_APPLICATION_LIST_NODE *Tree, PROXY_RB_KEY_TYPE key)
{
#if 0
	printf("Application Tree Parameter:.......\n");
	printf("\n \nProtocol Value :%d\nApplication Port :%d",Tree->key.protocol_type,Tree->key.application_port);
	printf("Application Key Parameter:........\n");
	printf("\n \nProtocol Value :%d\nApplication Port :%d",key.protocol_type,key.application_port);
#endif
	if(Tree->key.protocol_type == key.protocol_type)
	{
		if(Tree->key.application_port == key.application_port)
			return 0;
		else
			return(Tree->key.application_port - key.application_port);			
	}
	else
	{
		return(Tree->key.protocol_type - key.protocol_type);			
	}
}		
		
