#ifndef _PROXY_RB_
#define _PROXY_RB_

#define COLOR_BLACK 0
#define COLOR_RED 1


#define PROXY_RB_INSERT_OVERFLOW 0
#define PROXY_RB_NEW_ENTRY 1
#define PROXY_RB_UPDATED 2



/* for application list handling */


typedef struct
{
	USHORT protocol_type; 
	USHORT application_port;
} PROXY_RB_KEY_TYPE ;

typedef struct
{
	BYTE same_port_required;
/*	unsigned long age ; */
} PROXY_RB_INFO_TYPE ;

typedef struct
{
	RED_BLACK_NODE_HEADER rb_header ;
	PROXY_RB_KEY_TYPE key ;
	PROXY_RB_INFO_TYPE info ;
} PROXY_APPLICATION_LIST_NODE ;

/* for application list handling */

/* for descriptor handling in forward direction */

typedef struct
{
	ULONG client_ip_address;
	BYTE protocol_type; 
	USHORT application_port;
} PROXY_RB_CLIENT_KEY_TYPE;

typedef struct
{
	BYTE *client_descriptor ;
} PROXY_RB_CLIENT_INFO_TYPE ;

typedef struct
{
	RED_BLACK_NODE_HEADER rb_header ;
	PROXY_RB_CLIENT_KEY_TYPE key ;
	PROXY_RB_CLIENT_INFO_TYPE info ;
} PROXY_CLIENT_DESCRIPTOR_NODE ;



/* -----for descriptor handling in reverse direction ----------------------*/

typedef struct
{
	BYTE protocol_type; 
	USHORT application_port;
} PROXY_RB_SERVER_KEY_TYPE;

typedef struct
{
	BYTE *server_descriptor ;
} PROXY_RB_SERVER_INFO_TYPE ;

typedef struct
{
	RED_BLACK_NODE_HEADER rb_header ;
	PROXY_RB_SERVER_KEY_TYPE key ;
	PROXY_RB_SERVER_INFO_TYPE info ;
} PROXY_SERVER_DESCRIPTOR_NODE ;


typedef struct
{
	ULONG source_ip_address;
} PROXY_LINKCTRL_RB_KEY_TYPE ;

typedef struct
{
	ULONG aging_timeout ;
} PROXY_LINKCTRL_RB_INFO_TYPE ;

typedef struct
{
	RED_BLACK_NODE_HEADER rb_header ;
	PROXY_LINKCTRL_RB_KEY_TYPE key ;
	PROXY_LINKCTRL_RB_INFO_TYPE info ;
}PROXY_LINKCTRL_DESCRIPTOR_NODE ;

typedef struct RBTreeNode {
	struct RBTreeNode *Parent ;
	struct RBTreeNode *LChild ;
	struct RBTreeNode *RChild ;
	BYTE Color ;
   PROXY_RB_KEY_TYPE key_type ;
} RBTreeNodeType;

/*RBTreeNodeType SentinalNode = {NULL, NULL, NULL, 0, 1, '1'};*/
#define SentinalNode NULL

/* The following macro compares two ethernet addresses */
#define EQUAL(a, b) ((*((ULONG *)(a)) - *((ULONG *)(b))) : \
                     (*((ULONG *)(a)) - *((ULONG *)(b))) ?  \
                     (*((USHORT *)((BYTE *)(a)+4)) - *((USHORT *)((BYTE *)(b)+4))))

extern RBTreeNodeType *RBTreeInsert(RBTreeNodeType *, BYTE *);
extern RBTreeNodeType *RBNodeDelete(RBTreeNodeType *root, BYTE *string_to_search);
extern RBTreeNodeType *RBTreeSearch(RBTreeNodeType *Tree,BYTE *key_to_be_searched);
extern ULONG Number_Of_Nodes_In_RBTree(RBTreeNodeType *Tree);
extern RBTreeNodeType *RBReadFirst(RBTreeNodeType *);
extern RBTreeNodeType *RBReadNext(RBTreeNodeType *);

#endif
