/*--------------------------------------------------------------------------*\

Changes History : 

{sudha 07-Feb-2000. virtual server loopback support}

\*--------------------------------------------------------------------------*/

#include "defs.h"
#include <stdio.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>

#include <kstart.h>
#include "proxy.h" /* Added by Ravi */

#include <redblack.h>
#include "proxyrb.h"

#define PROXY_RB_INSERT_OVERFLOW 0
#define PROXY_RB_NEW_ENTRY 1
#define PROXY_RB_UPDATED 2


/* Define this and do operations like copying and comparisons more optimally */
#define PROXY_CUSTOM_OPERATIONS 1
#define PROXY_RB_STATISTICS 0

/* #if PROXY_RB_STATISTICS*/
static struct
{
	unsigned long number_of_nodes ; /* (PROXY_RB_NEW_ENTRY) */
	unsigned long number_of_search_hits ;
	unsigned long number_of_insert_hits ; /* (PROXY_RB_UPDATED) */
	unsigned long number_of_insert_overflows ;
   unsigned long number_of_deletions ;
} statistics ;
/* #endif */

/* The following need to defined for the specific application */


PROXY_SERVER_DESCRIPTOR_NODE far *sptr_proxy_server_descriptor_tree ;
/* sudha 07-Feb-2000 ... */
#ifdef __VIRTUAL_SERVER_LOOPBACK__ 
PROXY_SERVER_DESCRIPTOR_NODE far *sptr_virtual_server_loopback_server_descriptor_tree ;
#endif /* __VIRTUAL_SERVER_LOOPBACK__ */
/* ... sudha 07-Feb-2000 */

static PROXY_SERVER_DESCRIPTOR_NODE far *get_new_proxy_rb_node ()
{
#if PROXY_CUSTOM_OPERATIONS
	return ((PROXY_SERVER_DESCRIPTOR_NODE far *) _fmalloc (sizeof (PROXY_SERVER_DESCRIPTOR_NODE))) ;
#else
	return ((PROXY_SERVER_DESCRIPTOR_NODE far *) _fmalloc (sizeof (PROXY_SERVER_DESCRIPTOR_NODE))) ;
#endif
}

static void free_proxy_rb_node (PROXY_SERVER_DESCRIPTOR_NODE far *sptr_node)
{
#if PROXY_CUSTOM_OPERATIONS
	_ffree (sptr_node) ;
#else
	_ffree (sptr_node) ;
#endif
}


static int proxy_RB_demo_insert_node(PROXY_SERVER_DESCRIPTOR_NODE far *Tree, PROXY_RB_SERVER_KEY_TYPE key, PROXY_RB_SERVER_INFO_TYPE info, PROXY_SERVER_DESCRIPTOR_NODE far **ptr_sptr_new_node)
{
	PROXY_SERVER_DESCRIPTOR_NODE far *nptr ;
/* sudha 05-Nov-1999... */
	PROXY_SERVER_INFO *ptr_to_proxy_info;
/* ...sudha 05-Nov-1999 */
	int retVal ;

#if 0		/* Sri */
#if PROXY_CUSTOM_OPERATIONS
	retVal = _fmemcmp((unsigned char far *)&Tree->key, (unsigned char far *)&key, sizeof (PROXY_RB_SERVER_KEY_TYPE)) ;
#else
	retVal = _fmemcmp((unsigned char far *)&Tree->key, (unsigned char far *)&key, sizeof (PROXY_RB_SERVER_KEY_TYPE)) ;
#endif
#endif

	retVal = rb_server_compare_key(Tree, key); 

	if (retVal < 0)
	{
		if (Tree->rb_header.RChild != sptr_RB_sentinal_node)
			return (proxy_RB_demo_insert_node ((PROXY_SERVER_DESCRIPTOR_NODE far *)Tree->rb_header.RChild, key, info, ptr_sptr_new_node)) ;
		else
		{
			*ptr_sptr_new_node = nptr = get_new_proxy_rb_node() ;
			if (nptr == NULL)
			{
#if PROXY_RB_STATISTICS
				statistics.number_of_insert_overflows++ ;
#endif
				return PROXY_RB_INSERT_OVERFLOW ;
			}
			nptr->rb_header.LChild = nptr->rb_header.RChild = sptr_RB_sentinal_node ;
#if PROXY_CUSTOM_OPERATIONS
			nptr->key = key ;
			nptr->info = info ;
#else
			nptr->key = key ;
			nptr->info = info ;
#endif
/* sudha 05-Nov-1999... */
			ptr_to_proxy_info = (PROXY_SERVER_INFO *)nptr->info.server_descriptor;
 			ptr_to_proxy_info->server_node = nptr;
/* ...sudha 05-Nov-1999 */

			nptr->rb_header.Color = COLOR_RED ;
			nptr->rb_header.Parent = (RED_BLACK_NODE_HEADER far *)Tree ;
			Tree->rb_header.RChild = (RED_BLACK_NODE_HEADER far *)nptr ;
/* #if PROXY_RB_STATISTICS */
			statistics.number_of_nodes++ ;
/* #endif */
			return PROXY_RB_NEW_ENTRY ;
		}
	}
	else if (retVal > 0)
	{
		if (Tree->rb_header.LChild != sptr_RB_sentinal_node)
		{
			return (proxy_RB_demo_insert_node ((PROXY_SERVER_DESCRIPTOR_NODE far *)Tree->rb_header.LChild, key, info, ptr_sptr_new_node)) ;
		}
		else
		{
			*ptr_sptr_new_node = nptr = get_new_proxy_rb_node() ;
			if (nptr == NULL)
			{
#if PROXY_RB_STATISTICS
				statistics.number_of_insert_overflows++ ;
#endif
				return PROXY_RB_INSERT_OVERFLOW ;
			}
			nptr->rb_header.LChild = nptr->rb_header.RChild = sptr_RB_sentinal_node ;
#if PROXY_CUSTOM_OPERATIONS
			nptr->key = key ;
			nptr->info = info ;
#else
			nptr->key = key ;
			nptr->info = info ;
#endif
/* sudha 05-Nov-1999... */
			ptr_to_proxy_info = (PROXY_SERVER_INFO *)nptr->info.server_descriptor;
 			ptr_to_proxy_info->server_node = nptr;
/* ...sudha 05-Nov-1999 */

			nptr->rb_header.Color = COLOR_RED ;
			nptr->rb_header.Parent = (RED_BLACK_NODE_HEADER far *) Tree ;
			Tree->rb_header.LChild = (RED_BLACK_NODE_HEADER far *) nptr ;
/* #if PROXY_RB_STATISTICS */
			statistics.number_of_nodes++ ;
/* #endif */
			return PROXY_RB_NEW_ENTRY ;
		}
	}
#if PROXY_CUSTOM_OPERATIONS
	/* Here is where you should be putting in things like updating
	the information fields and things like that. For example you
	may want to reset an age field or update some field like
	information_source_port .... */
#endif
#if PROXY_RB_STATISTICS
	statistics.number_of_insert_hits++ ;
#endif
	return PROXY_RB_UPDATED ;
}


static int proxy_RB_demo_insert(PROXY_RB_SERVER_KEY_TYPE key, PROXY_RB_SERVER_INFO_TYPE info)
{
	PROXY_SERVER_DESCRIPTOR_NODE far *nptr, far *sptr_new_node ;
/* sudha 05-Nov-1999... */
	PROXY_SERVER_INFO *ptr_to_proxy_info;
/* ...sudha 05-Nov-1999 */
	int retVal ;

	if (sptr_proxy_server_descriptor_tree == (PROXY_SERVER_DESCRIPTOR_NODE far *)sptr_RB_sentinal_node)
	{
		nptr = get_new_proxy_rb_node() ;
		if (nptr == NULL)
		{
#if PROXY_RB_STATISTICS
			statistics.number_of_insert_overflows++ ;
#endif
			return PROXY_RB_INSERT_OVERFLOW ;
		}
#if PROXY_CUSTOM_OPERATIONS
		nptr->key = key ;
		nptr->info = info ;
#else
		nptr->key = key ;
		nptr->info = info ;
#endif

/* sudha 05-Nov-1999... */
		ptr_to_proxy_info = (PROXY_SERVER_INFO *)nptr->info.server_descriptor;
 		ptr_to_proxy_info->server_node = nptr;
/* ...sudha 05-Nov-1999 */

		nptr->rb_header.Color = COLOR_BLACK ;
		nptr->rb_header.Parent = nptr->rb_header.RChild = nptr->rb_header.LChild = sptr_RB_sentinal_node ;
		sptr_proxy_server_descriptor_tree = nptr ;
/* #if PROXY_RB_STATISTICS */
		statistics.number_of_nodes++ ;
/* #endif */
		return PROXY_RB_NEW_ENTRY ;
	}

	retVal = proxy_RB_demo_insert_node (sptr_proxy_server_descriptor_tree, key, info, &sptr_new_node) ;

	if (retVal == PROXY_RB_NEW_ENTRY)
	{
		sptr_proxy_server_descriptor_tree = (PROXY_SERVER_DESCRIPTOR_NODE far *) RB_red_balance ((RED_BLACK_NODE_HEADER far *)sptr_new_node, (RED_BLACK_NODE_HEADER far *)sptr_proxy_server_descriptor_tree) ;
	}
	return retVal ;
}


PROXY_SERVER_DESCRIPTOR_NODE far *proxy_rb_server_descriptor_search(PROXY_SERVER_DESCRIPTOR_NODE far *Tree, PROXY_RB_SERVER_KEY_TYPE key)
{
	int ret_val ;
	
	if (Tree == NULL)
	{
		return NULL;
	}

	if (Tree == (PROXY_SERVER_DESCRIPTOR_NODE far *)sptr_RB_sentinal_node)
		return NULL ;

#if 0
#if PROXY_CUSTOM_OPERATIONS
	ret_val = _fmemcmp((unsigned char far *)&Tree->key, (unsigned char far *)&key, sizeof (PROXY_RB_SERVER_KEY_TYPE)) ;
#else
	ret_val = _fmemcmp((unsigned char far *)&Tree->key, (unsigned char far *)&key, sizeof (PROXY_RB_SERVER_KEY_TYPE)) ;
#endif
#endif

	ret_val = rb_server_compare_key(Tree, key); 

	if (ret_val < 0)
	{
		return proxy_rb_server_descriptor_search ((PROXY_SERVER_DESCRIPTOR_NODE far *)Tree->rb_header.RChild, key) ;
	}
	else if (ret_val > 0)
	{	
	 	return proxy_rb_server_descriptor_search((PROXY_SERVER_DESCRIPTOR_NODE far *)Tree->rb_header.LChild, key) ;
	}
	else
	{
#if PROXY_RB_STATISTICS
			statistics.number_of_search_hits++ ;
#endif	

			return Tree ;
	}
} 

#if 0
extern unsigned long scc1_collision_errors ;
extern unsigned long scc1_overflow_errors ;
extern unsigned long scc1_CRC_errors ;
extern unsigned long scc1_short_frame_errors ;
extern unsigned long scc1_non_octet_aligned_frame_errors ;
extern unsigned long scc1_frame_length_violation_errors ;
#define PRINT_BUFFER_SIZE 1000
char print_buffer[PRINT_BUFFER_SIZE] ;

void display_proxy_tree ()
{
#if 0
	int index=0 ;
	PROXY_SERVER_DESCRIPTOR_NODE far *sptr_root = sptr_proxy_server_descriptor_tree;
	PROXY_SERVER_DESCRIPTOR_NODE far *sptr_next_node = (PROXY_SERVER_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_root) ;
	
	printf ("\n\nDisplaying Redblack Tree.....\n") ;
	while (sptr_next_node)
	{
		printf ("[%d]. %d      %d\n", ++index, sptr_next_node->key.protocol_type,
						sptr_next_node->key.application_port);
					
		sptr_next_node = (PROXY_SERVER_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
	}

#endif

#if 1
	BYTE application_buffer[200], temp_buffer[100];
	USHORT index = 0 ;
   PROXY_SERVER_DESCRIPTOR_NODE far *sptr_root = sptr_proxy_server_descriptor_tree ;
	PROXY_SERVER_DESCRIPTOR_NODE far *sptr_next_node = (PROXY_SERVER_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_root) ;
		
	application_buffer[0] = 0 ;
	printf ("\nPROXY: Proxy Server Configuration...............\n") ;
	printf ("Number of Applications %d\n",statistics.number_of_nodes);
	while (sptr_next_node)
	{
		if (index && ((index % 3) == 0))
		{
			printf ("%s", &application_buffer[0]) ;
			application_buffer[0] = 0 ;
		}
		sprintf (&temp_buffer[0], "\tProtocol : %04d Application : %04d\n",
					sptr_next_node->key.protocol_type,
					sptr_next_node->key.application_port);
		strcat (&application_buffer[0], &temp_buffer[0]) ;
		index++;
		sptr_next_node = (PROXY_SERVER_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
	}
#endif
	return ;
}

#endif

void add_entry_to_proxy_server_descriptor_tree (BYTE *proxy_server_descriptor, unsigned char *vptr_buffer)
{
   PROXY_RB_SERVER_INFO_TYPE info ;
	
	if (sptr_proxy_server_descriptor_tree == NULL)
		sptr_proxy_server_descriptor_tree = (PROXY_SERVER_DESCRIPTOR_NODE far *) sptr_RB_sentinal_node;


   info.server_descriptor = proxy_server_descriptor ;

   proxy_RB_demo_insert (*((PROXY_RB_SERVER_KEY_TYPE *)(vptr_buffer)), info) ;
	/* this 8 is sizeof(ULONG) and USHORT */
}

#define TEMP 0
#if 0
void initialize_proxy_rb_tree ()
{
   PROXY_RB_SERVER_KEY_TYPE proxy_descriptor_key ;
   int i ;
   PROXY_RB_SERVER_INFO_TYPE info ;

   info.age = proxy_descriptor_rb_node_age ;

   sptr_proxy_server_descriptor_tree = (PROXY_SERVER_DESCRIPTOR_NODE far *) sptr_RB_sentinal_node ;

   ethernet_address.ethernet_address_ulong = 0x00FFFFFF ;
   ethernet_address.ethernet_address_ushort = 0xFFFF ;

   for (i = 0 ; i < 300 ; i++)
   {
      proxy_RB_demo_insert (ethernet_address, info) ;
      ethernet_address.ethernet_address_ulong-- ;
   }
}
#endif


int delete_entry_from_proxy_server_tree (PROXY_RB_SERVER_KEY_TYPE key)
{
   PROXY_SERVER_DESCRIPTOR_NODE *sptr_node_to_delete ;
	BYTE is_root_node=FALSE;
	
   sptr_node_to_delete = proxy_rb_server_descriptor_search (sptr_proxy_server_descriptor_tree, key) ;
   if (sptr_node_to_delete)
   {
#if PROXY_RB_STATISTICS
      statistics.number_of_deletions++ ;
#endif
     	sptr_proxy_server_descriptor_tree = RB_delete ((RED_BLACK_NODE_HEADER far *)sptr_proxy_server_descriptor_tree, (RED_BLACK_NODE_HEADER far *)sptr_node_to_delete, (unsigned long) sizeof (PROXY_SERVER_DESCRIPTOR_NODE), (RED_BLACK_NODE_HEADER far **)&sptr_node_to_delete) ;
		free (sptr_node_to_delete);
	   return (1) ;
	}  
   return (0) ;
}



void age_proxy_server_descriptor_tree ()
{
#if 0
	PROXY_SERVER_DESCRIPTOR_NODE far *sptr_temp, far *sptr_next_node = (PROXY_SERVER_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_proxy_server_descriptor_tree) ;

   while (sptr_next_node)
   {
      sptr_temp = sptr_next_node ;
      sptr_next_node = (PROXY_SERVER_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
      if (sptr_temp->info.age)
      {
         sptr_temp->info.age-- ;
      }
      else
      {
#if 0
         sptr_proxy_server_descriptor_tree = (PROXY_SERVER_DESCRIPTOR_NODE far *)
            RB_delete((RED_BLACK_NODE_HEADER far *)sptr_temp,
                      (RED_BLACK_NODE_HEADER far *)sptr_proxy_server_descriptor_tree,
                      (unsigned long) sizeof (PROXY_SERVER_DESCRIPTOR_NODE),
                      (RED_BLACK_NODE_HEADER far **)&sptr_temp) ;
#endif
      }
   }
#endif
}

void delete_aged_out_entries_in_proxy_server_descriptor (void)
{
#if 0
	PROXY_SERVER_DESCRIPTOR_NODE far *x, far *sptr_next_node = (PROXY_SERVER_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_proxy_server_descriptor_tree) ;
   
   while (sptr_next_node)
   {
      if (sptr_next_node->info.age)
      {
      }
      else
      {
         sptr_proxy_server_descriptor_tree = (PROXY_SERVER_DESCRIPTOR_NODE far *)
            RB_delete((RED_BLACK_NODE_HEADER far *)sptr_next_node,
                      (RED_BLACK_NODE_HEADER far *)sptr_proxy_server_descriptor_tree,
                      (unsigned long) sizeof (PROXY_SERVER_DESCRIPTOR_NODE),
                      (RED_BLACK_NODE_HEADER far **)&x) ;
#if PROXY_RB_STATISTICS
         statistics.number_of_deletions++ ;
#endif
         free_proxy_rb_node (x) ;
         /* In one pass, delete just one. In fact as an optimization,
         we can keep track of the existence of aged out entries in
         a class variable so that we dont even need to call this function
         in case there are no aged entries */
         return ;
      }
      sptr_next_node = (PROXY_SERVER_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
   }
#endif
}



#define PRINT_BUFFER_SIZE 1000
static char pr_print_buffer[PRINT_BUFFER_SIZE] ;
void display_proxy_server_descriptors ()
{
	int i = 1, j ;
	unsigned char ch ;
	unsigned char far *x ;
	char *print_buffer_ptr = &pr_print_buffer[0] ;
	int print_buffer_length = 0 ;
   PROXY_SERVER_DESCRIPTOR_NODE far *sptr_root = sptr_proxy_server_descriptor_tree ;
	PROXY_SERVER_DESCRIPTOR_NODE far *sptr_next_node = (PROXY_SERVER_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_root) ;

	printf ("\n\nDisplaying Redblack Tree.....\n") ;
	while (sptr_next_node)
	{
		sprintf (print_buffer_ptr, "\n\tNode %04d : ", i++) ;
		print_buffer_ptr += 14 ;
		print_buffer_length += 14 ;
		if (print_buffer_length >= PRINT_BUFFER_SIZE - 50)
		{
			*print_buffer_ptr = 0 ;
			printf ("%s", &pr_print_buffer[0]) ;
			print_buffer_ptr = &pr_print_buffer[0] ;
			print_buffer_length = 0 ;
		}
		x = (unsigned char far *) &sptr_next_node->key ;
		for (j = 0 ; j < sizeof (PROXY_RB_SERVER_KEY_TYPE) ; j++)
		{
			ch =  *x++ ;
			sprintf (print_buffer_ptr, "%02X", ch) ;
			print_buffer_ptr += 2 ;
			print_buffer_length += 2 ;
			if (print_buffer_length >= PRINT_BUFFER_SIZE - 50)
			{
				*print_buffer_ptr = 0 ;
				printf ("%s", &pr_print_buffer[0]) ;
				print_buffer_ptr = &pr_print_buffer[0] ;
				print_buffer_length = 0 ;
			}
		}
#if 0
      sprintf (print_buffer_ptr, ", Age : %04d seconds", sptr_next_node->info.age/20) ;
		print_buffer_ptr += 20 ;
		print_buffer_length += 20 ;
#endif
		if (print_buffer_length >= PRINT_BUFFER_SIZE - 50)
		{
			*print_buffer_ptr = 0 ;
			printf ("%s", &pr_print_buffer[0]) ;
			print_buffer_ptr = &pr_print_buffer[0] ;
			print_buffer_length = 0 ;
		}
#if 0
      sprintf (print_buffer_ptr, ", Port : %04d", sptr_next_node->info.port_number) ;
		print_buffer_ptr += 13 ;
		print_buffer_length += 13 ;
#endif
		if (print_buffer_length >= PRINT_BUFFER_SIZE - 50)
		{
			*print_buffer_ptr = 0 ;
			printf ("%s", &pr_print_buffer[0]) ;
			print_buffer_ptr = &pr_print_buffer[0] ;
			print_buffer_length = 0 ;
		}


		if (sptr_next_node == sptr_root)
		{
			sprintf (print_buffer_ptr, " (ROOT)") ;
			print_buffer_ptr += 7 ;
			print_buffer_length += 7 ;
			if (print_buffer_length >= PRINT_BUFFER_SIZE - 50)
			{
				*print_buffer_ptr = 0 ;
				printf ("%s", &pr_print_buffer[0]) ;
				print_buffer_ptr = &pr_print_buffer[0] ;
				print_buffer_length = 0 ;
			}
		}
		sptr_next_node = (PROXY_SERVER_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
	}

	if (print_buffer_length)
		printf ("%s\n\n", &pr_print_buffer[0]) ;
	
	return ;
}

/* Added by Sreelu */
int rb_server_compare_key(PROXY_SERVER_DESCRIPTOR_NODE *Tree, PROXY_RB_SERVER_KEY_TYPE key)
{
#if 0
	printf("Server Tree Parameter:.......\n");
	printf("\n \nProtocol Value :%d\nApplication Port :%d",Tree->key.protocol_type,Tree->key.application_port);
	printf("Server Key Parameter:........\n");
	printf("\n \nProtocol Value :%d\nApplication Port :%d",key.protocol_type,key.application_port);
#endif
	if(Tree->key.protocol_type == key.protocol_type)
	{
		if(Tree->key.application_port == key.application_port)
			return 0;
		else
			return(Tree->key.application_port - key.application_port);			
	}
	else
	{
		return(Tree->key.protocol_type - key.protocol_type);			
	}
}

/* Added by Ravi on 04 Nov 1999 ... */
void display_proxy_server_descriptor()
{
	int count;
   PROXY_SERVER_DESCRIPTOR_NODE far *sptr_root = sptr_proxy_server_descriptor_tree, *sptr_next_node;
	PROXY_SERVER_INFO *info;

	if (sptr_root == NULL)
	{
		printf("Server Descriptor Tree is empty \n");
		return;
	}

	sptr_next_node = (PROXY_SERVER_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_root) ;

	while (sptr_next_node != NULL)
	{
/*		info =  (PROXY_SERVER_INFO *) sptr_next_node->info.server_descriptor;
		printf("IP: %08x, Protocol : %d, Port : %d, Age Time : %d\n", info->client_ip_address, info->protocol_type, 
											info->destination_port, info->proxy_idle_timer); */
		count ++;
		sptr_next_node = (PROXY_SERVER_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
	}

	printf("Number of Active Server Descriptor : %d\n", count);
}	
/* ... Added by Ravi on 04 Nov 1999 */

/* sudha 05-Nov-1999 */
int delete_server_node_entry_from_proxy_server_tree (PROXY_SERVER_INFO *ptr_to_proxy_info)
{
	PROXY_SERVER_DESCRIPTOR_NODE *sptr_node_to_delete;
/* sudha 11-Nov-1999... */
   PROXY_SERVER_DESCRIPTOR_NODE *temp_sptr_node ;
	PROXY_SERVER_INFO *temp_proxy_info;
/* ...sudha 11-Nov-1999 */

	BYTE is_root_node=FALSE;

	if (sptr_proxy_server_descriptor_tree == NULL)
	{
		return 0;
	}

	if ( sptr_proxy_server_descriptor_tree == (PROXY_SERVER_DESCRIPTOR_NODE far *)sptr_RB_sentinal_node)
		return 0 ;
	
/* sudha 11-Nov-1999... */
   temp_sptr_node = sptr_node_to_delete = ptr_to_proxy_info->server_node;
/* ...sudha 11-Nov-1999 */

#if 0
	printf("Deleting server node %08x, protocol %d, src_port %d, dest_port %d, IP %08x\n",
		ptr_to_proxy_info->server_node, ptr_to_proxy_info->protocol_type, 
		ptr_to_proxy_info->source_port, ptr_to_proxy_info->destination_port, 
		ptr_to_proxy_info->client_ip_address);
#endif

   if (sptr_node_to_delete != NULL)
   {
#if PROXY_RB_STATISTICS
      statistics.number_of_deletions++ ;
#endif
     	sptr_proxy_server_descriptor_tree = RB_delete ((RED_BLACK_NODE_HEADER far *)sptr_proxy_server_descriptor_tree, (RED_BLACK_NODE_HEADER far *)sptr_node_to_delete, (unsigned long) sizeof (PROXY_SERVER_DESCRIPTOR_NODE), (RED_BLACK_NODE_HEADER far **)&sptr_node_to_delete);
		free (sptr_node_to_delete);

/* sudha 11-Nov-1999... */
		temp_proxy_info = (PROXY_SERVER_INFO *) temp_sptr_node->info.server_descriptor;
		temp_proxy_info->server_node = temp_sptr_node;
/* ...sudha 11-Nov-1999 */

		ptr_to_proxy_info->server_node = NULL;		
	   return (1) ;
	}  
   return (0) ;
}
/* ...sudha 05-Nov-1999 */

/* sudha 07-Feb-2000 ... */
#ifdef __VIRTUAL_SERVER_LOOPBACK__

/*--------------------------------------------------------------------------*\

**	Function Name	: virtual_server_loopback_server_RB_demo_insert()
**	Description 	: Adding a new server descriptor in the virtual server loopback
						: server tree.
**	Parameters		: 1. server descriptor key	structure
						: 2. server descriptor info structure
**	Return Value	: int 0, 1 or 2
**	Notes				:

\*--------------------------------------------------------------------------*/

static int virtual_server_loopback_server_RB_demo_insert(PROXY_RB_SERVER_KEY_TYPE key, PROXY_RB_SERVER_INFO_TYPE info)
{
	PROXY_SERVER_DESCRIPTOR_NODE far *nptr, far *sptr_new_node;
	PROXY_SERVER_INFO *ptr_to_proxy_info;
	int retVal;

	if (sptr_virtual_server_loopback_server_descriptor_tree == (PROXY_SERVER_DESCRIPTOR_NODE far *)sptr_RB_sentinal_node)
	{
		nptr = get_new_proxy_rb_node();
		if (nptr == NULL)
		{
#if PROXY_RB_STATISTICS
			statistics.number_of_insert_overflows++;
#endif
			return PROXY_RB_INSERT_OVERFLOW;
		}
#if PROXY_CUSTOM_OPERATIONS
		nptr->key = key;
		nptr->info = info;
#else
		nptr->key = key;
		nptr->info = info;
#endif

		ptr_to_proxy_info = (PROXY_SERVER_INFO *)nptr->info.server_descriptor;
 		ptr_to_proxy_info->server_node = nptr;

		nptr->rb_header.Color = COLOR_BLACK;
		nptr->rb_header.Parent = nptr->rb_header.RChild = nptr->rb_header.LChild = sptr_RB_sentinal_node;
		sptr_virtual_server_loopback_server_descriptor_tree = nptr;
/* #if PROXY_RB_STATISTICS */
		statistics.number_of_nodes++;
/* #endif */
		return PROXY_RB_NEW_ENTRY;
	}

	retVal = proxy_RB_demo_insert_node (sptr_virtual_server_loopback_server_descriptor_tree, key, info, &sptr_new_node);

	if (retVal == PROXY_RB_NEW_ENTRY)
	{
		sptr_virtual_server_loopback_server_descriptor_tree = (PROXY_SERVER_DESCRIPTOR_NODE far *) RB_red_balance ((RED_BLACK_NODE_HEADER far *)sptr_new_node, (RED_BLACK_NODE_HEADER far *)sptr_virtual_server_loopback_server_descriptor_tree);
	}
	return retVal;
}

/*--------------------------------------------------------------------------*\

**	Function Name	: add_entry_to_virtual_server_loopback_server_descriptor_tree()
**	Description 	: Adding a new server descriptor in the virtual server loopback
						: server tree. Initializing the server descriptor info structure.
**	Parameters		: 1. ptr to server descriptor 
						: 2. ptr to server descriptor key
**	Return Value	: void
**	Notes				:

\*--------------------------------------------------------------------------*/

void add_entry_to_virtual_server_loopback_server_descriptor_tree (BYTE *proxy_server_descriptor, unsigned char *vptr_buffer)
{
   PROXY_RB_SERVER_INFO_TYPE info;
	
	if (sptr_virtual_server_loopback_server_descriptor_tree == NULL)
	{
		sptr_virtual_server_loopback_server_descriptor_tree = (PROXY_SERVER_DESCRIPTOR_NODE far *) sptr_RB_sentinal_node;
	}

   info.server_descriptor = proxy_server_descriptor;

   virtual_server_loopback_server_RB_demo_insert (*((PROXY_RB_SERVER_KEY_TYPE *)(vptr_buffer)), info);
	/* this 8 is sizeof(ULONG) and USHORT */

	return;
}

/*--------------------------------------------------------------------------*\

**	Function Name	: display_virtual_server_loopback_server_descriptor()
**	Description 	: register debugger function to display number of entries
						: in virtual server loopback server tree. 
**	Parameters		: None
**	Return Value	: void
**	Notes				:

\*--------------------------------------------------------------------------*/

void display_virtual_server_loopback_server_descriptor(void)
{
	int count = 0;
   PROXY_SERVER_DESCRIPTOR_NODE far *sptr_root = sptr_virtual_server_loopback_server_descriptor_tree, *sptr_next_node;
	PROXY_SERVER_INFO *sptr_proxy_server_info = NULL;

	if (sptr_root == NULL)
	{
		printf("Virtual Server Loopback Server Descriptor Tree is empty \n");
		return;
	}

	sptr_next_node = (PROXY_SERVER_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *) sptr_root);

	while (sptr_next_node != NULL)
	{
		sptr_proxy_server_info = (PROXY_SERVER_INFO *) sptr_next_node->info.server_descriptor;

/*		printf("SIP:%4x DIP:%4x SPort:%d DPort:%d Time:%d\n", 
							sptr_proxy_server_info->client_ip_address,
							sptr_proxy_server_info->destination_address,
							sptr_proxy_server_info->mapped_port,
							sptr_proxy_server_info->destination_port,
							sptr_proxy_server_info->proxy_idle_timer); */

		count ++;
		sptr_next_node = (PROXY_SERVER_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node);
	}

	printf("Number of Active Virtual Server Loopback Server Descriptor : %d\n", count);
	return;
}	

/*--------------------------------------------------------------------------*\

**	Function Name	: delete_server_node_entry_from_virtual_server_loopback_server_tree()
**	Description 	: deleting a server descriptor in the virtual server loopback
						: server tree. 
**	Parameters		: 1. ptr to server descriptor info
**	Return Value	: int 0 or 1
**	Notes				:

\*--------------------------------------------------------------------------*/

int delete_server_node_entry_from_virtual_server_loopback_server_tree (PROXY_SERVER_INFO *ptr_to_proxy_info)
{
	PROXY_SERVER_DESCRIPTOR_NODE *sptr_node_to_delete;
   PROXY_SERVER_DESCRIPTOR_NODE *temp_sptr_node;
	PROXY_SERVER_INFO *temp_proxy_info;

	BYTE is_root_node=FALSE;

	if (sptr_virtual_server_loopback_server_descriptor_tree == NULL)
	{
		return 0;
	}

	if (sptr_virtual_server_loopback_server_descriptor_tree == (PROXY_SERVER_DESCRIPTOR_NODE far *)sptr_RB_sentinal_node)
	{
		return 0;
	}
	
   temp_sptr_node = sptr_node_to_delete = ptr_to_proxy_info->server_node;

#if sudha
	printf("Deleting server node %08x, protocol %d, src_port %d, dest_port %d, IP %08x\n",
		ptr_to_proxy_info->server_node, ptr_to_proxy_info->protocol_type, 
		ptr_to_proxy_info->source_port, ptr_to_proxy_info->destination_port, 
		ptr_to_proxy_info->client_ip_address);
#endif

   if (sptr_node_to_delete != NULL)
   {
#if PROXY_RB_STATISTICS
      statistics.number_of_deletions++;
#endif
     	sptr_virtual_server_loopback_server_descriptor_tree = RB_delete 
			((RED_BLACK_NODE_HEADER far *)sptr_virtual_server_loopback_server_descriptor_tree, 
			 (RED_BLACK_NODE_HEADER far *)sptr_node_to_delete, (unsigned long) sizeof (PROXY_SERVER_DESCRIPTOR_NODE), 
			 (RED_BLACK_NODE_HEADER far **) &sptr_node_to_delete);

		free (sptr_node_to_delete);

		temp_proxy_info = (PROXY_SERVER_INFO *) temp_sptr_node->info.server_descriptor;
		temp_proxy_info->server_node = temp_sptr_node;

		ptr_to_proxy_info->server_node = NULL;		
	   return (1);
	}  
   return (0);
}

#endif /* __VIRTUAL_SERVER_LOOPBACK__ */
/* ... sudha 07-Feb-2000 */

