/*--------------------------------------------------------------------------*\

Changes History : 

{sudha 07-Feb-2000. virtual server loopback support}

\*--------------------------------------------------------------------------*/

#include <defs.h>


#include	<stdio.h>
#include	<stdarg.h>
#include <stddef.h>
#include	<stdlib.h>

#include "proxy.h"


#include "..\..\stacks\ip\karp.h"
#include "..\..\stacks\ip\kip.h"
#include "..\..\stacks\ip\kipuser.h"
#include "..\..\stacks\ip\varpuser.h"
#include "..\..\stacks\ip\varpstr.h"
#include "..\..\stacks\ip\vrarpusr.h"
#include "..\..\stacks\ip\vrarpstr.h"
#include "..\..\stacks\ip\kroute.h"	  
#include "..\..\stacks\ip\viprtstr.h"	  
#include "..\..\stacks\ip\vipusstr.h"  
#include "..\..\stacks\ip\vsktstr.h"
#include "..\..\stacks\ip\kudp.h"
#include "..\..\stacks\ip\vipktstr.h"
#include "..\..\stacks\ip\kicmp.h"
#include "..\..\stacks\ip\vudpuser.h"
#include "..\..\stacks\ip\vudpbuf.h"
#include "..\..\stacks\ip\vudpstr.h"
#include "..\..\stacks\ip\krip.h"
#include "..\..\stacks\ip\vripstr.h"
#include "..\..\stacks\ip\vicmpstr.h"
#include "..\..\stacks\ip\viprastr.h"
#include "..\..\stacks\ip\vipstr.h" 

#if STATUS_DEBUG
enum BOOLEAN register_debugger (void (*fptr_debug_function)(), char *signature) ;
void proxy_configuration (void) ;
void proxy_status (void) ;
void proxy_internet_port_status ();
extern void display_proxy_dns_cache_info ();
extern void display_sntp_date_time();
#endif


extern void proxy_server_timer ();
extern enum TEST proxy_server_control(enum APPLICATION_CONTROL_OPERATION command, ULONG parameter_0, 
		ULONG parameter_1);

extern void dns_filter_local_cache_info ();
extern PROXY_SERVER_CLASS proxy_server;

extern void set_ftp_port_numbers_during_init(); /* sudha 19 Aug 1999 */

BYTE *sptr_proxy_mapped_port_status= NULL;

/* sudha 07-Feb-2000 ... */
#ifdef __VIRTUAL_SERVER_LOOPBACK__
BYTE *sptr_virtual_server_loopback_mapped_port_status= NULL;
#endif /* __VIRTUAL_SERVER_LOOPBACK__ */
/* ... sudha 07-Feb-2000 */

/* Added by Ravi */
extern void display_proxy_server_client_descriptor();
extern void display_proxy_server_descriptor();
extern void display_nat_descriptor();

/* sudha 07-Feb-2000 ... */
#ifdef __VIRTUAL_SERVER_LOOPBACK__
extern void display_virtual_server_loopback_server_descriptor();
extern void display_virtual_server_loopback_client_descriptor();
#endif /* __VIRTUAL_SERVER_LOOPBACK__ */
/* ... sudha 07-Feb-2000 */

enum TEST initialize_proxy_server (ULONG clock_ticks_per_second)
{
	USHORT port_index=0;

	if (proxy_server.proxy_server_enabled == FALSE)
		return PASS;

	proxy_server.number_of_proxied_clients = 0;

#if OLD_FILTER
/* Sreelu for filter... */
	proxy_server.dns_resolver_state = PROXY_START_DNS_CLIENT;
/* ...Sreelu for filter */
#endif

	if (proxy_server.maximum_number_of_descriptors == 0)
		proxy_server.maximum_number_of_descriptors = MAXIMUM_ACTIVE_DESCRIPTORS;

	sptr_proxy_mapped_port_status = calloc (8195,1);
	if (sptr_proxy_mapped_port_status == NULL)
	{
		printf ("PROXY : Not Enough memory to store port status\n");
		return;
	}

/* sudha 07-Feb-2000 ... */
#ifdef __VIRTUAL_SERVER_LOOPBACK__
	sptr_virtual_server_loopback_mapped_port_status = calloc (8195,1);
	if (sptr_virtual_server_loopback_mapped_port_status == NULL)
	{
		printf ("PROXY : Not Enough memory to store virtual server loopback port status\n");
		return;
	}
#endif /* __VIRTUAL_SERVER_LOOPBACK__ */
/* ... sudha 07-Feb-2000 */

#if OLD_FILTER
/* Sreelu for filter... */
	proxy_server.start_resolving_dns_filters = TRUE;
/* ...Sreelu for filter */
#endif
		
	for (port_index = 1; port_index < NUMBER_OF_IP_PORTS ; port_index++)
	{
		proxy_server.port[port_index].throughput_index = 1;
		proxy_server.port[port_index].number_of_connections = 0;
	}		

#ifdef __LSL__
	if ((enum TEST) lsl_control (REGISTER_APPLICATION, "PROXY Server", PROXY_SERVER_APPLICATION, proxy_server_timer, 
			proxy_server_control, &proxy_server.application_id) == FAIL)	
	{
		proxy_printf ("PROXY_SERVER: register_application () failed to register Proxy Server with lsl\n");
		return (FAIL);
	}
	proxy_printf ("PROXY_SERVER : Intialized proxy server\n");

/* sudha 19 Aug 1999 */
	set_ftp_port_numbers_during_init(); 

	register_debugger (display_proxy_server_client_descriptor, "PROCLIENT") ;
	register_debugger (display_proxy_server_descriptor, "PROSERVER") ;
	register_debugger (display_sntp_date_time, "SNTPDATETIME");
	register_debugger (display_nat_descriptor, "PRONAT") ;

/* sudha 07-Feb-2000 ... */
#ifdef __VIRTUAL_SERVER_LOOPBACK__
	register_debugger (display_virtual_server_loopback_client_descriptor, "VSCLIENT");
	register_debugger (display_virtual_server_loopback_server_descriptor, "VSSERVER");
#endif /* __VIRTUAL_SERVER_LOOPBACK__ */
/* ... sudha 07-Feb-2000 */

#if 0
	register_debugger (proxy_configuration, "PROCON") ;
	register_debugger (proxy_status, "PROSTAT") ;
	register_debugger (proxy_internet_port_status, "PORTSTAT");
	register_debugger (display_proxy_dns_cache_info, "DNSCACHE");
	register_debugger (dns_filter_local_cache_info, "LOCALCACHE");
#endif
	return (PASS);
#else
	return (FAIL);
#endif
	return PASS;

}

enum TEST
proxy_server_control(enum APPLICATION_CONTROL_OPERATION command, ULONG parameter_0, 
		ULONG parameter_1)
{
	return PASS;
}


extern char *convert_ip_address_to_dot_format (char *, ULONG) ;
extern char *get_protocol_type (char *protocol_type_string, enum IP_PROTOCOL_VALUE protocol_type) ;
extern char *get_port_type (char *port_type_string, enum IP_PROTOCOL_VALUE protocol_type, USHORT protocol_port_number) ;

void ip_port_up (USHORT port_number)
{
#if 0
	USHORT application_index=0;
	PROXY_APPLICATION_TABLE *proxy_application_list = proxy_server.sptr_application_list;
	char protocol_type[20], application_type[20] ;

	for (application_index = 0; application_index < proxy_server.number_of_applications; 
				application_index++, proxy_application_list++)
	{
		printf ("PR: Protocol : %s, Application Port : %s\n",
			get_protocol_type (&protocol_type[0], proxy_application_list->protocol_type),
			get_port_type (&application_type[0], proxy_application_list->protocol_type, proxy_application_list->protocol_port)) ;
	}
#endif
/* Sachin, 3rd Oct. 1997 */
   proxy_server.port[port_number].port_down_by_no_demand = FALSE ;
   proxy_server.port[port_number].port_opened = TRUE ;
/* Sachin, 3rd Oct. 1997 */
   
   proxy_configuration () ;
}

void ip_port_down (USHORT port_number)
{
	PROXY_SERVER_INFO *ptr_to_proxy_server_info;
	USHORT count=0;
	
	ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) get_pointer_to_first_entry_in_list ((LINK *)&proxy_server.proxy_server_info_list);

	while (ptr_to_proxy_server_info != NULL)
	{
		if (ptr_to_proxy_server_info->outgoing_physical_port == port_number)
		{
			count++;
			ptr_to_proxy_server_info->proxy_idle_timer = 0 ;
		}
		ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) get_pointer_to_next_entry_in_list ((LINK *)ptr_to_proxy_server_info);
	}
	printf ("PROXY : Deleted %d Descriptors for port %04x\n", count, port_number);
}

