/*****************************************************************************
file	:	pr_rdrnr.c
auth	:	vidy
date	:	1st sept 1998
syno	:	this file contains the Timer Warner Bros. cable network (Road Runner) 
			specific remote rlogin routines
refer	:	http://people.qualcom.com/karn/rr/rrlogin.c - linux source
*****************************************************************************/
#include <defs.h>

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <kstart.h>

#include <string.h>
#include <memory.h>
#include "proxy.h"

#define	RR_PKT_LIMIT	400	/* maximum length of login packets */

BOOL road_runner_rlogin_replace_source_address_if_in_data(
	ULONG client_ip_address, ULONG outgoing_port_address, BYTE *ptr_to_data);
void rd_rnr_copy_address_and_pad(BYTE *tmp_ptr, BYTE *str_address);

/* the following routine will check if the client IP address is present
in the data area and replace it with out_going_port_address if found
ASSUMPTION : ptr_to_data is NULL terminated */

BOOL road_runner_rlogin_replace_source_address_if_in_data(
	ULONG client_ip_address, ULONG out_going_port_address, BYTE *ptr_to_data)
{
	int length_limit;
	BYTE	str_client_address[20];
	BYTE	str_out_going_port_address[20];
	BYTE	*tmp_ptr;

	/* just a sanity check to makesure the length is reasonable */
	for (length_limit = 0; ; length_limit++)
	{
		if (!ptr_to_data[length_limit])
			break;
		if (length_limit == RR_PKT_LIMIT)
		{
			printf("rd_rnr: very long packet\n");
			return FALSE;
		}
	}
	convert_ip_address_to_dot_format (str_client_address, client_ip_address);
	if (tmp_ptr = strstr(ptr_to_data, str_client_address))
	{
		/* replace the address */
		convert_ip_address_to_dot_format (str_out_going_port_address, out_going_port_address);
		rd_rnr_copy_address_and_pad(tmp_ptr, str_out_going_port_address);

		/* printf("rd_rnr: addr replaced: %s\n", ptr_to_data); */
	}
	
}

void rd_rnr_copy_address_and_pad(BYTE *tmp_ptr, BYTE *str_address)
{
	int length = 0;
	while (*str_address)
	{
		*tmp_ptr++ = *str_address++;
		length++;
	}
	while (length++ < 15)		/* overwrite remaining with 0x20 */
		*tmp_ptr++ = 0x20;
}
