/*--------------------------------------------------------------------------*\
Changes History :
		{Ravi, 08 Dec 1999, free() is changed to descriptor_free}
		{Ravi, 11 Dec 1999, set_port_status_to_not_in_use called in 
				 proxy_server_descriptor_timer}
		{sudha, 07-Feb-2000. virtual server loopback support}

\*--------------------------------------------------------------------------*/

#include <defs.h>

#include <stdio.h>
#include <stdlib.h>
#include <kstart.h>
#include "proxy.h"

#include <redblack.h>
#include "proxyrb.h"

#include "..\..\stacks\ip\kdns.h" 

#include "..\..\applicat\userdata\kuser.h"
#include "..\..\applicat\userdata\vuserstr.h"

extern DOMAIN_NAME_LIST *sptr_to_restricted_domain_address;
extern DOMAIN_NAME_LIST *current_domain_name;
extern PROXY_SERVER_CLASS proxy_server;

extern PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_proxy_client_descriptor_tree ;
extern PROXY_SERVER_DESCRIPTOR_NODE far *sptr_proxy_server_descriptor_tree ;

/* sudha 07-Feb-2000 ... */
#ifdef __VIRTUAL_SERVER_LOOPBACK__
extern PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_virtual_server_loopback_client_descriptor_tree ;
extern PROXY_SERVER_DESCRIPTOR_NODE far *sptr_virtual_server_loopback_server_descriptor_tree ;
#endif /* __VIRTUAL_SERVER_LOOPBACK__ */
/* ... sudha 07-Feb-2000 */

extern int delete_entry_from_proxy_server_tree (PROXY_RB_SERVER_KEY_TYPE key);
extern enum TEST get_ip_address_from_name (BYTE *domain_name, USHORT port_number, void (*fptr_complete_routine)(ULONG *, USHORT,USHORT, enum DNS_STATE));
extern int delete_entry_from_proxy_client_tree (PROXY_RB_CLIENT_KEY_TYPE key);

/* sudha 05-Nov-1999... */
extern int delete_client_node_entry_from_proxy_client_tree (PROXY_SERVER_INFO *ptr_to_proxy_info);
extern int delete_server_node_entry_from_proxy_server_tree (PROXY_SERVER_INFO *ptr_to_proxy_info);
/* ...sudha 05-Nov-1999 */

/* sudha 07-Feb-2000 ... */
#ifdef __VIRTUAL_SERVER_LOOPBACK__
extern int delete_client_node_entry_from_virtual_server_loopback_client_tree (PROXY_SERVER_INFO *ptr_to_proxy_info);
extern int delete_server_node_entry_from_virtual_server_loopback_server_tree (PROXY_SERVER_INFO *ptr_to_proxy_info);
#endif /* __VIRTUAL_SERVER_LOOPBACK__ */
/* ... sudha 07-Feb-2000 */

#if OLD_FILTER
void set_resolved_address_in_list(ULONG *resolved_ip_address, USHORT count,USHORT port_number, enum DNS_STATE status);
void process_proxy_server_domain_name_filters ();
#endif

extern void add_entry_ipadd_filter_rb_tree (IP_ADD_FILTER_INFO *user_info,unsigned char *vptr_buffer);

/*extern PROXY_DYNAMIC_APP_LIST *proxy_server_dynamic_application_list; */

/* Added by Ravi on 05 Nov 1999 ... */
int pr_ticks_to_second_timer;
/* ... Added by Ravi on 05 Nov 1999 */

void free_corresponding_application_list_entry (USHORT application_port)
{
	PROXY_DYNAMIC_APP_LIST *temp_application_list;
	PROXY_DYNAMIC_APP_LIST *previous_application_list;
	
	temp_application_list = proxy_server.proxy_server_dynamic_application_list;

/* Since previous_application_list ptr was not initialised - it was crashing when it tried 
	to delete first Entry */
	previous_application_list = proxy_server.proxy_server_dynamic_application_list;	/* Added by Sreelu */

	while (temp_application_list != NULL)
	{
		if (application_port == temp_application_list->application_port)
		{
			if (temp_application_list == proxy_server.proxy_server_dynamic_application_list)
			{
				proxy_server.proxy_server_dynamic_application_list = 
						proxy_server.proxy_server_dynamic_application_list->sptr_forward_link;					
			}
#if 0
			printf ("Freeing application list for %d\n",temp_application_list->application_port);
#endif
			previous_application_list->sptr_forward_link = temp_application_list->sptr_forward_link;
			free (temp_application_list);
			return;
		}			
		previous_application_list = temp_application_list;
		temp_application_list = temp_application_list->sptr_forward_link;
	}

#if 0
	printf ("Failed to free application list for %d\n", application_port);
#endif
	return;
}

/* Added by Sreelu for RB trees from Big Proxy */

void proxy_server_client_descriptor_timer ()
{
   PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_root = sptr_proxy_client_descriptor_tree ;
	PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_next_node;
	PROXY_SERVER_INFO *ptr_to_proxy_server_info;
	PROXY_RB_CLIENT_KEY_TYPE client_descriptor_key;
	PROXY_RB_SERVER_KEY_TYPE server_descriptor_key;
	int client_ret_val=0, server_ret_val=0;
		
	if (sptr_root == NULL )
		return;

	sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_root) ;

	while (sptr_next_node != NULL)
	{
		ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) sptr_next_node->info.client_descriptor;
		
		if (!ptr_to_proxy_server_info->proxy_idle_timer)
		{
/* sudhir added for ftp passive */
			
			if (ptr_to_proxy_server_info->protocol_type == TCP_PROTOCOL &&
					ptr_to_proxy_server_info->destination_port > 1024)
			{
#if 0
				printf ("PROXY : Trying to free %d\n", ptr_to_proxy_server_info->destination_port);
#endif
				free_corresponding_application_list_entry (ptr_to_proxy_server_info->destination_port);
			}

			proxy_printf ("PROXY : Freeing up Descriptor with dst port: %d physical port: %d\n", ptr_to_proxy_server_info->destination_port,
					ptr_to_proxy_server_info->outgoing_physical_port);

/*			delete_entry_from_list ((LINK *)&proxy_server.proxy_server_info_list, (LINK *)ptr_to_proxy_server_info);
			free (ptr_to_proxy_server_info); */
			proxy_server.number_of_proxied_clients--;
			
			client_descriptor_key.client_ip_address = ptr_to_proxy_server_info->client_ip_address;
			client_descriptor_key.protocol_type = ptr_to_proxy_server_info->protocol_type;
			client_descriptor_key.application_port = ptr_to_proxy_server_info->source_port;
			client_ret_val = delete_entry_from_proxy_client_tree (client_descriptor_key);

			server_descriptor_key.protocol_type = ptr_to_proxy_server_info->protocol_type;
			if (ptr_to_proxy_server_info->protocol_type == IP_DATA_ICMP)
			{
				server_descriptor_key.application_port = ptr_to_proxy_server_info->mapped_icmp_packet_id;
#if 0
				printf ("Deleting ICMP Descriptor with id %d\n",
							ptr_to_proxy_server_info->mapped_icmp_packet_id); 
#endif
			}
			else
				server_descriptor_key.application_port = ptr_to_proxy_server_info->mapped_port;

			server_ret_val = delete_entry_from_proxy_server_tree (server_descriptor_key);

			if (client_ret_val && server_ret_val)
			{
	         if (proxy_server.port[ptr_to_proxy_server_info->outgoing_physical_port].number_of_connections)
   				proxy_server.port[ptr_to_proxy_server_info->outgoing_physical_port].number_of_connections--;			

#if 0
      	   else
         	   printf ("PROXY :Trying to Free unknown Descriptor\n");
			 
				printf ("Freed Up Descriptor for %08x :: Application %d for port %04x\n",
					ptr_to_proxy_server_info->client_ip_address,
					ptr_to_proxy_server_info->destination_port,
					ptr_to_proxy_server_info->outgoing_physical_port);
#endif

				free (ptr_to_proxy_server_info);
			}
			else
				printf ("Failed to remove entry\n");
		}
		else
			ptr_to_proxy_server_info->proxy_idle_timer--;

 	
		sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
	}
}

void proxy_server_descriptor_timer ()
{
	PROXY_SERVER_INFO *ptr_to_proxy_server_info;
	PROXY_RB_SERVER_KEY_TYPE server_descriptor_key;
   PROXY_SERVER_DESCRIPTOR_NODE far *sptr_root = sptr_proxy_server_descriptor_tree ;
	PROXY_SERVER_DESCRIPTOR_NODE far *sptr_next_node;

/* Added by Ravi on 09 Nov 1999 ... */
	PROXY_RB_CLIENT_KEY_TYPE client_descriptor_key;
	int client_ret_val=0;
/* ... Added by Ravi on 09 Nov 1999 */

	int server_ret_val=0;
	
	if (sptr_root == NULL)
		return;

	sptr_next_node = (PROXY_SERVER_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_root) ;

	while (sptr_next_node != NULL)
	{
		server_ret_val = client_ret_val = 0;

		ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) sptr_next_node->info.server_descriptor;

		if (!ptr_to_proxy_server_info->proxy_idle_timer)
		{
			if (ptr_to_proxy_server_info->protocol_type == TCP_PROTOCOL &&
					ptr_to_proxy_server_info->destination_port > 1024)
			{
				free_corresponding_application_list_entry (ptr_to_proxy_server_info->destination_port);
			}

			proxy_server.number_of_proxied_clients--;

			if (ptr_to_proxy_server_info->protocol_type != IP_DATA_ICMP)
			{
				client_ret_val = delete_client_node_entry_from_proxy_client_tree (ptr_to_proxy_server_info);
				if (!client_ret_val)
					printf("Surprised! Client Descriptor Not Deleted... \n");
			}

			server_ret_val = delete_server_node_entry_from_proxy_server_tree (ptr_to_proxy_server_info);
			if (!server_ret_val)
				printf("Surprised! Server Descriptor Not Deleted... \n");

			if ((server_ret_val && client_ret_val) ||
				 (server_ret_val && ptr_to_proxy_server_info->protocol_type == IP_DATA_ICMP))
			{
      	   if (proxy_server.port[ptr_to_proxy_server_info->outgoing_physical_port].number_of_connections)
  					proxy_server.port[ptr_to_proxy_server_info->outgoing_physical_port].number_of_connections--;			

/* Added by Ravi on 11 Dec 1999 ... */
				/* vidy added this to rest the allocation status of mapped port */
				if (ptr_to_proxy_server_info->protocol_type != IP_DATA_ICMP)
				{
					set_port_status_to_not_in_use (ptr_to_proxy_server_info->mapped_port);
				}
				else
				{
					/* For all ICMP packets the mapped_port is irrelavant */
				}
/* ... Added by Ravi on 11 Dec 1999 */

					free (ptr_to_proxy_server_info);
			}
			else
				printf ("Failed to remove entry\n");
		}
		else
			ptr_to_proxy_server_info->proxy_idle_timer--;

		sptr_next_node = (PROXY_SERVER_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
	}
}
/* Added by Sreelu for RB trees from Big Proxy */

/* sudha 07-Feb-2000 ... */
#ifdef __VIRTUAL_SERVER_LOOPBACK__
void virtual_server_loopback_server_descriptor_timer ()
{
	PROXY_SERVER_INFO *ptr_to_proxy_server_info;
	PROXY_RB_SERVER_KEY_TYPE server_descriptor_key;
   PROXY_SERVER_DESCRIPTOR_NODE far *sptr_root = sptr_virtual_server_loopback_server_descriptor_tree;
	PROXY_SERVER_DESCRIPTOR_NODE far *sptr_next_node;
	PROXY_RB_CLIENT_KEY_TYPE client_descriptor_key;
	int client_ret_val = 0;
	int server_ret_val = 0;
	
	if (sptr_root == NULL)
	{
		return;
	}

	sptr_next_node = (PROXY_SERVER_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *) sptr_root);

	while (sptr_next_node != NULL)
	{
		server_ret_val = client_ret_val = 0;

		ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) sptr_next_node->info.server_descriptor;

		if (!ptr_to_proxy_server_info->proxy_idle_timer)
		{
			if (ptr_to_proxy_server_info->protocol_type != IP_DATA_ICMP)
			{
				client_ret_val = delete_client_node_entry_from_virtual_server_loopback_client_tree (ptr_to_proxy_server_info);

				if (!client_ret_val)
				{
					printf("Surprised! Virtual Server Loopback Client Descriptor Not Deleted... \n");
				}
			}

			server_ret_val = delete_server_node_entry_from_virtual_server_loopback_server_tree (ptr_to_proxy_server_info);

			if (!server_ret_val)
			{
				printf("Surprised! Virtual Server Loopback Server Descriptor Not Deleted... \n");
			}

			if ((server_ret_val && client_ret_val) ||
				 (server_ret_val && ptr_to_proxy_server_info->protocol_type == IP_DATA_ICMP))
			{
				if (ptr_to_proxy_server_info->protocol_type != IP_DATA_ICMP)
				{
					set_virtual_server_loopback_port_status_to_not_in_use (ptr_to_proxy_server_info->mapped_port);
				}
				else
				{
					/* For all ICMP packets the mapped_port is irrelavant */
				}

				free (ptr_to_proxy_server_info);
			}
			else
			{
				printf ("Failed to remove virtual server loopback entry\n");
			}				
		}
		else
		{
			ptr_to_proxy_server_info->proxy_idle_timer--;
		}
		sptr_next_node = (PROXY_SERVER_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *) sptr_next_node);
	}
	return;
}
#endif /* __VIRTUAL_SERVER_LOOPBACK__ */
/* ... sudha 07-Feb-2000 */

/*------------------------Neelu added for NAT-----------------------------*/
void process_nat_descriptor_timer ()
{
	PROXY_INTERNET_SERVER_DESCRIPTOR *sptr_internet_server_descriptor = NULL, *ptr_to_next_node=NULL;

	sptr_internet_server_descriptor = get_pointer_to_first_entry_in_list
						((LINK *)&proxy_server.proxy_internet_server_list);
	
	while (sptr_internet_server_descriptor != NULL)
	{
		ptr_to_next_node = (PROXY_INTERNET_SERVER_DESCRIPTOR *) get_pointer_to_next_entry_in_list ((LINK *)sptr_internet_server_descriptor);

		if (sptr_internet_server_descriptor->idle_timer)
			sptr_internet_server_descriptor->idle_timer--;
		else
		{
			delete_entry_from_list ((LINK *) &proxy_server.proxy_internet_server_list,
				(LINK *) sptr_internet_server_descriptor);
			free (sptr_internet_server_descriptor);
		}

		sptr_internet_server_descriptor = ptr_to_next_node;
	}	
 
	return;	
}

void process_nat_descriptor_table ()
{
	PROXY_INTERNET_SERVER_DESCRIPTOR *sptr_internet_server_descriptor=NULL;
	USHORT number_of_nat_descriptors=0;

	sptr_internet_server_descriptor = get_pointer_to_first_entry_in_list
						((LINK *)&proxy_server.proxy_internet_server_list);
	
	while (sptr_internet_server_descriptor != NULL)
	{
		sptr_internet_server_descriptor->idle_timer = 0;
		number_of_nat_descriptors++;

		sptr_internet_server_descriptor = (PROXY_INTERNET_SERVER_DESCRIPTOR *) get_pointer_to_next_entry_in_list ((LINK *)sptr_internet_server_descriptor);
	}

#if 0
	if (number_of_nat_descriptors)
		printf ("PROXY1: Deleted %04x descriptors from NAT table\n",number_of_nat_descriptors);
#endif

	return;	
}
/* ----------------------Neelu Ends----------------------------------*/

void proxy_server_timer ()
{
	PROXY_SERVER_INFO *ptr_to_proxy_server_info;

	if (!proxy_server.proxy_server_enabled)
	{
		proxy_printf ("PROXY_SERVER : Proxy server disabled\n");
		return;
	}

	if ((++pr_ticks_to_second_timer) >= 20)
	{
		proxy_server_descriptor_timer ();
/* sudha 07-Feb-2000 ... */
#ifdef __VIRTUAL_SERVER_LOOPBACK__ 
		virtual_server_loopback_server_descriptor_timer ();
#endif /* __VIRTUAL_SERVER_LOOPBACK__ */
/* ... sudha 07-Feb-2000 */

		process_nat_descriptor_timer ();  
		pr_ticks_to_second_timer = 0;
	}
	return;
}

#if OLD_FILTER
/* Sreelu for Filter... */
void start_resolving_proxy_dns_filters ()
{
	proxy_server.start_resolving_dns_filters = TRUE;
}

void process_proxy_server_domain_name_filters ()
{
	PROXY_FORBIDDEN_DOMAIN_ADDRESS *sptr_next_restricted_domain_address;
	BYTE domain_name_buffer[255];
	
	if (proxy_server.number_of_address_resolved == proxy_server.max_number_of_restricted_domain_address)
	{
		/* printf ("PROXY: All Domain names resolved\n");  */
		proxy_server.start_resolving_dns_filters = FALSE;
		return;
	}
		
	sptr_next_restricted_domain_address = proxy_server.ptr_to_restricted_domain_address +
					proxy_server.number_of_address_resolved;
	
	strcpy (&domain_name_buffer[0], sptr_next_restricted_domain_address->domain_name);
	proxy_server.number_of_address_resolved++;

	printf ("PROXY_DNS: Trying to Resolve %s\n",domain_name_buffer);
	
	proxy_server.dns_resolver_state = PROXY_WAIT_TO_RESOLVE;
   if (get_ip_address_from_name (domain_name_buffer, 0, set_resolved_address_in_list) == FAIL)
   {
		proxy_server.dns_resolver_state = PROXY_START_DNS_CLIENT;
		printf ("PROXY :resolving failed\n");
   } 
	return;
}

void set_resolved_address_in_list(ULONG *resolved_ip_address, USHORT count,USHORT port_number, enum DNS_STATE status)
{
	PROXY_FORBIDDEN_DOMAIN_ADDRESS *sptr_next_restricted_domain_address;
	USHORT domain_name_index=0,index = 0;
	BYTE dns_buffer[50];
	ULONG *temp_ptr;

	domain_name_index = proxy_server.number_of_address_resolved;
	domain_name_index--;

	sptr_next_restricted_domain_address = proxy_server.ptr_to_restricted_domain_address +
															domain_name_index;

	if (status == RESOLVED)
	{
		sptr_next_restricted_domain_address->count = 0; 		
		temp_ptr = sptr_next_restricted_domain_address->destination_ip_address = (ULONG *) calloc ( count, sizeof (ULONG));
		if ( temp_ptr == NULL )
		{
			printf("\n\rError allocating memory for resolved ip address.");
			return;
		}
      *temp_ptr = 0;
		for (index = 0;index < count;index++)
		{
			*(temp_ptr) = *(resolved_ip_address);
			convert_ip_address_to_dot_format (&dns_buffer[0], *(temp_ptr));
#if 1
			printf ("PROXY: Resolved Name is %s %s\n",sptr_next_restricted_domain_address->domain_name, dns_buffer);
#endif
   		sptr_next_restricted_domain_address->count++; 		
			temp_ptr++;
			resolved_ip_address++;
		}
	}
	else
	{
		printf ("PROXY_DNS: DNS Resolving Failed\n");
	}

	proxy_server.dns_resolver_state = PROXY_START_DNS_CLIENT;

	return;
}
#endif
/* ...Sreelu for Filter */

