/*--------------------------------------------------------------------------*\

Changes History : 

{sudha 02-Feb-2000. proxy pasv FTP, NAT active & pasv FTP support, minor fixes}

\*--------------------------------------------------------------------------*/

#include <defs.h>


#include	<stdio.h>
#include	<stdarg.h>
#include <stddef.h>
#include	<stdlib.h>
#include <string.h>
#include <kstart.h>
#include <memory.h>

#include <redblack.h>
#include "proxyrb.h"

#include <kstart.h>

#include "proxy.h"

#include "vnvproxy.h"

#include "..\..\stacks\ip\karp.h"
#include "..\..\stacks\ip\kip.h"
#include "..\..\stacks\ip\kipuser.h"
#include "..\..\stacks\ip\varpuser.h"
#include "..\..\stacks\ip\varpstr.h"
#include "..\..\stacks\ip\vrarpusr.h"
#include "..\..\stacks\ip\vrarpstr.h"
#include "..\..\stacks\ip\kroute.h"	  
#include "..\..\stacks\ip\viprtstr.h"	  
#include "..\..\stacks\ip\vipusstr.h"  
#include "..\..\stacks\ip\vsktstr.h"
#include "..\..\stacks\ip\kudp.h"
#include "..\..\stacks\ip\vipktstr.h"
#include "..\..\stacks\ip\kicmp.h"
#include "..\..\stacks\ip\vudpuser.h"
#include "..\..\stacks\ip\vudpbuf.h"
#include "..\..\stacks\ip\vudpstr.h"
#include "..\..\stacks\ip\krip.h"
#include "..\..\stacks\ip\vripstr.h"
#include "..\..\stacks\ip\vicmpstr.h"
#include "..\..\stacks\ip\viprastr.h"
#include "..\..\stacks\ip\vipstr.h" 

#include "..\..\stacks\tcp\ktcp.h"
#include "..\..\stacks\tcp\tcp.h"
#include "..\..\stacks\tcp\vtcpstr.h"
#include "..\..\stacks\tcp\tcphdr.h"


/*PROXY_DYNAMIC_APP_LIST *proxy_server_dynamic_application_list= NULL; */

/* Added by Sreelu for RB trees */
extern PROXY_APPLICATION_LIST_NODE far *sptr_proxy_address_tree ;
extern PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_proxy_client_descriptor_tree ;
extern PROXY_SERVER_DESCRIPTOR_NODE far *sptr_proxy_server_descriptor_tree ;
/* Added by Sreelu for RB trees */

/* sudha 19 Jan 1999 */
BOOL is_user_defined_port_not_in_reserved_port_list(USHORT lower_port, USHORT higher_port);

extern BYTE *get_ptr_to_tcp_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern USHORT get_tcp_port_number_from_ip_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, USHORT *destination_port);
extern USHORT get_outgoing_port_number (IP_PARAMETERS* sptr_ip_parameters) ;
extern USHORT get_a_free_port (USHORT, USHORT);
extern void tcp_checksum (IPADDR local_address, IPADDR remote_address, BYTE *tcp_pkt, 
		USHORT tcp_packet_size);
extern int strcmpi (char *s1, char *s2);
extern USHORT get_port_command_length (BYTE *ptr_to_start_of_port_command);
extern USHORT get_application_port_number (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, 
		USHORT *destination_port, enum IP_PROTOCOL_VALUE *protocol_type);

extern USHORT get_secured_lan_port_number();

/* Added by Sreelu for RB Trees */
extern PROXY_APPLICATION_LIST_NODE far *proxy_rb_demo_search(PROXY_APPLICATION_LIST_NODE far *Tree, PROXY_RB_KEY_TYPE key);
extern PROXY_CLIENT_DESCRIPTOR_NODE far *proxy_rb_client_descriptor_search(PROXY_CLIENT_DESCRIPTOR_NODE far *Tree, PROXY_RB_CLIENT_KEY_TYPE key);
extern PROXY_SERVER_DESCRIPTOR_NODE far *proxy_rb_server_descriptor_search(PROXY_SERVER_DESCRIPTOR_NODE far *Tree, PROXY_RB_SERVER_KEY_TYPE key);
/* Added by Sreelu for RB Trees */

/* sudha 02-Feb-2000. For pasv FTP support */
extern void proxy_rb_pasv_ftp_ctrl_client_descriptor_search(PROXY_CLIENT_DESCRIPTOR_NODE far *Tree, PROXY_SERVER_INFO *ptr_proxy_info);

/* sudha 08 June 1999 */
#define MAX_TCP_APPLICATIONS     42
#define MAX_UDP_APPLICATIONS     41

/* sudha 20 Aug 1999 */
#define TOTAL_TCP_APPLICATIONS     47 
/* MAX_TCP_APPLICATIONS + number of entries with double port numbers */
#define TOTAL_UDP_APPLICATIONS     46
/* MAX_UDP_APPLICATIONS + number of entries with double port numbers */

/* sudha 19 Aug 1999 */
USHORT get_port_index (USHORT protocol_type, USHORT protocol_port_number);
void set_protocol_port_number (USHORT protocol_type, USHORT port_number, USHORT application_index);
USHORT get_port_numbers_from_application (USHORT protocol_type, char *application, 
	USHORT *ctrl_port, USHORT *data_port, USHORT *ctrl_index, USHORT *data_index);

typedef struct
{
	USHORT protocol_port_number ;
	char *application ;
} PORT_TO_APPLICATION_MAP ;

PORT_TO_APPLICATION_MAP tcp_applications[] =
{
	{531, "CHAT", },
	{53, "DNS"},
	{7, "ECHO"},
	{79, "FINGER"},
	{21, "FTP"},
	{70, "GOPHER"},
	{144, "NEWS"},
	{110, "POP-3"},
	{532, "READNEWS"},
	{513, "RLOGIN"},
	{25,  "SMTP"},
	{23, "TELNET"},
	{69, "TFTP"},
	{80, "WEB"},
	{42, "HOST NAME SERVER"},
	{443, "HTTPS"},
	{194, "IRC"},
	{119, "NNTP"},
	{563, "SSL-NNTP"},
	{465, "SSL-SMTP"},
	{143, "IMAP"},
	{161, "SNMP"},
	{162, "SNMP-TRAP"},
	{220, "IMAP3"},
	{990, "SSL-FTP"},
	{992, "SSL-Telnet"},
	{993, "SSL-IMAP4"},
	{994, "SSL-IRC"},
	{995, "SSL-POP3"},
	{1090, "Real audio/video"},
	{1723, "PPTP"},
	{6667, "MIRC"},
	{1755, "MS-Streaming"},
	{8000, "Vxtreme"},
	{7070, "Real audio/video"},
	{5190, "AOL"},
	{902, "Q931"},
	{5006, "RTP"},
	{5007, "RTCP"},
	{6284, "Road Runner"},
	{6285, "Road Runner"},
	{7283, "Road Runner"},
	{20, "FTP"},
	{989, "SSL-FTP"},
	{900, "Q931"},
	{5004, "RTP"},
	{5005, "RTCP"},
	{0, ""}
} ;


PORT_TO_APPLICATION_MAP udp_applications[] =
{
	{531, "CHAT"},
	{53, "DNS"},
	{7, "ECHO"},
	{79, "FINGER"},
	{21, "FTP"},
	{70, "GOPHER"},
	{144, "NEWS"},
	{110, "POP-3"},
	{532, "READNEWS"},
	{25,  "SMTP"},
	{23, "TELNET"},
	{69, "TFTP"},
	{80, "WEB"},
	{42, "HOST NAME SERVER"},
	{443, "HTTPS"},
	{194, "IRC"},
	{119, "NNTP"},
	{563, "SSL-NNTP"},
	{465, "SSL-SMTP"},
	{143, "IMAP"},
	{161, "SNMP"},
	{162, "SNMP_TRAP"},
	{220, "IMAP3"},
	{990, "SSL-FTP"},
	{992, "SSL-Telnet"},
	{993, "SSL-IMAP4"},
	{994, "SSL-IRC"},
	{995, "SSL-POP3"},
	{1090, "Real audio/video"},
	{1723, "PPTP"},
	{6667, "MIRC"},
	{1755, "MS-Streaming"},
	{8000, "Vxtreme"},
	{7070, "Real audio/video"},
	{5190, "AOL"},
	{902, "Q931"},
	{5006, "RTP"},
	{5007, "RTCP"},
	{6284, "Road Runner"},
	{6285, "Road Runner"},
	{7283, "Road Runner"},
	{20, "FTP"},
	{989, "SSL-FTP"},
	{900, "Q931"},
	{5004, "RTP"},
	{5005, "RTCP"},
	{0, ""}
};


#if PROXY_DEBUG
extern char *convert_ip_address_to_dot_format (char *, ULONG) ;
extern char *get_protocol_type (char *protocol_type_string, enum IP_PROTOCOL_VALUE protocol_type) ;
extern char *get_port_type (char *port_type_string, enum IP_PROTOCOL_VALUE protocol_type, USHORT protocol_port_number) ;
#endif


/* Sachin, 09/01/1998 */
BYTE same_port_required_for_ftp = FALSE  ;
/* Sachin, 09/01/1998 */


ULONG string_to_ip_address (BYTE *Str);

enum TEST just_read_out (char *cptr_proxy_server_app_string)
{
   return PASS ;
}

/* RB trees - Sreelu */
enum TEST proxy_server_applications_cfg_string (char *cptr_proxy_server_app_string)
{
	int protocol_port, protocol ;
	PROXY_RB_KEY_TYPE	next_application_list;
	BYTE same_port_required=TRUE;

/*sri	PROXY_APPLICATION_TABLE	*sptr_next_application; */
	
	/* number_of_applications : Number of applications configured to be proxied
	   max_number_of_applications : Another field, which decides on the amount of memory to alloocate
	   sptr_application_list : pointer to the applications list
	*/

#if 0		/* Commented by Sreelu for RB trees */
	if (proxy_server.number_of_applications == 0)
	{
		/* Malloc only when the first of the application list strings appear */
		if ((proxy_server.sptr_application_list = (PROXY_APPLICATION_TABLE *) table_malloc (
					(proxy_server.max_number_of_applications - proxy_server.max_number_of_user_defined_applications),sizeof (PROXY_APPLICATION_TABLE))) == NULL)
		{
			proxy_printf ("PROXY: Error allocating Memory\n");
			return FAIL;
		}
	}

	/* Start from the first free slot in the applications list */
	sptr_next_application = proxy_server.sptr_application_list + proxy_server.number_of_applications ;
#endif

	while (1)
   {
      if (sscanf (cptr_proxy_server_app_string, "%04x,%04x", &protocol, &protocol_port) == 0)
         break ;

     next_application_list.protocol_type = (USHORT) protocol ;
     next_application_list.application_port = (USHORT) protocol_port ;

/* new addition for strict port forwarding */
		switch (next_application_list.application_port)
		{
			case WEB_RESERVED_PORT :
				same_port_required = FALSE;				
/*				sptr_next_application->same_port_required = FALSE;*/
				break;

/* Sachin, 09/01/1998 */

			case FTP_DATA_PORT :
			case FTP_COMMAND_PORT :
				same_port_required = same_port_required_for_ftp ;
/*				sptr_next_application->same_port_required = same_port_required_for_ftp ;*/
				break;


/* Sachin, 09/01/1998 */

			default :
				same_port_required = TRUE;				
/*				sptr_next_application->same_port_required = TRUE;*/
				break;
		}
/* new addition for strict port forwarding */

		add_entry_to_proxy_rb_tree (same_port_required, &next_application_list);

/*		sptr_next_application++; */
		proxy_server.number_of_applications++ ;

      cptr_proxy_server_app_string = strchr (cptr_proxy_server_app_string, ',') ;
      if (cptr_proxy_server_app_string == NULL)
         break ;

      cptr_proxy_server_app_string++ ;
      cptr_proxy_server_app_string = strchr (cptr_proxy_server_app_string, ',') ;
      if (cptr_proxy_server_app_string == NULL)
         break ;
      cptr_proxy_server_app_string++ ;

   }
	return PASS;
}

/* Added By Ravi on 04 Jan 1999 for User Defined Ranges ... */
enum TEST proxy_server_applications_info_string (char *cptr_proxy_server_app_string)
{
	int protocol, lower_port_number, higher_port_number ;
   PROXY_APP_PORT_RANGE_LIST *ptr_to_port_range ;     /* Ravi */
	
	/* number_of_applications : Number of applications configured to be proxied
	   max_number_of_applications : Another field, which decides on the amount of memory to alloocate
	   sptr_application_list : pointer to the applications list
	*/

	if (proxy_server.number_of_user_defined_applications == 0)
	{
		/* Malloc only when the first of the application list strings appear */
		if ((proxy_server.proxy_server_application_port_range_list = (PROXY_APP_PORT_RANGE_LIST *) table_malloc (
					proxy_server.max_number_of_user_defined_applications,sizeof (PROXY_APP_PORT_RANGE_LIST))) == NULL)
		{
			proxy_printf ("PROXY: Error allocating Memory\n");
			return FAIL;
		}
	}

	/* Start from the first free slot in the applications list */
	ptr_to_port_range = proxy_server.proxy_server_application_port_range_list + proxy_server.number_of_user_defined_applications ;


	while (1)
   {
      if (sscanf (cptr_proxy_server_app_string, "%04x,%04x,%04x", &protocol, &lower_port_number, &higher_port_number) == 0)
         break ;

      ptr_to_port_range->protocol = (USHORT) protocol ;
      ptr_to_port_range->lower_port_number = (USHORT) lower_port_number ;
      ptr_to_port_range->higher_port_number = (USHORT) higher_port_number ;


		ptr_to_port_range++;
		proxy_server.number_of_user_defined_applications++ ;

      cptr_proxy_server_app_string = strchr (cptr_proxy_server_app_string, ',') ;
      if (cptr_proxy_server_app_string == NULL)
         break ;

      cptr_proxy_server_app_string++ ;
      cptr_proxy_server_app_string = strchr (cptr_proxy_server_app_string, ',') ;
      if (cptr_proxy_server_app_string == NULL)
         break ;

      cptr_proxy_server_app_string++ ;
      cptr_proxy_server_app_string = strchr (cptr_proxy_server_app_string, ',') ;
      if (cptr_proxy_server_app_string == NULL)
         break ;

      cptr_proxy_server_app_string++ ;
      cptr_proxy_server_app_string = strchr (cptr_proxy_server_app_string, ',') ;
      if (cptr_proxy_server_app_string == NULL)
         break ;
      cptr_proxy_server_app_string++ ;

   }
	return PASS;
}


extern ULONG str_to_net (char *) ;
void get_ftp_src_port_and_address (BYTE *ptr_to_tcp_pkt, USHORT *source_port, ULONG *source_address)
{
	BYTE temp_buffer[50], temp_ip_address[25], temp_port[10];
	USHORT port1, port2, new_port_number, buffer_index=0, number_of_commas=0,index=0;
	ULONG src_ip_address;

	ptr_to_tcp_pkt += 5;
	memcpy (temp_buffer, ptr_to_tcp_pkt, 40);
	temp_buffer[40] = 0;
	strtok (temp_buffer, "\n");

	while (temp_buffer[buffer_index])
	{
		temp_ip_address[buffer_index] = temp_buffer[buffer_index];
		if (temp_buffer[buffer_index] == ',')
		{
			temp_ip_address[buffer_index] = '.';			
			number_of_commas++;
		}

		if (number_of_commas == 4)
		{
			temp_ip_address[buffer_index] = 0;
			buffer_index++;
			break;
		}
		buffer_index++;
	}		

	src_ip_address = str_to_net (temp_ip_address);	
	*source_address = src_ip_address;

	while (temp_buffer[buffer_index])
	{
		temp_port[index++] = temp_buffer[buffer_index];		
		if (temp_buffer[buffer_index] == '\n')
		{
			temp_port[index-2] = 0;			
			break;
		}
		buffer_index++;
	}	
	sscanf (temp_port ,"%hu,%hu",&port1, &port2);		
	
	port1 = port1 & 0x00ff;
	port1 = port1 << 8;
	port2 = port2 &0x00ff;
	new_port_number = (port1 | port2);
	*source_port = new_port_number;	

	return;
}

BYTE *check_for_ftp_port_command_and_process (UNION_IP_PACKET *uptr_ip_rx_packet, enum BOOLEAN *return_value, IP_PARAMETERS *sptr_ip_parameters, PROXY_SERVER_INFO *sptr_control_connection)
{
	BYTE temp_buff[6];
	BYTE *ptr_to_tcp_pkt;
	USHORT source_port=0;
	ULONG source_ip_address;
	PROXY_SERVER_INFO *ptr_to_proxy_server_info;
#if PROXY_DEBUG
	char mapped_ip_address[20], src_ip_address[20], dest_application[10], protocol_type_string[10] ;
	USHORT protocol_port ;
	enum IP_PROTOCOL_VALUE protocol_type ;
#endif
	USHORT ip_total_length = sptr_ip_parameters->total_length ;
	USHORT port_command_length, ip_header_length = sptr_ip_parameters->header_length ;
	PROXY_RB_CLIENT_KEY_TYPE client_descriptor_key;
	PROXY_RB_SERVER_KEY_TYPE server_descriptor_key;
	
	ptr_to_tcp_pkt = get_ptr_to_tcp_packet ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters);
	if ((port_command_length = get_port_command_length (ptr_to_tcp_pkt)) > 35)
	{
		/* It can never be greater */
		*return_value = FALSE ;
		return NULL ;
	}
	if (port_command_length + ip_header_length + sizeof (TCP_HEADER) != ip_total_length)
	{
		*return_value = FALSE ;
		return NULL ;
	}
	memcpy (temp_buff,ptr_to_tcp_pkt,4);
	temp_buff[4] = 0;
	if (strcmpi (temp_buff, "Port"))
	{
		*return_value = FALSE;
		return NULL;
	}

/*	ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) malloc (sizeof (PROXY_SERVER_INFO)); */
	ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) calloc (sizeof (PROXY_SERVER_INFO), 1);
	if (ptr_to_proxy_server_info == NULL)
	{
		proxy_printf ("PROXY_SERVER: Not Enough memory to proxy, Dropping packet\n");
		*return_value = FALSE; /* Added by Ravi */
		return NULL;
	}

	ptr_to_proxy_server_info->outgoing_physical_port = 
		sptr_control_connection->outgoing_physical_port ;


   proxy_server.port[sptr_control_connection->outgoing_physical_port].number_of_connections++ ;


	if (ptr_to_proxy_server_info->outgoing_physical_port == 0)
	{
		free (ptr_to_proxy_server_info);
		*return_value = FALSE; /* Added by Ravi */
		return NULL;
	}	

	get_ftp_src_port_and_address (ptr_to_tcp_pkt, &source_port, &source_ip_address);

	ptr_to_proxy_server_info->mapped_port = get_a_free_port(0, source_port);

#ifdef PROXY_ON_SECURED_LAN_PORT
	ptr_to_proxy_server_info->outgoing_port_address =  get_ip_address (get_secured_lan_port_number());
#else
	ptr_to_proxy_server_info->outgoing_port_address = get_ip_address (ptr_to_proxy_server_info->outgoing_physical_port);
#endif
				


	ptr_to_proxy_server_info->source_port = source_port;
	ptr_to_proxy_server_info->client_ip_address = source_ip_address;
	ptr_to_proxy_server_info->protocol_type = sptr_ip_parameters->protocol;
	ptr_to_proxy_server_info->proxy_idle_timer = 600;

/* sudha 05-Nov-1999... */
	ptr_to_proxy_server_info->client_node = NULL;
	ptr_to_proxy_server_info->server_node = NULL;		
/* ...sudha 05-Nov-1999 */

/* Sachin, 23/12/1997 */
   if (ptr_to_proxy_server_info->ptr_to_ftp_command_descriptor)
	   ptr_to_proxy_server_info->ptr_to_ftp_command_descriptor->proxy_idle_timer = 600;
/* Sachin, 23/12/1997 */
	ptr_to_proxy_server_info->connection_closing = FALSE;
	
/*sri	add_entry_to_list ((LINK *)&proxy_server.proxy_server_info_list, (LINK *)ptr_to_proxy_server_info);*/

	client_descriptor_key.client_ip_address = source_ip_address;
	client_descriptor_key.protocol_type = sptr_ip_parameters->protocol;
	client_descriptor_key.application_port = source_port;

	add_entry_to_proxy_client_descriptor_tree (ptr_to_proxy_server_info, (BYTE *) &client_descriptor_key);
	server_descriptor_key.protocol_type = sptr_ip_parameters->protocol;
	server_descriptor_key.application_port = ptr_to_proxy_server_info->mapped_port ;

	add_entry_to_proxy_server_descriptor_tree (ptr_to_proxy_server_info, (BYTE *) &server_descriptor_key);

#if PROXY_DEBUG
	protocol_port = get_application_port_number ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters, &protocol_port, &protocol_type) ;	
	proxy_printf ("PROXY: Mapping <%s,%04X> to <%s,%04X> to proxy %s port %s on WAN %04X\n",
		convert_ip_address_to_dot_format (&src_ip_address[0], ptr_to_proxy_server_info->client_ip_address),
		ptr_to_proxy_server_info->source_port,
		convert_ip_address_to_dot_format (&mapped_ip_address[0], ptr_to_proxy_server_info->outgoing_port_address),
		ptr_to_proxy_server_info->mapped_port,
		get_protocol_type (&protocol_type_string[0], protocol_type),
		get_port_type (&dest_application[0], protocol_type, protocol_port), 
		ptr_to_proxy_server_info->outgoing_physical_port-1) ;
#endif

	
	proxy_server.number_of_proxied_clients++;
	if (proxy_server.number_of_proxied_clients > proxy_server.peak_concurrent_descriptor_count)
		proxy_server.peak_concurrent_descriptor_count = proxy_server.number_of_proxied_clients ;
	
	*return_value = TRUE;
	return ((BYTE *)ptr_to_proxy_server_info);
}


USHORT get_first_active_port ()
{
#if 0	
   USHORT port_number ;
	
	for (port_number = 0 ; port_number < NUMBER_OF_PROXY_PORTS ; port_number++)
	{
		if (is_ipport_up (port_number+1) == TRUE)
		{
            proxy_server.port[port_number+1].number_of_connections++ ;
				return (port_number+1);
		}
	}
	return 0;
#endif
}



USHORT get_matched_port_from_existing_descriptor (USHORT reserved_port, IP_PARAMETERS *sptr_ip_parameters)
{
	PROXY_SERVER_INFO *ptr_to_proxy_server_info;
	USHORT port_number = 0;
	PROXY_RB_CLIENT_KEY_TYPE client_descriptor_key;
	PROXY_CLIENT_DESCRIPTOR_NODE far *proxy_temp_client_descriptor_list;
   BYTE string[20];		/* Added by Sreelu */
					
	
	client_descriptor_key.client_ip_address = sptr_ip_parameters->source_address;
	client_descriptor_key.protocol_type = sptr_ip_parameters->protocol;
	client_descriptor_key.application_port = reserved_port;

	proxy_temp_client_descriptor_list = proxy_rb_client_descriptor_search (
							sptr_proxy_client_descriptor_tree, client_descriptor_key);

	if (proxy_temp_client_descriptor_list == NULL)
	{
		proxy_printf ("PROXY: Search failed in client descriptor list\n");
		return port_number;
	}

	ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) proxy_temp_client_descriptor_list->info.client_descriptor;

	if (ptr_to_proxy_server_info)
		port_number = ptr_to_proxy_server_info->outgoing_physical_port;
	else
		printf ("PROXY: No Descriptor exist for this tree\n");
	
	printf ("PROXY :Matched Port is %d\n", port_number); 

#if 0		/* Commented by Sreelu for RB tress */
	ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) get_pointer_to_first_entry_in_list ((LINK *)&proxy_server.proxy_server_info_list); 
	while (ptr_to_proxy_server_info != NULL)
	{
#if 0
		printf ("Matching %x  %x::  %d  %d :: %x  %x \n",ptr_to_proxy_server_info->client_ip_address,
			sptr_ip_parameters->source_address,
			ptr_to_proxy_server_info->destination_port, reserved_port,
			ptr_to_proxy_server_info->destination_address, sptr_ip_parameters->destination_address);
#endif
			
		if ((ptr_to_proxy_server_info->client_ip_address == sptr_ip_parameters->source_address) &&
			(ptr_to_proxy_server_info->destination_port == reserved_port))
/*			(ptr_to_proxy_server_info->destination_address == sptr_ip_parameters->destination_address)) */
		{
			port_number = ptr_to_proxy_server_info->outgoing_physical_port;
			break;
		}
		ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) get_pointer_to_next_entry_in_list ((LINK *)ptr_to_proxy_server_info);
	}
#endif

	return port_number;
}


USHORT get_proper_port_to_send_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters)
{
	USHORT reserved_port=0, port_number=0, dummy_port=0, application_index=0;
	PROXY_APPLICATION_TABLE *proxy_application_list = proxy_server.sptr_application_list;
	PROXY_RB_KEY_TYPE proxy_rb_key;
	PROXY_APPLICATION_LIST_NODE *proxy_temp_application_node;
		
	if (sptr_ip_parameters->protocol == TCP_PROTOCOL)
		reserved_port = get_tcp_port_number_from_ip_packet ((BYTE *)uptr_ip_rx_packet,
						sptr_ip_parameters, &dummy_port);
	else if (sptr_ip_parameters->protocol == UDP_PROTOCOL)
		reserved_port = get_udp_port_number_from_ip_packet ((BYTE *)uptr_ip_rx_packet,
						sptr_ip_parameters, &dummy_port);
		
	proxy_rb_key.protocol_type = sptr_ip_parameters->protocol;
	proxy_rb_key.application_port = reserved_port;

	proxy_temp_application_node = proxy_rb_demo_search (sptr_proxy_address_tree, proxy_rb_key);

	if (proxy_temp_application_node  && proxy_temp_application_node->info.same_port_required)
	{
		port_number = get_matched_port_from_existing_descriptor (reserved_port, sptr_ip_parameters);							
	}


#if 0		/* Commented by Sreelu for RB trees */
	for (application_index = 0; application_index <= proxy_server.number_of_applications; 
				application_index++, proxy_application_list++)
		if ((proxy_application_list->protocol_port == reserved_port) && 
				(proxy_application_list->protocol_type == sptr_ip_parameters->protocol))
			break;

	if (proxy_application_list->same_port_required)
		port_number = get_matched_port_from_existing_descriptor (reserved_port, sptr_ip_parameters);							
#endif

	if (port_number)
	{
      proxy_server.port[port_number].number_of_connections++ ;
		printf ("PROXY: Allocating Same Port %04x as configured\n",port_number);
		return port_number;
	}

	if (port_number == 0)
		port_number = get_outgoing_port_number(sptr_ip_parameters);

	return port_number;
}

PROXY_SERVER_INFO *get_free_proxy_server_info_ptr (USHORT application_port, BYTE *uptr_rx_packet, 
		IP_PARAMETERS *sptr_ip_parameters, USHORT rxed_port_number, USHORT protocol_type, 
		enum BOOLEAN *eptr_ftp_port_command, enum BOOLEAN is_icmp_packet, IP_ROUTE_ENTRY *sptr_static_route_entry)
{
	PROXY_SERVER_INFO *ptr_to_proxy_server_info;
	ULONG client_ip_address;
	enum BOOLEAN return_value= FALSE;
	PROXY_SERVER_INFO *new_descriptor;
	USHORT reserved_port=0, dummy_port=0;
	UNION_IP_PACKET *uptr_ip_rx_packet;
#if PROXY_DEBUG
	char mapped_ip_address[20], src_ip_address[20], dest_application[10], protocol_type_string[10] ;
	USHORT protocol_port ;
	enum IP_PROTOCOL_VALUE ip_protocol_type ;
#endif

	PROXY_RB_CLIENT_KEY_TYPE client_descriptor_key;
	PROXY_CLIENT_DESCRIPTOR_NODE far *proxy_temp_client_descriptor_list;

	PROXY_RB_SERVER_KEY_TYPE server_descriptor_key;

	*eptr_ftp_port_command = FALSE ;

	uptr_ip_rx_packet = (UNION_IP_PACKET *) uptr_rx_packet;
	client_ip_address = uptr_ip_rx_packet->ip.header.source_ip_address;


	switch (sptr_ip_parameters->protocol)
	{
		case IP_DATA_TCP:
		case IP_DATA_UDP:
			client_descriptor_key.client_ip_address = client_ip_address;
			client_descriptor_key.protocol_type = sptr_ip_parameters->protocol;
			client_descriptor_key.application_port = application_port;
			proxy_temp_client_descriptor_list = proxy_rb_client_descriptor_search (
							sptr_proxy_client_descriptor_tree, client_descriptor_key);

			if (proxy_temp_client_descriptor_list)
				ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) proxy_temp_client_descriptor_list->info.client_descriptor;

			reserved_port = get_tcp_port_number_from_ip_packet ((BYTE *)uptr_ip_rx_packet,
					sptr_ip_parameters, &dummy_port);

			if ( proxy_temp_client_descriptor_list != NULL &&
				  proxy_temp_client_descriptor_list->key.application_port == application_port && 
				  proxy_temp_client_descriptor_list->key.client_ip_address == client_ip_address &&
				  proxy_temp_client_descriptor_list->key.protocol_type == sptr_ip_parameters->protocol &&
				  ptr_to_proxy_server_info->source_port == dummy_port)
			{

/* This is to support FTP */
/* sudha 02-Feb-2000. Changed "FTP_COMMAND_PORT" to dynamic ftp ctrl port */
				if (reserved_port == proxy_server.ftp_ctrl_conn_port)													
				{
					new_descriptor = (PROXY_SERVER_INFO *) check_for_ftp_port_command_and_process (uptr_rx_packet, &return_value, sptr_ip_parameters, ptr_to_proxy_server_info);
				}		

				if (return_value == TRUE)
				{
					new_descriptor->ptr_to_ftp_command_descriptor = ptr_to_proxy_server_info;
					ptr_to_proxy_server_info->ptr_to_ftp_data_descriptor = new_descriptor;

/* This is to support TFTP */
					ptr_to_proxy_server_info->tftp_packet_detected = FALSE;
/* This is to support TFTP */

					new_descriptor->incoming_physical_port = sptr_ip_parameters->rx_port_number;
		
					*eptr_ftp_port_command = TRUE ;
				}
				return (ptr_to_proxy_server_info);
			}

		default:
			break;
	}
			
	ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) calloc (sizeof (PROXY_SERVER_INFO), 1);
	if (ptr_to_proxy_server_info == NULL)
	{
		proxy_printf ("PROXY_SERVER: Not Enough memory to proxy, Dropping packet\n");	
		return NULL;
	}

	ptr_to_proxy_server_info->ftp_port_command_on = FALSE;
	ptr_to_proxy_server_info->seq_offset = 0;
	
	ptr_to_proxy_server_info->in_use = TRUE;
	ptr_to_proxy_server_info->protocol_type = sptr_ip_parameters->protocol;
	ptr_to_proxy_server_info->destination_address = sptr_ip_parameters->destination_address;
		
	ptr_to_proxy_server_info->ptr_to_ftp_data_descriptor = NULL;
	ptr_to_proxy_server_info->source_port = application_port; 
	ptr_to_proxy_server_info->client_ip_address = uptr_ip_rx_packet->ip.header.source_ip_address ;				
	
	if(sptr_ip_parameters->protocol == IP_DATA_TCP)
		ptr_to_proxy_server_info->proxy_idle_timer = 600;
	else			
		ptr_to_proxy_server_info->proxy_idle_timer = 60;

	ptr_to_proxy_server_info->connection_closing = FALSE;
	ptr_to_proxy_server_info->tftp_packet_detected = FALSE;
	
	reserved_port = get_tcp_port_number_from_ip_packet ((BYTE *)uptr_ip_rx_packet,
							sptr_ip_parameters, &dummy_port);

/* sudha 02-Feb-2000 */
/* Interchanged reserved_port & application_port variables */
	ptr_to_proxy_server_info->mapped_port = get_a_free_port(reserved_port, application_port);

/* sudha 02-Feb-2000. For pasv FTP support ... */
	ptr_to_proxy_server_info->destination_port = reserved_port; 
	proxy_rb_pasv_ftp_ctrl_client_descriptor_search (sptr_proxy_client_descriptor_tree, ptr_to_proxy_server_info);	
/* ... sudha 02-Feb-2000. For pasv FTP support */

/* sudha 05-Nov-1999... */
	ptr_to_proxy_server_info->client_node = NULL;
	ptr_to_proxy_server_info->server_node = NULL;		
/* ...sudha 05-Nov-1999 */

/* Sachin, 23/12/1997 */
   if (ptr_to_proxy_server_info->ptr_to_ftp_command_descriptor)
	{
/*		printf ("Setting idle timer for ftp\n"); */
	   ptr_to_proxy_server_info->ptr_to_ftp_command_descriptor->proxy_idle_timer = 600;
	}
/* Sachin, 23/12/1997 */

/* Added by Ravi to Support Static Routes on 20 August 1999 ... */
	if (sptr_static_route_entry == NULL)
	{
		if (is_icmp_packet == TRUE)
	   {
/* Naveen 27/2/1998: For FIREWALL ... */
			ptr_to_proxy_server_info->outgoing_physical_port = get_outgoing_port_number(sptr_ip_parameters); /*get_first_active_port();*/
	      proxy_server.port[ptr_to_proxy_server_info->outgoing_physical_port].number_of_connections++;
/* ... Naveen 27/2/1998: For FIREWALL */
   	}
/* sudhir only for ping */
		else
		{
/* sudha 02-Feb-2000. For pasv FTP support ... */
			if ((ptr_to_proxy_server_info->physical_port_for_pasv_ftp_data_connection != 0) && 
				 (ptr_to_proxy_server_info->ptr_to_ftp_command_descriptor))
			{
				ptr_to_proxy_server_info->outgoing_physical_port = 
					ptr_to_proxy_server_info->physical_port_for_pasv_ftp_data_connection;
				proxy_server.port[ptr_to_proxy_server_info->outgoing_physical_port].number_of_connections++;
			}
			else
			{
/* ... sudha 02-Feb-2000. For pasv FTP support */
				ptr_to_proxy_server_info->outgoing_physical_port = 
					get_proper_port_to_send_packet (uptr_rx_packet, sptr_ip_parameters);
			}
		}
	}
	else
	{
		ptr_to_proxy_server_info->outgoing_physical_port =  sptr_static_route_entry->port_number;		
	}
/* ... Added by Ravi to Support Static Routes on 20 August 1999 */


	if (ptr_to_proxy_server_info->outgoing_physical_port == 0)
	{
		proxy_printf ("PROXY: No Internet ports to proxy on\n") ;
		free (ptr_to_proxy_server_info);
		return NULL;
	}

#ifdef PROXY_ON_SECURED_LAN_PORT
	ptr_to_proxy_server_info->outgoing_port_address =  get_ip_address (get_secured_lan_port_number());
#else
	ptr_to_proxy_server_info->outgoing_port_address =  get_ip_address (ptr_to_proxy_server_info->outgoing_physical_port);
#endif

	proxy_server.last_allocated_port = ptr_to_proxy_server_info->outgoing_physical_port;
/*	printf ("PROXY: Outgoing Internet Port is %d\n",ptr_to_proxy_server_info->outgoing_physical_port); */

	proxy_server.number_of_proxied_clients++;

	if (proxy_server.number_of_proxied_clients > proxy_server.peak_concurrent_descriptor_count)
		proxy_server.peak_concurrent_descriptor_count = proxy_server.number_of_proxied_clients ;

	if(sptr_ip_parameters->protocol == IP_DATA_ICMP)
		return ptr_to_proxy_server_info;

	client_descriptor_key.client_ip_address = ptr_to_proxy_server_info->client_ip_address;
	client_descriptor_key.protocol_type = sptr_ip_parameters->protocol;
	client_descriptor_key.application_port = ptr_to_proxy_server_info->source_port;
	add_entry_to_proxy_client_descriptor_tree (ptr_to_proxy_server_info, (BYTE *) &client_descriptor_key);


	server_descriptor_key.protocol_type = sptr_ip_parameters->protocol;
	server_descriptor_key.application_port = ptr_to_proxy_server_info->mapped_port;
	
	add_entry_to_proxy_server_descriptor_tree (ptr_to_proxy_server_info, (BYTE *) &server_descriptor_key);

#if PROXY_DEBUG
	protocol_port = get_application_port_number (uptr_rx_packet, sptr_ip_parameters, &protocol_port, &ip_protocol_type) ;	
	proxy_printf ("PROXY: Mapping <%s,%04X> to <%s,%04X> to proxy %s port %s on WAN %04X\n",
		convert_ip_address_to_dot_format (&src_ip_address[0], ptr_to_proxy_server_info->client_ip_address),
		ptr_to_proxy_server_info->source_port,
		convert_ip_address_to_dot_format (&mapped_ip_address[0], ptr_to_proxy_server_info->outgoing_port_address),
		ptr_to_proxy_server_info->mapped_port,
		get_protocol_type (&protocol_type_string[0], ip_protocol_type),
		get_port_type (&dest_application[0], sptr_ip_parameters->protocol, protocol_port), 
		ptr_to_proxy_server_info->outgoing_physical_port-1) ;
#endif
	
	return ptr_to_proxy_server_info;
}


UNION_IP_PACKET *update_tcp_checksum_in_packet (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters)
{
	BYTE *ptr_to_tcp_packet;
	USHORT tcp_packet_size=0;


	tcp_packet_size = uptr_ip_rx_packet->ip.header.total_length - (USHORT) (uptr_ip_rx_packet->ip.header.version_header_length.header_length << 2);
	
	ptr_to_tcp_packet = (BYTE *) ((ULONG) uptr_ip_rx_packet + sizeof(UNION_MAC_HEADER) + (ULONG) (uptr_ip_rx_packet->ip.header.version_header_length.header_length << 2)); 

	tcp_checksum (uptr_ip_rx_packet->ip.header.source_ip_address,uptr_ip_rx_packet->ip.header.destination_ip_address,
				ptr_to_tcp_packet,tcp_packet_size);
	
	return (uptr_ip_rx_packet);
}

UNION_IP_PACKET *update_udp_checksum_in_packet (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters)
{
	PSEUDO_IP_PARAMETERS pseudo_header;
	UDP_HEADER *ptr_to_udp_hdr;
	BYTE *ptr_to_udp_packet;

	ptr_to_udp_packet = (BYTE *) ((ULONG) uptr_ip_rx_packet + sizeof(UNION_MAC_HEADER) + sptr_ip_parameters->header_length);
	ptr_to_udp_hdr = (UDP_HEADER *)ptr_to_udp_packet;
		
	pseudo_header.length = ptr_to_udp_hdr->length;
	pseudo_header.source_address = sptr_ip_parameters->source_address;
	pseudo_header.destination_address = sptr_ip_parameters->destination_address;
	pseudo_header.zero_field = 0x00;
	pseudo_header.protocol = UDP_PROTOCOL;
	
	ptr_to_udp_hdr->checksum = 0x0000;	

	compute_checksum_for_packet (&pseudo_header,(UDP_PACKET *)uptr_ip_rx_packet, ptr_to_udp_hdr->length);
}

void proxy_printf (const char *cptr_format, ...)
{
   enum BOOLEAN print_string;

	va_list argptr;

	va_start (argptr,cptr_format); 

   print_string = proxy_server.proxy_server_printf_enabled;

	if (print_string == TRUE)
	{
		vprintf (cptr_format,argptr);
	}

	va_end (argptr);
}

ULONG string_to_ip_address (BYTE *Str)
{
	int f1, f2, f3, f4;

	if (sscanf(Str,"%3u,%3u,%3u,%3u", &f1, &f2, &f3, &f4) != 4)
		return(-1l);

	if ((f1 < 0) || (f1 > 255) || (f2 < 0) || (f2 > 255) ||
			(f3 < 0) || (f3 > 255) || (f4 < 0) || (f4 > 255))
		return(-1);

	return ((f1 << 24) | (f2 << 16) | (f3 << 8) | f4);
}

char *get_protocol_type (char *protocol_type_string, enum IP_PROTOCOL_VALUE protocol_type)
{
	switch (protocol_type)
	{
		case (ICMP_PROTOCOL) :
			strcpy (protocol_type_string, "ICMP") ;
			break ;

		case (TCP_PROTOCOL) :
			strcpy (protocol_type_string, "TCP") ;
			break ;

		case (IGP_PROTOCOL) :
			strcpy (protocol_type_string, "IGP") ;
			break ;

		case (UDP_PROTOCOL) :
			strcpy (protocol_type_string, "UDP") ;
			break ;

		/* Added By Ravi */
		case (TCP_UDP_PROTOCOL) :
			strcpy (protocol_type_string, "TCP & UDP") ;
			break ;

		default :
			strcpy (protocol_type_string, "Unknown") ;
			break ;
	}
	return (protocol_type_string) ;
}


USHORT get_protocol_port_number (USHORT protocol_type, USHORT application_index)
{

	switch (protocol_type)
	{
		case (TCP_PROTOCOL) :
/* sudha 27 Nov 1998 */
		case (TCP_UDP_PROTOCOL) : 
			if (application_index < (MAX_TCP_APPLICATIONS + 1))
				return tcp_applications[application_index-1].protocol_port_number	;
			
		case (UDP_PROTOCOL) :
			if (application_index < (MAX_UDP_APPLICATIONS + 1))
				return udp_applications[application_index-1].protocol_port_number	;

		default:
			return application_index;
	}
	return 0;
}
				
		

char *get_port_type (char *port_type_string, enum IP_PROTOCOL_VALUE protocol_type, USHORT protocol_port_number)
{
	int index ;

	switch (protocol_type)
	{
		case (TCP_PROTOCOL) :
 		/* Added By Ravi On 04 Nov 1998 ... */
		case (TCP_UDP_PROTOCOL) :
		/* ... Added By Ravi On 04 Nov 1998 */
			for (index = 0 ;
			     tcp_applications[index].protocol_port_number && tcp_applications[index].protocol_port_number != protocol_port_number ;
			     index++) ;
				if (tcp_applications[index].protocol_port_number == 0)
				{
					return ("user defined");
/*					sprintf (port_type_string, "%04X", protocol_port_number) ; */
				}
				else
					strcpy (port_type_string, tcp_applications[index].application) ;
				break ;

		case (UDP_PROTOCOL) :
			for (index = 0 ;
			     udp_applications[index].protocol_port_number && udp_applications[index].protocol_port_number != protocol_port_number ;
			     index++) ;
				if (udp_applications[index].protocol_port_number == 0)
				{
					return ("user defined");
/*					sprintf (port_type_string, "%04X", protocol_port_number) ; */
				}
				else
					strcpy (port_type_string, udp_applications[index].application) ;
				break ;

		default :
			
			sprintf (port_type_string, "%04X", protocol_port_number) ;
	}
	return (port_type_string) ; 
}

/* sudha 19 Aug 1999. For FTP configurable ctrl & data ports */
USHORT get_port_index (USHORT protocol_type, USHORT protocol_port_number)
{
	int index ;

	switch (protocol_type)
	{
		case (TCP_PROTOCOL) :
			for (index = 0 ;
			     tcp_applications[index].protocol_port_number && tcp_applications[index].protocol_port_number != protocol_port_number ;
			     index++) ;
				if (strcmp(tcp_applications[index].application,"") == 0)
				{
					printf("\n\rTCP Fail1 %d", index);
					return 0xFF; /* user defined entry */
				}
				else
					break ;

		case (UDP_PROTOCOL) :
			for (index = 0 ;
			     udp_applications[index].protocol_port_number && udp_applications[index].protocol_port_number != protocol_port_number ;
			     index++) ;
				if (strcmp(udp_applications[index].application,"") == 0)
				{
					printf("\n\rUDP Fail1 %d", index);
					return 0xFF; /* user defined entry */
				}
				else
					break ;

		default :
			printf("\n\rUDP Fail2. %d", UDP_PROTOCOL);
			return 0xFF;
	}
/* printf("\n\rPROXY: Index is %d",index); */
	return (index) ; 
}

void set_protocol_port_number (USHORT protocol_type, USHORT port_number, USHORT application_index)
{
	switch (protocol_type)
	{
		case (TCP_PROTOCOL) :
			if (application_index < TOTAL_TCP_APPLICATIONS)
			{
				tcp_applications[application_index].protocol_port_number	= port_number;
				return;
			}
			break;

		case (UDP_PROTOCOL) :
			if (application_index < TOTAL_UDP_APPLICATIONS)
			{
				udp_applications[application_index].protocol_port_number = port_number;
				return;
			}
			break;

		default:
			printf("\n\rUDPset is %d", UDP_PROTOCOL);
			return ;
	}
	return ;
}

USHORT get_port_numbers_from_application (USHORT protocol_type, char *application, 
	USHORT *ctrl_port, USHORT *data_port, USHORT *ctrl_index, USHORT *data_index)
{
	int index1 = 0, index2 = 0;
	switch (protocol_type)
	{
		case (TCP_PROTOCOL) :
			for (index1 = 0 ;
			     tcp_applications[index1].protocol_port_number && 
				  (strcmp(tcp_applications[index1].application,application) != 0);
			     index1++) ;
				if (strcmp(tcp_applications[index1].application,"") == 0)
					return 0; /* user defined entry */
				else
				{
					*ctrl_port = tcp_applications[index1].protocol_port_number;
					*ctrl_index = index1;
				}

			for (index2 = index1 + 1;
			     tcp_applications[index2].protocol_port_number && 
				  (strcmp(tcp_applications[index2].application,application) != 0);
			     index2++) ;
				if (strcmp(tcp_applications[index2].application,"") == 0)
					return 0; /* user defined entry */
				else
				{
					*data_port = tcp_applications[index2].protocol_port_number;
					*data_index = index2;
				}
			break;

		case (UDP_PROTOCOL) :

			for (index1 = 0 ;
			     udp_applications[index1].protocol_port_number && 
				  (strcmp(udp_applications[index1].application,application) != 0);
			     index1++) ;
				if (strcmp(udp_applications[index1].application,"") == 0)
				{
					printf("\n\rUDP Fail3.%d", index1);
					return 0; /* user defined entry */
				}
				else
				{
					*ctrl_port = udp_applications[index1].protocol_port_number;
					*ctrl_index = index1;
				}

			for (index2 = index1 + 1;
			     udp_applications[index2].protocol_port_number && 
				  (strcmp(udp_applications[index2].application,application) != 0);
			     index2++) ;
				if (strcmp(udp_applications[index2].application,"") == 0)
				{
					printf("\n\rUDP Fail4 %d", index2);
					return 0; /* user defined entry */
				}
				else
				{
					*data_port = udp_applications[index2].protocol_port_number;
					*data_index = index2;
				}
			break;

		default:
			printf("\n\rUDPget is %d", UDP_PROTOCOL);
			break;
	}
/* printf("\n\rPROXY : port is %d, index  is %d, data is %d, index is %d", 
*ctrl_port, *ctrl_index, *data_port, *data_index); */
	return 1;
}

void proxy_configuration ()
{
	BYTE application_buffer[200], temp_buffer_1[20], temp_buffer_2[20], temp_buffer[100] ;
	PROXY_APPLICATION_TABLE *sptr_proxy_application_list = proxy_server.sptr_application_list;
	USHORT index = 0 ;
	
	application_buffer[0] = 0 ;
	printf ("\nPROXY: Proxy Server Configuration...............\n") ;
	printf ("PROXY: Number of Applications : %d\n", proxy_server.number_of_applications) ;
	for (index = 0 ; index < proxy_server.number_of_applications ; sptr_proxy_application_list++, index++)
	{
		if (index && ((index % 3) == 0))
		{
			proxy_printf ("%s", &application_buffer[0]) ;
			application_buffer[0] = 0 ;
		}
		sprintf (&temp_buffer[0], "\tProtocol : %s Application : %s (%04d)\n",
					get_protocol_type (&temp_buffer_1[0], sptr_proxy_application_list->protocol_type),
					get_port_type (&temp_buffer_2[0], sptr_proxy_application_list->protocol_type, sptr_proxy_application_list->protocol_port),
					sptr_proxy_application_list->protocol_port) ;
		strcat (&application_buffer[0], &temp_buffer[0]) ;
	}
	if (proxy_server.number_of_applications)
		proxy_printf ("%s", &application_buffer[0]) ;
}

void proxy_status ()
{
	int count = 0 ;
	PROXY_SERVER_INFO *ptr_to_proxy_server_info;
   PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_root = sptr_proxy_client_descriptor_tree ;
	PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_next_node;
	
/*sri	ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) get_pointer_to_first_entry_in_list ((LINK *)&proxy_server.proxy_server_info_list); */

	if (sptr_root == NULL )
		return;

	sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_root) ;

	while (sptr_next_node != NULL)
	{
		count++ ;
/*		ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) get_pointer_to_next_entry_in_list ((LINK *)ptr_to_proxy_server_info); */
		sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
	}	  

	printf ("\nPROXY: Displaying status............\n") ;
	printf ("Number of active clients being proxied : %d\n", proxy_server.number_of_proxied_clients) ;
	printf ("Number of descriptors in the list : %d\n", count) ;
	printf ("Peak Active Descriptor Count : %d\n", proxy_server.peak_concurrent_descriptor_count) ;
}


void proxy_internet_port_status ()
{
	USHORT port_index;
	BYTE temp_buffer1[25], temp_buffer2[25];

	for (port_index = 0;	port_index < NUMBER_OF_PROXY_PORTS; port_index++)
	{
		if (is_ipport_up (port_index) == FALSE)
			continue;
			
		printf ("PROXY: Displaying status of Port %d...\n",port_index);				
		printf ("Local IP Address : %s   Remote IP Address : %s\n",
				convert_ip_address_to_dot_format (temp_buffer1, get_ip_address (port_index)),
				convert_ip_address_to_dot_format (temp_buffer2, get_ip_remote_address (port_index)));
      printf ("Number of connections : %d\n", proxy_server.port[port_index].number_of_connections) ;
	}										
	return;
}

/* Added By Ravi on 04 Jan 1999 ... */
void proxy_user_defined_application ()
{
	int application_index;
	PROXY_APP_PORT_RANGE_LIST *ptr_to_port_range = proxy_server.proxy_server_application_port_range_list;

	printf("\n Number of Reserved Application     : %d ", proxy_server.number_of_applications);
	printf("\n Number of User Defined Application : %d ", proxy_server.number_of_user_defined_applications);

	for (application_index = 0; application_index < proxy_server.number_of_user_defined_applications; 
		  application_index++, ptr_to_port_range++)
	{
		printf("\n Protocol : %04x  Lower Port : %04x  Higher Port : %04x",ptr_to_port_range->protocol, ptr_to_port_range->lower_port_number, ptr_to_port_range->higher_port_number);
	}
}
/* ... Added By Ravi on 04 Jan 1999 */

/* sudhir for ftp passive command handling */

void add_port_to_application_list (USHORT application_port_number)
{
	PROXY_DYNAMIC_APP_LIST *temp_app_list_ptr;

	/* temp_app_list_ptr = (PROXY_DYNAMIC_APP_LIST *) malloc (sizeof (PROXY_DYNAMIC_APP_LIST));	 */
	temp_app_list_ptr = (PROXY_DYNAMIC_APP_LIST *) calloc (sizeof (PROXY_DYNAMIC_APP_LIST), 1);
	if (temp_app_list_ptr == NULL)
	{
		printf ("PROXY : Not Enough memory add application\n");
		return;
	} 
	proxy_printf ("Added new entry to list %d\n",application_port_number);	 
	temp_app_list_ptr->application_port = application_port_number;
	temp_app_list_ptr->sptr_forward_link = proxy_server.proxy_server_dynamic_application_list;
	proxy_server.proxy_server_dynamic_application_list = temp_app_list_ptr;
	return;
}

/* sudha 02-Feb-2000. Changed return type from "void" to "USHORT" for
NAT pasv FTP support */
USHORT add_passive_port_to_application_list (BYTE *ptr_to_data_packet)
{
	BYTE temp_buffer[75], temp_port[10];	
	USHORT number_of_commas =0, buffer_index = 0, index =0, port1, port2, new_port_number;
	

	memcpy (temp_buffer, ptr_to_data_packet, 60);
	temp_buffer[60] = 0;
	strtok (temp_buffer, "\n");

	while (temp_buffer[buffer_index])
	{
		if (temp_buffer[buffer_index] == ',')
			number_of_commas++;
		
		buffer_index++;
		if (number_of_commas == 4)
			break;
	}

	while (temp_buffer[buffer_index])
	{
		temp_port[index++] = temp_buffer[buffer_index];		
		if (temp_buffer[buffer_index] == '\n')
		{
			temp_port[index-2] = 0;			
			break;
		}
		buffer_index++;
	}	
	sscanf (temp_port ,"%hu,%hu",&port1, &port2);		
	port1 = port1 & 0x00ff;
	port1 = port1 << 8;
	port2 = port2 &0x00ff;
	new_port_number = (port1 | port2);

	add_port_to_application_list (new_port_number);

	proxy_printf ("PROXY : Added Port number %d to application list\n",new_port_number);

/* sudha 02-Feb-2000. Changed the return type from "void" to "USHORT" for
NAT pasv FTP support */
	return (new_port_number);	
}

/* Added by Sreelu for Passive FTP Entries */
void display_passive_ftp_entries()
{
	PROXY_DYNAMIC_APP_LIST *sptr_application_list = proxy_server.proxy_server_dynamic_application_list;

	printf ("\n **");
	printf ("\n          Displaying Passive FTP Entries           ") ;
	printf ("\n **");
	if(sptr_application_list == NULL)
		return;

	while(1)
	{
		printf("\n [%d]", sptr_application_list->application_port);
		if(sptr_application_list->sptr_forward_link == NULL)
			break;
		sptr_application_list = sptr_application_list->sptr_forward_link;
	}
}

/* Added by Sreelu for Filters... */

enum TEST proxy_forbidden_site_address_string (char *cptr_proxy_forbidden_address)
{
#if OLD_FILTER		/* Commented by Sreelu */
	PROXY_FORBIDDEN_SITE_LIST *sptr_next_forbidden_site;
	char *cptr_ip_address;
	char scanf_string[20];
   BYTE dest_address[25];
	
	if (proxy_server.number_of_forbidden_sites == 0)
	{
		if ((proxy_server.ptr_to_forbidden_list = (PROXY_FORBIDDEN_SITE_LIST *) table_malloc (
						proxy_server.max_number_of_forbidden_sites, sizeof (PROXY_FORBIDDEN_SITE_LIST))) == NULL)
		{
			proxy_printf ("PROXY: Error allocating Memory\n");
			return FAIL;
		}
	}

	sptr_next_forbidden_site = proxy_server.ptr_to_forbidden_list + proxy_server.number_of_forbidden_sites;
	cptr_ip_address = &scanf_string[0];

	while (1)
	{
		sscanf (cptr_proxy_forbidden_address,"%03ju.%03ju.%03ju.%03ju",(int *)(cptr_ip_address + 0),(int *)(cptr_ip_address + 1),
			(int *)(cptr_ip_address + 2),(int *)(cptr_ip_address + 3));

		sptr_next_forbidden_site->destination_ip_address = *((ULONG *)cptr_ip_address); 	
		proxy_server.number_of_forbidden_sites++;

#if 0 
		printf ("PROXY :Restricted Dest Address is %08x,%s\n",
         sptr_next_forbidden_site->destination_ip_address,
         convert_ip_address_to_dot_format (&dest_address[0],
         sptr_next_forbidden_site->destination_ip_address));

#endif 

		cptr_proxy_forbidden_address = strchr (cptr_proxy_forbidden_address, ',');
		if (cptr_proxy_forbidden_address == NULL)
			break;
		cptr_proxy_forbidden_address++;
		sptr_next_forbidden_site++;
	}
#endif
	return PASS;
}

enum TEST proxy_restricted_client_address_string (char *cptr_proxy_forbidden_address)
{
#if OLD_FILTER		/* Commented by Sreelu */
	PROXY_RESTRICTED_CLIENT_LIST *sptr_next_restricted_client;
	char *cptr_ip_address;
	char scanf_string[20];
	
	if (proxy_server.number_of_restricted_clients == 0)
	{
		if ((proxy_server.ptr_to_restricted_client_list = (PROXY_RESTRICTED_CLIENT_LIST *) table_malloc (
						proxy_server.max_number_of_restricted_clients, sizeof (PROXY_RESTRICTED_CLIENT_LIST))) == NULL)
		{
			proxy_printf ("PROXY: Error allocating Memory\n");
			return FAIL;
		}
	}

	sptr_next_restricted_client = proxy_server.ptr_to_restricted_client_list + proxy_server.number_of_restricted_clients;
	cptr_ip_address = &scanf_string[0];

	while (1)
	{
		sscanf (cptr_proxy_forbidden_address,"%03ju.%03ju.%03ju.%03ju",(int *)(cptr_ip_address + 0),(int *)(cptr_ip_address + 1),
			(int *)(cptr_ip_address + 2),(int *)(cptr_ip_address + 3));

		sptr_next_restricted_client->source_ip_address = *((ULONG *)cptr_ip_address); 	

		proxy_server.number_of_restricted_clients++;
	
		cptr_proxy_forbidden_address = strchr (cptr_proxy_forbidden_address, ',');
		if (cptr_proxy_forbidden_address == NULL)
			break;
		cptr_proxy_forbidden_address++;	
		sptr_next_restricted_client++;
	}
#endif
	return PASS;
}

enum TEST proxy_restricted_application_string (char *cptr_proxy_server_app_string)
{
#if OLD_FILTER		/* Commented by Sreelu */
	int protocol_port, protocol ;
	PROXY_APPLICATION_TABLE	*sptr_next_application;
	
	/* number_of_applications : Number of applications configured to be proxied
	   max_number_of_applications : Another field, which decides on the amount of memory to alloocate
	   sptr_application_list : pointer to the applications list
	*/

	if (proxy_server.number_of_restricted_applications == 0)
	{
		/* Malloc only when the first of the application list strings appear */
		if ((proxy_server.sptr_restricted_application_list = (PROXY_APPLICATION_TABLE *) table_malloc (
					proxy_server.max_number_of_restricted_applications,sizeof (PROXY_APPLICATION_TABLE))) == NULL)
		{
			proxy_printf ("PROXY: Error allocating Memory\n");
			return FAIL;
		}
	}

	/* Start from the first free slot in the applications list */
	sptr_next_application = proxy_server.sptr_restricted_application_list + proxy_server.number_of_restricted_applications ;


	while (1)
   {
      if (sscanf (cptr_proxy_server_app_string, "%04x,%04x", &protocol, &protocol_port) == 0)
         break ;

      sptr_next_application->protocol_type = (USHORT) protocol ;
      sptr_next_application->protocol_port = (USHORT) protocol_port ;
		
#if 0
		printf ("PROXY : Application is %04x  %04x\n",sptr_next_application->protocol_type,
					sptr_next_application->protocol_port);			 
#endif
		sptr_next_application++;
		proxy_server.number_of_restricted_applications++ ;

      cptr_proxy_server_app_string = strchr (cptr_proxy_server_app_string, ',') ;
      if (cptr_proxy_server_app_string == NULL)
         break ;

      cptr_proxy_server_app_string++ ;
      cptr_proxy_server_app_string = strchr (cptr_proxy_server_app_string, ',') ;
      if (cptr_proxy_server_app_string == NULL)
         break ;
      cptr_proxy_server_app_string++ ;
   }
#endif
	return PASS;
}

enum TEST proxy_restricted_MAC_address_string (char *cptr_restricted_MAC_address_string)
{
#if OLD_FILTER		/* Commented by Sreelu */
	PROXY_RESTRICTED_MAC_ADDRESS_LIST *sptr_next_restricted_MAC_address_list;
	BYTE *temp, mac_address_array[20];
	
	if (proxy_server.number_of_restricted_MAC_address == 0)
	{
		if ((proxy_server.ptr_to_restricted_MAC_address_list = (PROXY_RESTRICTED_MAC_ADDRESS_LIST *) table_malloc (
						proxy_server.max_number_of_restricted_MAC_address, sizeof (PROXY_RESTRICTED_MAC_ADDRESS_LIST))) == NULL)
		{
			proxy_printf ("PROXY: Error allocating Memory\n");
			return FAIL;
		}
	}

	sptr_next_restricted_MAC_address_list = proxy_server.ptr_to_restricted_MAC_address_list +
					proxy_server.number_of_restricted_MAC_address;

	while (1)
	{
		sscanf (cptr_restricted_MAC_address_string,"%02jx%02jx%02jx%02jx%02jx%02jx",
				(int *) (mac_address_array), (int *) (mac_address_array+1),
				(int *) (mac_address_array+2), (int *) (mac_address_array+3),
				(int *) (mac_address_array+4), (int *) (mac_address_array+5));

		temp = &sptr_next_restricted_MAC_address_list->mac_address[0];

		*temp++ = (BYTE) mac_address_array[0];
		*temp++ = (BYTE) mac_address_array[1];
		*temp++ = (BYTE) mac_address_array[2];
		*temp++ = (BYTE) mac_address_array[3];
		*temp++ = (BYTE) mac_address_array[4];
		*temp++ = (BYTE) mac_address_array[5];
	
#if 0
		printf ("PROXY : MAC address is %08x\n",sptr_next_restricted_MAC_address_list->mac_address);
#endif
				
		proxy_server.number_of_restricted_MAC_address++;		

		cptr_restricted_MAC_address_string = strchr (cptr_restricted_MAC_address_string, ',');
		if (cptr_restricted_MAC_address_string == NULL)
			break;
		cptr_restricted_MAC_address_string++;
		sptr_next_restricted_MAC_address_list++;
	}
#endif
	return PASS;
}

enum TEST proxy_restricted_domain_name_string (char *cptr_restricted_domain_name_string)
{
#if OLD_FILTER		/* Commented by Sreelu */
	PROXY_FORBIDDEN_DOMAIN_ADDRESS *sptr_next_restricted_domain_address;
	
	if (proxy_server.number_of_restricted_domain_address == 0)
	{
		if ((proxy_server.ptr_to_restricted_domain_address = (PROXY_FORBIDDEN_DOMAIN_ADDRESS *) table_malloc (proxy_server.max_number_of_restricted_domain_address, sizeof (PROXY_FORBIDDEN_DOMAIN_ADDRESS))) == NULL)
		{
			proxy_printf ("PROXY: Error allocating Memory\n");
			return FAIL;
		}
	}
		
	sptr_next_restricted_domain_address = proxy_server.ptr_to_restricted_domain_address +
												proxy_server.number_of_restricted_domain_address;
	
	strcpy (sptr_next_restricted_domain_address->domain_name, cptr_restricted_domain_name_string);
	proxy_server.number_of_restricted_domain_address++;

#endif
	return PASS;
}

BOOL is_user_defined_port_not_in_reserved_port_list(USHORT lower_port, USHORT higher_port)
{
	int index1, index2;
	if ( higher_port == 0 )
	{
		index1 = lower_port;
		for(index2 = 0; index2 < 20; index2++)
		{
			if ( index1 == tcp_applications[index2].protocol_port_number )
				return FALSE;
		}

		for(index2 = 0; index2 < 19; index2++)
		{
			if ( index1 == udp_applications[index2].protocol_port_number )
				return FALSE;
		}
	}
	else
	{
		for (index1 = lower_port; index1 <= higher_port; index1++)
		{
			for(index2 = 0; index2 < 20; index2++)
			{
				if ( index1 == tcp_applications[index2].protocol_port_number )
					return FALSE;
			}
		
			for(index2 = 0; index2 < 19; index2++)
			{
				if ( index1 == udp_applications[index2].protocol_port_number )
					return FALSE;
			}
		}
	}
	return TRUE;
}

/* sudha 19 Aug 1999.For configurable FTP ctrl & data ports */

void set_ftp_port_numbers_during_init()
{
	USHORT prev_ctrl_port = 0, prev_data_port = 0, ctrl_port = 0, data_port = 0;
	USHORT ctrl_index = 0, data_index = 0, ret_val, protocol=0;
	char application[10];

	ctrl_port = proxy_server.ftp_ctrl_conn_port;
	data_port = proxy_server.ftp_data_conn_port; 
	strcpy(application, "FTP");

	protocol = TCP_PROTOCOL;		
	ret_val = get_port_numbers_from_application(protocol, application, 
					&prev_ctrl_port, &prev_data_port, &ctrl_index, &data_index);
	if (ret_val == 1)
	{
		set_protocol_port_number(protocol, ctrl_port, ctrl_index);
		set_protocol_port_number(protocol, data_port, data_index);
	}

	protocol = UDP_PROTOCOL;		
	ret_val = get_port_numbers_from_application(protocol, application, 
					&prev_ctrl_port, &prev_data_port, &ctrl_index, &data_index);
	if (ret_val == 1)
	{
		set_protocol_port_number(protocol, ctrl_port, ctrl_index);
		set_protocol_port_number(protocol, data_port, data_index);
	}
	return ;
}

/* Ravi on 28-Jan-2000 ... */
void display_nat_descriptor()
{
	PROXY_INTERNET_SERVER_DESCRIPTOR *sptr_internet_server_descriptor = NULL, *ptr_to_next_node = NULL;
	USHORT count = 0;

	sptr_internet_server_descriptor = get_pointer_to_first_entry_in_list
						((LINK *)&proxy_server.proxy_internet_server_list);
	
	while (sptr_internet_server_descriptor != NULL)
	{
		count ++;
/*		printf("SrcIP:%4x SrcPort:%d DestPort:%d Time:%d Secs\n", 
							sptr_internet_server_descriptor->source_address,
							sptr_internet_server_descriptor->source_port,
							sptr_internet_server_descriptor->destination_port,
							sptr_internet_server_descriptor->idle_timer); */
		sptr_internet_server_descriptor = (PROXY_INTERNET_SERVER_DESCRIPTOR *) get_pointer_to_next_entry_in_list ((LINK *)sptr_internet_server_descriptor);
	}	
	printf("Number of NAT Descriptor : %d\n", count);
}
/* ... Ravi on 28-Jan-2000 */


