/*--------------------------------------------------------------------------*\

Changes History : 

{sudha 02-Feb-2000. In PROXY_SERVER_INFO struct for pasv FTP support}
{sudha 02-Feb-2000. In PROXY_DYNAMIC_NAT_APP_LIST, PROXY_INTERNET_SERVER_DESCRIPTOR, 
	PROXY_SERVER_CLASS structs for NAT active & pasv FTP support }
{sudha 07-Feb-2000. In PROXY_SERVER_INFO struct for virtual server
 	loopback support } 
		
\*--------------------------------------------------------------------------*/

#ifndef __VPROXY_
#define __VPROXY_


typedef struct PROXY_DYNAMIC_APP_LIST
{
	struct PROXY_DYNAMIC_APP_LIST *sptr_forward_link;
	USHORT application_port;
} PROXY_DYNAMIC_APP_LIST;

/* Ravi taken from Small Proxy on 04 Jan 1999 ... */
/* Imran, for port range addition */
typedef struct PROXY_APP_PORT_RANGE_LIST
{
	USHORT protocol;
	USHORT lower_port_number;
	USHORT higher_port_number;
} PROXY_APP_PORT_RANGE_LIST;
/* Imran, for port range addition */
/* ... Ravi taken from Small Proxy on 04 Jan 1999*/


typedef struct PROXY_SERVER_INFO
{
#if sudha /* sudha 02-Feb-2000 */
	struct PROXY_SERVER_INFO  *sptr_forward_link;
	struct PROXY_SERVER_INFO  *sptr_backward_link;
#endif 

	struct PROXY_SERVER_INFO  *ptr_to_ftp_data_descriptor;
	struct PROXY_SERVER_INFO  *ptr_to_ftp_command_descriptor;

/* sudhir for passive ftp comm */
	PROXY_DYNAMIC_APP_LIST *ptr_to_dynamic_application_list;  

	USHORT hit_count;          /* this is for future use */
	USHORT outgoing_physical_port;
	USHORT incoming_physical_port;

/* sudhir for strict port allocation */
	ULONG destination_address;
/* sudhir for strict port allocation */

	ULONG client_ip_address;
	ULONG outgoing_port_address;
	USHORT source_port;
	USHORT destination_port;
	USHORT mapped_port;
	USHORT proxy_idle_timer;
	USHORT protocol_type;
	
	int seq_offset;
	USHORT icmp_packet_id;
	USHORT mapped_icmp_packet_id;
	BYTE ftp_port_command_on;

	BYTE tftp_packet_detected;

	BYTE set_src_port_number;
	BYTE in_use;
	BYTE connection_closing;

/* sudha 05-Nov-1999... */
	struct PROXY_CLIENT_DESCRIPTOR_NODE far *client_node;
	struct PROXY_SERVER_DESCRIPTOR_NODE far *server_node;
/* ...sudha 05-Nov-1999 */

/* sudha 07-Feb-2000. For virtual server loopback packet */
	ULONG outgoing_destination_address; 

/* sudha 02-Feb-2000. Pasv FTP support ... */
	USHORT pasv_port; 
	USHORT physical_port_for_pasv_ftp_data_connection; 
/* ... sudha 02-Feb-2000. Pasv FTP support */

	BYTE ftp_pasv_mode_on; /* sudha 07-Feb-2000. For virtual server loopback */

} PROXY_SERVER_INFO;

typedef struct PROXY_SERVER_PORT_CLASS
{
	BYTE_ENUM (BOOLEAN)       proxy_server_enabled;
	USHORT                    recorded_tx_buffer_size;
	USHORT                    throughput_index;
	USHORT                    number_of_connections;
	USHORT                    number_of_bytes_txed;
	USHORT                    number_of_bytes_rxed;
	USHORT                    number_of_packets_txed;
	USHORT                    number_of_packets_rxed;
	enum WAN_THROUGHPUT_STATS tp_status;
/* Sachin, 3rd Oct. 1997 */
   BYTE_ENUM (BOOLEAN) port_down_by_no_demand ;
   BYTE_ENUM (BOOLEAN) port_opened ;
/* Sachin, 3rd Oct. 1997 */
	
}PROXY_SERVER_PORT_CLASS;

typedef struct PROXY_APPLICATION_TABLE
{	
	USHORT protocol_type;
	USHORT protocol_port;
	BYTE same_port_required;

}PROXY_APPLICATION_TABLE;

typedef struct PROXY_NAT_ADDRESS_LIST {
	ULONG local_address;
	ULONG global_address;
} PROXY_NAT_ADDRESS_LIST;

/* sudha 02-Feb-2000.For NAT pasv FTP support.To add dynamic pasv ports ... */
typedef struct PROXY_DYNAMIC_NAT_APP_LIST {
	struct PROXY_DYNAMIC_NAT_APP_LIST *sptr_forward_link;
	ULONG dynamic_server_ip_address; 
	USHORT ip_protocol_type;
	USHORT application_port;
} PROXY_DYNAMIC_NAT_APP_LIST;
/* ... sudha 02-Feb-2000. For NAT pasv FTP support */

typedef struct PROXY_DYNAMIC_SERVER_LIST {
	ULONG dynamic_server_ip_address;          /* dynamic in the sense of ip address sharing */
	USHORT ip_protocol_type;
	USHORT application_port;
} PROXY_DYNAMIC_SERVER_LIST;

typedef struct PROXY_INTERNET_SERVER_DESCRIPTOR
{
	struct PROXY_INTERNET_SERVER_DESCRIPTOR *sptr_forward_link;
	struct PROXY_INTERNET_SERVER_DESCRIPTOR *sptr_backward_link;

	USHORT destination_port;
	USHORT source_port;
	USHORT rx_port_number;
	USHORT protocol;
	ULONG destination_address;
	ULONG source_address;
	ULONG local_mapped_address;
	int seq_offset;
	USHORT idle_timer;

/* sudha 02-Feb-2000. For NAT active, pasv FTP support ... */
	BYTE ftp_pasv_mode_on; 
	BYTE connection_closing;
	
	struct PROXY_INTERNET_SERVER_DESCRIPTOR *ptr_to_ftp_data_descriptor;
	struct PROXY_INTERNET_SERVER_DESCRIPTOR *ptr_to_ftp_command_descriptor;

	USHORT pasv_port; 
/* ... sudha 02-Feb-2000. For NAT active, pasv FTP support */

}PROXY_INTERNET_SERVER_DESCRIPTOR;

#if 1
typedef struct PROXY_FORBIDDEN_SITE_LIST 
{
	ULONG  destination_ip_address;
}PROXY_FORBIDDEN_SITE_LIST;

typedef struct PROXY_FORBIDDEN_DOMAIN_ADDRESS
{
	ULONG *destination_ip_address;
	BYTE domain_name[255];
	USHORT count;
}PROXY_FORBIDDEN_DOMAIN_ADDRESS;

typedef struct PROXY_RESTRICTED_CLIENT_LIST 
{
	ULONG  source_ip_address;
}PROXY_RESTRICTED_CLIENT_LIST;

typedef struct PROXY_RESTRICTED_MAC_ADDRESS_LIST 
{
	BYTE mac_address[6];
}PROXY_RESTRICTED_MAC_ADDRESS_LIST ;
#endif

typedef struct PROXY_SERVER_CLASS
{
	BYTE_ENUM (BOOLEAN)      proxy_server_enabled;
	BYTE_ENUM (BOOLEAN)      proxy_any_application_enabled;
#if 0
	USHORT                   number_of_tcp_proxy_applications;
	USHORT                   number_of_udp_proxy_applications;
#endif
	USHORT 						 number_of_proxied_clients;
	USHORT 						 peak_concurrent_descriptor_count ;
	PROXY_SERVER_PORT_CLASS  port[NUMBER_OF_IP_PORTS];
	USHORT 						 proxy_server_idle_timeout;
	USHORT 						 proxy_server_table_size;
	USHORT 						 proxy_server_idle_entry_cache_size;
	ULONG 						 application_id;
	USHORT 						 max_number_of_applications;
	USHORT 						 max_number_of_user_defined_applications; /* Added By Ravi */
	USHORT 						 number_of_applications;
	USHORT 						 number_of_user_defined_applications; /* Added By Ravi */
	USHORT 						 maximum_number_of_descriptors;
	BYTE_ENUM (BOOLEAN)      proxy_server_printf_enabled;
	PROXY_SERVER_INFO 		 proxy_server_info_list;
	PROXY_APPLICATION_TABLE *sptr_application_list ;
	PROXY_DYNAMIC_APP_LIST  *proxy_server_dynamic_application_list;

/* Ravi taken from Imran on 04 Jan 1999 ... */
/* Imran,for port range addition */
	PROXY_APP_PORT_RANGE_LIST *proxy_server_application_port_range_list;
/* ... Ravi taken from Imran on 04 Jan 1999 */

/* sudha 12 Aug 1999.For configurable FTP ctrl & data ports */
	USHORT ftp_ctrl_conn_port;
	USHORT ftp_data_conn_port;

	USHORT number_of_global_address;
	USHORT total_number_of_global_address;
	PROXY_NAT_ADDRESS_LIST *global_address_list;
	
	ULONG proxy_local_internet_server_address;	
	USHORT number_of_dynamic_servers;  /* dynamic in the sense of using single ip address */
	USHORT total_number_of_dynamic_servers;   /* this is count of local servers
															which uses single ip address */
	PROXY_DYNAMIC_SERVER_LIST *dynamic_internet_server_list;

	PROXY_INTERNET_SERVER_DESCRIPTOR proxy_internet_server_list;

#if 1
/* For Filters */
	USHORT number_of_forbidden_sites;
	USHORT max_number_of_forbidden_sites;
	PROXY_FORBIDDEN_SITE_LIST *ptr_to_forbidden_list;

	USHORT number_of_restricted_clients;
	USHORT max_number_of_restricted_clients;
	PROXY_RESTRICTED_CLIENT_LIST *ptr_to_restricted_client_list;
	
	USHORT number_of_restricted_applications;
	USHORT max_number_of_restricted_applications;
	PROXY_APPLICATION_TABLE *sptr_restricted_application_list;
	
	USHORT number_of_restricted_MAC_address;
	USHORT max_number_of_restricted_MAC_address;
 	PROXY_RESTRICTED_MAC_ADDRESS_LIST *ptr_to_restricted_MAC_address_list;
#endif

	USHORT number_of_restricted_domain_address;
	USHORT max_number_of_restricted_domain_address;
	USHORT number_of_address_resolved;
	PROXY_FORBIDDEN_DOMAIN_ADDRESS *ptr_to_restricted_domain_address;

	BYTE	start_resolving_dns_filters;

	USHORT  dns_resolver_state;
	USHORT last_allocated_port;

/* For Filters */

/* sudha 02-Feb-2000. For NAT pasv FTP */
	PROXY_DYNAMIC_NAT_APP_LIST *dynamic_nat_application_list;

}PROXY_SERVER_CLASS;

/* sudhir for ftp passive command handling */

#endif




