#include	"defs.h"
/*	$Modname: snmppvar.c$  $version: 1.6$		 $date: 01/26/95$	  */
/*
* 	$lgb$
1.0 06/01/94 ross
1.1 06/02/94 ross more general clean-up.
1.2 06/03/94 ross adding protocol and driver traps.
1.3 06/20/94 ross
1.4 06/20/94 ross fixed copyright notice.  Removed some unnecessary port number parameters from functions.
1.5 12/27/94 ross fix table access functions.  Added sort instrumentation.
1.6 01/26/95 ross fixes to work with new generic snmp in rwutils, fixed mib table
* 	$lge$
*/
/***********************************************************
	Portions Copyright 1988, 1989 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <string.h>
#include "snmp.h"
#include "vsnmpmib.h"
/**********************************************************************************/
static enum SNMP_STATE parse_variable_bindings_list_header (BYTE **bptr_actual_variable_value, enum SNMP_PDU_TYPE request_type,
	enum VARIABLE_ACCESS_RIGHTS *eptr_read_write, enum BOOLEAN *eptr_exact, BYTE **bptr_rxed_packet,
	USHORT *usptr_length_of_rxed_packet, enum SNMP_PDU_TYPE *eptr_type, BYTE **bptr_header, BYTE **bptr_response_packet,
	USHORT *usptr_length_of_response_packet, BYTE **bptr_variable_list_start, ULONG *ulptr_error_index);
static enum SNMP_STATE process_variable_bindings_list (BYTE *bptr_variable_bindings, USHORT length_of_variable_bindings,
	enum BOOLEAN exact, MANAGER_CLASS *sptr_manager, enum SNMP_PDU_TYPE request_type, enum VARIABLE_ACCESS_RIGHTS read_write,
	enum BOOLEAN do_set, BYTE *bptr_actual_variable_value, BYTE **bptr_response_packet, USHORT *usptr_length_of_response_packet,
	ULONG *ulptr_error_index);
/* Srikar, Mar 19, 1997. Changed the prototype for object id changes */
static enum SNMP_STATE  extract_a_variable_binding_to_process (enum BOOLEAN *eptr_continue_outer_loop,
	enum BOOLEAN *eptr_end_of_table, char **cptr_next_variable_name, USHORT *usptr_length_of_object_id_name,
	BYTE **ptr_to_bptr_variable_bindings, USHORT *usptr_length_of_variable_bindings, OBJECT_ID *sptr_object_id_name,
	enum ASN_TYPES *eptr_variable_value_type, USHORT *usptr_length_of_variable_value, BYTE **ptr_to_bptr_to_variable_value,
	VARIABLE **ptr_to_sptr_mib_variable, enum ASN_TYPES *eptr_mib_variable_type, USHORT *usptr_number_of_table_indices,
	enum BOOLEAN exact, OBJECT_ID *sptr_table_indices, OBJECT_ID **ptr_to_sptr_to_table_indices_in_variable_binding_name,
	USHORT *usptr_access_control_list, USHORT *usptr_snmp_community, enum VARIABLE_ACCESS_RIGHTS read_write,
	USHORT *usptr_number_of_received_table_indices);

/**********************************************************************************/
/*
 * parse_variables_list goes through the list of variables and retrieves each one,
 * placing it's value in the output packet.	If doSet is non-zero, the variable is set
 * with the value in the packet.	If any error occurs, an error code is returned.
 */
enum SNMP_STATE parse_variable_bindings_list (BYTE *bptr_variable_bindings_list, USHORT length_of_variable_bindings_list,
	BYTE *bptr_response_packet, USHORT length_of_response_packet, enum SNMP_PDU_TYPE request_type, ULONG *ulptr_error_index,
	enum BOOLEAN do_set, MANAGER_CLASS *sptr_manager, BYTE **bptr_end_of_response_packet)
{
	enum VARIABLE_ACCESS_RIGHTS read_write;
	enum BOOLEAN exact;
	USHORT dummy_length;
  	USHORT header_shift;
	enum SNMP_PDU_TYPE type;
	BYTE *bptr_actual_variable_value;
	BYTE *bptr_header;
	BYTE *bptr_start_of_response_variable_bindings_list;
	enum SNMP_STATE return_code;
	enum ASN_TYPES asn_type;

	/* parses the variable binding list header */

	return_code = parse_variable_bindings_list_header (&bptr_actual_variable_value, request_type, &read_write, &exact,
		&bptr_variable_bindings_list, &length_of_variable_bindings_list, &type, &bptr_header, &bptr_response_packet,
		&length_of_response_packet, &bptr_start_of_response_variable_bindings_list, ulptr_error_index);

	snmp_printf (SNMP_PARSE_PRINTF, "SNMP: Length of variable bindings list is %d\n", length_of_variable_bindings_list);

	if (return_code != SNMP_OK)
		{
		return (return_code);
		}

	/* processes all the variable bindings */

	return_code = process_variable_bindings_list (bptr_variable_bindings_list, length_of_variable_bindings_list, exact,
		sptr_manager, request_type, read_write, do_set, bptr_actual_variable_value, &bptr_response_packet,
		&length_of_response_packet, ulptr_error_index);

	if (return_code != SNMP_OK)
		{
		return (return_code);
		}

	*bptr_end_of_response_packet = bptr_response_packet;  /* save a pointer to the end of the packet */

	/* Since header lengths would be encoded in one byte, things need to be fixed, now that the actual lengths are known. */

	header_shift = 0x0000;

	length_of_response_packet = (USHORT) (*bptr_end_of_response_packet - bptr_start_of_response_variable_bindings_list);

	if (length_of_response_packet >= 0x80)
		{
		++header_shift;

		if (length_of_response_packet > 0xff)
			{
			++header_shift;
			}
		}

	if (header_shift != 0x0000)
		{
		shift_array (bptr_start_of_response_variable_bindings_list,
			(USHORT) (*bptr_end_of_response_packet - bptr_start_of_response_variable_bindings_list), (short) header_shift);

		*bptr_end_of_response_packet = (BYTE *) ((ULONG) *bptr_end_of_response_packet + header_shift);

		bptr_start_of_response_variable_bindings_list =
			(BYTE *) ((ULONG) bptr_start_of_response_variable_bindings_list + header_shift);
		}

	/* Now rebuild header with the actual length */

	dummy_length = (USHORT) (*bptr_end_of_response_packet - bptr_start_of_response_variable_bindings_list);

	asn_type = (enum ASN_TYPES) ((ULONG) ASN_SEQUENCE | (ULONG) ASN_CONSTRUCTOR);

	if (asn_build_header (bptr_header, &dummy_length, asn_type, dummy_length) == NULL)
		{
		/* This is not logical error, but that's what rfc says */

		return (SNMP_ERROR_TOO_BIG);
		}

	*ulptr_error_index = 0x00000000L;

	return (SNMP_OK);
}
/**********************************************************************************/
static enum SNMP_STATE parse_variable_bindings_list_header (BYTE **bptr_actual_variable_value, enum SNMP_PDU_TYPE request_type,
	enum VARIABLE_ACCESS_RIGHTS *eptr_read_write, enum BOOLEAN *eptr_exact, BYTE **bptr_variable_bindings_list,
	USHORT *usptr_length_of_variable_bindings_list, enum SNMP_PDU_TYPE *eptr_type, BYTE **bptr_header,
	BYTE **bptr_response_packet, USHORT *usptr_length_of_response_packet, BYTE **bptr_variable_list_start,
	ULONG *ulptr_error_index)
{
	enum ASN_TYPES asn_type;

	*bptr_actual_variable_value = snmp.actual_variable_name;

	if (request_type == SET_REQUEST_MESSAGE)
		{
		++snmp.mib.snmpInSetRequests;

		*eptr_read_write = WRITE;
		}
	else
		{
		*eptr_read_write = READ;
		}

	if (request_type == GET_NEXT_REQUEST_MESSAGE)
		{
		++snmp.mib.snmpInGetNexts;

		*eptr_exact = FALSE;
		}
	else
		{
		++snmp.mib.snmpInGetRequests;

		*eptr_exact = TRUE;
		}

	/* this next statement parses the variable binding list header */

	*bptr_variable_bindings_list = asn_parse_header (*bptr_variable_bindings_list, usptr_length_of_variable_bindings_list,
		(UNION_SNMP_TYPES *) eptr_type);

	if (*bptr_variable_bindings_list == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP ERROR: not enough space for variable list\r\n");

		++snmp.mib.snmpInAsnParseErrs;

		return (SNMP_PARSE_ERROR);
		}

	if (*eptr_type != (enum SNMP_PDU_TYPE) ((ULONG) ASN_SEQUENCE | (ULONG) ASN_CONSTRUCTOR))
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP ERROR: wrong type found in the received packet\n");

		++snmp.mib.snmpInAsnParseErrs;

		return (SNMP_PARSE_ERROR);
		}

	*bptr_header = *bptr_response_packet;

	asn_type = (enum ASN_TYPES) ((ULONG) ASN_SEQUENCE | (ULONG) ASN_CONSTRUCTOR);

	*bptr_response_packet = asn_build_header (*bptr_response_packet, usptr_length_of_response_packet, asn_type, 0x0000);

	if (bptr_response_packet == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP ERROR: not enough space in the output packet \r\n");

		++snmp.mib.snmpInAsnParseErrs;

		return (SNMP_BUILD_ERROR);
		}

	*bptr_variable_list_start = *bptr_response_packet;

	*ulptr_error_index = 0x00000001;

	return (SNMP_OK);
}
/**********************************************************************************/
static enum SNMP_STATE process_variable_bindings_list (BYTE *bptr_variable_bindings, USHORT length_of_variable_bindings,
	enum BOOLEAN exact, MANAGER_CLASS *sptr_manager, enum SNMP_PDU_TYPE request_type, enum VARIABLE_ACCESS_RIGHTS read_write,
	enum BOOLEAN do_set, BYTE *bptr_actual_variable_value, BYTE **bptr_response_packet, USHORT *usptr_length_of_response_packet,
	ULONG *ulptr_error_index)
{
	/* Srikar, Mar 19, 1997. Changed the names of the following variables */
	/* number_of_bytes_in_received_table_indices - number_of_received_table_indices */
	/* number_of_bytes_in_table_indices - number_of_table_indices */
	VARIABLE	*sptr_mib_variable;
	VARIABLE	*sptr_mib_variable_last;
	VARIABLE *sptr_mib_variable_next;
	enum ASN_TYPES mib_variable_type;
/*	USHORT length_of_actual_variable_value = sizeof(ULONG);*/
	USHORT length_of_actual_variable_value ;
	USHORT access_control_list;
	USHORT snmp_community;
	enum ASN_TYPES variable_value_type;
	USHORT length_of_object_id_name;
	OBJECT_ID object_id_name[MAXIMUM_NUMBER_OF_SUB_IDS_IN_OBJECT_ID];
	BYTE *bptr_to_variable_value;
	/* Srikar, Mar 19, 1997. Changed the data type from BYTE to OBJECT_ID */
	OBJECT_ID *sptr_to_table_indices_in_variable_binding_name;
	USHORT length_of_variable_value;
	USHORT number_of_received_table_indices;
	USHORT number_of_table_indices;
	/* Srikar, Mar 19, 1997. Changed the data type from BYTE to OBJECT_ID */
	OBJECT_ID table_indices[MAXIMUM_NUMBER_OF_BYTES_FOR_TABLE_INDICES];
	enum BOOLEAN end_of_table;
	char *cptr_next_variable_name;
	enum BOOLEAN continue_outer_loop;
	enum SNMP_STATE snmp_state;

	PARAMETER_NOT_USED (sptr_manager);

	sptr_mib_variable_last = &variables[snmp.number_of_variables - 1];

	while (length_of_variable_bindings > 0x0000)
		{
		snmp_state = extract_a_variable_binding_to_process (&continue_outer_loop, &end_of_table, &cptr_next_variable_name,
			&length_of_object_id_name, &bptr_variable_bindings, &length_of_variable_bindings, &object_id_name[0],
			&variable_value_type, &length_of_variable_value, &bptr_to_variable_value, &sptr_mib_variable, &mib_variable_type,
			&number_of_table_indices, exact, &table_indices[0], &sptr_to_table_indices_in_variable_binding_name,
			&access_control_list, &snmp_community, read_write, &number_of_received_table_indices);

		if (snmp_state != SNMP_OK)
			{
			return (snmp_state);
			}

		switch (request_type)
			{
			case GET_NEXT_REQUEST_MESSAGE:

				snmp_state = process_get_next_request_message (&sptr_mib_variable,
					bptr_actual_variable_value, &length_of_actual_variable_value, &number_of_table_indices,
					&table_indices[0], &end_of_table, &cptr_next_variable_name, sptr_mib_variable_last, &mib_variable_type);

				if (snmp_state != SNMP_OK)
					{
					return (snmp_state);
					}

				break;

			case GET_REQUEST_MESSAGE:

				snmp_state = process_get_request_message (sptr_mib_variable,
					bptr_actual_variable_value, &length_of_actual_variable_value, &number_of_table_indices,
					&table_indices[0], &end_of_table, &cptr_next_variable_name);

				if (snmp_state != SNMP_OK)
					{
					return (snmp_state);
					}

				break;

			case SET_REQUEST_MESSAGE:
				snmp_state = process_set_request_message (sptr_mib_variable,
					bptr_actual_variable_value, &length_of_actual_variable_value, &number_of_table_indices,
					&table_indices[0], &end_of_table, &cptr_next_variable_name, do_set, variable_value_type,
					length_of_variable_value, mib_variable_type, bptr_to_variable_value);

				if (snmp_state != SNMP_OK)
					{
					return (snmp_state);
					}

				break;

			default:

				return (SNMP_PARSE_ERROR);
			}

		snmp_printf (SNMP_PARSE_PRINTF, "SNMP: end_of_table:%u, cptr_next_variable_name:%p\n", end_of_table,
			cptr_next_variable_name);

		if ((sptr_mib_variable == (sptr_mib_variable_last + 1)) || (continue_outer_loop == TRUE))
			{
			continue;
			}

		rebuild_object_id_and_table_indices (sptr_mib_variable, &sptr_mib_variable_next,
			sptr_to_table_indices_in_variable_binding_name, number_of_received_table_indices, &mib_variable_type,
			&number_of_table_indices, &table_indices[0], cptr_next_variable_name, &object_id_name[0],
			&length_of_object_id_name);

		/* the retrieved value of the variable is placed in the outgoing packet */
		*bptr_response_packet = build_a_variable_binding (*bptr_response_packet, usptr_length_of_response_packet, object_id_name,
			length_of_object_id_name, (enum ASN_TYPES) mib_variable_type, length_of_actual_variable_value,
			bptr_actual_variable_value);

		if (*bptr_response_packet == NULL)
			{
			++snmp.mib.snmpOutTooBigs;

			return (SNMP_ERROR_TOO_BIG);
			}

		++(*ulptr_error_index);
		}

	return (SNMP_OK);
}
/**********************************************************************************/
/* Srikar, Mar 19, 1997. Changed the type and name of the following parameters */
/* bptr_table_indices - sptr_table_indices(BYTE * - OBJECT_ID *) */
/* ptr_to_bptr_to_table_indices_in_variable_binding_name - ptr_to_sptr_to_table_indices_in_variable_binding_name */
/* (BYTE **  - OBJECT_ID **) */
/* changed the following variable names */
/* usptr_number_of_bytes_in_table_indices - usptr_number_of_table_indices */
/* usptr_number_of_bytes_in_received_table_indices - usptr_number_of_received_table_indices */
static enum SNMP_STATE extract_a_variable_binding_to_process (enum BOOLEAN *eptr_continue_outer_loop,
	enum BOOLEAN *eptr_end_of_table, char **cptr_next_variable_name, USHORT *usptr_length_of_object_id_name,
	BYTE **ptr_to_bptr_variable_bindings, USHORT *usptr_length_of_variable_bindings, OBJECT_ID *sptr_object_id_name,
	enum ASN_TYPES *eptr_variable_value_type, USHORT *usptr_length_of_variable_value, BYTE **ptr_to_bptr_to_variable_value,
	VARIABLE **ptr_to_sptr_mib_variable, enum ASN_TYPES *eptr_mib_variable_type, USHORT *usptr_number_of_table_indices,
	enum BOOLEAN exact, OBJECT_ID *sptr_table_indices, OBJECT_ID **ptr_to_sptr_to_table_indices_in_variable_binding_name,
	USHORT *usptr_access_control_list, USHORT *usptr_snmp_community, enum VARIABLE_ACCESS_RIGHTS read_write,
	USHORT *usptr_number_of_received_table_indices)
{
		*eptr_continue_outer_loop = FALSE;

		*eptr_end_of_table = FALSE;

		*cptr_next_variable_name = NULL;

		++snmp.mib.snmpInTotalReqVars;

		*usptr_length_of_object_id_name = MAXIMUM_NUMBER_OF_SUB_IDS_IN_OBJECT_ID;

		/* this next statement parses the next variable binding (ie. (name, value) pair) */

		*ptr_to_bptr_variable_bindings = parse_a_variable_binding (*ptr_to_bptr_variable_bindings,
			usptr_length_of_variable_bindings, sptr_object_id_name, usptr_length_of_object_id_name, eptr_variable_value_type,
			usptr_length_of_variable_value, ptr_to_bptr_to_variable_value);

		snmp_printf (SNMP_PARSE_PRINTF, "SNMP: Length of remaining variable bindings is %d\n", *usptr_length_of_variable_bindings);

		if (*ptr_to_bptr_variable_bindings == NULL)
			{
			snmp_printf (SNMP_ALARM_PRINTF, "SNMP: Error in parsing a variable binding\n");

			++snmp.mib.snmpInAsnParseErrs;

			return (SNMP_PARSE_ERROR);
			}

		/* now attempt to retrieve the variable on the local entity */

		*ptr_to_sptr_mib_variable = get_mib_variable_and_table_indices (sptr_object_id_name, usptr_length_of_object_id_name,
			eptr_mib_variable_type, usptr_access_control_list, exact, usptr_number_of_table_indices, sptr_table_indices,
			ptr_to_sptr_to_table_indices_in_variable_binding_name);

		if (*ptr_to_sptr_mib_variable == NULL)
			{
			snmp_printf (SNMP_ALARM_PRINTF, "SNMP: Error in geting mib variable\n");

			++snmp.mib.snmpInNoSuchNames;

			return (SNMP_ERROR_NO_SUCH_NAME);
			}

		/* Check if this user has access rights to this variable */

		*usptr_snmp_community = get_snmp_community (&snmp.session_id[0]);

/*		printf("\r\naccess_control_list %hx \r\nsnmp_community %hx\r\nread_write %hx",*usptr_access_control_list,*usptr_snmp_community,read_write);*/

	if (check_access_to_this_snmp_community (*usptr_access_control_list, *usptr_snmp_community, read_write) == 0x0000)
			{
			snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: Community %04x access denied\r\n", *usptr_snmp_community);

			++snmp.mib.snmpInBadCommunityUses;

			return (SNMP_ERROR_READ_ONLY);
			}

		*usptr_number_of_received_table_indices = *usptr_number_of_table_indices;

		snmp_printf (SNMP_PARSE_PRINTF, "SNMP: Received object id :");

		print_variable_and_indices (&(*ptr_to_sptr_mib_variable)->mib_name[0], *usptr_number_of_table_indices,
			sptr_table_indices);

		return (SNMP_OK);
}
