#include	"defs.h"
/*	$Modname: snmputil.c$  $version: 1.12$		$date: 01/26/95$	 */
/*
* 	$lgb$
1.0 04/28/94 keyur Initial version.
1.1 04/28/94 keyur Added support for version control
1.2 05/17/94 keyur Added support for Big Endian - Little Endian consideration.
1.3 05/18/94 keyur Removed a bug for memcpy overrun in snmputil.c
1.4 05/26/94 keyur
1.5 05/28/94 keyur adding enumerations.
1.6 06/01/94 ross
1.7 06/02/94 ross more general clean-up.
1.8 06/03/94 ross adding protocol and driver traps.
1.9 06/20/94 ross fixed copyright notice.  Removed some unnecessary port number parameters from fu
1.10 08/12/94 ross Changed for BIG_ENDIAN.  Courtesy of Danny.
1.11 12/27/94 ross fix table access functions.  Added sort instrumentation.
1.12 01/26/95 ross fixes to work with new generic snmp in rwutils, fixed mib table
* 	$lge$
*/
/***********************************************************
	Portions Copyright 1988, 1989 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <stdarg.h>
#include <string.h>
#include <stdlib.h>
#include "snmp.h"
/****************************************************************************/
static void packet_allocation_error (ULONG size_of_packet);
/****************************************************************************/
SNMP_BUFFER *snmp_get_a_send_packet (USHORT size_of_packet)
{
	void *vptr_tx_packet;

	vptr_tx_packet = (void *) calloc (1, size_of_packet + sizeof (enum SNAP_PROTOCOL_ID));

	snmp_printf (SNMP_MEMORY_PRINTF, "SNMP: Pointer to send packet : %p\r\n", vptr_tx_packet);

	if (vptr_tx_packet == NULL)
		{
		packet_allocation_error (size_of_packet);
		}
	else
		{
		vptr_tx_packet = (void *) ((ULONG) vptr_tx_packet + sizeof (enum SNAP_PROTOCOL_ID));
		}

	return (vptr_tx_packet);
}
/*************************************************************************/
void snmp_free_a_send_packet (void *vptr_txed_packet)
{
	snmp_printf (SNMP_MEMORY_PRINTF, "Free of %08lx\r\n", (ULONG) vptr_txed_packet);

	vptr_txed_packet = (void *) ((ULONG) vptr_txed_packet - sizeof (enum SNAP_PROTOCOL_ID));

#ifdef __BORLANDC__
	if (((ULONG) vptr_txed_packet) & 0x00000001)
		{
		snmp_printf (SNMP_MEMORY_PRINTF, "Free Error of %p\r\n", vptr_txed_packet);

		return;
		}
#endif

	free (vptr_txed_packet);
}
/**********************************************************************************/
void *duplicate_snmp_data_buffer (void *vptr_rxed_buffer, USHORT number_of_bytes)
{
	void *vptr_duplicated_buffer;

	vptr_duplicated_buffer = table_malloc (1, number_of_bytes);

	if (vptr_duplicated_buffer != NULL)
		{
		memcpy (vptr_duplicated_buffer, vptr_rxed_buffer, number_of_bytes);
		}
	else
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP: duplicate_snmp_data_buffer (): table_malloc failed\n");
		}

	return (vptr_duplicated_buffer);
}
/*************************************************************************/
static void packet_allocation_error (ULONG size_of_packet)
{
	snmp_printf (SNMP_ALARM_PRINTF, "SNMP: Error Allocating Packet	size %08x\r\n", size_of_packet);
}
/**********************************************************************************/
int compare (OBJECT_ID *sptr_name1, USHORT length1, OBJECT_ID *sptr_name2, USHORT length2)
{
	USHORT length;

	/* length = minimum of length1 and length2 */

	if (length1 < length2)
		{
		length = length1;
		}
	else
		{
		length = length2;
		}

	/* find first non-matching byte */

	while (length-- > 0x0000)
		{
		if (*sptr_name1 < *sptr_name2)
			{
			return (-1);
			}

		if (*sptr_name2++ < *sptr_name1++)
			{
			return (1);
			}
		}

	/* bytes match up to length of shorter string */

	if (length1 < length2)
		{
		/* sptr_name1 shorter, so it is "less" */

		return (-1);
		}

	if (length2 < length1)
		{
		return (0x0001);
		}

	/* both strings are equal */

	return (0x0000);
}
/**********************************************************************************/
void shift_array (BYTE *bptr_begin, USHORT length_of_array, short shift_amount)
{
	BYTE	*bptr_old_array;
	BYTE	*bptr_new_array;

	if (shift_amount >= 0x0000)
		{
		bptr_old_array = bptr_begin + length_of_array - 1;
		bptr_new_array = bptr_old_array + shift_amount;

		while (length_of_array-- != 0x0000)
			{
			*bptr_new_array = *bptr_old_array;

			--bptr_new_array;
			--bptr_old_array;
			}
		} 
	else 
		{
		bptr_old_array = bptr_begin;

		bptr_new_array = bptr_begin + shift_amount;

		while (length_of_array-- != 0x0000)
			{
			*bptr_new_array = *bptr_old_array;

			++bptr_new_array;
			++bptr_old_array;
			}
		}
}
/**********************************************************************************/
/*
 * create a packet identical to the input packet, except for the error status
 * and the error index which are set according to the input variables.
 * Returns PASS upon success and FAIL upon failure.
 */
enum TEST create_identical_packet (BYTE *bptr_original_packet, BYTE *bptr_output_packet,
	USHORT length_of_packet, ULONG error_status, ULONG error_index, BYTE **bptr_end_of_packet)
{
	USHORT length;
	USHORT header_length;
	ULONG	dummy;
	enum ASN_TYPES type;
	BYTE *bptr_rxed_packet;
	BYTE *bptr_header;
	BYTE *bptr_request_id;
	BYTE *bptr_error_status;
	BYTE *bptr_error_index;
	BYTE *bptr_variable_list;

	memcpy ((BYTE *) bptr_output_packet, (BYTE *) bptr_original_packet, length_of_packet);

	length = length_of_packet;

	bptr_header = snmp_auth_parse (bptr_output_packet, &length, &snmp.session_id[0], &snmp.length_of_session_id,
		(ULONG *) &dummy);

	if (bptr_header == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP ERROR: header parse error\n");

		return (FAIL);
		}

	bptr_request_id = asn_parse_header (bptr_header, &length, (UNION_SNMP_TYPES *) &dummy);

	if (bptr_request_id == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP ERROR: header parse error in request id\n");

		return (FAIL);
		}

	header_length = length;

	bptr_error_status = asn_parse_integer (bptr_request_id, &length, &type, (ULONG *) &dummy, sizeof (dummy), 0x00);

	if (bptr_error_status == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP ERROR: header parse error in error status \r\n");

		return (FAIL);
		}

	bptr_error_index = asn_parse_integer (bptr_error_status, &length, &type, (ULONG *) &dummy, sizeof (dummy), 0x00);

	if (bptr_error_index == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP ERROR: header parse error in error index\n");

		return (FAIL);
		}

	bptr_variable_list = asn_parse_integer (bptr_error_index, &length, &type, (ULONG *) &dummy, sizeof (dummy), 0x00);

	if (bptr_variable_list == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP ERROR: variable list parse error \r\n");

		return (FAIL);
		}

	bptr_rxed_packet = asn_build_header (bptr_header, &header_length, (enum ASN_TYPES) GET_RESPONSE_MESSAGE, header_length);

	if (bptr_rxed_packet != bptr_request_id)
		{
		return (FAIL);
		}

	length = length_of_packet;

	type = (enum ASN_TYPES) ((ULONG) ASN_UNIVERSAL | (ULONG) ASN_PRIMITIVE | (ULONG) ASN_INTEGER);

	/* building error status */

	bptr_rxed_packet = asn_build_integer (bptr_error_status, &length, type, &error_status, sizeof (error_status), 0x00);

	if (bptr_rxed_packet != bptr_error_index)
		{
		return (FAIL);
		}

	/* building error index */

	bptr_rxed_packet = asn_build_integer (bptr_error_index, &length, (enum ASN_TYPES) type, &error_index, sizeof (error_index),
		0x00);

	if (bptr_rxed_packet != bptr_variable_list)
		{
		return (FAIL);
		}

	*bptr_end_of_packet = bptr_output_packet + length_of_packet;

	return (PASS);
}
/*************************************************************************/
void snmp_printf (enum SNMP_PRINTF_GROUPS printf_group, const char *bptr_format, ...)
{
	enum BOOLEAN print_string;

	va_list argptr;

	va_start (argptr, bptr_format);

	if (snmp.print_class.printing_enabled == FALSE)
		{
		va_end (argptr);

		return;
		}

	print_string = FALSE;

	switch (printf_group)
		{
		case SNMP_INIT_PRINTF:

			print_string = snmp.print_class.init_printing_enabled;

			break;

		case SNMP_SOCKET_PRINTF:

			print_string = snmp.print_class.socket_printing_enabled;

			break;

		case SNMP_PARSE_PRINTF:

			print_string = snmp.print_class.parse_printing_enabled;

			break;

		case SNMP_TX_PRINTF:

			print_string = snmp.print_class.transmit_printing_enabled;

			break;

		case SNMP_RX_PRINTF:

			print_string = snmp.print_class.receive_printing_enabled;

			break;

		case SNMP_MIB_PRINTF:

			print_string = snmp.print_class.mib_printing_enabled;

			break;

		case SNMP_DATA_PRINTF:

			print_string = snmp.print_class.data_printing_enabled;

			break;

		case SNMP_MEMORY_PRINTF:

			print_string = snmp.print_class.memory_printing_enabled;

			break;

		case SNMP_ALARM_PRINTF:

			print_string = snmp.print_class.alarm_printing_enabled;

			break;
		}

	if (print_string == TRUE)
		{
		vprintf (bptr_format, argptr);
		}

	va_end (argptr);
}
