// File : sntcstm.h
// July 29, 1997. Contains the SNTP related functions.

#include "defs.h"
#include <string.h>
#include <stddef.h>
#include <pharlap.h>
#include <kstart.h>
#include <v8022str.h>
#include <vethstr.h>
#include <lslproto.h>
#include <socket.h>
#include <visnpstr.h>
#include <general.h>
#include <vnvrmstr.h>
#include <cache.h>

#include <snmptrap.h>
#include "vsntcstm.h"

extern	int AssignUTCOffset(BYTE *buffer, long *offset_ptr);
extern	BYTE *ConvertUTCOffset(long utc_offset,BYTE *buffer);
extern	int ValidateDaylightOffset(long value);

// CHANGED_SN, Jul 29, 1997. Added the following for SNTP configuration.

/****************************************************************************/
enum TEST get_sntp_setup_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_size_of_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name)
{
	if (check_for_manager_authorization(mib_operation) == FALSE)
		return(FALSE);

	return(process_mib_variable (mib_operation,cptr_mib_string,bptr_variable_value,
		usptr_size_of_variable_value,usptr_size_of_table_indices,sptr_table_indices,eptr_end_of_table,
		ptr_to_cptr_next_variable_name,&sntp_snmp_table[0x00]));
}

/**********************************************************************************/
enum TEST snmp_get_or_set_OffsetFromUTC(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained, BYTE *value_changed_for_set)
{
	char	utc_offset[sizeof(Cache.SNTPInfo.UTCOffsetString)];

	if (mib_operation == SET_OPERATION)
	{
		strncpy_null(utc_offset, vptr_mib_value_obtained, sizeof(utc_offset) - 1);
		snmp_get_or_set_string (port_number, mib_operation, offset, _class, size, utc_offset, usptr_length_of_mib_obtained, value_changed_for_set);
		if (!AssignUTCOffset(Cache.SNTPInfo.UTCOffsetString, &Cache.SNTPInfo.UTCOffset))
			return(FAIL);
		return(PASS);
	}
	ConvertUTCOffset(Cache.SNTPInfo.UTCOffset,Cache.SNTPInfo.UTCOffsetString);
	return(snmp_get_or_set_string (port_number, mib_operation, offset, _class, size, vptr_mib_value_obtained, usptr_length_of_mib_obtained, value_changed_for_set));
}
/**********************************************************************************/
enum TEST snmp_get_or_set_Ordinal(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained, BYTE *value_changed_for_set)
{
	if (mib_operation == SET_OPERATION)
	{
		switch (*(ULONG *) vptr_mib_value_obtained)
		{
			case FIRST :
			case SECOND :
			case THIRD :
			case FOURTH :
			case LAST :
				break;
			default :
				return(FAIL);
		}
	}
	return(snmp_get_or_set_byte (port_number, mib_operation, offset, _class, size, vptr_mib_value_obtained, usptr_length_of_mib_obtained, value_changed_for_set));
}
/**********************************************************************************/
enum TEST snmp_get_or_set_DayOfWeek(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained, BYTE *value_changed_for_set)
{
	if (mib_operation == SET_OPERATION)
	{
		switch (*(ULONG *) vptr_mib_value_obtained)
		{
			case SUNDAY :
			case MONDAY :
			case TUESDAY :
			case WEDNESDAY :
			case THURSDAY :
			case FRIDAY :
			case SATURDAY :
				break;
			default :
				return(FAIL);
		}
	}
	return(snmp_get_or_set_byte (port_number, mib_operation, offset, _class, size, vptr_mib_value_obtained, usptr_length_of_mib_obtained, value_changed_for_set));
}
/**********************************************************************************/
enum TEST snmp_get_or_set_Month(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained, BYTE *value_changed_for_set)
{
	if (mib_operation == SET_OPERATION)
	{
		switch (*(ULONG *) vptr_mib_value_obtained)
		{
			case JANUARY :
			case FEBRUARY :
			case MARCH :
			case APRIL :
			case MAY :
			case JUNE :
			case JULY :
			case AUGUST :
			case SEPTEMBER :
			case OCTOBER :
			case NOVEMBER :
			case DECEMBER :
				break;
			default :
				return(FAIL);
		}
	}
	return(snmp_get_or_set_byte (port_number, mib_operation, offset, _class, size, vptr_mib_value_obtained, usptr_length_of_mib_obtained, value_changed_for_set));
}
/**********************************************************************************/
enum TEST snmp_get_or_set_TimeHour(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained, BYTE *value_changed_for_set)
{
	if (mib_operation == SET_OPERATION)
	{
		if (*((ULONG *) vptr_mib_value_obtained) >= 24)
			return(FAIL);
	}
	return(snmp_get_or_set_byte (port_number, mib_operation, offset, _class, size, vptr_mib_value_obtained, usptr_length_of_mib_obtained, value_changed_for_set));
}
/**********************************************************************************/
enum TEST snmp_get_or_set_TimeMinute(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained, BYTE *value_changed_for_set)
{
	if (mib_operation == SET_OPERATION)
	{
		if (*((ULONG *) vptr_mib_value_obtained) >= 60)
			return(FAIL);
	}
	return(snmp_get_or_set_byte (port_number, mib_operation, offset, _class, size, vptr_mib_value_obtained, usptr_length_of_mib_obtained, value_changed_for_set));
}

enum TEST snmp_get_or_set_DaylightSavingsOffset(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained, BYTE *value_changed_for_set)
{
	if (mib_operation == SET_OPERATION)
	{
		if (!ValidateDaylightOffset(*((ULONG *) vptr_mib_value_obtained)))
			return(FAIL);
	}
	return(snmp_get_or_set_ulong (port_number, mib_operation, offset, _class, size, vptr_mib_value_obtained, usptr_length_of_mib_obtained, value_changed_for_set));
}
