/*---------------------------------------------------------------------------
Module		:	SNTP Client
File			:	SNTPDLSP.C
Author		:	Vinod Porwal.
---------------------------------------------------------------------------*/

#include "defs.h"
#include <stdlib.h>
#include <string.h>
#include "sntp.h"

	/*	To check whether a given year is a leap year.	*/
#define	IS_LEAP_YEAR(x)	(x % 4 == 0 && x % 100 != 0 || x % 400 == 0)

extern BYTE days_in_month[];

void find_weekday(SntpDateTime *d_ptr)
{
	WORD days;
	int	idx;

	/*	Get number of days since beginning of month */
	days = (WORD) (d_ptr->Day - 1);

	/*	Add number of days since beginning of year upto beginning of month.	*/
	for (idx = 1; idx < d_ptr->Month; idx++)
	{
		days += days_in_month[idx - 1];
		if (idx == 2 && IS_LEAP_YEAR(d_ptr->Year))
			days++;	/*	Add 1 day in Feb if leap year.	*/
	}

	/*	Add number of days since 1900 upto beginning of year.	*/

	days += (WORD) (d_ptr->Year - 1900) * 365;
	/*	For each leap year from 1900 upto previous year add one day.	*/
	for (idx = 1900; idx < d_ptr->Year; idx++)
		if (IS_LEAP_YEAR(idx))
			days++;

	// 2 indicates the Weekday on 1st Jan 1900 (monday)
	d_ptr->WeekDay =  (BYTE) ((days + 1) % 7);

}

enum BOOLEAN find_date(SntpDateTime *d_ptr)
{
	SntpDateTime temp_date;
	int diff;
	BYTE valid_date;
	int i;	

	temp_date = *d_ptr;

	// get the weekday on 1st of this month
	temp_date.Day = 1;
	find_weekday(&temp_date);

	// find the Day corresponding the to 1st occurence of the given weekday
	// in this month.
	if (d_ptr->WeekDay != temp_date.WeekDay)
	{
		diff = d_ptr->WeekDay - temp_date.WeekDay;
		if (diff < 0)
			diff += 7;
		temp_date.Day += (BYTE) diff;
		temp_date.WeekDay = d_ptr->WeekDay;
	}

	//  calculate the valid date of this month.
	valid_date =  days_in_month[temp_date.Month - 1];
	if ( temp_date.Month == 2 && IS_LEAP_YEAR(temp_date.Year))
		valid_date++;

	// find the Day corresponding to the given weekday and the occurence 
	// indicated in d_ptr->Day. 1st occurence is already set. We will 
	for (i = 1; i < d_ptr->Day; i++)
		temp_date.Day += 7;

	if (temp_date.Day  <= valid_date)
	{
		d_ptr->Day = temp_date.Day;
		return(TRUE);
	}
	else
	{
	// BUG FIX: If LAST WeekDay and date is invalid then take 4th Week Day 
		if (d_ptr->Day == 5)
		{
		   temp_date.Day -= 7;
			d_ptr->Day = temp_date.Day;
		}
		else
			return(FALSE);		// will take care of Day > 5 ! should not happen
		return(TRUE);
	}
}

#if 0
int compare_date_time(SntpDateTime f1, SntpDateTime f2)
{	
	if (f1.Year > f2.Year)
		return (1);
	else
		if (f1.Year < f2.Year)
			return(-1);

	if (f1.Month > f2.Month)
		return (1);
	else
		if (f1.Month < f2.Month)
			return(-1);

	if (f1.Day > f2.Day)
		return (1);
	else
		if (f1.Day < f2.Day)
			return(-1);
	
	if (f1.Hour > f2.Hour)
		return (1);
	else
		if (f1.Hour < f2.Hour)
			return(-1);

	if (f1.Minute > f2.Minute)
		return (1);
	else
		if (f1.Minute < f2.Minute)
			return(-1);

	if (f1.Second > f2.Second)
		return (1);
	else
		if (f1.Second < f2.Second)
			return(-1);

	if (f1.FracSecond > f2.FracSecond)
		return (1);
	else
		if (f1.FracSecond < f2.FracSecond)
			return(-1);
	return(0);
}	  
#endif

long find_diff(SntpDateTime f1, SntpDateTime f2)
{	
	long diff;
	
	diff = (f1.Day - f2.Day) * 24 * 60 * 60;
	diff += (f1.Hour - f2.Hour) * 60 * 60;
	diff += (f1.Minute - f2.Minute) * 60;
	diff += (f1.Second  - f2.Second);

	return(diff);
}						   

enum BOOLEAN has_daylight_period_started(SntpDateTime curr_date,SntpDateTime ds_date)
{
	SntpDateTime		start_date;
	long			diff;

	start_date = ds_date;
	start_date.Year = curr_date.Year;
	if (find_date(&start_date) == FALSE)
		return(FALSE);
#if 0
	if (compare_date_time(curr_date,start_date) >= 0)
		return(TRUE);
	else
		return(FALSE);
#endif
	diff = find_diff(curr_date,start_date);
	if ( diff < 0 )
	{
/*		diff = labs(diff); sri */
		if (diff < (sntp.poll_interval + sntp.initial_poll_interval))
		{
			sntp.poll_interval = diff;
			ForceARequest = TRUE;
		}
		return(FALSE);
	}
	else
		return(TRUE);
}

enum BOOLEAN has_daylight_period_finished(SntpDateTime curr_date,SntpDateTime de_date)
{
	SntpDateTime		end_date;
	long			diff;

	end_date = de_date;
	end_date.Year = curr_date.Year;
	if (find_date(&end_date) == FALSE)
		return(FALSE);
#if 0
	if (compare_date_time(curr_date,end_date) >= 0)
		return(TRUE);
	else
		return(FALSE);
#endif
	diff = find_diff(curr_date,end_date);
	if ( diff < 0 )
	{
/*		diff = labs(diff); sri */
		if (diff < (sntp.poll_interval + sntp.initial_poll_interval))
		{
			sntp.poll_interval = diff;
			ForceARequest = TRUE;
		}
		return(FALSE);
	}
	else
		return(TRUE);
}

enum BOOLEAN check_if_in_daylights_savings_period(SntpDateTime curr_date)
{

	if (sntp.time_zone.ds_date.Month < sntp.time_zone.de_date.Month)
	{
		if ((curr_date.Month > sntp.time_zone.ds_date.Month) &&
			 (curr_date.Month < sntp.time_zone.de_date.Month))
			return(TRUE); 
		if (curr_date.Month == sntp.time_zone.ds_date.Month)
		{
			if (has_daylight_period_started(curr_date,sntp.time_zone.ds_date))
				return(TRUE);
			else
				return(FALSE);
		}
		if (curr_date.Month == sntp.time_zone.de_date.Month)
		{
			if (has_daylight_period_finished(curr_date,sntp.time_zone.de_date))
				return(FALSE);
			else
				return(TRUE);
		}
		return(FALSE);
	}
	else if (sntp.time_zone.ds_date.Month > sntp.time_zone.de_date.Month)
	{
		if ((curr_date.Month > sntp.time_zone.ds_date.Month) || 
			 (curr_date.Month < sntp.time_zone.de_date.Month))
			return(TRUE); 
		if (curr_date.Month == sntp.time_zone.ds_date.Month)
		{
			if (has_daylight_period_started(curr_date,sntp.time_zone.ds_date))
				return(TRUE);
			else
				return(FALSE);
		}
		if (curr_date.Month == sntp.time_zone.de_date.Month)
		{
			if (has_daylight_period_finished(curr_date,sntp.time_zone.de_date))
				return(FALSE);
			else
				return(TRUE);
		}
		return(FALSE);
	}
	else
	{
		if (has_daylight_period_started(curr_date,sntp.time_zone.ds_date))
			if (!has_daylight_period_finished(curr_date,sntp.time_zone.de_date))
				return(TRUE);
		return(FALSE);
	}
}

