/*---------------------------------------------------------------------------
Module		:	SNTP Client
File			:	SNTPINIT.C
Author		:	Vinod Porwal.
---------------------------------------------------------------------------*/


#define GLOBAL_FILE
#include "defs.h"
#include <stdlib.h>
#include <string.h>
#include "sntp.h"

static enum TEST register_sntp (void);
enum TEST sntp_control (enum APPLICATION_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1);
enum TEST initialize_sntp_socket_interface (void);

extern ULONG get_ip_address(USHORT);
extern enum BOOLEAN is_ip_enabled(void);
extern USHORT get_insecured_lan_port_number();	/* Added by Sreelu */

void initialize_sntp_defaults(void)
{
	sntp.enabled = FALSE;
	sntp.ntp_server_ip_address = 0x00000000;
	strcpy(sntp.time_zone.standard_name,"PDT");
	sntp.time_zone.offset_from_utc = -( 8 * 60);		//-08:00 hrs from UTC
	sntp.time_zone.daylight_enabled = TRUE;
	sntp.time_zone.ds_date.Month = 4;					// April
	sntp.time_zone.ds_date.Day = 1;					   // First
	sntp.time_zone.ds_date.WeekDay = 0; 				// Sunday
	sntp.time_zone.ds_date.Hour	= 2;					// 02:00 
	sntp.time_zone.ds_date.Minute	= 0;
	sntp.time_zone.de_date.Month = 10;				// October
	sntp.time_zone.de_date.Day = 5;					// Last
	sntp.time_zone.de_date.WeekDay = 0; 			// Sunday
	sntp.time_zone.de_date.Hour	= 2;				// 02:00
	sntp.time_zone.de_date.Minute	= 0;
	sntp.time_zone.daylight_offset = 60;			// forwared by 60 minutes

	sntp.timeout_period = RETRANSMIT_TIME;
	sntp.no_of_retransmission_allowed = MAX_NO_OF_RETRIES;
	sntp.initial_poll_interval = INITIAL_POLL_INTERVAL;

}

enum TEST initialize_sntp(ULONG clock_ticks_per_second)
{
	sntp.timer_class.clock_ticks_per_second = clock_ticks_per_second;
	
	if (sntp.enabled == FALSE)
		return(PASS);


/*	sntp.ntp_server_ip_address = 0x80fc1301; */


	sntp.poll_interval = sntp.initial_poll_interval;
	sntp.poll_timer = 0;
	sntp.retransmission_timer = 0;
	
	sntp.current_state = TO_SEND_REQUEST;
	sntp.socket_interface_enabled = TRUE;

	if (register_sntp () == FAIL)	
	{
//		LastError = INIT_SNTP_FAILED;
		return (FAIL);
	}

	if (initialize_sntp_socket_interface () == FAIL)
		return (PASS);

	sntp.timer_class.timer_enabled = TRUE;
	return (PASS);
}

enum TEST initialize_sntp_socket_interface (void)
{

	SOCKADDR_IN local_read_sockaddr_in;

	if ( sntp.socket_interface_enabled  == FALSE )
		return (FAIL) ;

	sntp.local_internet_address = get_ip_address(get_insecured_lan_port_number());
	sntp.socket = socket (AF_INET, SOCK_DGRAM,0L);

	if (sntp.socket == FAILED) 
	{
		return (FAIL);
	}
	printf("SNTP Socket initialised sucessfully\n");		

	associate_application_with_socket (sntp.socket, sntp.application_id);

	local_read_sockaddr_in.sin_family = AF_INET;
	local_read_sockaddr_in.sin_port = NTP_UDP_PORT;

/* Commented by Ravi */
/*	local_read_sockaddr_in.sin_addr.s_addr = sntp.local_internet_address;   */

	local_read_sockaddr_in.sin_addr.s_addr = INTERNET_ADDRESS_ANY;

	/* bind local ip address & port number to the socket */

	if (bind (sntp.socket, (SOCKADDR *)&local_read_sockaddr_in, sizeof(SOCKADDR_IN)) == FAILED) 
	{
		closesocket(sntp.socket);
		return (FAIL);
	}

	sntp.socket_interface_initialized = TRUE ;
	return (PASS);
}

static enum TEST register_sntp (void)
{
#ifdef __LSL__
	if ((enum TEST) lsl_control (REGISTER_APPLICATION, "SNTP Client", SNTP_CLIENT_APPLICATION, sntp_timer, sntp_control,
		&sntp.application_id) == FAIL)
	{
		return (FAIL);
	}
	return (PASS);
#else
	return (FAIL);
#endif
}


enum TEST sntp_control (enum APPLICATION_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1)
{
	PARAMETER_NOT_USED (parameter_0);
	PARAMETER_NOT_USED (parameter_1);

	switch (command)
	{
		case START_APPLICATION:
			break;

		case TERMINATE_APPLICATION:
			lsl_control ((ULONG) DEREGISTER_APPLICATION, (ULONG) APPLICATION_LAYER_TYPE, sntp.application_id);
			sntp.enabled = FALSE;
			break;

		case IS_APPLICATION_ENABLED:
			*((enum BOOLEAN *) parameter_1) = sntp.enabled;
			break;

		default:
			break;
	}
   return(PASS);
}
// CHANGED_SN, Aug 5, 1997. Added the following function to check for SNTP in SNMP.

int		is_sntp_enabled(void)
{
	return(sntp.enabled);
}

