/*---------------------------------------------------------------------------
Module		:	SNTP Client
File			:	SNTPRX.C
Author		:	Vinod Porwal.
---------------------------------------------------------------------------*/
#include "defs.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "sntp.h"

int is_resp_for_our_sntp_client(NTP_PACKET *sptr_ntp_buffer,SOCKADDR_IN *sptr_remote_sockaddr_in);

NTP_PACKET ntp_buffer;

int sntp_read_data_from_socket (NTP_PACKET *sptr_ntp_buffer)
{
	int number_of_bytes_received;
	SOCKADDR_IN remote_sockaddr_in;
	ULONG sockaddr_length;
	SntpDateTime  *temp_datetime;		/* Added by Sreelu */

	sockaddr_length = sizeof (SOCKADDR_IN);

	number_of_bytes_received = recvfrom (sntp.socket,(char *) sptr_ntp_buffer, 
						sizeof(NTP_PACKET),(int) NULL,(SOCKADDR *)&remote_sockaddr_in, 
						(int *) &sockaddr_length);

//	if (number_of_bytes_received <= sizeof(0))
	if (number_of_bytes_received < sizeof(NTP_PACKET))
		return (0);

	if (!is_resp_for_our_sntp_client(sptr_ntp_buffer,&remote_sockaddr_in))
		return (0);

	return (1);

} 


int is_resp_for_our_sntp_client(NTP_PACKET *sptr_ntp_buffer,SOCKADDR_IN *sptr_remote_sockaddr_in)
{	
	if (sptr_remote_sockaddr_in->sin_addr.s_addr != sntp.ntp_server_ip_address)
	{
		return(0);
	}
			// reply for a request from us ?
	if ( (sptr_ntp_buffer->li_vn_mode &  MODE_MASK) != SERVER)
		return(0);

	return(1);

}

int valid_sntp_response(NTP_PACKET *sptr_ntp_buffer)
{
			// response for which we have timed out ?
	if (sntp.current_state != REQUEST_SENT)
	{
		return(0);
	}

			// is server clock synchronized ?
	if (memcmp(&sntp.our_timestamp,&sptr_ntp_buffer->originate_timestamp,
											sizeof(NTP_TIMESTAMP)))
		return(0);


	if (( (sptr_ntp_buffer->li_vn_mode & LI_MASK) >> LI_SHIFT) == ALARM_CONDITION)
		return(0);
									// stratum field lies within 1-14
//	if ((sptr_ntp_buffer->stratum < 1 ) || (sptr_ntp_buffer->stratum > 14))
//		return(0);

	if (((sptr_ntp_buffer->li_vn_mode & VERSION_MASK) >> VERSION_SHIFT) != OUR_SNTP_VERSION)
		return(0);

	if (sptr_ntp_buffer->transmit_timestamp.seconds == 0L)
		return(0);

	return(1);
}


void process_sntp_packets(NTP_PACKET *sptr_ntp_buffer)
{
	SntpDateTime		curr_date_time;
	SntpDateTime		temp_date_time;
	NTP_TIMESTAMP receive_time;
	NTP_TIMESTAMP transmit_time;
	NTP_TIMESTAMP ntp_server_time;
	ULONG			  delay;
	ULONG				correction;
	// BYTE				temp_buffer[50];

	// get the server time and convert to local time
	ntp_server_time.seconds  = net_to_host_long(sptr_ntp_buffer->transmit_timestamp.seconds);
	ntp_server_time.seconds_fraction = net_to_host_long(sptr_ntp_buffer->transmit_timestamp.seconds_fraction);
	get_local_time_from_utc(&ntp_server_time);

	// caclulate the roundtrip delay
	transmit_time.seconds  = net_to_host_long(sptr_ntp_buffer->originate_timestamp.seconds);
//	transmit_time.seconds_fraction = net_to_host_long(sptr_ntp_buffer->originate_timestamp.seconds_fraction);
	GetDateTime(&temp_date_time);
	datetime_to_ntp_timestamp(&temp_date_time,&receive_time);
	get_utc_from_local_time(&receive_time);
	delay = (receive_time.seconds - transmit_time.seconds);
//	UpdateLastMessage(0xff,temp_buffer, LEVEL_3);

	 // correct the server time to take into account delays.
	ntp_server_time.seconds += (delay / 2);
	ntp_timestamp_to_datetime(&ntp_server_time,&curr_date_time);

	ForceARequest = FALSE;

	// check if Daylights Savigs Used, if yes check if time within the
	// daylights saving period. if so update time.
	if (sntp.time_zone.daylight_enabled && check_if_in_daylights_savings_period(curr_date_time))
	{
//		UpdateLastMessage(0xff,"Daylight Savings Applied", LEVEL_3);
		ntp_server_time.seconds += (sntp.time_zone.daylight_offset * 60);
		ntp_timestamp_to_datetime(&ntp_server_time,&curr_date_time);
	}

// calculate the correction
	get_local_time_from_utc(&receive_time);

#if 0
	printf("\nSNTPRX: SNTP TimeStamp : %16x\n", ntp_server_time.seconds);		
	printf("SNTPRX: Receive TimeStamp: %16x\n", receive_time.seconds);		
#endif

	if (receive_time.seconds > ntp_server_time.seconds)
		correction = receive_time.seconds - ntp_server_time.seconds;
	else
		correction =  ntp_server_time.seconds - receive_time.seconds;

	if (correction)
	{
		//	GetDateTime(&temp_date_time);
		if(!SetCurrentDateTime(&curr_date_time)) 
			SetCurrentDateTime(&temp_date_time);
	}

	// recalculate poll_timer 
	if ( correction <=  MAX_DELTA )
	{
/* Added by Sreelu 
	SNTP Timer should be disabled once we update our Local SNTP timer with the 
	Real Timer. SNTP Request packet triggers the WAN port & Never brings it down
	on demand */
		sntp.timer_class.timer_enabled = FALSE;

/*		printf("Correction is :%ld\n",correction); */
		if (!ForceARequest)
		{ 
/*			printf("change sntp poll time\n");	 */
			sntp.poll_interval = sntp.poll_interval + sntp.initial_poll_interval;
			if (sntp.poll_interval > (sntp.initial_poll_interval * 16))
				sntp.poll_interval = sntp.initial_poll_interval * 16;
		}
	}
	else
	{
/* Added by Sreelu 
	SNTP Timer should be disabled once we update our Local SNTP timer with the 
	Real Timer. SNTP Request packet triggers the WAN port & Never brings it down
	on demand */
		sntp.timer_class.timer_enabled = TRUE;

#if 0
			sntp.poll_interval = sntp.poll_interval - sntp.initial_poll_interval;
			if (sntp.poll_interval < sntp.initial_poll_interval)
#endif
		if (!ForceARequest || (sntp.poll_interval > sntp.initial_poll_interval))
				sntp.poll_interval = sntp.initial_poll_interval;
	}
//	sprintf(temp_buffer,"clock corrected by %lu seconds",correction);
//	UpdateLastMessage(0xff,temp_buffer, LEVEL_3);
	sntp.poll_timer	= sntp.poll_interval * 20;
	printf("Poll Timer is : %ld\n",sntp.poll_timer);
}

void handle_receive_on_sntp_port()
{
	if(!sntp_read_data_from_socket(&ntp_buffer))
		return;
	 
	if (valid_sntp_response(&ntp_buffer) )
	{
		process_sntp_packets(&ntp_buffer);
		sntp.current_state = TO_SEND_REQUEST;
	}
}
