/*---------------------------------------------------------------------------
Module		:	SNTP Client
File			:	SNTPTX.C
Author		:	Vinod Porwal.
---------------------------------------------------------------------------*/
#include "defs.h"
#include <stdlib.h>
#include <string.h>
#include "sntp.h"


void send_sntp_request_packet(void)
{
	NTP_PACKET		*sptr_ntp_packet;
	SOCKADDR_IN		destination;
 // ULONG  			ip_address;
	SntpDateTime			curr_date_time;

	sptr_ntp_packet = (NTP_PACKET *)table_malloc(1, sizeof(NTP_PACKET));
	
	if ( sptr_ntp_packet == NULL ) 
				return;

	memset(&destination,0,sizeof(SOCKADDR_IN));
	destination.sin_family = AF_INET;
	destination.sin_port = NTP_UDP_PORT;
//	ip_address = swap_long(sntp.ntp_server_ip_address);
//	destination.sin_addr.s_addr = ip_address;
	destination.sin_addr.s_addr = sntp.ntp_server_ip_address;

// fill the data packet here
	sptr_ntp_packet->li_vn_mode = (NO_WARNING <<  6	) |  
											(OUR_SNTP_VERSION << 3) | CLIENT;
	GetDateTime(&curr_date_time);		/* Sreelu */

	datetime_to_ntp_timestamp(&curr_date_time,&sptr_ntp_packet->transmit_timestamp);
	get_utc_from_local_time(&sptr_ntp_packet->transmit_timestamp);

	sptr_ntp_packet->transmit_timestamp.seconds =
			 host_to_net_long(sptr_ntp_packet->transmit_timestamp.seconds);
	sptr_ntp_packet->transmit_timestamp.seconds_fraction =
			 host_to_net_long(sptr_ntp_packet->transmit_timestamp.seconds_fraction);

	memcpy(&sntp.our_timestamp,&sptr_ntp_packet->transmit_timestamp,
									sizeof(NTP_TIMESTAMP));

 	// if the function fails we will try next time. 
#ifdef SOCKET_LIB_FREE_MEMORY_ON_ERROR
	if (sendto(sntp.socket, (char *)sptr_ntp_packet, sizeof(NTP_PACKET),(int) NULL,
  			(SOCKADDR *) &destination, sizeof(SOCKADDR_IN)) != FAILED)
		table_free (sptr_ntp_packet);
#else
	sendto(sntp.socket, (char *)sptr_ntp_packet, sizeof(NTP_PACKET),(int) NULL,
  			(SOCKADDR *) &destination, sizeof(SOCKADDR_IN));
	table_free (sptr_ntp_packet);
#endif
}

void handle_transmit_on_sntp_port(void)
{
	if (sntp.current_state == 	REQUEST_SENT)
	{
		if (!sntp.retransmission_timer)
		{
			send_sntp_request_packet();
			sntp.retransmission_timer = sntp.timeout_period * 18;
			sntp.poll_timer	= sntp.poll_interval * 18;
			sntp.no_of_retransmission--;	
			if (sntp.no_of_retransmission == 0)
				sntp.current_state = TO_SEND_REQUEST;
		}
	}
	else
	{
		if (!sntp.poll_timer)
		{
			send_sntp_request_packet();
			sntp.retransmission_timer = sntp.timeout_period * 18;
			sntp.poll_timer	= sntp.poll_interval * 18;
			sntp.current_state = REQUEST_SENT;
			sntp.no_of_retransmission = sntp.no_of_retransmission_allowed;
		}
	}
}
