/*---------------------------------------------------------------------------
Module		:	SNTP Client
File			:	SNTPUTIL.C
Author		:	Vinod Porwal.
---------------------------------------------------------------------------*/

#include "defs.h"
#include <stdlib.h>
#include <string.h>
#include "sntp.h"

	/*	To check whether a given year is a leap year.	*/
#define	IS_LEAP_YEAR(x)	(x % 4 == 0 && x % 100 != 0 || x % 400 == 0)

BYTE	days_in_month[] = {	/*	Number of days to month.	*/
	31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31
};

extern ULONG net_to_host_long(ULONG);
extern ULONG host_to_net_long(ULONG);

void datetime_to_ntp_timestamp(SntpDateTime *d_ptr,NTP_TIMESTAMP *n_ptr)
{
	WORD days;
	ULONG seconds;
	int	idx;

	/*	Get number of days since beginning of month.	*/
	days = (WORD) (d_ptr->Day - 1);

	/*	Add number of days since beginning of year upto beginning of month.	*/
	for (idx = 1; idx < d_ptr->Month; idx++) 
	{
		days += days_in_month[idx - 1];
		if (idx == 2 && IS_LEAP_YEAR(d_ptr->Year))
			days++;	/*	Add 1 day in Feb if leap year.	*/
	}

	/*	Add number of days since 1900 upto beginning of year.	*/
	days += (WORD) (d_ptr->Year - 1900) * 365;
	/*	For each leap year from 1900 upto previous year add one day.	*/
	for (idx = 1900; idx < d_ptr->Year; idx++)
		if (IS_LEAP_YEAR(idx))
			days++;

	/*	Number of seconds since start of day.	*/
	seconds = (ULONG) ( d_ptr->Hour * 60L * 60 + d_ptr->Minute * 60L +
								d_ptr->Second);

	seconds = seconds + days * 24L * 60 * 60;
//	n_ptr->seconds = host_to_net_long(seconds);
	n_ptr->seconds = seconds;
	n_ptr->seconds_fraction = 0;

}

void ntp_timestamp_to_datetime(NTP_TIMESTAMP *n_ptr, SntpDateTime *d_ptr)
{
	WORD 	days;
	BYTE	hours;
	BYTE	minutes;
	BYTE	seconds;
	ULONG	duration;
	WORD  days_in_this_year;
	WORD  days_in_this_month;

//	duration = net_to_host_long(n_ptr->seconds);
	duration = n_ptr->seconds;

	for (days = 0; duration >= 24 * 60 * 60L;
								duration -=  24 * 60 * 60L, days++)
		;
	for (hours = 0; duration >= 60 * 60L; duration -= 60 * 60L,
														hours++)
		;
	for (minutes = 0; duration >= 60L; duration -= 60L, minutes++)
		;
	seconds = duration;

	d_ptr->Year = 1900; 		// 0:00:00 hrs on 1st Jan 1900 , Monday.
	d_ptr->Day 	= 1;
	d_ptr->Month = 1;
	// 1 indicates MONDAY and 7 is no. of days in a week
	d_ptr->WeekDay = (BYTE) ((days + 1 ) % 7);


	while(1)
	{
		days_in_this_year = 365;
		if (IS_LEAP_YEAR(d_ptr->Year))
			days_in_this_year++;
		if (days >= days_in_this_year)
		{
			days-= days_in_this_year;
			d_ptr->Year++;
		}	
		else
			break;
	}

	d_ptr->FracSecond = 0;
	d_ptr->Second = seconds;
	d_ptr->Minute = minutes;
	d_ptr->Hour = hours;

	while (1)
	{
		days_in_this_month = days_in_month[d_ptr->Month - 1];
		if (d_ptr->Month == 2 && IS_LEAP_YEAR(d_ptr->Year))
			days_in_this_month++;
		if (days < days_in_this_month) {
			d_ptr->Day += (BYTE) days;
			break;
		}
		days -= days_in_this_month;
		d_ptr->Month++;
	}
}

//  local time = UTC +  bias;

void get_local_time_from_utc(NTP_TIMESTAMP *sptr_timestamp)
{
	long utc_offset_in_seconds;		

	utc_offset_in_seconds = sntp.time_zone.offset_from_utc *  60;
	sptr_timestamp->seconds +=  utc_offset_in_seconds;

}

void get_utc_from_local_time(NTP_TIMESTAMP *sptr_timestamp)
{
	long utc_offset_in_seconds;		

	utc_offset_in_seconds = sntp.time_zone.offset_from_utc *  60;

	sptr_timestamp->seconds -=  utc_offset_in_seconds;
}

/* Added by Sreelu... */
int SetCurrentDateTime(SntpDateTime far *d_ptr)
{
	datetime_to_ntp_timestamp(d_ptr, &sntp.current_time_in_ntp);
	return (1);
}

void GetDateTime (SntpDateTime far *dt_ptr)
{
	ntp_timestamp_to_datetime(&sntp.current_time_in_ntp, dt_ptr);
}

void sntp_increment_timer(void)
{
	sntp.current_time_in_ntp.seconds++;	
}

void display_sntp_date_time()
{
	SntpDateTime dt_time;
	GetDateTime(&dt_time);
	printf("\nSNTP DATE TIME\n\n");
	printf("Year      : %d\n",dt_time.Year);
	printf("Month     : %d\n",dt_time.Month);
	printf("Day       : %d\n",dt_time.Day);
	printf("WeekDay   : %d\n",dt_time.WeekDay);
	printf("Hour      : %d\n",dt_time.Hour);
	printf("Minute    : %d\n",dt_time.Minute);
	printf("Second    : %d\n",dt_time.Second);
	printf("FracSecond: %d\n",dt_time.FracSecond);
}

/*...Added by Sreelu */
