/*---------------------------------------------------------------------------
Module		:	SNTP Client
File			:	SNTP.H
Author		:	Vinod Porwal.
Purpose		:	This file contains all the configuration strings
---------------------------------------------------------------------------*/

extern void set_daylight_offset(char *cptr_daylight_offset_string,ULONG offset,ULONG ulptr_base);
extern void set_utc_offset(char *cptr_utc_offset_string,ULONG offset,ULONG ulptr_base);

CONFIGURATION_TABLE sntp_configuration_table =
{
	{TRUE},
	{
		{
			NULL,
			(enum BOOLEAN *) TRUE,
			"SNTP =",
			(ULONG) offsetof (SNTP_CLASS, enabled),
			(ULONG) &sntp,
			(ULONG) NULL
		},
		{
			(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
			set_ip_address,
			NULL,
			"SNTP Server IP Address =",
			(ULONG) offsetof (SNTP_CLASS, ntp_server_ip_address),
			(ULONG) &sntp,
			(ULONG) NULL
		},
		{
			(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
			set_variable_string,
			NULL,
			"SNTP TimeZone Standard Name =",
			(ULONG) offsetof (SNTP_CLASS, time_zone.standard_name),
			(ULONG) &sntp,
			(ULONG) NULL
		},
		{
			(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
			set_utc_offset,
			NULL,
			"SNTP Offset From UTC =",
			(ULONG) offsetof (SNTP_CLASS,time_zone.offset_from_utc),
			(ULONG) &sntp,
			(ULONG) NULL
		},
		{
			NULL,
			(enum BOOLEAN *) TRUE,
			"SNTP Daylight Savings =",
			(ULONG) offsetof (SNTP_CLASS, time_zone.daylight_enabled),
			(ULONG) &sntp,
			(ULONG) NULL
		},
		{
			(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
			set_byte_decimal_value,
			NULL,
			"SNTP Daylight Start Day =",
			(ULONG) offsetof (SNTP_CLASS,time_zone.ds_date.Day),
			(ULONG) &sntp,
			(ULONG) NULL
		},
		{
			(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
			set_byte_decimal_value,
			NULL,
			"SNTP Daylight Start WeekDay =",
			(ULONG) offsetof (SNTP_CLASS,time_zone.ds_date.WeekDay),
			(ULONG) &sntp,
			(ULONG) NULL
		},
		{
			(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
			set_byte_decimal_value,
			NULL,
			"SNTP Daylight Start Month =",
			(ULONG) offsetof (SNTP_CLASS,time_zone.ds_date.Month),
			(ULONG) &sntp,
			(ULONG) NULL
		},
		{
			(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
			set_byte_decimal_value,
			NULL,
			"SNTP Daylight Start Time Hour =",
			(ULONG) offsetof (SNTP_CLASS,time_zone.ds_date.Hour),
			(ULONG) &sntp,
			(ULONG) NULL
		},
		{
			(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
			set_byte_decimal_value,
			NULL,
			"SNTP Daylight Start Time Minute =",
			(ULONG) offsetof (SNTP_CLASS,time_zone.ds_date.Minute),
			(ULONG) &sntp,
			(ULONG) NULL
		},
		{
			(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
			set_byte_decimal_value,
			NULL,
			"SNTP Daylight End Day =",
			(ULONG) offsetof (SNTP_CLASS,time_zone.de_date.Day),
			(ULONG) &sntp,
			(ULONG) NULL
		},
		{
			(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
			set_byte_decimal_value,
			NULL,
			"SNTP Daylight End WeekDay =",
			(ULONG) offsetof (SNTP_CLASS,time_zone.de_date.WeekDay),
			(ULONG) &sntp,
			(ULONG) NULL
		},
		{
			(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
			set_byte_decimal_value,
			NULL,
			"SNTP Daylight End Month =",
			(ULONG) offsetof (SNTP_CLASS,time_zone.de_date.Month),
			(ULONG) &sntp,
			(ULONG) NULL
		},
		{
			(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
			set_byte_decimal_value,
			NULL,
			"SNTP Daylight End Time Hour =",
			(ULONG) offsetof (SNTP_CLASS,time_zone.de_date.Hour),
	  		(ULONG) &sntp,
			(ULONG) NULL
		},
		{
			(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
			set_byte_decimal_value,
			NULL,
			"SNTP Daylight End Time Minute =",
			(ULONG) offsetof (SNTP_CLASS,time_zone.de_date.Minute),
	  		(ULONG) &sntp,
			(ULONG) NULL
		},
		{
			(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
			set_daylight_offset,
			NULL,
			"SNTP Daylight Offset =",
			(ULONG) offsetof (SNTP_CLASS,time_zone.daylight_offset),
			(ULONG) &sntp,
			(ULONG) NULL
		},
		{
			(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
			set_ushort_decimal_value,
			NULL,
			"SNTP Number of Retransmissions =",
			(ULONG) offsetof (SNTP_CLASS, no_of_retransmission_allowed),
			(ULONG) &sntp,
			(ULONG) NULL
		},
		{
			(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
			set_ushort_decimal_value,
			NULL,
			"SNTP Timeout Period =",
			(ULONG) offsetof (SNTP_CLASS,timeout_period),
			(ULONG) &sntp,
			(ULONG) NULL
		},
		{
			(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
			set_ushort_decimal_value,
			NULL,
			"SNTP Initial Poll Interval =",
			(ULONG) offsetof (SNTP_CLASS, initial_poll_interval),
			(ULONG) &sntp,
			(ULONG) NULL
		},
	}
} ;
