// File : vsntcstm.h
// July 29, 1997. Contains the SNTP related definitions.

enum TEST snmp_get_or_set_OffsetFromUTC(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained, BYTE *value_changed_for_set);

enum TEST snmp_get_or_set_Ordinal(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained, BYTE *value_changed_for_set);

enum TEST snmp_get_or_set_DayOfWeek(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained, BYTE *value_changed_for_set);

enum TEST snmp_get_or_set_Month(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained, BYTE *value_changed_for_set);

enum TEST snmp_get_or_set_TimeHour(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained, BYTE *value_changed_for_set);

enum TEST snmp_get_or_set_TimeMinute(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained, BYTE *value_changed_for_set);

enum TEST snmp_get_or_set_DaylightSavingsOffset(USHORT port_number, enum MIB_OPERATION mib_operation, ULONG offset, ULONG _class, ULONG size,
	void *vptr_mib_value_obtained, USHORT *usptr_length_of_mib_obtained, BYTE *value_changed_for_set);

enum {
	FIRST = 1,
	SECOND,
	THIRD,
	FOURTH,
	LAST,
};

enum {
	SUNDAY,
	MONDAY,
	TUESDAY,
	WEDNESDAY,
	THURSDAY,
	FRIDAY,
	SATURDAY,
};

enum {
	JANUARY = 1,
	FEBRUARY,
	MARCH,
	APRIL,
	MAY,
	JUNE,
	JULY,
	AUGUST,
	SEPTEMBER,
	OCTOBER,
	NOVEMBER,
	DECEMBER,
};

SNMP_TABLE_ENTRY_PARAMETERS sntp_snmp_table_parameters[] =
{
	{(ULONG) &Cache,
		FALSE
	},
};

SNMP_TABLE_ENTRY sntp_snmp_table[] =
{
	{"serSNTP_Client",sizeof(ULONG),snmp_get_or_set_boolean,
		FALSE,
		FALSE,
		(ULONG) offsetof (CACHE_CLASS,SNTPInfo.ClientEnabled),
		&sntp_snmp_table_parameters[0],
		REBOOT_REQUIRED_FLAG + CACHE_MODIFIED_FLAG,
		snmp_SNTPSetupChange_trap
	},

	{"serSNTP_ServerAddress",sizeof(ULONG),snmp_get_or_set_ip_address,
		FALSE,
		FALSE,
		(ULONG) offsetof (CACHE_CLASS,SNTPInfo.ServerIPAddress),
		&sntp_snmp_table_parameters[0],
		CACHE_MODIFIED_FLAG,
		snmp_SNTPSetupChange_trap
	},
		
	{"serSNTP_TZname",sizeof(Cache.SNTPInfo.TZStandardName) - 1 ,snmp_get_or_set_string,
		FALSE,
		FALSE,
		(ULONG) offsetof (CACHE_CLASS,SNTPInfo.TZStandardName),
		&sntp_snmp_table_parameters[0],
		CACHE_MODIFIED_FLAG,
		snmp_SNTPSetupChange_trap
	},

	{"serSNTP_OffsetFromUTC",sizeof(Cache.SNTPInfo.UTCOffsetString) - 1,snmp_get_or_set_OffsetFromUTC,
		FALSE,
		FALSE,
		(ULONG) offsetof (CACHE_CLASS,SNTPInfo.UTCOffsetString),
		&sntp_snmp_table_parameters[0],
		CACHE_MODIFIED_FLAG,
		snmp_SNTPSetupChange_trap
	},

	{"serSNTP_DaylightSavings",sizeof(ULONG),snmp_get_or_set_boolean,
		FALSE,
		FALSE,
		(ULONG) offsetof (CACHE_CLASS,SNTPInfo.DaylightEnabled),
		&sntp_snmp_table_parameters[0],
		CACHE_MODIFIED_FLAG,
		snmp_SNTPSetupChange_trap
	},

	{"serSNTP_DaylightSavingsOffset",sizeof(ULONG),snmp_get_or_set_DaylightSavingsOffset,
		FALSE,
		FALSE,
		(ULONG) offsetof (CACHE_CLASS,SNTPInfo.DaylightOffset),
		&sntp_snmp_table_parameters[0],
		CACHE_MODIFIED_FLAG,
		snmp_SNTPSetupChange_trap
	},

	{"serSNTP_StartOrdinal",sizeof(ULONG),snmp_get_or_set_Ordinal,
		FALSE,
		FALSE,
		(ULONG) offsetof (CACHE_CLASS,SNTPInfo.StartTime.Ordinal),
		&sntp_snmp_table_parameters[0],
		CACHE_MODIFIED_FLAG,
		snmp_SNTPSetupChange_trap
	},

	{"serSNTP_StartDayOfWeek",sizeof(ULONG),snmp_get_or_set_DayOfWeek,
		FALSE,
		FALSE,
		(ULONG) offsetof (CACHE_CLASS,SNTPInfo.StartTime.DayOfWeek),
		&sntp_snmp_table_parameters[0],
		CACHE_MODIFIED_FLAG,
		snmp_SNTPSetupChange_trap
	},

	{"serSNTP_StartMonth",sizeof(ULONG),snmp_get_or_set_Month,
		FALSE,
		FALSE,
		(ULONG) offsetof (CACHE_CLASS,SNTPInfo.StartTime.Month),
		&sntp_snmp_table_parameters[0],
		CACHE_MODIFIED_FLAG,
		snmp_SNTPSetupChange_trap
	},

	{"serSNTP_StartTimeHour",sizeof(ULONG),snmp_get_or_set_TimeHour,
		FALSE,
		FALSE,
		(ULONG) offsetof (CACHE_CLASS,SNTPInfo.StartTime.Hour),
		&sntp_snmp_table_parameters[0],
		CACHE_MODIFIED_FLAG,
		snmp_SNTPSetupChange_trap
	},

	{"serSNTP_StartTimeMinute",sizeof(ULONG),snmp_get_or_set_TimeMinute,
		FALSE,
		FALSE,
		(ULONG) offsetof (CACHE_CLASS,SNTPInfo.StartTime.Minute),
		&sntp_snmp_table_parameters[0],
		CACHE_MODIFIED_FLAG,
		snmp_SNTPSetupChange_trap
	},

	{"serSNTP_EndOrdinal",sizeof(ULONG),snmp_get_or_set_Ordinal,
		FALSE,
		FALSE,
		(ULONG) offsetof (CACHE_CLASS,SNTPInfo.EndTime.Ordinal),
		&sntp_snmp_table_parameters[0],
		CACHE_MODIFIED_FLAG,
		snmp_SNTPSetupChange_trap
	},

	{"serSNTP_EndDayOfWeek",sizeof(ULONG),snmp_get_or_set_DayOfWeek,
		FALSE,
		FALSE,
		(ULONG) offsetof (CACHE_CLASS,SNTPInfo.EndTime.DayOfWeek),
		&sntp_snmp_table_parameters[0],
		CACHE_MODIFIED_FLAG,
		snmp_SNTPSetupChange_trap
	},

	{"serSNTP_EndMonth",sizeof(ULONG),snmp_get_or_set_Month,
		FALSE,
		FALSE,
		(ULONG) offsetof (CACHE_CLASS,SNTPInfo.EndTime.Month),
		&sntp_snmp_table_parameters[0],
		CACHE_MODIFIED_FLAG,
		snmp_SNTPSetupChange_trap
	},

	{"serSNTP_EndTimeHour",sizeof(ULONG),snmp_get_or_set_TimeHour,
		FALSE,
		FALSE,
		(ULONG) offsetof (CACHE_CLASS,SNTPInfo.EndTime.Hour),
		&sntp_snmp_table_parameters[0],
		CACHE_MODIFIED_FLAG,
		snmp_SNTPSetupChange_trap
	},

	{"serSNTP_EndTimeMinute",sizeof(ULONG),snmp_get_or_set_TimeMinute,
		FALSE,
		FALSE,
		(ULONG) offsetof (CACHE_CLASS,SNTPInfo.EndTime.Minute),
		&sntp_snmp_table_parameters[0],
		CACHE_MODIFIED_FLAG,
		snmp_SNTPSetupChange_trap
	},

	{"",0x0000,NULL,
		FALSE,
		FALSE,
		(ULONG) NULL,
		NULL
	}
};
