/*---------------------------------------------------------------------------
Module		:	SNTP Client
File			:	VSNTPSTR.H
Author		:	Vinod Porwal.
---------------------------------------------------------------------------*/
#ifndef _VSNTPSTR_H_
#define _VSNTPSTR_H_

typedef struct {
	WORD Year;                /* 1980 - 2099 */
	BYTE Month;               /* 1 - 12 */
	BYTE Day;                 /* 1 - 31 */
	BYTE WeekDay;             /* 0 - Sunday, 1 - Monday etc */
	BYTE Hour;                /* 0 - 23 */
	BYTE Minute;              /* 0 - 59 */
	BYTE Second;              /* 0 - 59 */
	BYTE FracSecond;          /* 0 - 99  (100 = 1sec */
} SntpDateTime;

typedef	struct	{
	USHORT	ElapsedDays;		/*	Elapsed days.	*/
	BYTE	ElapsedHours;		/*	Elapsed hours.	*/
	BYTE	ElapsedMinutes;		/*	Elapsed minutes.	*/
	BYTE	ElapsedSeconds;		/*	Elapsed seconds.	*/
} ElapsedTime;

typedef	struct	SNTP_TIMER_CLASS
{
	BYTE_ENUM (BOOLEAN)				timer_enabled;
	ULONG									clock_ticks_per_second;
	ULONG									tick_counter;
} SNTP_TIMER_CLASS;

typedef	struct 	TIME_ZONE_CLASS
{
	BYTE									standard_name[TIME_ZONE_NAME_LEN+1];
	long									offset_from_utc;
	BYTE_ENUM (BOOLEAN)				daylight_enabled;
	SntpDateTime								ds_date;
	SntpDateTime								de_date;
	long									daylight_offset;
}	TIME_ZONE_CLASS;

typedef 	struct	NTP_TIMESTAMP
{
	ULONG		seconds;
	ULONG		seconds_fraction;
}	NTP_TIMESTAMP;

typedef	struct	SNTP_CLASS
{
	BYTE_ENUM (BOOLEAN)				enabled;
	ULONG 								application_id;
	BYTE_ENUM (BOOLEAN)				socket_interface_enabled;
	BYTE_ENUM (BOOLEAN) 				socket_interface_initialized;
	int 									socket;
	ULONG									local_internet_address;
	ULONG									ntp_server_ip_address;
	USHORT								timeout_period;
	USHORT								no_of_retransmission_allowed;
	USHORT								initial_poll_interval;
	TIME_ZONE_CLASS					time_zone;
	USHORT								current_state;
	USHORT								poll_interval;
	USHORT								no_of_retransmission;
	ULONG									poll_timer;
	ULONG									retransmission_timer;
	NTP_TIMESTAMP						our_timestamp;
	SNTP_TIMER_CLASS 					timer_class;
/* Should Refer this time for further reference */
	NTP_TIMESTAMP						current_time_in_ntp;		/* Sreelu */
} SNTP_CLASS;

typedef	struct 	NTP_PACKET
{
	BYTE									li_vn_mode;
	BYTE									stratum;
	BYTE									poll;
	BYTE									precision;
	ULONG									root_delay;
	ULONG									root_despersion;
	ULONG									refrence_identifier;	
	NTP_TIMESTAMP						refrence_timestamp;
	NTP_TIMESTAMP						originate_timestamp;
	NTP_TIMESTAMP						receive_timestamp;
	NTP_TIMESTAMP						transmit_timestamp;
//	ULONG									key_identifier;
//	BYTE									message_digest[16];
}	NTP_PACKET;

/*	sntprx.c */
extern void handle_receive_on_sntp_port(void);

/* sntptmr.c */
extern void sntp_timer(void);

/* sntptx.c */
void handle_transmit_on_sntp_port(void);

/* sntputil.c */
extern void datetime_to_ntp_timestamp(SntpDateTime *d_ptr,NTP_TIMESTAMP *n_ptr);
extern void ntp_timestamp_to_datetime(NTP_TIMESTAMP *n_ptr, SntpDateTime *d_ptr);
// extern void ntp_timestamp_wrt_utc(NTP_TIMESTAMP *n_ptr,int flag);
extern int 	SetDateTime(SntpDateTime far *d_ptr);
extern int 	SetCurrentDateTime(SntpDateTime far *d_ptr);
extern void get_local_time_from_utc(NTP_TIMESTAMP *sptr_timestamp);
extern void get_utc_from_local_time(NTP_TIMESTAMP *sptr_timestamp);

/* sntpdlsp.c */
extern enum BOOLEAN check_if_in_daylights_savings_period(SntpDateTime curr_date);

#endif /* _VSNTPSTR_H_ */



