#include	<defs.h>
#include	"telnet.h"

/****************************************************************************
	Routine		: tcdm
	Input			: Index to TELNET structure corresponding to this connection.
					  	Character - not used.
	Synopsis		: Decrements the counting flag when a DM is received. DM is
						an indication of end of URGent data.
****************************************************************************/

/* received DATA MARK */
USHORT	tcdm(TELNET_CLIENT_CLASS *client_info_ptr, BYTE character)
{
	if (client_info_ptr->synching)
		client_info_ptr->synching--;
	return 1;
}

/****************************************************************************
	Routine		: urg_callback
	Input			: skt : Socket number on which URGent data has been received.
	Synopsis		: Called by TCP to indicate that a TELNET 'Synch' has been 
						received on 'skt'. Increments a counting flag .
****************************************************************************/


void	urg_callback(int skt)
{
	USHORT	index;
	TELNET_CLIENT_CLASS	*connection_ptr = telnet.clients_info;
	
	for( index = 0; index < telnet.max_telnet_connections; index++,connection_ptr++) {
		if ((connection_ptr->in_use) && (connection_ptr->socket_num == skt)) { 
			connection_ptr->synching++;
			break;
		}
	}
}		

