#include	<defs.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	"telnet.h"
#include	"menu.h"
#include "dialout.h"

#define	TINVALID	0xff

extern register_urg_func_with_tcp(int, void (*)(int));

/****************************************************************************
	Routine		: initialize_client
	Input			: Index to TELNET structure corresponding to this connection.
						Socket number of this connection.
	Synopsis		: Initializes the TELNET structure for this new connection.
****************************************************************************/

USHORT	initialize_client(TELNET_CLIENT_CLASS *client_info_ptr, int skt)
{
	/* Allocate space for the receive buffer */
	if ((client_info_ptr->recv_buffer = malloc(MAX_TCP_PKT)) == NULL)
	{
		tel_printf(TELNET_ALARM, "TELNET: Insufficient memory to continue new connection\n\r");
		return 0;
	}
	/* Allocate memory for file transfer buffers */
	client_info_ptr->char_buffer_ptr = (BYTE *)buffer_malloc(MAX_CHAR_BUFFER_SIZE);
	if (client_info_ptr->char_buffer_ptr == NULL)
	{
		tel_printf(TELNET_ALARM, "TELNET: Insufficient memory to continue new connection\n\r");
		return 0;
	}
	client_info_ptr->bytes_in_char_buffer = 0;

	client_info_ptr->recv_buffer_index = 0;
	client_info_ptr->socket_num = skt;
	client_info_ptr->sostate = TSDATA;
	client_info_ptr->subnegstate = SS_START;
	client_info_ptr->noga = FALSE;
	client_info_ptr->was_echoing = FALSE;
	client_info_ptr->echoing = FALSE;
	client_info_ptr->synching = FALSE;
	client_info_ptr->sndtmark = FALSE;

	client_info_ptr->last_char = 0;
	client_info_ptr->menustate = TMS_SUPERMENU;
	client_info_ptr->more = 0;
	client_info_ptr->pwd_attempts = 0;
	client_info_ptr->delayed_tx_buffer = NULL;

	client_info_ptr->dialout_user_entry = NULL;
	client_info_ptr->verifying_dialout_pwd = FALSE;
	client_info_ptr->dialout_idle_timer = DIALOUT_IDLE_TIME;
	client_info_ptr->interrupted = FALSE;
	client_info_ptr->force_close = FALSE;

/* sudhir  2/2/97 */
   client_info_ptr->in_use_by_terminal_server = FALSE ;

	client_info_ptr->in_use = 1;

/* sudhir 12/5/97 */
   client_info_ptr->modify_config_entered = 0;
   client_info_ptr->edit_filter = 0;
   client_info_ptr->ptr_to_filter = NULL;
   client_info_ptr->next_screen = 0;

/* sudhir new change */
	client_info_ptr->connect_to_ourself = FALSE;
	client_info_ptr->start_our_server = FALSE;

	register_urg_func_with_tcp(skt, urg_callback);


/* sudhir for proxy server statistics */
	client_info_ptr->stati_update_timeout = 1200;

	return 1;
}
	

/****************************************************************************
	Routine		: fsm_init
	Input			: fsm - pointer to a 2d matrix which will contain the state
						transitions for all 255 chars. 
					  ttab - pointer to a compact array of structures having all
						possible state transitions.
					  nstates - number of possible states in the state machine.
	Synopsis		: Makes an exhastive state transition table from the compact
						table.
****************************************************************************/

void	fsm_init(BYTE fsm[][NCHRS], fsm_trans *ttab, USHORT nstates)
{
	fsm_trans	*pt;
	USHORT		sn, ti, cn;

	for (cn=0; cn < NCHRS; cn++)
		for(ti=0; ti < nstates; ti++)
			fsm[ti][cn] =TINVALID;

	for (ti =0; ttab[ti].ft_state != FSINVALID; ++ti) {
		pt = &ttab[ti];
		sn = pt->ft_state;
		if (pt->ft_char == TCANY) {
			for (cn=0; cn<NCHRS; cn++)
				if(fsm[sn][cn] == TINVALID	)
					fsm[sn][cn] = ti;
		} else
			fsm[sn][pt->ft_char] = ti;
	}
	/* set all uninitialized indices to an invalid transition */
	for (cn =0; cn<NCHRS; cn++)
		for (ti=0; ti<nstates; ti++)
			if(fsm[ti][cn] == TINVALID)
				fsm[ti][cn] = ti;
}

/*Deepak...*/
USHORT	initialize_client_for_dumbtty (TELNET_CLIENT_CLASS *client_info_ptr)
{
	/* Allocate space for the receive buffer */
	if ((client_info_ptr->recv_buffer = malloc(MAX_TCP_PKT)) == NULL)
	{
		tel_printf(TELNET_ALARM, "TELNET: Insufficient memory to continue new connection\n\r");
		return 0;
	}
	/* Allocate memory for file transfer buffers */
	client_info_ptr->char_buffer_ptr = (BYTE *)buffer_malloc(MAX_CHAR_BUFFER_SIZE);
	if (client_info_ptr->char_buffer_ptr == NULL)
	{
		tel_printf(TELNET_ALARM, "TELNET: Insufficient memory to continue new connection\n\r");
		return 0;
	}
	client_info_ptr->bytes_in_char_buffer = 0;

	client_info_ptr->recv_buffer_index = 0;
	client_info_ptr->sostate = TSDATA;
	client_info_ptr->subnegstate = SS_START;
	client_info_ptr->noga = FALSE;
	client_info_ptr->was_echoing = FALSE;
	client_info_ptr->echoing = FALSE;
	client_info_ptr->synching = FALSE;
	client_info_ptr->sndtmark = FALSE;

	client_info_ptr->last_char = 0;
	client_info_ptr->menustate = TMS_SUPERMENU;
	client_info_ptr->more = 0;
	client_info_ptr->pwd_attempts = 0;
	client_info_ptr->delayed_tx_buffer = NULL;

	client_info_ptr->dialout_user_entry = NULL;
	client_info_ptr->verifying_dialout_pwd = FALSE;
	client_info_ptr->dialout_idle_timer = DIALOUT_IDLE_TIME;
	client_info_ptr->interrupted = FALSE;
	client_info_ptr->force_close = FALSE;

	client_info_ptr->in_use = 1;

	return 1;
}	
/*...Deepak*/
	



